// chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-test-utils.h"


namespace segmentation_internals::mojom {
ServiceStatus::ServiceStatus()
    : is_initialized(),
      intialization_status() {}

ServiceStatus::ServiceStatus(
    bool is_initialized_in,
    int32_t intialization_status_in)
    : is_initialized(std::move(is_initialized_in)),
      intialization_status(std::move(intialization_status_in)) {}

ServiceStatus::~ServiceStatus() = default;
size_t ServiceStatus::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_initialized);
  seed = mojo::internal::Hash(seed, this->intialization_status);
  return seed;
}

void ServiceStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_initialized"), this->is_initialized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "intialization_status"), this->intialization_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SegmentInfo::SegmentInfo()
    : segment_name(),
      segment_id(),
      segment_data(),
      can_execute_segment(),
      prediction_result(),
      prediction_timestamp() {}

SegmentInfo::SegmentInfo(
    const std::string& segment_name_in,
    int32_t segment_id_in,
    const std::string& segment_data_in,
    bool can_execute_segment_in,
    const std::string& prediction_result_in,
    ::base::Time prediction_timestamp_in)
    : segment_name(std::move(segment_name_in)),
      segment_id(std::move(segment_id_in)),
      segment_data(std::move(segment_data_in)),
      can_execute_segment(std::move(can_execute_segment_in)),
      prediction_result(std::move(prediction_result_in)),
      prediction_timestamp(std::move(prediction_timestamp_in)) {}

SegmentInfo::~SegmentInfo() = default;

void SegmentInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segment_name"), this->segment_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segment_id"), this->segment_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segment_data"), this->segment_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_execute_segment"), this->can_execute_segment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prediction_result"), this->prediction_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prediction_timestamp"), this->prediction_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SegmentInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClientInfo::ClientInfo()
    : segmentation_key(),
      selected_segment(),
      segment_info() {}

ClientInfo::ClientInfo(
    const std::string& segmentation_key_in,
    const std::string& selected_segment_in,
    std::vector<SegmentInfoPtr> segment_info_in)
    : segmentation_key(std::move(segmentation_key_in)),
      selected_segment(std::move(selected_segment_in)),
      segment_info(std::move(segment_info_in)) {}

ClientInfo::~ClientInfo() = default;

void ClientInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segmentation_key"), this->segmentation_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_segment"), this->selected_segment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segment_info"), this->segment_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SegmentInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClientInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive segmentation_internals::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply segmentation_internals::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe9352a0b;  // IPCStableHash for segmentation_internals::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send segmentation_internals::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::segmentation_internals::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::segmentation_internals::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::segmentation_internals::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::segmentation_internals::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetServiceStatus: {
      return &PageHandler::GetServiceStatus_Sym::IPCStableHash;
    }
    case messages::PageHandler::kExecuteModel: {
      return &PageHandler::ExecuteModel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOverwriteResult: {
      return &PageHandler::OverwriteResult_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetSelected: {
      return &PageHandler::SetSelected_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetServiceStatus:
            return "Receive segmentation_internals::mojom::PageHandler::GetServiceStatus";
      case messages::PageHandler::kExecuteModel:
            return "Receive segmentation_internals::mojom::PageHandler::ExecuteModel";
      case messages::PageHandler::kOverwriteResult:
            return "Receive segmentation_internals::mojom::PageHandler::OverwriteResult";
      case messages::PageHandler::kSetSelected:
            return "Receive segmentation_internals::mojom::PageHandler::SetSelected";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetServiceStatus:
            return "Receive reply segmentation_internals::mojom::PageHandler::GetServiceStatus";
      case messages::PageHandler::kExecuteModel:
            return "Receive reply segmentation_internals::mojom::PageHandler::ExecuteModel";
      case messages::PageHandler::kOverwriteResult:
            return "Receive reply segmentation_internals::mojom::PageHandler::OverwriteResult";
      case messages::PageHandler::kSetSelected:
            return "Receive reply segmentation_internals::mojom::PageHandler::SetSelected";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetServiceStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc0fdbc2;  // IPCStableHash for segmentation_internals::mojom::PageHandler::GetServiceStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ExecuteModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcaf6533b;  // IPCStableHash for segmentation_internals::mojom::PageHandler::ExecuteModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OverwriteResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00811c2c;  // IPCStableHash for segmentation_internals::mojom::PageHandler::OverwriteResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetSelected_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdb04f5bf;  // IPCStableHash for segmentation_internals::mojom::PageHandler::SetSelected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetServiceStatus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send segmentation_internals::mojom::PageHandler::GetServiceStatus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetServiceStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::segmentation_internals::mojom::internal::PageHandler_GetServiceStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetServiceStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ExecuteModel(
    int32_t in_segment_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send segmentation_internals::mojom::PageHandler::ExecuteModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("segment_id"), in_segment_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kExecuteModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::segmentation_internals::mojom::internal::PageHandler_ExecuteModel_Params_Data> params(
          message);
  params.Allocate();

  params->segment_id = in_segment_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ExecuteModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OverwriteResult(
    int32_t in_segment_id, float in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send segmentation_internals::mojom::PageHandler::OverwriteResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("segment_id"), in_segment_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOverwriteResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::segmentation_internals::mojom::internal::PageHandler_OverwriteResult_Params_Data> params(
          message);
  params.Allocate();

  params->segment_id = in_segment_id;

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OverwriteResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetSelected(
    const std::string& in_segmentation_key, int32_t in_optimization_target) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send segmentation_internals::mojom::PageHandler::SetSelected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("segmentation_key"), in_segmentation_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("optimization_target"), in_optimization_target,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetSelected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::segmentation_internals::mojom::internal::PageHandler_SetSelected_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->segmentation_key)::BaseType> segmentation_key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_segmentation_key,
    segmentation_key_fragment);

  params->segmentation_key.Set(
      segmentation_key_fragment.is_null() ? nullptr : segmentation_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->segmentation_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null segmentation_key in PageHandler.SetSelected request");

  params->optimization_target = in_optimization_target;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetSelected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetServiceStatus: {
      DCHECK(message->is_serialized());
      internal::PageHandler_GetServiceStatus_Params_Data* params =
          reinterpret_cast<internal::PageHandler_GetServiceStatus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetServiceStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetServiceStatus(        );
      return true;
    }
    case messages::PageHandler::kExecuteModel: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ExecuteModel_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ExecuteModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      int32_t p_segment_id{};
      PageHandler_ExecuteModel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_segment_id = input_data_view.segment_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteModel(        
        std::move(p_segment_id));
      return true;
    }
    case messages::PageHandler::kOverwriteResult: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OverwriteResult_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OverwriteResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      int32_t p_segment_id{};
      float p_result{};
      PageHandler_OverwriteResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_segment_id = input_data_view.segment_id();
      if (success)
        p_result = input_data_view.result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OverwriteResult(        
        std::move(p_segment_id), 
        std::move(p_result));
      return true;
    }
    case messages::PageHandler::kSetSelected: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetSelected_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetSelected_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::string p_segmentation_key{};
      int32_t p_optimization_target{};
      PageHandler_SetSelected_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSegmentationKey(&p_segmentation_key))
        success = false;
      if (success)
        p_optimization_target = input_data_view.optimization_target();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSelected(        
        std::move(p_segmentation_key), 
        std::move(p_optimization_target));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetServiceStatus: {
      break;
    }
    case messages::PageHandler::kExecuteModel: {
      break;
    }
    case messages::PageHandler::kOverwriteResult: {
      break;
    }
    case messages::PageHandler::kSetSelected: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetServiceStatus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ExecuteModel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OverwriteResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetSelected_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::segmentation_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnServiceStatusChanged: {
      return &Page::OnServiceStatusChanged_Sym::IPCStableHash;
    }
    case messages::Page::kOnClientInfoAvailable: {
      return &Page::OnClientInfoAvailable_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnServiceStatusChanged:
            return "Receive segmentation_internals::mojom::Page::OnServiceStatusChanged";
      case messages::Page::kOnClientInfoAvailable:
            return "Receive segmentation_internals::mojom::Page::OnClientInfoAvailable";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnServiceStatusChanged:
            return "Receive reply segmentation_internals::mojom::Page::OnServiceStatusChanged";
      case messages::Page::kOnClientInfoAvailable:
            return "Receive reply segmentation_internals::mojom::Page::OnClientInfoAvailable";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnServiceStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c729fa3;  // IPCStableHash for segmentation_internals::mojom::Page::OnServiceStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnClientInfoAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08be2ee9;  // IPCStableHash for segmentation_internals::mojom::Page::OnClientInfoAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnServiceStatusChanged(
    bool in_is_initialized, int32_t in_status_flag) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send segmentation_internals::mojom::Page::OnServiceStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_initialized"), in_is_initialized,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status_flag"), in_status_flag,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnServiceStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::segmentation_internals::mojom::internal::Page_OnServiceStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_initialized = in_is_initialized;

  params->status_flag = in_status_flag;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnServiceStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnClientInfoAvailable(
    std::vector<ClientInfoPtr> in_client_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send segmentation_internals::mojom::Page::OnClientInfoAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_info"), in_client_info,
                        "<value of type std::vector<ClientInfoPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnClientInfoAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::segmentation_internals::mojom::internal::Page_OnClientInfoAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_info)::BaseType>
      client_info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& client_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::segmentation_internals::mojom::ClientInfoDataView>>(
    in_client_info,
    client_info_fragment,
    &client_info_validate_params);

  params->client_info.Set(
      client_info_fragment.is_null() ? nullptr : client_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_info in Page.OnClientInfoAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnClientInfoAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnServiceStatusChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnServiceStatusChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnServiceStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      bool p_is_initialized{};
      int32_t p_status_flag{};
      Page_OnServiceStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_initialized = input_data_view.is_initialized();
      if (success)
        p_status_flag = input_data_view.status_flag();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnServiceStatusChanged(        
        std::move(p_is_initialized), 
        std::move(p_status_flag));
      return true;
    }
    case messages::Page::kOnClientInfoAvailable: {
      DCHECK(message->is_serialized());
      internal::Page_OnClientInfoAvailable_Params_Data* params =
          reinterpret_cast<internal::Page_OnClientInfoAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      std::vector<ClientInfoPtr> p_client_info{};
      Page_OnClientInfoAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientInfo(&p_client_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClientInfoAvailable(        
        std::move(p_client_info));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnServiceStatusChanged: {
      break;
    }
    case messages::Page::kOnClientInfoAvailable: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnServiceStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnClientInfoAvailable_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::segmentation_internals::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // segmentation_internals::mojom


namespace mojo {


// static
bool StructTraits<::segmentation_internals::mojom::ServiceStatus::DataView, ::segmentation_internals::mojom::ServiceStatusPtr>::Read(
    ::segmentation_internals::mojom::ServiceStatus::DataView input,
    ::segmentation_internals::mojom::ServiceStatusPtr* output) {
  bool success = true;
  ::segmentation_internals::mojom::ServiceStatusPtr result(::segmentation_internals::mojom::ServiceStatus::New());
  
      if (success)
        result->is_initialized = input.is_initialized();
      if (success)
        result->intialization_status = input.intialization_status();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::segmentation_internals::mojom::SegmentInfo::DataView, ::segmentation_internals::mojom::SegmentInfoPtr>::Read(
    ::segmentation_internals::mojom::SegmentInfo::DataView input,
    ::segmentation_internals::mojom::SegmentInfoPtr* output) {
  bool success = true;
  ::segmentation_internals::mojom::SegmentInfoPtr result(::segmentation_internals::mojom::SegmentInfo::New());
  
      if (success && !input.ReadSegmentName(&result->segment_name))
        success = false;
      if (success)
        result->segment_id = input.segment_id();
      if (success && !input.ReadSegmentData(&result->segment_data))
        success = false;
      if (success)
        result->can_execute_segment = input.can_execute_segment();
      if (success && !input.ReadPredictionResult(&result->prediction_result))
        success = false;
      if (success && !input.ReadPredictionTimestamp(&result->prediction_timestamp))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::segmentation_internals::mojom::ClientInfo::DataView, ::segmentation_internals::mojom::ClientInfoPtr>::Read(
    ::segmentation_internals::mojom::ClientInfo::DataView input,
    ::segmentation_internals::mojom::ClientInfoPtr* output) {
  bool success = true;
  ::segmentation_internals::mojom::ClientInfoPtr result(::segmentation_internals::mojom::ClientInfo::New());
  
      if (success && !input.ReadSegmentationKey(&result->segmentation_key))
        success = false;
      if (success && !input.ReadSelectedSegment(&result->selected_segment))
        success = false;
      if (success && !input.ReadSegmentInfo(&result->segment_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace segmentation_internals::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetServiceStatus() {
  GetForwardingInterface()->GetServiceStatus();
}
void PageHandlerInterceptorForTesting::ExecuteModel(int32_t segment_id) {
  GetForwardingInterface()->ExecuteModel(
    std::move(segment_id)
    );
}
void PageHandlerInterceptorForTesting::OverwriteResult(int32_t segment_id, float result) {
  GetForwardingInterface()->OverwriteResult(
    std::move(segment_id)
    , 
    std::move(result)
    );
}
void PageHandlerInterceptorForTesting::SetSelected(const std::string& segmentation_key, int32_t optimization_target) {
  GetForwardingInterface()->SetSelected(
    std::move(segmentation_key)
    , 
    std::move(optimization_target)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;





void PageInterceptorForTesting::OnServiceStatusChanged(bool is_initialized, int32_t status_flag) {
  GetForwardingInterface()->OnServiceStatusChanged(
    std::move(is_initialized)
    , 
    std::move(status_flag)
    );
}
void PageInterceptorForTesting::OnClientInfoAvailable(std::vector<ClientInfoPtr> client_info) {
  GetForwardingInterface()->OnClientInfoAvailable(
    std::move(client_info)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // segmentation_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif