// chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-params-data.h"
namespace segmentation_internals {
namespace mojom {

namespace internal {


// static
bool ServiceStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceStatus_Data* object =
      static_cast<const ServiceStatus_Data*>(data);

  return true;
}

ServiceStatus_Data::ServiceStatus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SegmentInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SegmentInfo_Data* object =
      static_cast<const SegmentInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->segment_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& segment_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->segment_name, validation_context,
                                         &segment_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->segment_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& segment_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->segment_data, validation_context,
                                         &segment_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prediction_result, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prediction_result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prediction_result, validation_context,
                                         &prediction_result_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prediction_timestamp, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->prediction_timestamp, validation_context))
    return false;

  return true;
}

SegmentInfo_Data::SegmentInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientInfo_Data* object =
      static_cast<const ClientInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->segmentation_key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& segmentation_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->segmentation_key, validation_context,
                                         &segmentation_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selected_segment, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selected_segment_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selected_segment, validation_context,
                                         &selected_segment_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->segment_info, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& segment_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->segment_info, validation_context,
                                         &segment_info_validate_params)) {
    return false;
  }

  return true;
}

ClientInfo_Data::ClientInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetServiceStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetServiceStatus_Params_Data* object =
      static_cast<const PageHandler_GetServiceStatus_Params_Data*>(data);

  return true;
}

PageHandler_GetServiceStatus_Params_Data::PageHandler_GetServiceStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ExecuteModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ExecuteModel_Params_Data* object =
      static_cast<const PageHandler_ExecuteModel_Params_Data*>(data);

  return true;
}

PageHandler_ExecuteModel_Params_Data::PageHandler_ExecuteModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OverwriteResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OverwriteResult_Params_Data* object =
      static_cast<const PageHandler_OverwriteResult_Params_Data*>(data);

  return true;
}

PageHandler_OverwriteResult_Params_Data::PageHandler_OverwriteResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetSelected_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetSelected_Params_Data* object =
      static_cast<const PageHandler_SetSelected_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->segmentation_key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& segmentation_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->segmentation_key, validation_context,
                                         &segmentation_key_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetSelected_Params_Data::PageHandler_SetSelected_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnServiceStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnServiceStatusChanged_Params_Data* object =
      static_cast<const Page_OnServiceStatusChanged_Params_Data*>(data);

  return true;
}

Page_OnServiceStatusChanged_Params_Data::Page_OnServiceStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnClientInfoAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnClientInfoAvailable_Params_Data* object =
      static_cast<const Page_OnClientInfoAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_info, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_info, validation_context,
                                         &client_info_validate_params)) {
    return false;
  }

  return true;
}

Page_OnClientInfoAvailable_Params_Data::Page_OnClientInfoAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace segmentation_internals