// chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace segmentation_internals::mojom {
class ServiceStatusDataView;

class SegmentInfoDataView;

class ClientInfoDataView;



}  // segmentation_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::segmentation_internals::mojom::ServiceStatusDataView> {
  using Data = ::segmentation_internals::mojom::internal::ServiceStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::segmentation_internals::mojom::SegmentInfoDataView> {
  using Data = ::segmentation_internals::mojom::internal::SegmentInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::segmentation_internals::mojom::ClientInfoDataView> {
  using Data = ::segmentation_internals::mojom::internal::ClientInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace segmentation_internals::mojom {
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ServiceStatusDataView {
 public:
  ServiceStatusDataView() = default;

  ServiceStatusDataView(
      internal::ServiceStatus_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_initialized() const {
    return data_->is_initialized;
  }
  int32_t intialization_status() const {
    return data_->intialization_status;
  }
 private:
  internal::ServiceStatus_Data* data_ = nullptr;
};


class SegmentInfoDataView {
 public:
  SegmentInfoDataView() = default;

  SegmentInfoDataView(
      internal::SegmentInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSegmentNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentName(UserType* output) {
    
    auto* pointer = data_->segment_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t segment_id() const {
    return data_->segment_id;
  }
  inline void GetSegmentDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentData(UserType* output) {
    
    auto* pointer = data_->segment_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool can_execute_segment() const {
    return data_->can_execute_segment;
  }
  inline void GetPredictionResultDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPredictionResult(UserType* output) {
    
    auto* pointer = data_->prediction_result.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPredictionTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPredictionTimestamp(UserType* output) {
    
    auto* pointer = data_->prediction_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::SegmentInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClientInfoDataView {
 public:
  ClientInfoDataView() = default;

  ClientInfoDataView(
      internal::ClientInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSegmentationKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentationKey(UserType* output) {
    
    auto* pointer = data_->segmentation_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectedSegmentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedSegment(UserType* output) {
    
    auto* pointer = data_->selected_segment.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSegmentInfoDataView(
      mojo::ArrayDataView<SegmentInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentInfo(UserType* output) {
    
    auto* pointer = data_->segment_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::segmentation_internals::mojom::SegmentInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ClientInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // segmentation_internals::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_DATA_VIEW_H_