// chrome/browser/ui/webui/reload_button/reload_button.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/reload_button/reload_button.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/reload_button/reload_button.mojom-params-data.h"
namespace reload_button {
namespace mojom {

NOINLINE static const char* ClickDispositionFlagToStringHelper(ClickDispositionFlag value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClickDispositionFlag::kMiddleMouseButton:
      return "kMiddleMouseButton";
    case ClickDispositionFlag::kAltKeyDown:
      return "kAltKeyDown";
    case ClickDispositionFlag::kMetaKeyDown:
      return "kMetaKeyDown";
    default:
      return nullptr;
  }
}

std::string ClickDispositionFlagToString(ClickDispositionFlag value) {
  const char *str = ClickDispositionFlagToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClickDispositionFlag value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClickDispositionFlag value) {
  return os << ClickDispositionFlagToString(value);
}

namespace internal {


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Reload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Reload_Params_Data* object =
      static_cast<const PageHandler_Reload_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->flags, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& flags_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::reload_button::mojom::internal::ClickDispositionFlag_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->flags, validation_context,
                                         &flags_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_Reload_Params_Data::PageHandler_Reload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StopReload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StopReload_Params_Data* object =
      static_cast<const PageHandler_StopReload_Params_Data*>(data);

  return true;
}

PageHandler_StopReload_Params_Data::PageHandler_StopReload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowContextMenu_Params_Data* object =
      static_cast<const PageHandler_ShowContextMenu_Params_Data*>(data);

  return true;
}

PageHandler_ShowContextMenu_Params_Data::PageHandler_ShowContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetReloadButtonState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetReloadButtonState_Params_Data* object =
      static_cast<const Page_SetReloadButtonState_Params_Data*>(data);

  return true;
}

Page_SetReloadButtonState_Params_Data::Page_SetReloadButtonState_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace reload_button

namespace perfetto {

// static
void TraceFormatTraits<::reload_button::mojom::ClickDispositionFlag>::WriteIntoTrace(
   perfetto::TracedValue context, ::reload_button::mojom::ClickDispositionFlag value) {
  return std::move(context).WriteString(::reload_button::mojom::ClickDispositionFlagToString(value));
}

} // namespace perfetto