// chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-data-view.h"




namespace std {

template <>
struct hash<::related_website_sets::mojom::SiteType>
    : public mojo::internal::EnumHashImpl<::related_website_sets::mojom::SiteType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::related_website_sets::mojom::SiteType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::related_website_sets::mojom::SiteType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::related_website_sets::mojom::SiteType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::related_website_sets::mojom::MemberDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::related_website_sets::mojom::MemberDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::related_website_sets::mojom::internal::Member_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::site(input)) in_site = Traits::site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site)::BaseType> site_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_site,
      site_fragment);

    fragment->site.Set(
        site_fragment.is_null() ? nullptr : site_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->site.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site in Member struct");

    
    mojo::internal::Serialize<::related_website_sets::mojom::SiteType>(
      Traits::type(input),
      &fragment->type);
  }

  static bool Deserialize(::related_website_sets::mojom::internal::Member_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::related_website_sets::mojom::MemberDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::related_website_sets::mojom::RelatedWebsiteSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::related_website_sets::mojom::RelatedWebsiteSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::related_website_sets::mojom::internal::RelatedWebsiteSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::primary_site(input)) in_primary_site = Traits::primary_site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary_site)::BaseType> primary_site_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_primary_site,
      primary_site_fragment);

    fragment->primary_site.Set(
        primary_site_fragment.is_null() ? nullptr : primary_site_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primary_site.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary_site in RelatedWebsiteSet struct");

    decltype(Traits::member_sites(input)) in_member_sites = Traits::member_sites(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->member_sites)::BaseType>
        member_sites_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& member_sites_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::related_website_sets::mojom::MemberDataView>>(
      in_member_sites,
      member_sites_fragment,
      &member_sites_validate_params);

    fragment->member_sites.Set(
        member_sites_fragment.is_null() ? nullptr : member_sites_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->member_sites.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null member_sites in RelatedWebsiteSet struct");

    fragment->managed_by_enterprise = Traits::managed_by_enterprise(input);
  }

  static bool Deserialize(::related_website_sets::mojom::internal::RelatedWebsiteSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::related_website_sets::mojom::RelatedWebsiteSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::related_website_sets::mojom::GetRelatedWebsiteSetsResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::related_website_sets::mojom::GetRelatedWebsiteSetsResponseDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::related_website_sets::mojom::internal::GetRelatedWebsiteSetsResponse_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::related_website_sets::mojom::GetRelatedWebsiteSetsResponseDataView::Tag::kRelatedWebsiteSets: {
    decltype(Traits::related_website_sets(input))
    in_related_website_sets = Traits::related_website_sets(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_related_website_sets)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& related_website_sets_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::related_website_sets::mojom::RelatedWebsiteSetDataView>>(
  in_related_website_sets,
  value_fragment,
  &related_website_sets_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null related_website_sets in GetRelatedWebsiteSetsResponse union");
    fragment->data.f_related_website_sets.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::related_website_sets::mojom::GetRelatedWebsiteSetsResponseDataView::Tag::kErrorMessage: {
    decltype(Traits::error_message(input))
    in_error_message = Traits::error_message(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_message)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_error_message,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_message in GetRelatedWebsiteSetsResponse union");
    fragment->data.f_error_message.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::related_website_sets::mojom::internal::GetRelatedWebsiteSetsResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::related_website_sets::mojom::GetRelatedWebsiteSetsResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace related_website_sets::mojom {

inline void MemberDataView::GetSiteDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->site.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void RelatedWebsiteSetDataView::GetPrimarySiteDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->primary_site.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RelatedWebsiteSetDataView::GetMemberSitesDataView(
    mojo::ArrayDataView<MemberDataView>* output) {
  auto pointer = data_->member_sites.Get();
  *output = mojo::ArrayDataView<MemberDataView>(pointer, message_);
}


inline void GetRelatedWebsiteSetsResponseDataView::GetRelatedWebsiteSetsDataView(
    mojo::ArrayDataView<RelatedWebsiteSetDataView>* output) const {
  CHECK(is_related_website_sets());
  *output = mojo::ArrayDataView<RelatedWebsiteSetDataView>(data_->data.f_related_website_sets.Get(), message_);
}
inline void GetRelatedWebsiteSetsResponseDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) const {
  CHECK(is_error_message());
  *output = mojo::StringDataView(data_->data.f_error_message.Get(), message_);
}


}  // related_website_sets::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::related_website_sets::mojom::SiteType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::related_website_sets::mojom::SiteType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_SHARED_H_