// chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_PRIVATE_STATE_TOKENS_PRIVATE_STATE_TOKENS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_PRIVATE_STATE_TOKENS_PRIVATE_STATE_TOKENS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace private_state_tokens::mojom {

class PrivateStateTokensPageHandlerProxy;

template <typename ImplRefTraits>
class PrivateStateTokensPageHandlerStub;

class PrivateStateTokensPageHandlerRequestValidator;
class PrivateStateTokensPageHandlerResponseValidator;


class PrivateStateTokensPageHandler
    : public PrivateStateTokensPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "private_state_tokens.mojom.PrivateStateTokensPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PrivateStateTokensPageHandlerInterfaceBase;
  using Proxy_ = PrivateStateTokensPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrivateStateTokensPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PrivateStateTokensPageHandlerRequestValidator;
  using ResponseValidator_ = PrivateStateTokensPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetIssuerTokenCountsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetIssuerTokenCounts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PrivateStateTokensPageHandler() = default;

  using GetIssuerTokenCountsCallback = base::OnceCallback<void(std::vector<IssuerTokenCountPtr>)>;
  using GetIssuerTokenCountsMojoCallback = base::OnceCallback<void(std::vector<IssuerTokenCountPtr>)>;

  virtual void GetIssuerTokenCounts(GetIssuerTokenCountsCallback callback) = 0;
};



class  PrivateStateTokensPageHandlerProxy
    : public PrivateStateTokensPageHandler {
 public:
  using InterfaceType = PrivateStateTokensPageHandler;

  explicit PrivateStateTokensPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetIssuerTokenCounts(GetIssuerTokenCountsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PrivateStateTokensPageHandlerStubDispatch {
 public:
  static bool Accept(PrivateStateTokensPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrivateStateTokensPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrivateStateTokensPageHandler>>
class PrivateStateTokensPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrivateStateTokensPageHandlerStub() = default;
  ~PrivateStateTokensPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrivateStateTokensPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrivateStateTokensPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrivateStateTokensPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrivateStateTokensPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  IssuerTokenCount {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IssuerTokenCount, T>::value>;
  using DataView = IssuerTokenCountDataView;
  using Data_ = internal::IssuerTokenCount_Data;

  template <typename... Args>
  static IssuerTokenCountPtr New(Args&&... args) {
    return IssuerTokenCountPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IssuerTokenCountPtr From(const U& u) {
    return mojo::TypeConverter<IssuerTokenCountPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IssuerTokenCount>::Convert(*this);
  }


  IssuerTokenCount();

  IssuerTokenCount(
      const std::string& issuer,
      int32_t count);


  ~IssuerTokenCount();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IssuerTokenCountPtr>
  IssuerTokenCountPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IssuerTokenCount::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IssuerTokenCount::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IssuerTokenCount::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IssuerTokenCount::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IssuerTokenCount::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IssuerTokenCount::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IssuerTokenCount_UnserializedMessageContext<
            UserType, IssuerTokenCount::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IssuerTokenCount::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IssuerTokenCount::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IssuerTokenCount_UnserializedMessageContext<
            UserType, IssuerTokenCount::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IssuerTokenCount::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string issuer;
  
  int32_t count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IssuerTokenCount::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IssuerTokenCount::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IssuerTokenCount::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IssuerTokenCount::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
IssuerTokenCountPtr IssuerTokenCount::Clone() const {
  return New(
      mojo::Clone(issuer),
      mojo::Clone(count)
  );
}

template <typename T, IssuerTokenCount::EnableIfSame<T>*>
bool IssuerTokenCount::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->issuer, other_struct.issuer))
    return false;
  if (!mojo::Equals(this->count, other_struct.count))
    return false;
  return true;
}

template <typename T, IssuerTokenCount::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.issuer < rhs.issuer)
    return true;
  if (rhs.issuer < lhs.issuer)
    return false;
  if (lhs.count < rhs.count)
    return true;
  if (rhs.count < lhs.count)
    return false;
  return false;
}


}  // private_state_tokens::mojom

namespace mojo {


template <>
struct  StructTraits<::private_state_tokens::mojom::IssuerTokenCount::DataView,
                                         ::private_state_tokens::mojom::IssuerTokenCountPtr> {
  static bool IsNull(const ::private_state_tokens::mojom::IssuerTokenCountPtr& input) { return !input; }
  static void SetToNull(::private_state_tokens::mojom::IssuerTokenCountPtr* output) { output->reset(); }

  static const decltype(::private_state_tokens::mojom::IssuerTokenCount::issuer)& issuer(
      const ::private_state_tokens::mojom::IssuerTokenCountPtr& input) {
    return input->issuer;
  }

  static decltype(::private_state_tokens::mojom::IssuerTokenCount::count) count(
      const ::private_state_tokens::mojom::IssuerTokenCountPtr& input) {
    return input->count;
  }

  static bool Read(::private_state_tokens::mojom::IssuerTokenCount::DataView input, ::private_state_tokens::mojom::IssuerTokenCountPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_PRIVATE_STATE_TOKENS_PRIVATE_STATE_TOKENS_MOJOM_H_