// chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_PRIVACY_SANDBOX_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_PRIVACY_SANDBOX_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom.h"
#include "components/content_settings/core/common/content_settings_types.mojom-forward.h"
#include "components/content_settings/core/common/content_settings.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace privacy_sandbox_internals::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "privacy_sandbox_internals.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadPrefsWithPrefixesMinVersion = 0,
    kReadContentSettingsMinVersion = 0,
    kGetTpcdMetadataGrantsMinVersion = 0,
    kContentSettingsPatternToStringMinVersion = 0,
    kStringToContentSettingsPatternMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReadPrefsWithPrefixes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadContentSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetTpcdMetadataGrants_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ContentSettingsPatternToString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StringToContentSettingsPattern_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using ReadPrefsWithPrefixesCallback = base::OnceCallback<void(std::vector<PrivacySandboxInternalsPrefPtr>)>;
  using ReadPrefsWithPrefixesMojoCallback = base::OnceCallback<void(std::vector<PrivacySandboxInternalsPrefPtr>)>;

  virtual void ReadPrefsWithPrefixes(const std::vector<std::string>& pref_prefixes, ReadPrefsWithPrefixesCallback callback) = 0;

  using ReadContentSettingsCallback = base::OnceCallback<void(const std::vector<::ContentSettingPatternSource>&)>;
  using ReadContentSettingsMojoCallback = base::OnceCallback<void(const std::vector<::ContentSettingPatternSource>&)>;

  virtual void ReadContentSettings(::content_settings::mojom::ContentSettingsType type, ReadContentSettingsCallback callback) = 0;

  using GetTpcdMetadataGrantsCallback = base::OnceCallback<void(const std::vector<::ContentSettingPatternSource>&)>;
  using GetTpcdMetadataGrantsMojoCallback = base::OnceCallback<void(const std::vector<::ContentSettingPatternSource>&)>;

  virtual void GetTpcdMetadataGrants(GetTpcdMetadataGrantsCallback callback) = 0;

  using ContentSettingsPatternToStringCallback = base::OnceCallback<void(const std::string&)>;
  using ContentSettingsPatternToStringMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ContentSettingsPatternToString(const ::ContentSettingsPattern& pattern, ContentSettingsPatternToStringCallback callback) = 0;

  using StringToContentSettingsPatternCallback = base::OnceCallback<void(const ::ContentSettingsPattern&)>;
  using StringToContentSettingsPatternMojoCallback = base::OnceCallback<void(const ::ContentSettingsPattern&)>;

  virtual void StringToContentSettingsPattern(const std::string& s, StringToContentSettingsPatternCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "privacy_sandbox_internals.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReadPrefsWithPrefixes(const std::vector<std::string>& pref_prefixes, ReadPrefsWithPrefixesCallback callback) final;
  
  void ReadContentSettings(::content_settings::mojom::ContentSettingsType type, ReadContentSettingsCallback callback) final;
  
  void GetTpcdMetadataGrants(GetTpcdMetadataGrantsCallback callback) final;
  
  void ContentSettingsPatternToString(const ::ContentSettingsPattern& pattern, ContentSettingsPatternToStringCallback callback) final;
  
  void StringToContentSettingsPattern(const std::string& s, StringToContentSettingsPatternCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  PrivacySandboxInternalsPref {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrivacySandboxInternalsPref, T>::value>;
  using DataView = PrivacySandboxInternalsPrefDataView;
  using Data_ = internal::PrivacySandboxInternalsPref_Data;

  template <typename... Args>
  static PrivacySandboxInternalsPrefPtr New(Args&&... args) {
    return PrivacySandboxInternalsPrefPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrivacySandboxInternalsPrefPtr From(const U& u) {
    return mojo::TypeConverter<PrivacySandboxInternalsPrefPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrivacySandboxInternalsPref>::Convert(*this);
  }


  PrivacySandboxInternalsPref();

  PrivacySandboxInternalsPref(
      const std::string& name,
      ::base::Value value);

PrivacySandboxInternalsPref(const PrivacySandboxInternalsPref&) = delete;
PrivacySandboxInternalsPref& operator=(const PrivacySandboxInternalsPref&) = delete;

  ~PrivacySandboxInternalsPref();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrivacySandboxInternalsPrefPtr>
  PrivacySandboxInternalsPrefPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivacySandboxInternalsPref::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivacySandboxInternalsPref::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrivacySandboxInternalsPref::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrivacySandboxInternalsPref_UnserializedMessageContext<
            UserType, PrivacySandboxInternalsPref::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrivacySandboxInternalsPref::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrivacySandboxInternalsPref::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrivacySandboxInternalsPref_UnserializedMessageContext<
            UserType, PrivacySandboxInternalsPref::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrivacySandboxInternalsPref::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ::base::Value value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PrivacySandboxInternalsPrefPtr PrivacySandboxInternalsPref::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>*>
bool PrivacySandboxInternalsPref::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, PrivacySandboxInternalsPref::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // privacy_sandbox_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPref::DataView,
                                         ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr> {
  static bool IsNull(const ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr& input) { return !input; }
  static void SetToNull(::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr* output) { output->reset(); }

  static const decltype(::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPref::name)& name(
      const ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr& input) {
    return input->name;
  }

  static const decltype(::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPref::value)& value(
      const ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr& input) {
    return input->value;
  }

  static bool Read(::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPref::DataView input, ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_PRIVACY_SANDBOX_INTERNALS_MOJOM_H_