// chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-test-utils.h"
#include "components/content_settings/core/common/content_settings_param_traits.h"


namespace privacy_sandbox_internals::mojom {
PrivacySandboxInternalsPref::PrivacySandboxInternalsPref()
    : name(),
      value() {}

PrivacySandboxInternalsPref::PrivacySandboxInternalsPref(
    const std::string& name_in,
    ::base::Value value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

PrivacySandboxInternalsPref::~PrivacySandboxInternalsPref() = default;

void PrivacySandboxInternalsPref::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrivacySandboxInternalsPref::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kReadPrefsWithPrefixes: {
      return &PageHandler::ReadPrefsWithPrefixes_Sym::IPCStableHash;
    }
    case messages::PageHandler::kReadContentSettings: {
      return &PageHandler::ReadContentSettings_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTpcdMetadataGrants: {
      return &PageHandler::GetTpcdMetadataGrants_Sym::IPCStableHash;
    }
    case messages::PageHandler::kContentSettingsPatternToString: {
      return &PageHandler::ContentSettingsPatternToString_Sym::IPCStableHash;
    }
    case messages::PageHandler::kStringToContentSettingsPattern: {
      return &PageHandler::StringToContentSettingsPattern_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kReadPrefsWithPrefixes:
            return "Receive privacy_sandbox_internals::mojom::PageHandler::ReadPrefsWithPrefixes";
      case messages::PageHandler::kReadContentSettings:
            return "Receive privacy_sandbox_internals::mojom::PageHandler::ReadContentSettings";
      case messages::PageHandler::kGetTpcdMetadataGrants:
            return "Receive privacy_sandbox_internals::mojom::PageHandler::GetTpcdMetadataGrants";
      case messages::PageHandler::kContentSettingsPatternToString:
            return "Receive privacy_sandbox_internals::mojom::PageHandler::ContentSettingsPatternToString";
      case messages::PageHandler::kStringToContentSettingsPattern:
            return "Receive privacy_sandbox_internals::mojom::PageHandler::StringToContentSettingsPattern";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kReadPrefsWithPrefixes:
            return "Receive reply privacy_sandbox_internals::mojom::PageHandler::ReadPrefsWithPrefixes";
      case messages::PageHandler::kReadContentSettings:
            return "Receive reply privacy_sandbox_internals::mojom::PageHandler::ReadContentSettings";
      case messages::PageHandler::kGetTpcdMetadataGrants:
            return "Receive reply privacy_sandbox_internals::mojom::PageHandler::GetTpcdMetadataGrants";
      case messages::PageHandler::kContentSettingsPatternToString:
            return "Receive reply privacy_sandbox_internals::mojom::PageHandler::ContentSettingsPatternToString";
      case messages::PageHandler::kStringToContentSettingsPattern:
            return "Receive reply privacy_sandbox_internals::mojom::PageHandler::StringToContentSettingsPattern";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::ReadPrefsWithPrefixes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf1c8958d;  // IPCStableHash for privacy_sandbox_internals::mojom::PageHandler::ReadPrefsWithPrefixes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ReadContentSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5676b6be;  // IPCStableHash for privacy_sandbox_internals::mojom::PageHandler::ReadContentSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTpcdMetadataGrants_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9184d130;  // IPCStableHash for privacy_sandbox_internals::mojom::PageHandler::GetTpcdMetadataGrants
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ContentSettingsPatternToString_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe18f7ac5;  // IPCStableHash for privacy_sandbox_internals::mojom::PageHandler::ContentSettingsPatternToString
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::StringToContentSettingsPattern_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15f1f413;  // IPCStableHash for privacy_sandbox_internals::mojom::PageHandler::StringToContentSettingsPattern
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_ReadPrefsWithPrefixes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ReadPrefsWithPrefixes_ForwardToCallback(
      PageHandler::ReadPrefsWithPrefixesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ReadPrefsWithPrefixes_ForwardToCallback(const PageHandler_ReadPrefsWithPrefixes_ForwardToCallback&) = delete;
  PageHandler_ReadPrefsWithPrefixes_ForwardToCallback& operator=(const PageHandler_ReadPrefsWithPrefixes_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ReadPrefsWithPrefixesCallback callback_;
};

class PageHandler_ReadContentSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ReadContentSettings_ForwardToCallback(
      PageHandler::ReadContentSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ReadContentSettings_ForwardToCallback(const PageHandler_ReadContentSettings_ForwardToCallback&) = delete;
  PageHandler_ReadContentSettings_ForwardToCallback& operator=(const PageHandler_ReadContentSettings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ReadContentSettingsCallback callback_;
};

class PageHandler_GetTpcdMetadataGrants_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTpcdMetadataGrants_ForwardToCallback(
      PageHandler::GetTpcdMetadataGrantsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTpcdMetadataGrants_ForwardToCallback(const PageHandler_GetTpcdMetadataGrants_ForwardToCallback&) = delete;
  PageHandler_GetTpcdMetadataGrants_ForwardToCallback& operator=(const PageHandler_GetTpcdMetadataGrants_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTpcdMetadataGrantsCallback callback_;
};

class PageHandler_ContentSettingsPatternToString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ContentSettingsPatternToString_ForwardToCallback(
      PageHandler::ContentSettingsPatternToStringCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ContentSettingsPatternToString_ForwardToCallback(const PageHandler_ContentSettingsPatternToString_ForwardToCallback&) = delete;
  PageHandler_ContentSettingsPatternToString_ForwardToCallback& operator=(const PageHandler_ContentSettingsPatternToString_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ContentSettingsPatternToStringCallback callback_;
};

class PageHandler_StringToContentSettingsPattern_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_StringToContentSettingsPattern_ForwardToCallback(
      PageHandler::StringToContentSettingsPatternCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_StringToContentSettingsPattern_ForwardToCallback(const PageHandler_StringToContentSettingsPattern_ForwardToCallback&) = delete;
  PageHandler_StringToContentSettingsPattern_ForwardToCallback& operator=(const PageHandler_StringToContentSettingsPattern_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::StringToContentSettingsPatternCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::ReadPrefsWithPrefixes(
    const std::vector<std::string>& in_pref_prefixes, ReadPrefsWithPrefixesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send privacy_sandbox_internals::mojom::PageHandler::ReadPrefsWithPrefixes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pref_prefixes"), in_pref_prefixes,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReadPrefsWithPrefixes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_ReadPrefsWithPrefixes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pref_prefixes)::BaseType>
      pref_prefixes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pref_prefixes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_pref_prefixes,
    pref_prefixes_fragment,
    &pref_prefixes_validate_params);

  params->pref_prefixes.Set(
      pref_prefixes_fragment.is_null() ? nullptr : pref_prefixes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pref_prefixes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pref_prefixes in PageHandler.ReadPrefsWithPrefixes request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReadPrefsWithPrefixes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ReadPrefsWithPrefixes_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::ReadContentSettings(
    ::content_settings::mojom::ContentSettingsType in_type, ReadContentSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send privacy_sandbox_internals::mojom::PageHandler::ReadContentSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::content_settings::mojom::ContentSettingsType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReadContentSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_ReadContentSettings_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::content_settings::mojom::ContentSettingsType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReadContentSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ReadContentSettings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTpcdMetadataGrants(
    GetTpcdMetadataGrantsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send privacy_sandbox_internals::mojom::PageHandler::GetTpcdMetadataGrants");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTpcdMetadataGrants), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_GetTpcdMetadataGrants_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTpcdMetadataGrants");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTpcdMetadataGrants_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::ContentSettingsPatternToString(
    const ::ContentSettingsPattern& in_pattern, ContentSettingsPatternToStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send privacy_sandbox_internals::mojom::PageHandler::ContentSettingsPatternToString", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pattern"), in_pattern,
                        "<value of type const ::ContentSettingsPattern&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kContentSettingsPatternToString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_ContentSettingsPatternToString_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pattern)::BaseType> pattern_fragment(
          params.message());
  
  mojo::internal::Serialize<::content_settings::mojom::ContentSettingsPatternDataView>(
    in_pattern,
    pattern_fragment);

  params->pattern.Set(
      pattern_fragment.is_null() ? nullptr : pattern_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pattern.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pattern in PageHandler.ContentSettingsPatternToString request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ContentSettingsPatternToString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ContentSettingsPatternToString_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::StringToContentSettingsPattern(
    const std::string& in_s, StringToContentSettingsPatternCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send privacy_sandbox_internals::mojom::PageHandler::StringToContentSettingsPattern", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("s"), in_s,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStringToContentSettingsPattern), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_StringToContentSettingsPattern_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->s)::BaseType> s_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_s,
    s_fragment);

  params->s.Set(
      s_fragment.is_null() ? nullptr : s_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->s.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null s in PageHandler.StringToContentSettingsPattern request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StringToContentSettingsPattern");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_StringToContentSettingsPattern_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_ReadPrefsWithPrefixes_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ReadPrefsWithPrefixesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ReadPrefsWithPrefixes_ProxyToResponder> proxy(
        new PageHandler_ReadPrefsWithPrefixes_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ReadPrefsWithPrefixes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ReadPrefsWithPrefixes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ReadPrefsWithPrefixes_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ReadPrefsWithPrefixesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<PrivacySandboxInternalsPrefPtr> in_prefs);
};

bool PageHandler_ReadPrefsWithPrefixes_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  std::vector<PrivacySandboxInternalsPrefPtr> p_prefs{};
  PageHandler_ReadPrefsWithPrefixes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPrefs(&p_prefs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_prefs));
  }
  return true;
}

void PageHandler_ReadPrefsWithPrefixes_ProxyToResponder::Run(
    std::vector<PrivacySandboxInternalsPrefPtr> in_prefs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply privacy_sandbox_internals::mojom::PageHandler::ReadPrefsWithPrefixes", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prefs"), in_prefs,
                        "<value of type std::vector<PrivacySandboxInternalsPrefPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReadPrefsWithPrefixes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->prefs)::BaseType>
      prefs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& prefs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefDataView>>(
    in_prefs,
    prefs_fragment,
    &prefs_validate_params);

  params->prefs.Set(
      prefs_fragment.is_null() ? nullptr : prefs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->prefs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null prefs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReadPrefsWithPrefixes");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_ReadContentSettings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ReadContentSettingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ReadContentSettings_ProxyToResponder> proxy(
        new PageHandler_ReadContentSettings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ReadContentSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ReadContentSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ReadContentSettings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ReadContentSettingsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::ContentSettingPatternSource>& in_content_settings);
};

bool PageHandler_ReadContentSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ReadContentSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ReadContentSettings_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  std::vector<::ContentSettingPatternSource> p_content_settings{};
  PageHandler_ReadContentSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadContentSettings(&p_content_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_content_settings));
  }
  return true;
}

void PageHandler_ReadContentSettings_ProxyToResponder::Run(
    const std::vector<::ContentSettingPatternSource>& in_content_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply privacy_sandbox_internals::mojom::PageHandler::ReadContentSettings", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_settings"), in_content_settings,
                        "<value of type const std::vector<::ContentSettingPatternSource>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReadContentSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_ReadContentSettings_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_settings)::BaseType>
      content_settings_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& content_settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
    in_content_settings,
    content_settings_fragment,
    &content_settings_validate_params);

  params->content_settings.Set(
      content_settings_fragment.is_null() ? nullptr : content_settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_settings in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReadContentSettings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTpcdMetadataGrants_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTpcdMetadataGrantsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTpcdMetadataGrants_ProxyToResponder> proxy(
        new PageHandler_GetTpcdMetadataGrants_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTpcdMetadataGrants_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTpcdMetadataGrants_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTpcdMetadataGrants_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTpcdMetadataGrantsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::ContentSettingPatternSource>& in_content_settings);
};

bool PageHandler_GetTpcdMetadataGrants_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTpcdMetadataGrants_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTpcdMetadataGrants_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  std::vector<::ContentSettingPatternSource> p_content_settings{};
  PageHandler_GetTpcdMetadataGrants_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadContentSettings(&p_content_settings))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_content_settings));
  }
  return true;
}

void PageHandler_GetTpcdMetadataGrants_ProxyToResponder::Run(
    const std::vector<::ContentSettingPatternSource>& in_content_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply privacy_sandbox_internals::mojom::PageHandler::GetTpcdMetadataGrants", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_settings"), in_content_settings,
                        "<value of type const std::vector<::ContentSettingPatternSource>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTpcdMetadataGrants), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_GetTpcdMetadataGrants_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_settings)::BaseType>
      content_settings_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& content_settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
    in_content_settings,
    content_settings_fragment,
    &content_settings_validate_params);

  params->content_settings.Set(
      content_settings_fragment.is_null() ? nullptr : content_settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_settings in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTpcdMetadataGrants");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_ContentSettingsPatternToString_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ContentSettingsPatternToStringCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ContentSettingsPatternToString_ProxyToResponder> proxy(
        new PageHandler_ContentSettingsPatternToString_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ContentSettingsPatternToString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ContentSettingsPatternToString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ContentSettingsPatternToString_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ContentSettingsPatternToStringCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_s);
};

bool PageHandler_ContentSettingsPatternToString_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ContentSettingsPatternToString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ContentSettingsPatternToString_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  std::string p_s{};
  PageHandler_ContentSettingsPatternToString_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadS(&p_s))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_s));
  }
  return true;
}

void PageHandler_ContentSettingsPatternToString_ProxyToResponder::Run(
    const std::string& in_s) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply privacy_sandbox_internals::mojom::PageHandler::ContentSettingsPatternToString", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("s"), in_s,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kContentSettingsPatternToString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_ContentSettingsPatternToString_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->s)::BaseType> s_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_s,
    s_fragment);

  params->s.Set(
      s_fragment.is_null() ? nullptr : s_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->s.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null s in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ContentSettingsPatternToString");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_StringToContentSettingsPattern_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::StringToContentSettingsPatternCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_StringToContentSettingsPattern_ProxyToResponder> proxy(
        new PageHandler_StringToContentSettingsPattern_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_StringToContentSettingsPattern_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_StringToContentSettingsPattern_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_StringToContentSettingsPattern_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::StringToContentSettingsPatternCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::ContentSettingsPattern& in_pattern);
};

bool PageHandler_StringToContentSettingsPattern_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_StringToContentSettingsPattern_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_StringToContentSettingsPattern_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.4
  bool success = true;
  ::ContentSettingsPattern p_pattern{};
  PageHandler_StringToContentSettingsPattern_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPattern(&p_pattern))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_pattern));
  }
  return true;
}

void PageHandler_StringToContentSettingsPattern_ProxyToResponder::Run(
    const ::ContentSettingsPattern& in_pattern) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply privacy_sandbox_internals::mojom::PageHandler::StringToContentSettingsPattern", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pattern"), in_pattern,
                        "<value of type const ::ContentSettingsPattern&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStringToContentSettingsPattern), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox_internals::mojom::internal::PageHandler_StringToContentSettingsPattern_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pattern)::BaseType> pattern_fragment(
          params.message());
  
  mojo::internal::Serialize<::content_settings::mojom::ContentSettingsPatternDataView>(
    in_pattern,
    pattern_fragment);

  params->pattern.Set(
      pattern_fragment.is_null() ? nullptr : pattern_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pattern.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pattern in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StringToContentSettingsPattern");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kReadPrefsWithPrefixes: {
      break;
    }
    case messages::PageHandler::kReadContentSettings: {
      break;
    }
    case messages::PageHandler::kGetTpcdMetadataGrants: {
      break;
    }
    case messages::PageHandler::kContentSettingsPatternToString: {
      break;
    }
    case messages::PageHandler::kStringToContentSettingsPattern: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kReadPrefsWithPrefixes: {
      internal::PageHandler_ReadPrefsWithPrefixes_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ReadPrefsWithPrefixes_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      std::vector<std::string> p_pref_prefixes{};
      PageHandler_ReadPrefsWithPrefixes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrefPrefixes(&p_pref_prefixes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_ReadPrefsWithPrefixes_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadPrefsWithPrefixes(        
        std::move(p_pref_prefixes), std::move(callback));
      return true;
    }
    case messages::PageHandler::kReadContentSettings: {
      internal::PageHandler_ReadContentSettings_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ReadContentSettings_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      ::content_settings::mojom::ContentSettingsType p_type{};
      PageHandler_ReadContentSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_ReadContentSettings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadContentSettings(        
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTpcdMetadataGrants: {
      internal::PageHandler_GetTpcdMetadataGrants_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTpcdMetadataGrants_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_GetTpcdMetadataGrants_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_GetTpcdMetadataGrants_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTpcdMetadataGrants(std::move(callback));
      return true;
    }
    case messages::PageHandler::kContentSettingsPatternToString: {
      internal::PageHandler_ContentSettingsPatternToString_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ContentSettingsPatternToString_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      ::ContentSettingsPattern p_pattern{};
      PageHandler_ContentSettingsPatternToString_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPattern(&p_pattern))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_ContentSettingsPatternToString_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContentSettingsPatternToString(        
        std::move(p_pattern), std::move(callback));
      return true;
    }
    case messages::PageHandler::kStringToContentSettingsPattern: {
      internal::PageHandler_StringToContentSettingsPattern_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_StringToContentSettingsPattern_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_s{};
      PageHandler_StringToContentSettingsPattern_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadS(&p_s))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          PageHandler_StringToContentSettingsPattern_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StringToContentSettingsPattern(        
        std::move(p_s), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_ReadPrefsWithPrefixes_Params_Data::Validate,
     &internal::PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data::Validate},
    { &internal::PageHandler_ReadContentSettings_Params_Data::Validate,
     &internal::PageHandler_ReadContentSettings_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTpcdMetadataGrants_Params_Data::Validate,
     &internal::PageHandler_GetTpcdMetadataGrants_ResponseParams_Data::Validate},
    { &internal::PageHandler_ContentSettingsPatternToString_Params_Data::Validate,
     &internal::PageHandler_ContentSettingsPatternToString_ResponseParams_Data::Validate},
    { &internal::PageHandler_StringToContentSettingsPattern_Params_Data::Validate,
     &internal::PageHandler_StringToContentSettingsPattern_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::privacy_sandbox_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::privacy_sandbox_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::privacy_sandbox_internals::mojom::Page::Name_,
    {});
}



}  // privacy_sandbox_internals::mojom


namespace mojo {


// static
bool StructTraits<::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPref::DataView, ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr>::Read(
    ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPref::DataView input,
    ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr* output) {
  bool success = true;
  ::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPrefPtr result(::privacy_sandbox_internals::mojom::PrivacySandboxInternalsPref::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace privacy_sandbox_internals::mojom {


void PageHandlerInterceptorForTesting::ReadPrefsWithPrefixes(const std::vector<std::string>& pref_prefixes, ReadPrefsWithPrefixesCallback callback) {
  GetForwardingInterface()->ReadPrefsWithPrefixes(
    std::move(pref_prefixes)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::ReadContentSettings(::content_settings::mojom::ContentSettingsType type, ReadContentSettingsCallback callback) {
  GetForwardingInterface()->ReadContentSettings(
    std::move(type)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTpcdMetadataGrants(GetTpcdMetadataGrantsCallback callback) {
  GetForwardingInterface()->GetTpcdMetadataGrants(std::move(callback));
}
void PageHandlerInterceptorForTesting::ContentSettingsPatternToString(const ::ContentSettingsPattern& pattern, ContentSettingsPatternToStringCallback callback) {
  GetForwardingInterface()->ContentSettingsPatternToString(
    std::move(pattern)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::StringToContentSettingsPattern(const std::string& s, StringToContentSettingsPatternCallback callback) {
  GetForwardingInterface()->StringToContentSettingsPattern(
    std::move(s)
    , std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::ReadPrefsWithPrefixes(
    const std::vector<std::string>& pref_prefixes, std::vector<PrivacySandboxInternalsPrefPtr>* out_prefs) {
  base::RunLoop loop;
  proxy_->ReadPrefsWithPrefixes(
      std::move(pref_prefixes),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<PrivacySandboxInternalsPrefPtr>* out_prefs
,
             std::vector<PrivacySandboxInternalsPrefPtr> prefs) {*out_prefs = std::move(prefs);
            loop->Quit();
          },
          &loop,
          out_prefs));
  loop.Run();
}

std::vector<PrivacySandboxInternalsPrefPtr> PageHandlerAsyncWaiter::ReadPrefsWithPrefixes(
    const std::vector<std::string>& pref_prefixes) {
  std::vector<PrivacySandboxInternalsPrefPtr> async_wait_result;
  ReadPrefsWithPrefixes(std::move(pref_prefixes),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::ReadContentSettings(
    ::content_settings::mojom::ContentSettingsType type, std::vector<::ContentSettingPatternSource>* out_content_settings) {
  base::RunLoop loop;
  proxy_->ReadContentSettings(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::ContentSettingPatternSource>* out_content_settings
,
             const std::vector<::ContentSettingPatternSource>& content_settings) {*out_content_settings = std::move(content_settings);
            loop->Quit();
          },
          &loop,
          out_content_settings));
  loop.Run();
}

std::vector<::ContentSettingPatternSource> PageHandlerAsyncWaiter::ReadContentSettings(
    ::content_settings::mojom::ContentSettingsType type) {
  std::vector<::ContentSettingPatternSource> async_wait_result;
  ReadContentSettings(std::move(type),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTpcdMetadataGrants(
    std::vector<::ContentSettingPatternSource>* out_content_settings) {
  base::RunLoop loop;
  proxy_->GetTpcdMetadataGrants(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::ContentSettingPatternSource>* out_content_settings
,
             const std::vector<::ContentSettingPatternSource>& content_settings) {*out_content_settings = std::move(content_settings);
            loop->Quit();
          },
          &loop,
          out_content_settings));
  loop.Run();
}

std::vector<::ContentSettingPatternSource> PageHandlerAsyncWaiter::GetTpcdMetadataGrants(
    ) {
  std::vector<::ContentSettingPatternSource> async_wait_result;
  GetTpcdMetadataGrants(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::ContentSettingsPatternToString(
    const ::ContentSettingsPattern& pattern, std::string* out_s) {
  base::RunLoop loop;
  proxy_->ContentSettingsPatternToString(
      std::move(pattern),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_s
,
             const std::string& s) {*out_s = std::move(s);
            loop->Quit();
          },
          &loop,
          out_s));
  loop.Run();
}

std::string PageHandlerAsyncWaiter::ContentSettingsPatternToString(
    const ::ContentSettingsPattern& pattern) {
  std::string async_wait_result;
  ContentSettingsPatternToString(std::move(pattern),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::StringToContentSettingsPattern(
    const std::string& s, ::ContentSettingsPattern* out_pattern) {
  base::RunLoop loop;
  proxy_->StringToContentSettingsPattern(
      std::move(s),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ContentSettingsPattern* out_pattern
,
             const ::ContentSettingsPattern& pattern) {*out_pattern = std::move(pattern);
            loop->Quit();
          },
          &loop,
          out_pattern));
  loop.Run();
}

::ContentSettingsPattern PageHandlerAsyncWaiter::StringToContentSettingsPattern(
    const std::string& s) {
  ::ContentSettingsPattern async_wait_result;
  StringToContentSettingsPattern(std::move(s),&async_wait_result);
  return async_wait_result;
}




PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // privacy_sandbox_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif