// chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-params-data.h"
namespace privacy_sandbox_internals {
namespace mojom {

namespace internal {


// static
bool PrivacySandboxInternalsPref_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrivacySandboxInternalsPref_Data* object =
      static_cast<const PrivacySandboxInternalsPref_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  return true;
}

PrivacySandboxInternalsPref_Data::PrivacySandboxInternalsPref_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReadPrefsWithPrefixes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReadPrefsWithPrefixes_Params_Data* object =
      static_cast<const PageHandler_ReadPrefsWithPrefixes_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pref_prefixes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pref_prefixes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->pref_prefixes, validation_context,
                                         &pref_prefixes_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ReadPrefsWithPrefixes_Params_Data::PageHandler_ReadPrefsWithPrefixes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data* object =
      static_cast<const PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prefs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prefs, validation_context,
                                         &prefs_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data::PageHandler_ReadPrefsWithPrefixes_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReadContentSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReadContentSettings_Params_Data* object =
      static_cast<const PageHandler_ReadContentSettings_Params_Data*>(data);


  if (!::content_settings::mojom::internal::ContentSettingsType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

PageHandler_ReadContentSettings_Params_Data::PageHandler_ReadContentSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReadContentSettings_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReadContentSettings_ResponseParams_Data* object =
      static_cast<const PageHandler_ReadContentSettings_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_settings, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_settings, validation_context,
                                         &content_settings_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ReadContentSettings_ResponseParams_Data::PageHandler_ReadContentSettings_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTpcdMetadataGrants_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTpcdMetadataGrants_Params_Data* object =
      static_cast<const PageHandler_GetTpcdMetadataGrants_Params_Data*>(data);

  return true;
}

PageHandler_GetTpcdMetadataGrants_Params_Data::PageHandler_GetTpcdMetadataGrants_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTpcdMetadataGrants_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTpcdMetadataGrants_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTpcdMetadataGrants_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_settings, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_settings, validation_context,
                                         &content_settings_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetTpcdMetadataGrants_ResponseParams_Data::PageHandler_GetTpcdMetadataGrants_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ContentSettingsPatternToString_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ContentSettingsPatternToString_Params_Data* object =
      static_cast<const PageHandler_ContentSettingsPatternToString_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pattern, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pattern, validation_context))
    return false;

  return true;
}

PageHandler_ContentSettingsPatternToString_Params_Data::PageHandler_ContentSettingsPatternToString_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ContentSettingsPatternToString_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ContentSettingsPatternToString_ResponseParams_Data* object =
      static_cast<const PageHandler_ContentSettingsPatternToString_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->s, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& s_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->s, validation_context,
                                         &s_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ContentSettingsPatternToString_ResponseParams_Data::PageHandler_ContentSettingsPatternToString_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StringToContentSettingsPattern_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StringToContentSettingsPattern_Params_Data* object =
      static_cast<const PageHandler_StringToContentSettingsPattern_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->s, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& s_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->s, validation_context,
                                         &s_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_StringToContentSettingsPattern_Params_Data::PageHandler_StringToContentSettingsPattern_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_StringToContentSettingsPattern_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_StringToContentSettingsPattern_ResponseParams_Data* object =
      static_cast<const PageHandler_StringToContentSettingsPattern_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pattern, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pattern, validation_context))
    return false;

  return true;
}

PageHandler_StringToContentSettingsPattern_ResponseParams_Data::PageHandler_StringToContentSettingsPattern_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace privacy_sandbox_internals