// chrome/browser/ui/webui/password_manager/password_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace password_manager::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "password_manager.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "password_manager.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kExtendAuthValidityMinVersion = 0,
    kDeleteAllPasswordManagerDataMinVersion = 0,
    kCopyPlaintextBackupPasswordMinVersion = 0,
    kRemoveBackupPasswordMinVersion = 0,
    kGetActorLoginPermissionsMinVersion = 0,
    kRevokeActorLoginPermissionMinVersion = 0,
    kChangePasswordManagerPinMinVersion = 0,
    kShowAddShortcutDialogMinVersion = 0,
    kIsAccountStorageEnabledMinVersion = 0,
    kSetAccountStorageEnabledMinVersion = 0,
    kShouldShowAccountStorageSettingToggleMinVersion = 0,
    kIsPasswordManagerPinAvailableMinVersion = 0,
    kSwitchBiometricAuthBeforeFillingStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ExtendAuthValidity_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteAllPasswordManagerData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyPlaintextBackupPassword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveBackupPassword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetActorLoginPermissions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RevokeActorLoginPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ChangePasswordManagerPin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowAddShortcutDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsAccountStorageEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAccountStorageEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShouldShowAccountStorageSettingToggle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsPasswordManagerPinAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SwitchBiometricAuthBeforeFillingState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void ExtendAuthValidity() = 0;

  using DeleteAllPasswordManagerDataCallback = base::OnceCallback<void(bool)>;
  using DeleteAllPasswordManagerDataMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteAllPasswordManagerData(DeleteAllPasswordManagerDataCallback callback) = 0;

  using CopyPlaintextBackupPasswordCallback = base::OnceCallback<void(bool)>;
  using CopyPlaintextBackupPasswordMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CopyPlaintextBackupPassword(int32_t id, CopyPlaintextBackupPasswordCallback callback) = 0;

  virtual void RemoveBackupPassword(int32_t id) = 0;

  using GetActorLoginPermissionsCallback = base::OnceCallback<void(std::vector<ActorLoginPermissionPtr>)>;
  using GetActorLoginPermissionsMojoCallback = base::OnceCallback<void(std::vector<ActorLoginPermissionPtr>)>;

  virtual void GetActorLoginPermissions(GetActorLoginPermissionsCallback callback) = 0;

  virtual void RevokeActorLoginPermission(ActorLoginPermissionPtr site) = 0;

  using ChangePasswordManagerPinCallback = base::OnceCallback<void(bool)>;
  using ChangePasswordManagerPinMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ChangePasswordManagerPin(ChangePasswordManagerPinCallback callback) = 0;

  virtual void ShowAddShortcutDialog() = 0;

  using IsAccountStorageEnabledCallback = base::OnceCallback<void(bool)>;
  using IsAccountStorageEnabledMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsAccountStorageEnabled(IsAccountStorageEnabledCallback callback) = 0;

  virtual void SetAccountStorageEnabled(bool enabled) = 0;

  using ShouldShowAccountStorageSettingToggleCallback = base::OnceCallback<void(bool)>;
  using ShouldShowAccountStorageSettingToggleMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ShouldShowAccountStorageSettingToggle(ShouldShowAccountStorageSettingToggleCallback callback) = 0;

  using IsPasswordManagerPinAvailableCallback = base::OnceCallback<void(bool)>;
  using IsPasswordManagerPinAvailableMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsPasswordManagerPinAvailable(IsPasswordManagerPinAvailableCallback callback) = 0;

  using SwitchBiometricAuthBeforeFillingStateCallback = base::OnceCallback<void(bool)>;
  using SwitchBiometricAuthBeforeFillingStateMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SwitchBiometricAuthBeforeFillingState(SwitchBiometricAuthBeforeFillingStateCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "password_manager.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ExtendAuthValidity() final;
  
  void DeleteAllPasswordManagerData(DeleteAllPasswordManagerDataCallback callback) final;
  
  void CopyPlaintextBackupPassword(int32_t id, CopyPlaintextBackupPasswordCallback callback) final;
  
  void RemoveBackupPassword(int32_t id) final;
  
  void GetActorLoginPermissions(GetActorLoginPermissionsCallback callback) final;
  
  void RevokeActorLoginPermission(ActorLoginPermissionPtr site) final;
  
  void ChangePasswordManagerPin(ChangePasswordManagerPinCallback callback) final;
  
  void ShowAddShortcutDialog() final;
  
  void IsAccountStorageEnabled(IsAccountStorageEnabledCallback callback) final;
  
  void SetAccountStorageEnabled(bool enabled) final;
  
  void ShouldShowAccountStorageSettingToggle(ShouldShowAccountStorageSettingToggleCallback callback) final;
  
  void IsPasswordManagerPinAvailable(IsPasswordManagerPinAvailableCallback callback) final;
  
  void SwitchBiometricAuthBeforeFillingState(SwitchBiometricAuthBeforeFillingStateCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  DomainInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DomainInfo, T>::value>;
  using DataView = DomainInfoDataView;
  using Data_ = internal::DomainInfo_Data;

  template <typename... Args>
  static DomainInfoPtr New(Args&&... args) {
    return DomainInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DomainInfoPtr From(const U& u) {
    return mojo::TypeConverter<DomainInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DomainInfo>::Convert(*this);
  }


  DomainInfo();

  DomainInfo(
      const std::string& human_readable_name,
      const ::GURL& url,
      const std::string& signon_realm);


  ~DomainInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DomainInfoPtr>
  DomainInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DomainInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DomainInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DomainInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DomainInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DomainInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DomainInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DomainInfo_UnserializedMessageContext<
            UserType, DomainInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DomainInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DomainInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DomainInfo_UnserializedMessageContext<
            UserType, DomainInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DomainInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string human_readable_name;
  
  ::GURL url;
  
  std::string signon_realm;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DomainInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DomainInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DomainInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DomainInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ActorLoginPermission {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ActorLoginPermission, T>::value>;
  using DataView = ActorLoginPermissionDataView;
  using Data_ = internal::ActorLoginPermission_Data;

  template <typename... Args>
  static ActorLoginPermissionPtr New(Args&&... args) {
    return ActorLoginPermissionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ActorLoginPermissionPtr From(const U& u) {
    return mojo::TypeConverter<ActorLoginPermissionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ActorLoginPermission>::Convert(*this);
  }


  ActorLoginPermission();

  ActorLoginPermission(
      DomainInfoPtr domain_info,
      const ::GURL& favicon_url,
      const std::string& username);

ActorLoginPermission(const ActorLoginPermission&) = delete;
ActorLoginPermission& operator=(const ActorLoginPermission&) = delete;

  ~ActorLoginPermission();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ActorLoginPermissionPtr>
  ActorLoginPermissionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ActorLoginPermission::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ActorLoginPermission::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ActorLoginPermission::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ActorLoginPermission::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ActorLoginPermission::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ActorLoginPermission::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ActorLoginPermission_UnserializedMessageContext<
            UserType, ActorLoginPermission::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ActorLoginPermission::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ActorLoginPermission::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ActorLoginPermission_UnserializedMessageContext<
            UserType, ActorLoginPermission::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ActorLoginPermission::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DomainInfoPtr domain_info;
  
  ::GURL favicon_url;
  
  std::string username;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ActorLoginPermission::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ActorLoginPermission::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ActorLoginPermission::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ActorLoginPermission::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DomainInfoPtr DomainInfo::Clone() const {
  return New(
      mojo::Clone(human_readable_name),
      mojo::Clone(url),
      mojo::Clone(signon_realm)
  );
}

template <typename T, DomainInfo::EnableIfSame<T>*>
bool DomainInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->human_readable_name, other_struct.human_readable_name))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->signon_realm, other_struct.signon_realm))
    return false;
  return true;
}

template <typename T, DomainInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.human_readable_name < rhs.human_readable_name)
    return true;
  if (rhs.human_readable_name < lhs.human_readable_name)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.signon_realm < rhs.signon_realm)
    return true;
  if (rhs.signon_realm < lhs.signon_realm)
    return false;
  return false;
}
template <typename StructPtrType>
ActorLoginPermissionPtr ActorLoginPermission::Clone() const {
  return New(
      mojo::Clone(domain_info),
      mojo::Clone(favicon_url),
      mojo::Clone(username)
  );
}

template <typename T, ActorLoginPermission::EnableIfSame<T>*>
bool ActorLoginPermission::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->domain_info, other_struct.domain_info))
    return false;
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  if (!mojo::Equals(this->username, other_struct.username))
    return false;
  return true;
}

template <typename T, ActorLoginPermission::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.domain_info < rhs.domain_info)
    return true;
  if (rhs.domain_info < lhs.domain_info)
    return false;
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  if (lhs.username < rhs.username)
    return true;
  if (rhs.username < lhs.username)
    return false;
  return false;
}


}  // password_manager::mojom

namespace mojo {


template <>
struct  StructTraits<::password_manager::mojom::DomainInfo::DataView,
                                         ::password_manager::mojom::DomainInfoPtr> {
  static bool IsNull(const ::password_manager::mojom::DomainInfoPtr& input) { return !input; }
  static void SetToNull(::password_manager::mojom::DomainInfoPtr* output) { output->reset(); }

  static const decltype(::password_manager::mojom::DomainInfo::human_readable_name)& human_readable_name(
      const ::password_manager::mojom::DomainInfoPtr& input) {
    return input->human_readable_name;
  }

  static const decltype(::password_manager::mojom::DomainInfo::url)& url(
      const ::password_manager::mojom::DomainInfoPtr& input) {
    return input->url;
  }

  static const decltype(::password_manager::mojom::DomainInfo::signon_realm)& signon_realm(
      const ::password_manager::mojom::DomainInfoPtr& input) {
    return input->signon_realm;
  }

  static bool Read(::password_manager::mojom::DomainInfo::DataView input, ::password_manager::mojom::DomainInfoPtr* output);
};


template <>
struct  StructTraits<::password_manager::mojom::ActorLoginPermission::DataView,
                                         ::password_manager::mojom::ActorLoginPermissionPtr> {
  static bool IsNull(const ::password_manager::mojom::ActorLoginPermissionPtr& input) { return !input; }
  static void SetToNull(::password_manager::mojom::ActorLoginPermissionPtr* output) { output->reset(); }

  static const decltype(::password_manager::mojom::ActorLoginPermission::domain_info)& domain_info(
      const ::password_manager::mojom::ActorLoginPermissionPtr& input) {
    return input->domain_info;
  }

  static const decltype(::password_manager::mojom::ActorLoginPermission::favicon_url)& favicon_url(
      const ::password_manager::mojom::ActorLoginPermissionPtr& input) {
    return input->favicon_url;
  }

  static const decltype(::password_manager::mojom::ActorLoginPermission::username)& username(
      const ::password_manager::mojom::ActorLoginPermissionPtr& input) {
    return input->username;
  }

  static bool Read(::password_manager::mojom::ActorLoginPermission::DataView input, ::password_manager::mojom::ActorLoginPermissionPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_H_