// chrome/browser/ui/webui/password_manager/password_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/password_manager/password_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-params-data.h"
#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-import-headers.h"
#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-test-utils.h"


namespace password_manager::mojom {
DomainInfo::DomainInfo()
    : human_readable_name(),
      url(),
      signon_realm() {}

DomainInfo::DomainInfo(
    const std::string& human_readable_name_in,
    const ::GURL& url_in,
    const std::string& signon_realm_in)
    : human_readable_name(std::move(human_readable_name_in)),
      url(std::move(url_in)),
      signon_realm(std::move(signon_realm_in)) {}

DomainInfo::~DomainInfo() = default;

void DomainInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "human_readable_name"), this->human_readable_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signon_realm"), this->signon_realm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DomainInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ActorLoginPermission::ActorLoginPermission()
    : domain_info(),
      favicon_url(),
      username() {}

ActorLoginPermission::ActorLoginPermission(
    DomainInfoPtr domain_info_in,
    const ::GURL& favicon_url_in,
    const std::string& username_in)
    : domain_info(std::move(domain_info_in)),
      favicon_url(std::move(favicon_url_in)),
      username(std::move(username_in)) {}

ActorLoginPermission::~ActorLoginPermission() = default;

void ActorLoginPermission::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain_info"), this->domain_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DomainInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username"), this->username,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ActorLoginPermission::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive password_manager::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply password_manager::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x703aab4f;  // IPCStableHash for password_manager::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send password_manager::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::password_manager::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::password_manager::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::password_manager::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kExtendAuthValidity: {
      return &PageHandler::ExtendAuthValidity_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeleteAllPasswordManagerData: {
      return &PageHandler::DeleteAllPasswordManagerData_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCopyPlaintextBackupPassword: {
      return &PageHandler::CopyPlaintextBackupPassword_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRemoveBackupPassword: {
      return &PageHandler::RemoveBackupPassword_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetActorLoginPermissions: {
      return &PageHandler::GetActorLoginPermissions_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRevokeActorLoginPermission: {
      return &PageHandler::RevokeActorLoginPermission_Sym::IPCStableHash;
    }
    case messages::PageHandler::kChangePasswordManagerPin: {
      return &PageHandler::ChangePasswordManagerPin_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowAddShortcutDialog: {
      return &PageHandler::ShowAddShortcutDialog_Sym::IPCStableHash;
    }
    case messages::PageHandler::kIsAccountStorageEnabled: {
      return &PageHandler::IsAccountStorageEnabled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetAccountStorageEnabled: {
      return &PageHandler::SetAccountStorageEnabled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShouldShowAccountStorageSettingToggle: {
      return &PageHandler::ShouldShowAccountStorageSettingToggle_Sym::IPCStableHash;
    }
    case messages::PageHandler::kIsPasswordManagerPinAvailable: {
      return &PageHandler::IsPasswordManagerPinAvailable_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSwitchBiometricAuthBeforeFillingState: {
      return &PageHandler::SwitchBiometricAuthBeforeFillingState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kExtendAuthValidity:
            return "Receive password_manager::mojom::PageHandler::ExtendAuthValidity";
      case messages::PageHandler::kDeleteAllPasswordManagerData:
            return "Receive password_manager::mojom::PageHandler::DeleteAllPasswordManagerData";
      case messages::PageHandler::kCopyPlaintextBackupPassword:
            return "Receive password_manager::mojom::PageHandler::CopyPlaintextBackupPassword";
      case messages::PageHandler::kRemoveBackupPassword:
            return "Receive password_manager::mojom::PageHandler::RemoveBackupPassword";
      case messages::PageHandler::kGetActorLoginPermissions:
            return "Receive password_manager::mojom::PageHandler::GetActorLoginPermissions";
      case messages::PageHandler::kRevokeActorLoginPermission:
            return "Receive password_manager::mojom::PageHandler::RevokeActorLoginPermission";
      case messages::PageHandler::kChangePasswordManagerPin:
            return "Receive password_manager::mojom::PageHandler::ChangePasswordManagerPin";
      case messages::PageHandler::kShowAddShortcutDialog:
            return "Receive password_manager::mojom::PageHandler::ShowAddShortcutDialog";
      case messages::PageHandler::kIsAccountStorageEnabled:
            return "Receive password_manager::mojom::PageHandler::IsAccountStorageEnabled";
      case messages::PageHandler::kSetAccountStorageEnabled:
            return "Receive password_manager::mojom::PageHandler::SetAccountStorageEnabled";
      case messages::PageHandler::kShouldShowAccountStorageSettingToggle:
            return "Receive password_manager::mojom::PageHandler::ShouldShowAccountStorageSettingToggle";
      case messages::PageHandler::kIsPasswordManagerPinAvailable:
            return "Receive password_manager::mojom::PageHandler::IsPasswordManagerPinAvailable";
      case messages::PageHandler::kSwitchBiometricAuthBeforeFillingState:
            return "Receive password_manager::mojom::PageHandler::SwitchBiometricAuthBeforeFillingState";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kExtendAuthValidity:
            return "Receive reply password_manager::mojom::PageHandler::ExtendAuthValidity";
      case messages::PageHandler::kDeleteAllPasswordManagerData:
            return "Receive reply password_manager::mojom::PageHandler::DeleteAllPasswordManagerData";
      case messages::PageHandler::kCopyPlaintextBackupPassword:
            return "Receive reply password_manager::mojom::PageHandler::CopyPlaintextBackupPassword";
      case messages::PageHandler::kRemoveBackupPassword:
            return "Receive reply password_manager::mojom::PageHandler::RemoveBackupPassword";
      case messages::PageHandler::kGetActorLoginPermissions:
            return "Receive reply password_manager::mojom::PageHandler::GetActorLoginPermissions";
      case messages::PageHandler::kRevokeActorLoginPermission:
            return "Receive reply password_manager::mojom::PageHandler::RevokeActorLoginPermission";
      case messages::PageHandler::kChangePasswordManagerPin:
            return "Receive reply password_manager::mojom::PageHandler::ChangePasswordManagerPin";
      case messages::PageHandler::kShowAddShortcutDialog:
            return "Receive reply password_manager::mojom::PageHandler::ShowAddShortcutDialog";
      case messages::PageHandler::kIsAccountStorageEnabled:
            return "Receive reply password_manager::mojom::PageHandler::IsAccountStorageEnabled";
      case messages::PageHandler::kSetAccountStorageEnabled:
            return "Receive reply password_manager::mojom::PageHandler::SetAccountStorageEnabled";
      case messages::PageHandler::kShouldShowAccountStorageSettingToggle:
            return "Receive reply password_manager::mojom::PageHandler::ShouldShowAccountStorageSettingToggle";
      case messages::PageHandler::kIsPasswordManagerPinAvailable:
            return "Receive reply password_manager::mojom::PageHandler::IsPasswordManagerPinAvailable";
      case messages::PageHandler::kSwitchBiometricAuthBeforeFillingState:
            return "Receive reply password_manager::mojom::PageHandler::SwitchBiometricAuthBeforeFillingState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::ExtendAuthValidity_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbb61841;  // IPCStableHash for password_manager::mojom::PageHandler::ExtendAuthValidity
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeleteAllPasswordManagerData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25f7faa2;  // IPCStableHash for password_manager::mojom::PageHandler::DeleteAllPasswordManagerData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CopyPlaintextBackupPassword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c66b296;  // IPCStableHash for password_manager::mojom::PageHandler::CopyPlaintextBackupPassword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RemoveBackupPassword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x32b38035;  // IPCStableHash for password_manager::mojom::PageHandler::RemoveBackupPassword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetActorLoginPermissions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0d80b56f;  // IPCStableHash for password_manager::mojom::PageHandler::GetActorLoginPermissions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RevokeActorLoginPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6bb3fb01;  // IPCStableHash for password_manager::mojom::PageHandler::RevokeActorLoginPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ChangePasswordManagerPin_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x627ab70d;  // IPCStableHash for password_manager::mojom::PageHandler::ChangePasswordManagerPin
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowAddShortcutDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c1a9bd4;  // IPCStableHash for password_manager::mojom::PageHandler::ShowAddShortcutDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::IsAccountStorageEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d573792;  // IPCStableHash for password_manager::mojom::PageHandler::IsAccountStorageEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetAccountStorageEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a0b73b5;  // IPCStableHash for password_manager::mojom::PageHandler::SetAccountStorageEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShouldShowAccountStorageSettingToggle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ad0abcc;  // IPCStableHash for password_manager::mojom::PageHandler::ShouldShowAccountStorageSettingToggle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::IsPasswordManagerPinAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f515de2;  // IPCStableHash for password_manager::mojom::PageHandler::IsPasswordManagerPinAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SwitchBiometricAuthBeforeFillingState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c209ffb;  // IPCStableHash for password_manager::mojom::PageHandler::SwitchBiometricAuthBeforeFillingState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_DeleteAllPasswordManagerData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DeleteAllPasswordManagerData_ForwardToCallback(
      PageHandler::DeleteAllPasswordManagerDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DeleteAllPasswordManagerData_ForwardToCallback(const PageHandler_DeleteAllPasswordManagerData_ForwardToCallback&) = delete;
  PageHandler_DeleteAllPasswordManagerData_ForwardToCallback& operator=(const PageHandler_DeleteAllPasswordManagerData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DeleteAllPasswordManagerDataCallback callback_;
};

class PageHandler_CopyPlaintextBackupPassword_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_CopyPlaintextBackupPassword_ForwardToCallback(
      PageHandler::CopyPlaintextBackupPasswordCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_CopyPlaintextBackupPassword_ForwardToCallback(const PageHandler_CopyPlaintextBackupPassword_ForwardToCallback&) = delete;
  PageHandler_CopyPlaintextBackupPassword_ForwardToCallback& operator=(const PageHandler_CopyPlaintextBackupPassword_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::CopyPlaintextBackupPasswordCallback callback_;
};

class PageHandler_GetActorLoginPermissions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetActorLoginPermissions_ForwardToCallback(
      PageHandler::GetActorLoginPermissionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetActorLoginPermissions_ForwardToCallback(const PageHandler_GetActorLoginPermissions_ForwardToCallback&) = delete;
  PageHandler_GetActorLoginPermissions_ForwardToCallback& operator=(const PageHandler_GetActorLoginPermissions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetActorLoginPermissionsCallback callback_;
};

class PageHandler_ChangePasswordManagerPin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ChangePasswordManagerPin_ForwardToCallback(
      PageHandler::ChangePasswordManagerPinCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ChangePasswordManagerPin_ForwardToCallback(const PageHandler_ChangePasswordManagerPin_ForwardToCallback&) = delete;
  PageHandler_ChangePasswordManagerPin_ForwardToCallback& operator=(const PageHandler_ChangePasswordManagerPin_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ChangePasswordManagerPinCallback callback_;
};

class PageHandler_IsAccountStorageEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_IsAccountStorageEnabled_ForwardToCallback(
      PageHandler::IsAccountStorageEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_IsAccountStorageEnabled_ForwardToCallback(const PageHandler_IsAccountStorageEnabled_ForwardToCallback&) = delete;
  PageHandler_IsAccountStorageEnabled_ForwardToCallback& operator=(const PageHandler_IsAccountStorageEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::IsAccountStorageEnabledCallback callback_;
};

class PageHandler_ShouldShowAccountStorageSettingToggle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_ShouldShowAccountStorageSettingToggle_ForwardToCallback(
      PageHandler::ShouldShowAccountStorageSettingToggleCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_ShouldShowAccountStorageSettingToggle_ForwardToCallback(const PageHandler_ShouldShowAccountStorageSettingToggle_ForwardToCallback&) = delete;
  PageHandler_ShouldShowAccountStorageSettingToggle_ForwardToCallback& operator=(const PageHandler_ShouldShowAccountStorageSettingToggle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::ShouldShowAccountStorageSettingToggleCallback callback_;
};

class PageHandler_IsPasswordManagerPinAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_IsPasswordManagerPinAvailable_ForwardToCallback(
      PageHandler::IsPasswordManagerPinAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_IsPasswordManagerPinAvailable_ForwardToCallback(const PageHandler_IsPasswordManagerPinAvailable_ForwardToCallback&) = delete;
  PageHandler_IsPasswordManagerPinAvailable_ForwardToCallback& operator=(const PageHandler_IsPasswordManagerPinAvailable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::IsPasswordManagerPinAvailableCallback callback_;
};

class PageHandler_SwitchBiometricAuthBeforeFillingState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_SwitchBiometricAuthBeforeFillingState_ForwardToCallback(
      PageHandler::SwitchBiometricAuthBeforeFillingStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_SwitchBiometricAuthBeforeFillingState_ForwardToCallback(const PageHandler_SwitchBiometricAuthBeforeFillingState_ForwardToCallback&) = delete;
  PageHandler_SwitchBiometricAuthBeforeFillingState_ForwardToCallback& operator=(const PageHandler_SwitchBiometricAuthBeforeFillingState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::SwitchBiometricAuthBeforeFillingStateCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::ExtendAuthValidity(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::ExtendAuthValidity");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kExtendAuthValidity), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_ExtendAuthValidity_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ExtendAuthValidity");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::DeleteAllPasswordManagerData(
    DeleteAllPasswordManagerDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::DeleteAllPasswordManagerData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteAllPasswordManagerData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_DeleteAllPasswordManagerData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteAllPasswordManagerData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DeleteAllPasswordManagerData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::CopyPlaintextBackupPassword(
    int32_t in_id, CopyPlaintextBackupPasswordCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send password_manager::mojom::PageHandler::CopyPlaintextBackupPassword", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCopyPlaintextBackupPassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_CopyPlaintextBackupPassword_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CopyPlaintextBackupPassword");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_CopyPlaintextBackupPassword_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::RemoveBackupPassword(
    int32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send password_manager::mojom::PageHandler::RemoveBackupPassword", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveBackupPassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_RemoveBackupPassword_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveBackupPassword");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetActorLoginPermissions(
    GetActorLoginPermissionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::GetActorLoginPermissions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetActorLoginPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_GetActorLoginPermissions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetActorLoginPermissions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetActorLoginPermissions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::RevokeActorLoginPermission(
    ActorLoginPermissionPtr in_site) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send password_manager::mojom::PageHandler::RevokeActorLoginPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site"), in_site,
                        "<value of type ActorLoginPermissionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRevokeActorLoginPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_RevokeActorLoginPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->site)::BaseType> site_fragment(
          params.message());
  
  mojo::internal::Serialize<::password_manager::mojom::ActorLoginPermissionDataView>(
    in_site,
    site_fragment);

  params->site.Set(
      site_fragment.is_null() ? nullptr : site_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site in PageHandler.RevokeActorLoginPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RevokeActorLoginPermission");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ChangePasswordManagerPin(
    ChangePasswordManagerPinCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::ChangePasswordManagerPin");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kChangePasswordManagerPin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_ChangePasswordManagerPin_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ChangePasswordManagerPin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ChangePasswordManagerPin_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::ShowAddShortcutDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::ShowAddShortcutDialog");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowAddShortcutDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_ShowAddShortcutDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowAddShortcutDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::IsAccountStorageEnabled(
    IsAccountStorageEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::IsAccountStorageEnabled");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsAccountStorageEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_IsAccountStorageEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsAccountStorageEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_IsAccountStorageEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetAccountStorageEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send password_manager::mojom::PageHandler::SetAccountStorageEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetAccountStorageEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_SetAccountStorageEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetAccountStorageEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShouldShowAccountStorageSettingToggle(
    ShouldShowAccountStorageSettingToggleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::ShouldShowAccountStorageSettingToggle");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShouldShowAccountStorageSettingToggle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShouldShowAccountStorageSettingToggle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_ShouldShowAccountStorageSettingToggle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::IsPasswordManagerPinAvailable(
    IsPasswordManagerPinAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::IsPasswordManagerPinAvailable");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsPasswordManagerPinAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_IsPasswordManagerPinAvailable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsPasswordManagerPinAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_IsPasswordManagerPinAvailable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SwitchBiometricAuthBeforeFillingState(
    SwitchBiometricAuthBeforeFillingStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send password_manager::mojom::PageHandler::SwitchBiometricAuthBeforeFillingState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSwitchBiometricAuthBeforeFillingState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SwitchBiometricAuthBeforeFillingState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_SwitchBiometricAuthBeforeFillingState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_DeleteAllPasswordManagerData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DeleteAllPasswordManagerDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DeleteAllPasswordManagerData_ProxyToResponder> proxy(
        new PageHandler_DeleteAllPasswordManagerData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DeleteAllPasswordManagerData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DeleteAllPasswordManagerData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DeleteAllPasswordManagerData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::DeleteAllPasswordManagerDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_DeleteAllPasswordManagerData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  bool p_success{};
  PageHandler_DeleteAllPasswordManagerData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_DeleteAllPasswordManagerData_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::PageHandler::DeleteAllPasswordManagerData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteAllPasswordManagerData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteAllPasswordManagerData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_CopyPlaintextBackupPassword_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::CopyPlaintextBackupPasswordCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_CopyPlaintextBackupPassword_ProxyToResponder> proxy(
        new PageHandler_CopyPlaintextBackupPassword_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_CopyPlaintextBackupPassword_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_CopyPlaintextBackupPassword_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_CopyPlaintextBackupPassword_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::CopyPlaintextBackupPasswordCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_CopyPlaintextBackupPassword_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  bool p_success{};
  PageHandler_CopyPlaintextBackupPassword_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_CopyPlaintextBackupPassword_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::PageHandler::CopyPlaintextBackupPassword", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCopyPlaintextBackupPassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CopyPlaintextBackupPassword");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetActorLoginPermissions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetActorLoginPermissionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetActorLoginPermissions_ProxyToResponder> proxy(
        new PageHandler_GetActorLoginPermissions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetActorLoginPermissions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetActorLoginPermissions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetActorLoginPermissions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetActorLoginPermissionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ActorLoginPermissionPtr> in_sites);
};

bool PageHandler_GetActorLoginPermissions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetActorLoginPermissions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetActorLoginPermissions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.4
  bool success = true;
  std::vector<ActorLoginPermissionPtr> p_sites{};
  PageHandler_GetActorLoginPermissions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSites(&p_sites))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_sites));
  }
  return true;
}

void PageHandler_GetActorLoginPermissions_ProxyToResponder::Run(
    std::vector<ActorLoginPermissionPtr> in_sites) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::PageHandler::GetActorLoginPermissions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sites"), in_sites,
                        "<value of type std::vector<ActorLoginPermissionPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetActorLoginPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_GetActorLoginPermissions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sites)::BaseType>
      sites_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sites_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::password_manager::mojom::ActorLoginPermissionDataView>>(
    in_sites,
    sites_fragment,
    &sites_validate_params);

  params->sites.Set(
      sites_fragment.is_null() ? nullptr : sites_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sites.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sites in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetActorLoginPermissions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_ChangePasswordManagerPin_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ChangePasswordManagerPinCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ChangePasswordManagerPin_ProxyToResponder> proxy(
        new PageHandler_ChangePasswordManagerPin_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ChangePasswordManagerPin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ChangePasswordManagerPin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ChangePasswordManagerPin_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ChangePasswordManagerPinCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_ChangePasswordManagerPin_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ChangePasswordManagerPin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ChangePasswordManagerPin_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.6
  bool success = true;
  bool p_success{};
  PageHandler_ChangePasswordManagerPin_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_ChangePasswordManagerPin_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::PageHandler::ChangePasswordManagerPin", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kChangePasswordManagerPin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_ChangePasswordManagerPin_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ChangePasswordManagerPin");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_IsAccountStorageEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::IsAccountStorageEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_IsAccountStorageEnabled_ProxyToResponder> proxy(
        new PageHandler_IsAccountStorageEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_IsAccountStorageEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_IsAccountStorageEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_IsAccountStorageEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::IsAccountStorageEnabledCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);
};

bool PageHandler_IsAccountStorageEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_IsAccountStorageEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_IsAccountStorageEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.8
  bool success = true;
  bool p_enabled{};
  PageHandler_IsAccountStorageEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enabled));
  }
  return true;
}

void PageHandler_IsAccountStorageEnabled_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::PageHandler::IsAccountStorageEnabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsAccountStorageEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_IsAccountStorageEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsAccountStorageEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_ShouldShowAccountStorageSettingToggle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::ShouldShowAccountStorageSettingToggleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_ShouldShowAccountStorageSettingToggle_ProxyToResponder> proxy(
        new PageHandler_ShouldShowAccountStorageSettingToggle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_ShouldShowAccountStorageSettingToggle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_ShouldShowAccountStorageSettingToggle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_ShouldShowAccountStorageSettingToggle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::ShouldShowAccountStorageSettingToggleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_should_show);
};

bool PageHandler_ShouldShowAccountStorageSettingToggle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.10
  bool success = true;
  bool p_should_show{};
  PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_should_show = input_data_view.should_show();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_should_show));
  }
  return true;
}

void PageHandler_ShouldShowAccountStorageSettingToggle_ProxyToResponder::Run(
    bool in_should_show) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::PageHandler::ShouldShowAccountStorageSettingToggle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_show"), in_should_show,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShouldShowAccountStorageSettingToggle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->should_show = in_should_show;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShouldShowAccountStorageSettingToggle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_IsPasswordManagerPinAvailable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::IsPasswordManagerPinAvailableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_IsPasswordManagerPinAvailable_ProxyToResponder> proxy(
        new PageHandler_IsPasswordManagerPinAvailable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_IsPasswordManagerPinAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_IsPasswordManagerPinAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_IsPasswordManagerPinAvailable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::IsPasswordManagerPinAvailableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_available);
};

bool PageHandler_IsPasswordManagerPinAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.11
  bool success = true;
  bool p_is_available{};
  PageHandler_IsPasswordManagerPinAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_available = input_data_view.is_available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_available));
  }
  return true;
}

void PageHandler_IsPasswordManagerPinAvailable_ProxyToResponder::Run(
    bool in_is_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::PageHandler::IsPasswordManagerPinAvailable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_available"), in_is_available,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsPasswordManagerPinAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_available = in_is_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsPasswordManagerPinAvailable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_SwitchBiometricAuthBeforeFillingState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::SwitchBiometricAuthBeforeFillingStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_SwitchBiometricAuthBeforeFillingState_ProxyToResponder> proxy(
        new PageHandler_SwitchBiometricAuthBeforeFillingState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_SwitchBiometricAuthBeforeFillingState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_SwitchBiometricAuthBeforeFillingState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_SwitchBiometricAuthBeforeFillingState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::SwitchBiometricAuthBeforeFillingStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_SwitchBiometricAuthBeforeFillingState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.12
  bool success = true;
  bool p_success{};
  PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_SwitchBiometricAuthBeforeFillingState_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply password_manager::mojom::PageHandler::SwitchBiometricAuthBeforeFillingState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSwitchBiometricAuthBeforeFillingState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::password_manager::mojom::internal::PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SwitchBiometricAuthBeforeFillingState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kExtendAuthValidity: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ExtendAuthValidity_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ExtendAuthValidity_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_ExtendAuthValidity_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtendAuthValidity(        );
      return true;
    }
    case messages::PageHandler::kDeleteAllPasswordManagerData: {
      break;
    }
    case messages::PageHandler::kCopyPlaintextBackupPassword: {
      break;
    }
    case messages::PageHandler::kRemoveBackupPassword: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RemoveBackupPassword_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RemoveBackupPassword_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      int32_t p_id{};
      PageHandler_RemoveBackupPassword_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveBackupPassword(        
        std::move(p_id));
      return true;
    }
    case messages::PageHandler::kGetActorLoginPermissions: {
      break;
    }
    case messages::PageHandler::kRevokeActorLoginPermission: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RevokeActorLoginPermission_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RevokeActorLoginPermission_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      ActorLoginPermissionPtr p_site{};
      PageHandler_RevokeActorLoginPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSite(&p_site))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RevokeActorLoginPermission(        
        std::move(p_site));
      return true;
    }
    case messages::PageHandler::kChangePasswordManagerPin: {
      break;
    }
    case messages::PageHandler::kShowAddShortcutDialog: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowAddShortcutDialog_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowAddShortcutDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      PageHandler_ShowAddShortcutDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowAddShortcutDialog(        );
      return true;
    }
    case messages::PageHandler::kIsAccountStorageEnabled: {
      break;
    }
    case messages::PageHandler::kSetAccountStorageEnabled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetAccountStorageEnabled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetAccountStorageEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      bool p_enabled{};
      PageHandler_SetAccountStorageEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAccountStorageEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::PageHandler::kShouldShowAccountStorageSettingToggle: {
      break;
    }
    case messages::PageHandler::kIsPasswordManagerPinAvailable: {
      break;
    }
    case messages::PageHandler::kSwitchBiometricAuthBeforeFillingState: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kExtendAuthValidity: {
      break;
    }
    case messages::PageHandler::kDeleteAllPasswordManagerData: {
      internal::PageHandler_DeleteAllPasswordManagerData_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DeleteAllPasswordManagerData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_DeleteAllPasswordManagerData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_DeleteAllPasswordManagerData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteAllPasswordManagerData(std::move(callback));
      return true;
    }
    case messages::PageHandler::kCopyPlaintextBackupPassword: {
      internal::PageHandler_CopyPlaintextBackupPassword_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_CopyPlaintextBackupPassword_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      int32_t p_id{};
      PageHandler_CopyPlaintextBackupPassword_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_CopyPlaintextBackupPassword_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyPlaintextBackupPassword(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::PageHandler::kRemoveBackupPassword: {
      break;
    }
    case messages::PageHandler::kGetActorLoginPermissions: {
      internal::PageHandler_GetActorLoginPermissions_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetActorLoginPermissions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_GetActorLoginPermissions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          PageHandler_GetActorLoginPermissions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetActorLoginPermissions(std::move(callback));
      return true;
    }
    case messages::PageHandler::kRevokeActorLoginPermission: {
      break;
    }
    case messages::PageHandler::kChangePasswordManagerPin: {
      internal::PageHandler_ChangePasswordManagerPin_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ChangePasswordManagerPin_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      PageHandler_ChangePasswordManagerPin_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          PageHandler_ChangePasswordManagerPin_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangePasswordManagerPin(std::move(callback));
      return true;
    }
    case messages::PageHandler::kShowAddShortcutDialog: {
      break;
    }
    case messages::PageHandler::kIsAccountStorageEnabled: {
      internal::PageHandler_IsAccountStorageEnabled_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_IsAccountStorageEnabled_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      PageHandler_IsAccountStorageEnabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          PageHandler_IsAccountStorageEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsAccountStorageEnabled(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetAccountStorageEnabled: {
      break;
    }
    case messages::PageHandler::kShouldShowAccountStorageSettingToggle: {
      internal::PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      PageHandler_ShouldShowAccountStorageSettingToggle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      auto callback =
          PageHandler_ShouldShowAccountStorageSettingToggle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldShowAccountStorageSettingToggle(std::move(callback));
      return true;
    }
    case messages::PageHandler::kIsPasswordManagerPinAvailable: {
      internal::PageHandler_IsPasswordManagerPinAvailable_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_IsPasswordManagerPinAvailable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      PageHandler_IsPasswordManagerPinAvailable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      auto callback =
          PageHandler_IsPasswordManagerPinAvailable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsPasswordManagerPinAvailable(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSwitchBiometricAuthBeforeFillingState: {
      internal::PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      auto callback =
          PageHandler_SwitchBiometricAuthBeforeFillingState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwitchBiometricAuthBeforeFillingState(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_ExtendAuthValidity_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_DeleteAllPasswordManagerData_Params_Data::Validate,
     &internal::PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data::Validate},
    { &internal::PageHandler_CopyPlaintextBackupPassword_Params_Data::Validate,
     &internal::PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data::Validate},
    { &internal::PageHandler_RemoveBackupPassword_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetActorLoginPermissions_Params_Data::Validate,
     &internal::PageHandler_GetActorLoginPermissions_ResponseParams_Data::Validate},
    { &internal::PageHandler_RevokeActorLoginPermission_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ChangePasswordManagerPin_Params_Data::Validate,
     &internal::PageHandler_ChangePasswordManagerPin_ResponseParams_Data::Validate},
    { &internal::PageHandler_ShowAddShortcutDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_IsAccountStorageEnabled_Params_Data::Validate,
     &internal::PageHandler_IsAccountStorageEnabled_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetAccountStorageEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data::Validate,
     &internal::PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data::Validate},
    { &internal::PageHandler_IsPasswordManagerPinAvailable_Params_Data::Validate,
     &internal::PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data::Validate},
    { &internal::PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data::Validate,
     &internal::PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::password_manager::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::password_manager::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::password_manager::mojom::Page::Name_,
    {});
}



}  // password_manager::mojom


namespace mojo {


// static
bool StructTraits<::password_manager::mojom::DomainInfo::DataView, ::password_manager::mojom::DomainInfoPtr>::Read(
    ::password_manager::mojom::DomainInfo::DataView input,
    ::password_manager::mojom::DomainInfoPtr* output) {
  bool success = true;
  ::password_manager::mojom::DomainInfoPtr result(::password_manager::mojom::DomainInfo::New());
  
      if (success && !input.ReadHumanReadableName(&result->human_readable_name))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSignonRealm(&result->signon_realm))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::password_manager::mojom::ActorLoginPermission::DataView, ::password_manager::mojom::ActorLoginPermissionPtr>::Read(
    ::password_manager::mojom::ActorLoginPermission::DataView input,
    ::password_manager::mojom::ActorLoginPermissionPtr* output) {
  bool success = true;
  ::password_manager::mojom::ActorLoginPermissionPtr result(::password_manager::mojom::ActorLoginPermission::New());
  
      if (success && !input.ReadDomainInfo(&result->domain_info))
        success = false;
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
      if (success && !input.ReadUsername(&result->username))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace password_manager::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::ExtendAuthValidity() {
  GetForwardingInterface()->ExtendAuthValidity();
}
void PageHandlerInterceptorForTesting::DeleteAllPasswordManagerData(DeleteAllPasswordManagerDataCallback callback) {
  GetForwardingInterface()->DeleteAllPasswordManagerData(std::move(callback));
}
void PageHandlerInterceptorForTesting::CopyPlaintextBackupPassword(int32_t id, CopyPlaintextBackupPasswordCallback callback) {
  GetForwardingInterface()->CopyPlaintextBackupPassword(
    std::move(id)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::RemoveBackupPassword(int32_t id) {
  GetForwardingInterface()->RemoveBackupPassword(
    std::move(id)
    );
}
void PageHandlerInterceptorForTesting::GetActorLoginPermissions(GetActorLoginPermissionsCallback callback) {
  GetForwardingInterface()->GetActorLoginPermissions(std::move(callback));
}
void PageHandlerInterceptorForTesting::RevokeActorLoginPermission(ActorLoginPermissionPtr site) {
  GetForwardingInterface()->RevokeActorLoginPermission(
    std::move(site)
    );
}
void PageHandlerInterceptorForTesting::ChangePasswordManagerPin(ChangePasswordManagerPinCallback callback) {
  GetForwardingInterface()->ChangePasswordManagerPin(std::move(callback));
}
void PageHandlerInterceptorForTesting::ShowAddShortcutDialog() {
  GetForwardingInterface()->ShowAddShortcutDialog();
}
void PageHandlerInterceptorForTesting::IsAccountStorageEnabled(IsAccountStorageEnabledCallback callback) {
  GetForwardingInterface()->IsAccountStorageEnabled(std::move(callback));
}
void PageHandlerInterceptorForTesting::SetAccountStorageEnabled(bool enabled) {
  GetForwardingInterface()->SetAccountStorageEnabled(
    std::move(enabled)
    );
}
void PageHandlerInterceptorForTesting::ShouldShowAccountStorageSettingToggle(ShouldShowAccountStorageSettingToggleCallback callback) {
  GetForwardingInterface()->ShouldShowAccountStorageSettingToggle(std::move(callback));
}
void PageHandlerInterceptorForTesting::IsPasswordManagerPinAvailable(IsPasswordManagerPinAvailableCallback callback) {
  GetForwardingInterface()->IsPasswordManagerPinAvailable(std::move(callback));
}
void PageHandlerInterceptorForTesting::SwitchBiometricAuthBeforeFillingState(SwitchBiometricAuthBeforeFillingStateCallback callback) {
  GetForwardingInterface()->SwitchBiometricAuthBeforeFillingState(std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::DeleteAllPasswordManagerData(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteAllPasswordManagerData(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::DeleteAllPasswordManagerData(
    ) {
  bool async_wait_result;
  DeleteAllPasswordManagerData(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::CopyPlaintextBackupPassword(
    int32_t id, bool* out_success) {
  base::RunLoop loop;
  proxy_->CopyPlaintextBackupPassword(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::CopyPlaintextBackupPassword(
    int32_t id) {
  bool async_wait_result;
  CopyPlaintextBackupPassword(std::move(id),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetActorLoginPermissions(
    std::vector<ActorLoginPermissionPtr>* out_sites) {
  base::RunLoop loop;
  proxy_->GetActorLoginPermissions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ActorLoginPermissionPtr>* out_sites
,
             std::vector<ActorLoginPermissionPtr> sites) {*out_sites = std::move(sites);
            loop->Quit();
          },
          &loop,
          out_sites));
  loop.Run();
}

std::vector<ActorLoginPermissionPtr> PageHandlerAsyncWaiter::GetActorLoginPermissions(
    ) {
  std::vector<ActorLoginPermissionPtr> async_wait_result;
  GetActorLoginPermissions(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::ChangePasswordManagerPin(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->ChangePasswordManagerPin(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::ChangePasswordManagerPin(
    ) {
  bool async_wait_result;
  ChangePasswordManagerPin(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::IsAccountStorageEnabled(
    bool* out_enabled) {
  base::RunLoop loop;
  proxy_->IsAccountStorageEnabled(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}

bool PageHandlerAsyncWaiter::IsAccountStorageEnabled(
    ) {
  bool async_wait_result;
  IsAccountStorageEnabled(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::ShouldShowAccountStorageSettingToggle(
    bool* out_should_show) {
  base::RunLoop loop;
  proxy_->ShouldShowAccountStorageSettingToggle(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_should_show
,
             bool should_show) {*out_should_show = std::move(should_show);
            loop->Quit();
          },
          &loop,
          out_should_show));
  loop.Run();
}

bool PageHandlerAsyncWaiter::ShouldShowAccountStorageSettingToggle(
    ) {
  bool async_wait_result;
  ShouldShowAccountStorageSettingToggle(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::IsPasswordManagerPinAvailable(
    bool* out_is_available) {
  base::RunLoop loop;
  proxy_->IsPasswordManagerPinAvailable(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_available
,
             bool is_available) {*out_is_available = std::move(is_available);
            loop->Quit();
          },
          &loop,
          out_is_available));
  loop.Run();
}

bool PageHandlerAsyncWaiter::IsPasswordManagerPinAvailable(
    ) {
  bool async_wait_result;
  IsPasswordManagerPinAvailable(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::SwitchBiometricAuthBeforeFillingState(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->SwitchBiometricAuthBeforeFillingState(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::SwitchBiometricAuthBeforeFillingState(
    ) {
  bool async_wait_result;
  SwitchBiometricAuthBeforeFillingState(&async_wait_result);
  return async_wait_result;
}




PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // password_manager::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif