// chrome/browser/ui/webui/password_manager/password_manager.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'password_manager.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "password_manager.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'password_manager.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  extendAuthValidity(): void;
  deleteAllPasswordManagerData(): Promise<{
        success: boolean, }>;
  copyPlaintextBackupPassword(id: number): Promise<{
        success: boolean, }>;
  removeBackupPassword(id: number): void;
  getActorLoginPermissions(): Promise<{
        sites: ActorLoginPermission[], }>;
  revokeActorLoginPermission(site: ActorLoginPermission): void;
  changePasswordManagerPin(): Promise<{
        success: boolean, }>;
  showAddShortcutDialog(): void;
  isAccountStorageEnabled(): Promise<{
        enabled: boolean, }>;
  setAccountStorageEnabled(enabled: boolean): void;
  shouldShowAccountStorageSettingToggle(): Promise<{
        shouldShow: boolean, }>;
  isPasswordManagerPinAvailable(): Promise<{
        isAvailable: boolean, }>;
  switchBiometricAuthBeforeFillingState(): Promise<{
        success: boolean, }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  extendAuthValidity(): void {
    this.proxy.sendMessage(
        0,
        PageHandler_ExtendAuthValidity_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  deleteAllPasswordManagerData(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_DeleteAllPasswordManagerData_ParamsSpec.$,
        PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  copyPlaintextBackupPassword(
      id: number): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_CopyPlaintextBackupPassword_ParamsSpec.$,
        PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  removeBackupPassword(
      id: number): void {
    this.proxy.sendMessage(
        3,
        PageHandler_RemoveBackupPassword_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  getActorLoginPermissions(): Promise<{
        sites: ActorLoginPermission[], }> {
    return this.proxy.sendMessage(
        4,
        PageHandler_GetActorLoginPermissions_ParamsSpec.$,
        PageHandler_GetActorLoginPermissions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  revokeActorLoginPermission(
      site: ActorLoginPermission): void {
    this.proxy.sendMessage(
        5,
        PageHandler_RevokeActorLoginPermission_ParamsSpec.$,
        null,
        [
          site
        ],
        false);
  }

  changePasswordManagerPin(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        6,
        PageHandler_ChangePasswordManagerPin_ParamsSpec.$,
        PageHandler_ChangePasswordManagerPin_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  showAddShortcutDialog(): void {
    this.proxy.sendMessage(
        7,
        PageHandler_ShowAddShortcutDialog_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  isAccountStorageEnabled(): Promise<{
        enabled: boolean, }> {
    return this.proxy.sendMessage(
        8,
        PageHandler_IsAccountStorageEnabled_ParamsSpec.$,
        PageHandler_IsAccountStorageEnabled_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setAccountStorageEnabled(
      enabled: boolean): void {
    this.proxy.sendMessage(
        9,
        PageHandler_SetAccountStorageEnabled_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  shouldShowAccountStorageSettingToggle(): Promise<{
        shouldShow: boolean, }> {
    return this.proxy.sendMessage(
        10,
        PageHandler_ShouldShowAccountStorageSettingToggle_ParamsSpec.$,
        PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  isPasswordManagerPinAvailable(): Promise<{
        isAvailable: boolean, }> {
    return this.proxy.sendMessage(
        11,
        PageHandler_IsPasswordManagerPinAvailable_ParamsSpec.$,
        PageHandler_IsPasswordManagerPinAvailable_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  switchBiometricAuthBeforeFillingState(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        12,
        PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsSpec.$,
        PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_ExtendAuthValidity_ParamsSpec.$,
        null,
        impl.extendAuthValidity.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_DeleteAllPasswordManagerData_ParamsSpec.$,
        PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec.$,
        impl.deleteAllPasswordManagerData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_CopyPlaintextBackupPassword_ParamsSpec.$,
        PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec.$,
        impl.copyPlaintextBackupPassword.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_RemoveBackupPassword_ParamsSpec.$,
        null,
        impl.removeBackupPassword.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_GetActorLoginPermissions_ParamsSpec.$,
        PageHandler_GetActorLoginPermissions_ResponseParamsSpec.$,
        impl.getActorLoginPermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_RevokeActorLoginPermission_ParamsSpec.$,
        null,
        impl.revokeActorLoginPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_ChangePasswordManagerPin_ParamsSpec.$,
        PageHandler_ChangePasswordManagerPin_ResponseParamsSpec.$,
        impl.changePasswordManagerPin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_ShowAddShortcutDialog_ParamsSpec.$,
        null,
        impl.showAddShortcutDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_IsAccountStorageEnabled_ParamsSpec.$,
        PageHandler_IsAccountStorageEnabled_ResponseParamsSpec.$,
        impl.isAccountStorageEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_SetAccountStorageEnabled_ParamsSpec.$,
        null,
        impl.setAccountStorageEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_ShouldShowAccountStorageSettingToggle_ParamsSpec.$,
        PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsSpec.$,
        impl.shouldShowAccountStorageSettingToggle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_IsPasswordManagerPinAvailable_ParamsSpec.$,
        PageHandler_IsPasswordManagerPinAvailable_ResponseParamsSpec.$,
        impl.isPasswordManagerPinAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsSpec.$,
        PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsSpec.$,
        impl.switchBiometricAuthBeforeFillingState.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "password_manager.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  extendAuthValidity: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteAllPasswordManagerData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  copyPlaintextBackupPassword: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeBackupPassword: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getActorLoginPermissions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  revokeActorLoginPermission: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  changePasswordManagerPin: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showAddShortcutDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isAccountStorageEnabled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setAccountStorageEnabled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  shouldShowAccountStorageSettingToggle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isPasswordManagerPinAvailable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  switchBiometricAuthBeforeFillingState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.extendAuthValidity =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_ExtendAuthValidity_ParamsSpec.$,
        null,
        this.extendAuthValidity.createReceiverHandler(false /* expectsResponse */),
        false);
    this.deleteAllPasswordManagerData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_DeleteAllPasswordManagerData_ParamsSpec.$,
        PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec.$,
        this.deleteAllPasswordManagerData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.copyPlaintextBackupPassword =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_CopyPlaintextBackupPassword_ParamsSpec.$,
        PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec.$,
        this.copyPlaintextBackupPassword.createReceiverHandler(true /* expectsResponse */),
        false);
    this.removeBackupPassword =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_RemoveBackupPassword_ParamsSpec.$,
        null,
        this.removeBackupPassword.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getActorLoginPermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_GetActorLoginPermissions_ParamsSpec.$,
        PageHandler_GetActorLoginPermissions_ResponseParamsSpec.$,
        this.getActorLoginPermissions.createReceiverHandler(true /* expectsResponse */),
        false);
    this.revokeActorLoginPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_RevokeActorLoginPermission_ParamsSpec.$,
        null,
        this.revokeActorLoginPermission.createReceiverHandler(false /* expectsResponse */),
        false);
    this.changePasswordManagerPin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_ChangePasswordManagerPin_ParamsSpec.$,
        PageHandler_ChangePasswordManagerPin_ResponseParamsSpec.$,
        this.changePasswordManagerPin.createReceiverHandler(true /* expectsResponse */),
        false);
    this.showAddShortcutDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_ShowAddShortcutDialog_ParamsSpec.$,
        null,
        this.showAddShortcutDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.isAccountStorageEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_IsAccountStorageEnabled_ParamsSpec.$,
        PageHandler_IsAccountStorageEnabled_ResponseParamsSpec.$,
        this.isAccountStorageEnabled.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setAccountStorageEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_SetAccountStorageEnabled_ParamsSpec.$,
        null,
        this.setAccountStorageEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.shouldShowAccountStorageSettingToggle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_ShouldShowAccountStorageSettingToggle_ParamsSpec.$,
        PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsSpec.$,
        this.shouldShowAccountStorageSettingToggle.createReceiverHandler(true /* expectsResponse */),
        false);
    this.isPasswordManagerPinAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_IsPasswordManagerPinAvailable_ParamsSpec.$,
        PageHandler_IsPasswordManagerPinAvailable_ResponseParamsSpec.$,
        this.isPasswordManagerPinAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    this.switchBiometricAuthBeforeFillingState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsSpec.$,
        PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsSpec.$,
        this.switchBiometricAuthBeforeFillingState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'password_manager.mojom.Page',
        scope);
  }
}

export interface PageInterface {
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(_impl: PageInterface) {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "password_manager.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const DomainInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ActorLoginPermissionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ExtendAuthValidity_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteAllPasswordManagerData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CopyPlaintextBackupPassword_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveBackupPassword_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetActorLoginPermissions_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetActorLoginPermissions_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RevokeActorLoginPermission_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ChangePasswordManagerPin_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ChangePasswordManagerPin_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowAddShortcutDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsAccountStorageEnabled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsAccountStorageEnabled_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetAccountStorageEnabled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShouldShowAccountStorageSettingToggle_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsPasswordManagerPinAvailable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsPasswordManagerPinAvailable_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface DomainInfoMojoType {
  humanReadableName: string;
  url: url_mojom_Url;
  signonRealm: string;
}


export type DomainInfo = DomainInfoMojoType;
mojo.internal.Struct<DomainInfoMojoType>(
    DomainInfoSpec.$,
    'DomainInfo',
    [
      mojo.internal.StructField<DomainInfoMojoType, string>(
        'humanReadableName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DomainInfoMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DomainInfoMojoType, string>(
        'signonRealm', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ActorLoginPermissionMojoType {
  domainInfo: DomainInfo;
  faviconUrl: url_mojom_Url;
  username: string;
}


export type ActorLoginPermission = ActorLoginPermissionMojoType;
mojo.internal.Struct<ActorLoginPermissionMojoType>(
    ActorLoginPermissionSpec.$,
    'ActorLoginPermission',
    [
      mojo.internal.StructField<ActorLoginPermissionMojoType, DomainInfo>(
        'domainInfo', 0,
        0,
        DomainInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActorLoginPermissionMojoType, url_mojom_Url>(
        'faviconUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActorLoginPermissionMojoType, string>(
        'username', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ExtendAuthValidity_ParamsMojoType {
}


export type PageHandler_ExtendAuthValidity_Params = PageHandler_ExtendAuthValidity_ParamsMojoType;
mojo.internal.Struct<PageHandler_ExtendAuthValidity_ParamsMojoType>(
    PageHandler_ExtendAuthValidity_ParamsSpec.$,
    'PageHandler_ExtendAuthValidity_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_DeleteAllPasswordManagerData_ParamsMojoType {
}


export type PageHandler_DeleteAllPasswordManagerData_Params = PageHandler_DeleteAllPasswordManagerData_ParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteAllPasswordManagerData_ParamsMojoType>(
    PageHandler_DeleteAllPasswordManagerData_ParamsSpec.$,
    'PageHandler_DeleteAllPasswordManagerData_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_DeleteAllPasswordManagerData_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_DeleteAllPasswordManagerData_ResponseParams = PageHandler_DeleteAllPasswordManagerData_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteAllPasswordManagerData_ResponseParamsMojoType>(
    PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec.$,
    'PageHandler_DeleteAllPasswordManagerData_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_DeleteAllPasswordManagerData_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_CopyPlaintextBackupPassword_ParamsMojoType {
  id: number;
}


export type PageHandler_CopyPlaintextBackupPassword_Params = PageHandler_CopyPlaintextBackupPassword_ParamsMojoType;
mojo.internal.Struct<PageHandler_CopyPlaintextBackupPassword_ParamsMojoType>(
    PageHandler_CopyPlaintextBackupPassword_ParamsSpec.$,
    'PageHandler_CopyPlaintextBackupPassword_Params',
    [
      mojo.internal.StructField<PageHandler_CopyPlaintextBackupPassword_ParamsMojoType, number>(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_CopyPlaintextBackupPassword_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_CopyPlaintextBackupPassword_ResponseParams = PageHandler_CopyPlaintextBackupPassword_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_CopyPlaintextBackupPassword_ResponseParamsMojoType>(
    PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec.$,
    'PageHandler_CopyPlaintextBackupPassword_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_CopyPlaintextBackupPassword_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RemoveBackupPassword_ParamsMojoType {
  id: number;
}


export type PageHandler_RemoveBackupPassword_Params = PageHandler_RemoveBackupPassword_ParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveBackupPassword_ParamsMojoType>(
    PageHandler_RemoveBackupPassword_ParamsSpec.$,
    'PageHandler_RemoveBackupPassword_Params',
    [
      mojo.internal.StructField<PageHandler_RemoveBackupPassword_ParamsMojoType, number>(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetActorLoginPermissions_ParamsMojoType {
}


export type PageHandler_GetActorLoginPermissions_Params = PageHandler_GetActorLoginPermissions_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetActorLoginPermissions_ParamsMojoType>(
    PageHandler_GetActorLoginPermissions_ParamsSpec.$,
    'PageHandler_GetActorLoginPermissions_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetActorLoginPermissions_ResponseParamsMojoType {
  sites: ActorLoginPermission[];
}


export type PageHandler_GetActorLoginPermissions_ResponseParams = PageHandler_GetActorLoginPermissions_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetActorLoginPermissions_ResponseParamsMojoType>(
    PageHandler_GetActorLoginPermissions_ResponseParamsSpec.$,
    'PageHandler_GetActorLoginPermissions_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetActorLoginPermissions_ResponseParamsMojoType, ActorLoginPermission[]>(
        'sites', 0,
        0,
        mojo.internal.Array(ActorLoginPermissionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RevokeActorLoginPermission_ParamsMojoType {
  site: ActorLoginPermission;
}


export type PageHandler_RevokeActorLoginPermission_Params = PageHandler_RevokeActorLoginPermission_ParamsMojoType;
mojo.internal.Struct<PageHandler_RevokeActorLoginPermission_ParamsMojoType>(
    PageHandler_RevokeActorLoginPermission_ParamsSpec.$,
    'PageHandler_RevokeActorLoginPermission_Params',
    [
      mojo.internal.StructField<PageHandler_RevokeActorLoginPermission_ParamsMojoType, ActorLoginPermission>(
        'site', 0,
        0,
        ActorLoginPermissionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ChangePasswordManagerPin_ParamsMojoType {
}


export type PageHandler_ChangePasswordManagerPin_Params = PageHandler_ChangePasswordManagerPin_ParamsMojoType;
mojo.internal.Struct<PageHandler_ChangePasswordManagerPin_ParamsMojoType>(
    PageHandler_ChangePasswordManagerPin_ParamsSpec.$,
    'PageHandler_ChangePasswordManagerPin_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_ChangePasswordManagerPin_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_ChangePasswordManagerPin_ResponseParams = PageHandler_ChangePasswordManagerPin_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ChangePasswordManagerPin_ResponseParamsMojoType>(
    PageHandler_ChangePasswordManagerPin_ResponseParamsSpec.$,
    'PageHandler_ChangePasswordManagerPin_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_ChangePasswordManagerPin_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShowAddShortcutDialog_ParamsMojoType {
}


export type PageHandler_ShowAddShortcutDialog_Params = PageHandler_ShowAddShortcutDialog_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowAddShortcutDialog_ParamsMojoType>(
    PageHandler_ShowAddShortcutDialog_ParamsSpec.$,
    'PageHandler_ShowAddShortcutDialog_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_IsAccountStorageEnabled_ParamsMojoType {
}


export type PageHandler_IsAccountStorageEnabled_Params = PageHandler_IsAccountStorageEnabled_ParamsMojoType;
mojo.internal.Struct<PageHandler_IsAccountStorageEnabled_ParamsMojoType>(
    PageHandler_IsAccountStorageEnabled_ParamsSpec.$,
    'PageHandler_IsAccountStorageEnabled_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_IsAccountStorageEnabled_ResponseParamsMojoType {
  enabled: boolean;
}


export type PageHandler_IsAccountStorageEnabled_ResponseParams = PageHandler_IsAccountStorageEnabled_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_IsAccountStorageEnabled_ResponseParamsMojoType>(
    PageHandler_IsAccountStorageEnabled_ResponseParamsSpec.$,
    'PageHandler_IsAccountStorageEnabled_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_IsAccountStorageEnabled_ResponseParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetAccountStorageEnabled_ParamsMojoType {
  enabled: boolean;
}


export type PageHandler_SetAccountStorageEnabled_Params = PageHandler_SetAccountStorageEnabled_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetAccountStorageEnabled_ParamsMojoType>(
    PageHandler_SetAccountStorageEnabled_ParamsSpec.$,
    'PageHandler_SetAccountStorageEnabled_Params',
    [
      mojo.internal.StructField<PageHandler_SetAccountStorageEnabled_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShouldShowAccountStorageSettingToggle_ParamsMojoType {
}


export type PageHandler_ShouldShowAccountStorageSettingToggle_Params = PageHandler_ShouldShowAccountStorageSettingToggle_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShouldShowAccountStorageSettingToggle_ParamsMojoType>(
    PageHandler_ShouldShowAccountStorageSettingToggle_ParamsSpec.$,
    'PageHandler_ShouldShowAccountStorageSettingToggle_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsMojoType {
  shouldShow: boolean;
}


export type PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams = PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsMojoType>(
    PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsSpec.$,
    'PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsMojoType, boolean>(
        'shouldShow', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_IsPasswordManagerPinAvailable_ParamsMojoType {
}


export type PageHandler_IsPasswordManagerPinAvailable_Params = PageHandler_IsPasswordManagerPinAvailable_ParamsMojoType;
mojo.internal.Struct<PageHandler_IsPasswordManagerPinAvailable_ParamsMojoType>(
    PageHandler_IsPasswordManagerPinAvailable_ParamsSpec.$,
    'PageHandler_IsPasswordManagerPinAvailable_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_IsPasswordManagerPinAvailable_ResponseParamsMojoType {
  isAvailable: boolean;
}


export type PageHandler_IsPasswordManagerPinAvailable_ResponseParams = PageHandler_IsPasswordManagerPinAvailable_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_IsPasswordManagerPinAvailable_ResponseParamsMojoType>(
    PageHandler_IsPasswordManagerPinAvailable_ResponseParamsSpec.$,
    'PageHandler_IsPasswordManagerPinAvailable_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_IsPasswordManagerPinAvailable_ResponseParamsMojoType, boolean>(
        'isAvailable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsMojoType {
}


export type PageHandler_SwitchBiometricAuthBeforeFillingState_Params = PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsMojoType;
mojo.internal.Struct<PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsMojoType>(
    PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsSpec.$,
    'PageHandler_SwitchBiometricAuthBeforeFillingState_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams = PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsMojoType>(
    PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsSpec.$,
    'PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



