// chrome/browser/ui/webui/password_manager/password_manager.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/password_manager/password_manager.mojom.h"


namespace password_manager::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void ExtendAuthValidity() override;
  void DeleteAllPasswordManagerData(DeleteAllPasswordManagerDataCallback callback) override;
  void CopyPlaintextBackupPassword(int32_t id, CopyPlaintextBackupPasswordCallback callback) override;
  void RemoveBackupPassword(int32_t id) override;
  void GetActorLoginPermissions(GetActorLoginPermissionsCallback callback) override;
  void RevokeActorLoginPermission(ActorLoginPermissionPtr site) override;
  void ChangePasswordManagerPin(ChangePasswordManagerPinCallback callback) override;
  void ShowAddShortcutDialog() override;
  void IsAccountStorageEnabled(IsAccountStorageEnabledCallback callback) override;
  void SetAccountStorageEnabled(bool enabled) override;
  void ShouldShowAccountStorageSettingToggle(ShouldShowAccountStorageSettingToggleCallback callback) override;
  void IsPasswordManagerPinAvailable(IsPasswordManagerPinAvailableCallback callback) override;
  void SwitchBiometricAuthBeforeFillingState(SwitchBiometricAuthBeforeFillingStateCallback callback) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void DeleteAllPasswordManagerData(
      bool* out_success);
  bool DeleteAllPasswordManagerData();
  void CopyPlaintextBackupPassword(
      int32_t id, bool* out_success);
  bool CopyPlaintextBackupPassword(int32_t id);
  void GetActorLoginPermissions(
      std::vector<ActorLoginPermissionPtr>* out_sites);
  std::vector<ActorLoginPermissionPtr> GetActorLoginPermissions();
  void ChangePasswordManagerPin(
      bool* out_success);
  bool ChangePasswordManagerPin();
  void IsAccountStorageEnabled(
      bool* out_enabled);
  bool IsAccountStorageEnabled();
  void ShouldShowAccountStorageSettingToggle(
      bool* out_should_show);
  bool ShouldShowAccountStorageSettingToggle();
  void IsPasswordManagerPinAvailable(
      bool* out_is_available);
  bool IsPasswordManagerPinAvailable();
  void SwitchBiometricAuthBeforeFillingState(
      bool* out_success);
  bool SwitchBiometricAuthBeforeFillingState();

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // password_manager::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_TEST_UTILS_H_