// chrome/browser/ui/webui/password_manager/password_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/password_manager/password_manager.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::password_manager::mojom::DomainInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::password_manager::mojom::DomainInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::password_manager::mojom::internal::DomainInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::human_readable_name(input)) in_human_readable_name = Traits::human_readable_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->human_readable_name)::BaseType> human_readable_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_human_readable_name,
      human_readable_name_fragment);

    fragment->human_readable_name.Set(
        human_readable_name_fragment.is_null() ? nullptr : human_readable_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->human_readable_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null human_readable_name in DomainInfo struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in DomainInfo struct");

    decltype(Traits::signon_realm(input)) in_signon_realm = Traits::signon_realm(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signon_realm)::BaseType> signon_realm_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_signon_realm,
      signon_realm_fragment);

    fragment->signon_realm.Set(
        signon_realm_fragment.is_null() ? nullptr : signon_realm_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signon_realm.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signon_realm in DomainInfo struct");
  }

  static bool Deserialize(::password_manager::mojom::internal::DomainInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::password_manager::mojom::DomainInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::password_manager::mojom::ActorLoginPermissionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::password_manager::mojom::ActorLoginPermissionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::password_manager::mojom::internal::ActorLoginPermission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::domain_info(input)) in_domain_info = Traits::domain_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain_info)::BaseType> domain_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::password_manager::mojom::DomainInfoDataView>(
      in_domain_info,
      domain_info_fragment);

    fragment->domain_info.Set(
        domain_info_fragment.is_null() ? nullptr : domain_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain_info in ActorLoginPermission struct");

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->favicon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon_url in ActorLoginPermission struct");

    decltype(Traits::username(input)) in_username = Traits::username(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username)::BaseType> username_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_username,
      username_fragment);

    fragment->username.Set(
        username_fragment.is_null() ? nullptr : username_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->username.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null username in ActorLoginPermission struct");
  }

  static bool Deserialize(::password_manager::mojom::internal::ActorLoginPermission_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::password_manager::mojom::ActorLoginPermissionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace password_manager::mojom {

inline void DomainInfoDataView::GetHumanReadableNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->human_readable_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DomainInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DomainInfoDataView::GetSignonRealmDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->signon_realm.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ActorLoginPermissionDataView::GetDomainInfoDataView(
    DomainInfoDataView* output) {
  auto pointer = data_->domain_info.Get();
  *output = DomainInfoDataView(pointer, message_);
}
inline void ActorLoginPermissionDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ActorLoginPermissionDataView::GetUsernameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->username.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // password_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_SHARED_H_