// chrome/browser/ui/webui/password_manager/password_manager.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_PARAMS_DATA_H_
#define CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace password_manager::mojom {
namespace internal {
class  PageHandlerFactory_CreatePageHandler_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data page;
  mojo::internal::Handle_Data handler;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandlerFactory_CreatePageHandler_Params_Data>;

  PageHandlerFactory_CreatePageHandler_Params_Data();
  ~PageHandlerFactory_CreatePageHandler_Params_Data() = delete;
};
static_assert(sizeof(PageHandlerFactory_CreatePageHandler_Params_Data) == 24,
              "Bad sizeof(PageHandlerFactory_CreatePageHandler_Params_Data)");
class  PageHandler_ExtendAuthValidity_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ExtendAuthValidity_Params_Data>;

  PageHandler_ExtendAuthValidity_Params_Data();
  ~PageHandler_ExtendAuthValidity_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ExtendAuthValidity_Params_Data) == 8,
              "Bad sizeof(PageHandler_ExtendAuthValidity_Params_Data)");
class  PageHandler_DeleteAllPasswordManagerData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_DeleteAllPasswordManagerData_Params_Data>;

  PageHandler_DeleteAllPasswordManagerData_Params_Data();
  ~PageHandler_DeleteAllPasswordManagerData_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_DeleteAllPasswordManagerData_Params_Data) == 8,
              "Bad sizeof(PageHandler_DeleteAllPasswordManagerData_Params_Data)");
class  PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data>;

  PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data();
  ~PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data)");
class  PageHandler_CopyPlaintextBackupPassword_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_CopyPlaintextBackupPassword_Params_Data>;

  PageHandler_CopyPlaintextBackupPassword_Params_Data();
  ~PageHandler_CopyPlaintextBackupPassword_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_CopyPlaintextBackupPassword_Params_Data) == 16,
              "Bad sizeof(PageHandler_CopyPlaintextBackupPassword_Params_Data)");
class  PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data>;

  PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data();
  ~PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data)");
class  PageHandler_RemoveBackupPassword_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_RemoveBackupPassword_Params_Data>;

  PageHandler_RemoveBackupPassword_Params_Data();
  ~PageHandler_RemoveBackupPassword_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_RemoveBackupPassword_Params_Data) == 16,
              "Bad sizeof(PageHandler_RemoveBackupPassword_Params_Data)");
class  PageHandler_GetActorLoginPermissions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetActorLoginPermissions_Params_Data>;

  PageHandler_GetActorLoginPermissions_Params_Data();
  ~PageHandler_GetActorLoginPermissions_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetActorLoginPermissions_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetActorLoginPermissions_Params_Data)");
class  PageHandler_GetActorLoginPermissions_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ActorLoginPermission_Data>>> sites;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetActorLoginPermissions_ResponseParams_Data>;

  PageHandler_GetActorLoginPermissions_ResponseParams_Data();
  ~PageHandler_GetActorLoginPermissions_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetActorLoginPermissions_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetActorLoginPermissions_ResponseParams_Data)");
class  PageHandler_RevokeActorLoginPermission_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ActorLoginPermission_Data> site;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_RevokeActorLoginPermission_Params_Data>;

  PageHandler_RevokeActorLoginPermission_Params_Data();
  ~PageHandler_RevokeActorLoginPermission_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_RevokeActorLoginPermission_Params_Data) == 16,
              "Bad sizeof(PageHandler_RevokeActorLoginPermission_Params_Data)");
class  PageHandler_ChangePasswordManagerPin_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ChangePasswordManagerPin_Params_Data>;

  PageHandler_ChangePasswordManagerPin_Params_Data();
  ~PageHandler_ChangePasswordManagerPin_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ChangePasswordManagerPin_Params_Data) == 8,
              "Bad sizeof(PageHandler_ChangePasswordManagerPin_Params_Data)");
class  PageHandler_ChangePasswordManagerPin_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ChangePasswordManagerPin_ResponseParams_Data>;

  PageHandler_ChangePasswordManagerPin_ResponseParams_Data();
  ~PageHandler_ChangePasswordManagerPin_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_ChangePasswordManagerPin_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_ChangePasswordManagerPin_ResponseParams_Data)");
class  PageHandler_ShowAddShortcutDialog_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ShowAddShortcutDialog_Params_Data>;

  PageHandler_ShowAddShortcutDialog_Params_Data();
  ~PageHandler_ShowAddShortcutDialog_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ShowAddShortcutDialog_Params_Data) == 8,
              "Bad sizeof(PageHandler_ShowAddShortcutDialog_Params_Data)");
class  PageHandler_IsAccountStorageEnabled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_IsAccountStorageEnabled_Params_Data>;

  PageHandler_IsAccountStorageEnabled_Params_Data();
  ~PageHandler_IsAccountStorageEnabled_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_IsAccountStorageEnabled_Params_Data) == 8,
              "Bad sizeof(PageHandler_IsAccountStorageEnabled_Params_Data)");
class  PageHandler_IsAccountStorageEnabled_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enabled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_IsAccountStorageEnabled_ResponseParams_Data>;

  PageHandler_IsAccountStorageEnabled_ResponseParams_Data();
  ~PageHandler_IsAccountStorageEnabled_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_IsAccountStorageEnabled_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_IsAccountStorageEnabled_ResponseParams_Data)");
class  PageHandler_SetAccountStorageEnabled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enabled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_SetAccountStorageEnabled_Params_Data>;

  PageHandler_SetAccountStorageEnabled_Params_Data();
  ~PageHandler_SetAccountStorageEnabled_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_SetAccountStorageEnabled_Params_Data) == 16,
              "Bad sizeof(PageHandler_SetAccountStorageEnabled_Params_Data)");
class  PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data>;

  PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data();
  ~PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data) == 8,
              "Bad sizeof(PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data)");
class  PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t should_show : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data>;

  PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data();
  ~PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data)");
class  PageHandler_IsPasswordManagerPinAvailable_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_IsPasswordManagerPinAvailable_Params_Data>;

  PageHandler_IsPasswordManagerPinAvailable_Params_Data();
  ~PageHandler_IsPasswordManagerPinAvailable_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_IsPasswordManagerPinAvailable_Params_Data) == 8,
              "Bad sizeof(PageHandler_IsPasswordManagerPinAvailable_Params_Data)");
class  PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_available : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data>;

  PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data();
  ~PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data)");
class  PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data>;

  PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data();
  ~PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data) == 8,
              "Bad sizeof(PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data)");
class  PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data>;

  PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data();
  ~PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data)");

}  // namespace internal


class PageHandlerFactory_CreatePageHandler_ParamsDataView {
 public:
  PageHandlerFactory_CreatePageHandler_ParamsDataView() = default;

  PageHandlerFactory_CreatePageHandler_ParamsDataView(
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePage() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::password_manager::mojom::PageInterfaceBase>>(
            &data_->page, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::password_manager::mojom::PageHandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandlerFactory_CreatePageHandler_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_ExtendAuthValidity_ParamsDataView {
 public:
  PageHandler_ExtendAuthValidity_ParamsDataView() = default;

  PageHandler_ExtendAuthValidity_ParamsDataView(
      internal::PageHandler_ExtendAuthValidity_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_ExtendAuthValidity_Params_Data* data_ = nullptr;
};


class PageHandler_DeleteAllPasswordManagerData_ParamsDataView {
 public:
  PageHandler_DeleteAllPasswordManagerData_ParamsDataView() = default;

  PageHandler_DeleteAllPasswordManagerData_ParamsDataView(
      internal::PageHandler_DeleteAllPasswordManagerData_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_DeleteAllPasswordManagerData_Params_Data* data_ = nullptr;
};


class PageHandler_DeleteAllPasswordManagerData_ResponseParamsDataView {
 public:
  PageHandler_DeleteAllPasswordManagerData_ResponseParamsDataView() = default;

  PageHandler_DeleteAllPasswordManagerData_ResponseParamsDataView(
      internal::PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::PageHandler_DeleteAllPasswordManagerData_ResponseParams_Data* data_ = nullptr;
};


class PageHandler_CopyPlaintextBackupPassword_ParamsDataView {
 public:
  PageHandler_CopyPlaintextBackupPassword_ParamsDataView() = default;

  PageHandler_CopyPlaintextBackupPassword_ParamsDataView(
      internal::PageHandler_CopyPlaintextBackupPassword_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
 private:
  internal::PageHandler_CopyPlaintextBackupPassword_Params_Data* data_ = nullptr;
};


class PageHandler_CopyPlaintextBackupPassword_ResponseParamsDataView {
 public:
  PageHandler_CopyPlaintextBackupPassword_ResponseParamsDataView() = default;

  PageHandler_CopyPlaintextBackupPassword_ResponseParamsDataView(
      internal::PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::PageHandler_CopyPlaintextBackupPassword_ResponseParams_Data* data_ = nullptr;
};


class PageHandler_RemoveBackupPassword_ParamsDataView {
 public:
  PageHandler_RemoveBackupPassword_ParamsDataView() = default;

  PageHandler_RemoveBackupPassword_ParamsDataView(
      internal::PageHandler_RemoveBackupPassword_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
 private:
  internal::PageHandler_RemoveBackupPassword_Params_Data* data_ = nullptr;
};


class PageHandler_GetActorLoginPermissions_ParamsDataView {
 public:
  PageHandler_GetActorLoginPermissions_ParamsDataView() = default;

  PageHandler_GetActorLoginPermissions_ParamsDataView(
      internal::PageHandler_GetActorLoginPermissions_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetActorLoginPermissions_Params_Data* data_ = nullptr;
};


class PageHandler_GetActorLoginPermissions_ResponseParamsDataView {
 public:
  PageHandler_GetActorLoginPermissions_ResponseParamsDataView() = default;

  PageHandler_GetActorLoginPermissions_ResponseParamsDataView(
      internal::PageHandler_GetActorLoginPermissions_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSitesDataView(
      mojo::ArrayDataView<ActorLoginPermissionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSites(UserType* output) {
    
    auto* pointer = data_->sites.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::password_manager::mojom::ActorLoginPermissionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetActorLoginPermissions_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_RevokeActorLoginPermission_ParamsDataView {
 public:
  PageHandler_RevokeActorLoginPermission_ParamsDataView() = default;

  PageHandler_RevokeActorLoginPermission_ParamsDataView(
      internal::PageHandler_RevokeActorLoginPermission_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      ActorLoginPermissionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<::password_manager::mojom::ActorLoginPermissionDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_RevokeActorLoginPermission_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_ChangePasswordManagerPin_ParamsDataView {
 public:
  PageHandler_ChangePasswordManagerPin_ParamsDataView() = default;

  PageHandler_ChangePasswordManagerPin_ParamsDataView(
      internal::PageHandler_ChangePasswordManagerPin_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_ChangePasswordManagerPin_Params_Data* data_ = nullptr;
};


class PageHandler_ChangePasswordManagerPin_ResponseParamsDataView {
 public:
  PageHandler_ChangePasswordManagerPin_ResponseParamsDataView() = default;

  PageHandler_ChangePasswordManagerPin_ResponseParamsDataView(
      internal::PageHandler_ChangePasswordManagerPin_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::PageHandler_ChangePasswordManagerPin_ResponseParams_Data* data_ = nullptr;
};


class PageHandler_ShowAddShortcutDialog_ParamsDataView {
 public:
  PageHandler_ShowAddShortcutDialog_ParamsDataView() = default;

  PageHandler_ShowAddShortcutDialog_ParamsDataView(
      internal::PageHandler_ShowAddShortcutDialog_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_ShowAddShortcutDialog_Params_Data* data_ = nullptr;
};


class PageHandler_IsAccountStorageEnabled_ParamsDataView {
 public:
  PageHandler_IsAccountStorageEnabled_ParamsDataView() = default;

  PageHandler_IsAccountStorageEnabled_ParamsDataView(
      internal::PageHandler_IsAccountStorageEnabled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_IsAccountStorageEnabled_Params_Data* data_ = nullptr;
};


class PageHandler_IsAccountStorageEnabled_ResponseParamsDataView {
 public:
  PageHandler_IsAccountStorageEnabled_ResponseParamsDataView() = default;

  PageHandler_IsAccountStorageEnabled_ResponseParamsDataView(
      internal::PageHandler_IsAccountStorageEnabled_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
 private:
  internal::PageHandler_IsAccountStorageEnabled_ResponseParams_Data* data_ = nullptr;
};


class PageHandler_SetAccountStorageEnabled_ParamsDataView {
 public:
  PageHandler_SetAccountStorageEnabled_ParamsDataView() = default;

  PageHandler_SetAccountStorageEnabled_ParamsDataView(
      internal::PageHandler_SetAccountStorageEnabled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
 private:
  internal::PageHandler_SetAccountStorageEnabled_Params_Data* data_ = nullptr;
};


class PageHandler_ShouldShowAccountStorageSettingToggle_ParamsDataView {
 public:
  PageHandler_ShouldShowAccountStorageSettingToggle_ParamsDataView() = default;

  PageHandler_ShouldShowAccountStorageSettingToggle_ParamsDataView(
      internal::PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_ShouldShowAccountStorageSettingToggle_Params_Data* data_ = nullptr;
};


class PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsDataView {
 public:
  PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsDataView() = default;

  PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParamsDataView(
      internal::PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool should_show() const {
    return data_->should_show;
  }
 private:
  internal::PageHandler_ShouldShowAccountStorageSettingToggle_ResponseParams_Data* data_ = nullptr;
};


class PageHandler_IsPasswordManagerPinAvailable_ParamsDataView {
 public:
  PageHandler_IsPasswordManagerPinAvailable_ParamsDataView() = default;

  PageHandler_IsPasswordManagerPinAvailable_ParamsDataView(
      internal::PageHandler_IsPasswordManagerPinAvailable_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_IsPasswordManagerPinAvailable_Params_Data* data_ = nullptr;
};


class PageHandler_IsPasswordManagerPinAvailable_ResponseParamsDataView {
 public:
  PageHandler_IsPasswordManagerPinAvailable_ResponseParamsDataView() = default;

  PageHandler_IsPasswordManagerPinAvailable_ResponseParamsDataView(
      internal::PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_available() const {
    return data_->is_available;
  }
 private:
  internal::PageHandler_IsPasswordManagerPinAvailable_ResponseParams_Data* data_ = nullptr;
};


class PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsDataView {
 public:
  PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsDataView() = default;

  PageHandler_SwitchBiometricAuthBeforeFillingState_ParamsDataView(
      internal::PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_SwitchBiometricAuthBeforeFillingState_Params_Data* data_ = nullptr;
};


class PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsDataView {
 public:
  PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsDataView() = default;

  PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParamsDataView(
      internal::PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::PageHandler_SwitchBiometricAuthBeforeFillingState_ResponseParams_Data* data_ = nullptr;
};

















inline void PageHandler_GetActorLoginPermissions_ResponseParamsDataView::GetSitesDataView(
    mojo::ArrayDataView<ActorLoginPermissionDataView>* output) {
  auto pointer = data_->sites.Get();
  *output = mojo::ArrayDataView<ActorLoginPermissionDataView>(pointer, message_);
}


inline void PageHandler_RevokeActorLoginPermission_ParamsDataView::GetSiteDataView(
    ActorLoginPermissionDataView* output) {
  auto pointer = data_->site.Get();
  *output = ActorLoginPermissionDataView(pointer, message_);
}



























}  // password_manager::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_BROWSER_UI_WEBUI_PASSWORD_MANAGER_PASSWORD_MANAGER_MOJOM_PARAMS_DATA_H_