// chrome/browser/ui/webui/on_device_translation_internals/on_device_translation_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/on_device_translation_internals/on_device_translation_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/on_device_translation_internals/on_device_translation_internals.mojom-params-data.h"
namespace on_device_translation_internals {
namespace mojom {

NOINLINE static const char* LanguagePackStatusToStringHelper(LanguagePackStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LanguagePackStatus::kNotInstalled:
      return "kNotInstalled";
    case LanguagePackStatus::kInstalling:
      return "kInstalling";
    case LanguagePackStatus::kInstalled:
      return "kInstalled";
    default:
      return nullptr;
  }
}

std::string LanguagePackStatusToString(LanguagePackStatus value) {
  const char *str = LanguagePackStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LanguagePackStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LanguagePackStatus value) {
  return os << LanguagePackStatusToString(value);
}

namespace internal {


// static
bool LanguagePackInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LanguagePackInfo_Data* object =
      static_cast<const LanguagePackInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::on_device_translation_internals::mojom::internal::LanguagePackStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

LanguagePackInfo_Data::LanguagePackInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_InstallLanguagePackage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_InstallLanguagePackage_Params_Data* object =
      static_cast<const PageHandler_InstallLanguagePackage_Params_Data*>(data);

  return true;
}

PageHandler_InstallLanguagePackage_Params_Data::PageHandler_InstallLanguagePackage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UninstallLanguagePackage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UninstallLanguagePackage_Params_Data* object =
      static_cast<const PageHandler_UninstallLanguagePackage_Params_Data*>(data);

  return true;
}

PageHandler_UninstallLanguagePackage_Params_Data::PageHandler_UninstallLanguagePackage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnLanguagePackStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnLanguagePackStatus_Params_Data* object =
      static_cast<const Page_OnLanguagePackStatus_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& status_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->status, validation_context,
                                         &status_validate_params)) {
    return false;
  }

  return true;
}

Page_OnLanguagePackStatus_Params_Data::Page_OnLanguagePackStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace on_device_translation_internals

namespace perfetto {

// static
void TraceFormatTraits<::on_device_translation_internals::mojom::LanguagePackStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_translation_internals::mojom::LanguagePackStatus value) {
  return std::move(context).WriteString(::on_device_translation_internals::mojom::LanguagePackStatusToString(value));
}

} // namespace perfetto