// chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  LoadModelResultSpec as onDeviceModel_mojom_LoadModelResultSpec,
  LoadModelResult as onDeviceModel_mojom_LoadModelResult,
  OnDeviceModelPendingReceiver as onDeviceModel_mojom_OnDeviceModelPendingReceiver,
  CapabilitiesSpec as onDeviceModel_mojom_CapabilitiesSpec,
  Capabilities as onDeviceModel_mojom_Capabilities,
  DeviceInfoSpec as onDeviceModel_mojom_DeviceInfoSpec,
  DeviceInfo as onDeviceModel_mojom_DeviceInfo,
  DevicePerformanceInfoSpec as onDeviceModel_mojom_DevicePerformanceInfoSpec,
  DevicePerformanceInfo as onDeviceModel_mojom_DevicePerformanceInfo
} from './on_device_model.mojom-webui.js';
import {
  ModelPerformanceHintSpec as onDeviceModel_mojom_ModelPerformanceHintSpec,
  ModelPerformanceHint as onDeviceModel_mojom_ModelPerformanceHint
} from './on_device_model_service.mojom-webui.js';
import {
  BigBufferSpec as mojoBase_mojom_BigBufferSpec,
  BigBuffer as mojoBase_mojom_BigBuffer
} from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import {
  FilePathSpec as mojoBase_mojom_FilePathSpec,
  FilePath as mojoBase_mojom_FilePath
} from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  BitmapMappedFromTrustedProcessSpec as skia_mojom_BitmapMappedFromTrustedProcessSpec,
  BitmapMappedFromTrustedProcess as skia_mojom_BitmapMappedFromTrustedProcess
} from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';







export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_internals.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "on_device_internals.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_internals.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  loadModel(modelPath: mojoBase_mojom_FilePath, performanceHint: onDeviceModel_mojom_ModelPerformanceHint, model: onDeviceModel_mojom_OnDeviceModelPendingReceiver): Promise<{
        result: onDeviceModel_mojom_LoadModelResult,
        capabilities: onDeviceModel_mojom_Capabilities, }>;
  loadPlatformModel(modelPath: mojoBase_mojom_FilePath, model: onDeviceModel_mojom_OnDeviceModelPendingReceiver): Promise<{
        result: onDeviceModel_mojom_LoadModelResult, }>;
  getDeviceAndPerformanceInfo(): Promise<{
        performanceInfo: onDeviceModel_mojom_DevicePerformanceInfo,
        deviceInfo: onDeviceModel_mojom_DeviceInfo, }>;
  getDefaultModelPath(): Promise<{
        modelPath: (mojoBase_mojom_FilePath | null), }>;
  getPageData(): Promise<{
        pageData: PageData, }>;
  setFeatureRecentlyUsedState(featureKey: number, isRecentlyUsed: boolean): void;
  decodeBitmap(imageBuffer: mojoBase_mojom_BigBuffer): Promise<{
        bitmap: (skia_mojom_BitmapMappedFromTrustedProcess | null), }>;
  resetModelCrashCount(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  loadModel(
      modelPath: mojoBase_mojom_FilePath,
      performanceHint: onDeviceModel_mojom_ModelPerformanceHint,
      model: onDeviceModel_mojom_OnDeviceModelPendingReceiver): Promise<{
        result: onDeviceModel_mojom_LoadModelResult,
        capabilities: onDeviceModel_mojom_Capabilities, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_LoadModel_ParamsSpec.$,
        PageHandler_LoadModel_ResponseParamsSpec.$,
        [
          modelPath,
          performanceHint,
          model
        ],
        false);
  }

  loadPlatformModel(
      modelPath: mojoBase_mojom_FilePath,
      model: onDeviceModel_mojom_OnDeviceModelPendingReceiver): Promise<{
        result: onDeviceModel_mojom_LoadModelResult, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_LoadPlatformModel_ParamsSpec.$,
        PageHandler_LoadPlatformModel_ResponseParamsSpec.$,
        [
          modelPath,
          model
        ],
        false);
  }

  getDeviceAndPerformanceInfo(): Promise<{
        performanceInfo: onDeviceModel_mojom_DevicePerformanceInfo,
        deviceInfo: onDeviceModel_mojom_DeviceInfo, }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getDefaultModelPath(): Promise<{
        modelPath: (mojoBase_mojom_FilePath | null), }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_GetDefaultModelPath_ParamsSpec.$,
        PageHandler_GetDefaultModelPath_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getPageData(): Promise<{
        pageData: PageData, }> {
    return this.proxy.sendMessage(
        4,
        PageHandler_GetPageData_ParamsSpec.$,
        PageHandler_GetPageData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setFeatureRecentlyUsedState(
      featureKey: number,
      isRecentlyUsed: boolean): void {
    this.proxy.sendMessage(
        5,
        PageHandler_SetFeatureRecentlyUsedState_ParamsSpec.$,
        null,
        [
          featureKey,
          isRecentlyUsed
        ],
        false);
  }

  decodeBitmap(
      imageBuffer: mojoBase_mojom_BigBuffer): Promise<{
        bitmap: (skia_mojom_BitmapMappedFromTrustedProcess | null), }> {
    return this.proxy.sendMessage(
        6,
        PageHandler_DecodeBitmap_ParamsSpec.$,
        PageHandler_DecodeBitmap_ResponseParamsSpec.$,
        [
          imageBuffer
        ],
        false);
  }

  resetModelCrashCount(): void {
    this.proxy.sendMessage(
        7,
        PageHandler_ResetModelCrashCount_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_LoadModel_ParamsSpec.$,
        PageHandler_LoadModel_ResponseParamsSpec.$,
        impl.loadModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_LoadPlatformModel_ParamsSpec.$,
        PageHandler_LoadPlatformModel_ResponseParamsSpec.$,
        impl.loadPlatformModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        impl.getDeviceAndPerformanceInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_GetDefaultModelPath_ParamsSpec.$,
        PageHandler_GetDefaultModelPath_ResponseParamsSpec.$,
        impl.getDefaultModelPath.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_GetPageData_ParamsSpec.$,
        PageHandler_GetPageData_ResponseParamsSpec.$,
        impl.getPageData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_SetFeatureRecentlyUsedState_ParamsSpec.$,
        null,
        impl.setFeatureRecentlyUsedState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_DecodeBitmap_ParamsSpec.$,
        PageHandler_DecodeBitmap_ResponseParamsSpec.$,
        impl.decodeBitmap.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_ResetModelCrashCount_ParamsSpec.$,
        null,
        impl.resetModelCrashCount.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "on_device_internals.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  loadModel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  loadPlatformModel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDeviceAndPerformanceInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDefaultModelPath: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getPageData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setFeatureRecentlyUsedState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  decodeBitmap: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resetModelCrashCount: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.loadModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_LoadModel_ParamsSpec.$,
        PageHandler_LoadModel_ResponseParamsSpec.$,
        this.loadModel.createReceiverHandler(true /* expectsResponse */),
        false);
    this.loadPlatformModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_LoadPlatformModel_ParamsSpec.$,
        PageHandler_LoadPlatformModel_ResponseParamsSpec.$,
        this.loadPlatformModel.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDeviceAndPerformanceInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        this.getDeviceAndPerformanceInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDefaultModelPath =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_GetDefaultModelPath_ParamsSpec.$,
        PageHandler_GetDefaultModelPath_ResponseParamsSpec.$,
        this.getDefaultModelPath.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getPageData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_GetPageData_ParamsSpec.$,
        PageHandler_GetPageData_ResponseParamsSpec.$,
        this.getPageData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setFeatureRecentlyUsedState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_SetFeatureRecentlyUsedState_ParamsSpec.$,
        null,
        this.setFeatureRecentlyUsedState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.decodeBitmap =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_DecodeBitmap_ParamsSpec.$,
        PageHandler_DecodeBitmap_ResponseParamsSpec.$,
        this.decodeBitmap.createReceiverHandler(true /* expectsResponse */),
        false);
    this.resetModelCrashCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_ResetModelCrashCount_ParamsSpec.$,
        null,
        this.resetModelCrashCount.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'on_device_internals.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onLogMessageAdded(eventTime: mojoBase_mojom_Time, sourceFile: string, sourceLine: bigint, message: string): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onLogMessageAdded(
      eventTime: mojoBase_mojom_Time,
      sourceFile: string,
      sourceLine: bigint,
      message: string): void {
    this.proxy.sendMessage(
        0,
        Page_OnLogMessageAdded_ParamsSpec.$,
        null,
        [
          eventTime,
          sourceFile,
          sourceLine,
          message
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnLogMessageAdded_ParamsSpec.$,
        null,
        impl.onLogMessageAdded.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "on_device_internals.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onLogMessageAdded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onLogMessageAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnLogMessageAdded_ParamsSpec.$,
        null,
        this.onLogMessageAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BaseModelStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BaseModelInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SupplementaryModelInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FeatureAdaptationInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LoadModel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LoadModel_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LoadPlatformModel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LoadPlatformModel_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDefaultModelPath_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDefaultModelPath_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetPageData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetPageData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetFeatureRecentlyUsedState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DecodeBitmap_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DecodeBitmap_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ResetModelCrashCount_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnLogMessageAdded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageDataMojoType {
  baseModel: BaseModelState;
  suppModels: SupplementaryModelInfo[];
  modelCrashCount: number;
  maxModelCrashCount: number;
  featureAdaptations: FeatureAdaptationInfo[];
  performanceInfo: onDeviceModel_mojom_DevicePerformanceInfo;
  minVramMb: bigint;
}


export type PageData = PageDataMojoType;
mojo.internal.Struct<PageDataMojoType>(
    PageDataSpec.$,
    'PageData',
    [
      mojo.internal.StructField<PageDataMojoType, BaseModelState>(
        'baseModel', 0,
        0,
        BaseModelStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageDataMojoType, SupplementaryModelInfo[]>(
        'suppModels', 8,
        0,
        mojo.internal.Array(SupplementaryModelInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageDataMojoType, number>(
        'modelCrashCount', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageDataMojoType, number>(
        'maxModelCrashCount', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageDataMojoType, FeatureAdaptationInfo[]>(
        'featureAdaptations', 24,
        0,
        mojo.internal.Array(FeatureAdaptationInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageDataMojoType, onDeviceModel_mojom_DevicePerformanceInfo>(
        'performanceInfo', 32,
        0,
        onDeviceModel_mojom_DevicePerformanceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageDataMojoType, bigint>(
        'minVramMb', 40,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface BaseModelStateMojoType {
  state: string;
  registrationCriteria: {[key: string]: string};
  info: (BaseModelInfo | null);
}


export type BaseModelState = BaseModelStateMojoType;
mojo.internal.Struct<BaseModelStateMojoType>(
    BaseModelStateSpec.$,
    'BaseModelState',
    [
      mojo.internal.StructField<BaseModelStateMojoType, string>(
        'state', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseModelStateMojoType, {[key: string]: string}>(
        'registrationCriteria', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseModelStateMojoType, BaseModelInfo>(
        'info', 16,
        0,
        BaseModelInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface BaseModelInfoMojoType {
  componentVersion: string;
  filePath: string;
  fileSize: bigint;
  name: string;
  version: string;
  backendType: string;
}


export type BaseModelInfo = BaseModelInfoMojoType;
mojo.internal.Struct<BaseModelInfoMojoType>(
    BaseModelInfoSpec.$,
    'BaseModelInfo',
    [
      mojo.internal.StructField<BaseModelInfoMojoType, string>(
        'componentVersion', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseModelInfoMojoType, string>(
        'filePath', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseModelInfoMojoType, bigint>(
        'fileSize', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseModelInfoMojoType, string>(
        'name', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseModelInfoMojoType, string>(
        'version', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseModelInfoMojoType, string>(
        'backendType', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface SupplementaryModelInfoMojoType {
  suppModelName: string;
  isReady: boolean;
}


export type SupplementaryModelInfo = SupplementaryModelInfoMojoType;
mojo.internal.Struct<SupplementaryModelInfoMojoType>(
    SupplementaryModelInfoSpec.$,
    'SupplementaryModelInfo',
    [
      mojo.internal.StructField<SupplementaryModelInfoMojoType, string>(
        'suppModelName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SupplementaryModelInfoMojoType, boolean>(
        'isReady', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface FeatureAdaptationInfoMojoType {
  featureName: string;
  featureKey: number;
  isRecentlyUsed: boolean;
  version: bigint;
}


export type FeatureAdaptationInfo = FeatureAdaptationInfoMojoType;
mojo.internal.Struct<FeatureAdaptationInfoMojoType>(
    FeatureAdaptationInfoSpec.$,
    'FeatureAdaptationInfo',
    [
      mojo.internal.StructField<FeatureAdaptationInfoMojoType, string>(
        'featureName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeatureAdaptationInfoMojoType, number>(
        'featureKey', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeatureAdaptationInfoMojoType, bigint>(
        'version', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<FeatureAdaptationInfoMojoType, boolean>(
        'isRecentlyUsed', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_LoadModel_ParamsMojoType {
  modelPath: mojoBase_mojom_FilePath;
  performanceHint: onDeviceModel_mojom_ModelPerformanceHint;
  model: onDeviceModel_mojom_OnDeviceModelPendingReceiver;
}


export type PageHandler_LoadModel_Params = PageHandler_LoadModel_ParamsMojoType;
mojo.internal.Struct<PageHandler_LoadModel_ParamsMojoType>(
    PageHandler_LoadModel_ParamsSpec.$,
    'PageHandler_LoadModel_Params',
    [
      mojo.internal.StructField<PageHandler_LoadModel_ParamsMojoType, mojoBase_mojom_FilePath>(
        'modelPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_LoadModel_ParamsMojoType, onDeviceModel_mojom_ModelPerformanceHint>(
        'performanceHint', 8,
        0,
        onDeviceModel_mojom_ModelPerformanceHintSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_LoadModel_ParamsMojoType, onDeviceModel_mojom_OnDeviceModelPendingReceiver>(
        'model', 12,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_LoadModel_ResponseParamsMojoType {
  result: onDeviceModel_mojom_LoadModelResult;
  capabilities: onDeviceModel_mojom_Capabilities;
}


export type PageHandler_LoadModel_ResponseParams = PageHandler_LoadModel_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_LoadModel_ResponseParamsMojoType>(
    PageHandler_LoadModel_ResponseParamsSpec.$,
    'PageHandler_LoadModel_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_LoadModel_ResponseParamsMojoType, onDeviceModel_mojom_LoadModelResult>(
        'result', 0,
        0,
        onDeviceModel_mojom_LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_LoadModel_ResponseParamsMojoType, onDeviceModel_mojom_Capabilities>(
        'capabilities', 8,
        0,
        onDeviceModel_mojom_CapabilitiesSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_LoadPlatformModel_ParamsMojoType {
  modelPath: mojoBase_mojom_FilePath;
  model: onDeviceModel_mojom_OnDeviceModelPendingReceiver;
}


export type PageHandler_LoadPlatformModel_Params = PageHandler_LoadPlatformModel_ParamsMojoType;
mojo.internal.Struct<PageHandler_LoadPlatformModel_ParamsMojoType>(
    PageHandler_LoadPlatformModel_ParamsSpec.$,
    'PageHandler_LoadPlatformModel_Params',
    [
      mojo.internal.StructField<PageHandler_LoadPlatformModel_ParamsMojoType, mojoBase_mojom_FilePath>(
        'modelPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_LoadPlatformModel_ParamsMojoType, onDeviceModel_mojom_OnDeviceModelPendingReceiver>(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_LoadPlatformModel_ResponseParamsMojoType {
  result: onDeviceModel_mojom_LoadModelResult;
}


export type PageHandler_LoadPlatformModel_ResponseParams = PageHandler_LoadPlatformModel_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_LoadPlatformModel_ResponseParamsMojoType>(
    PageHandler_LoadPlatformModel_ResponseParamsSpec.$,
    'PageHandler_LoadPlatformModel_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_LoadPlatformModel_ResponseParamsMojoType, onDeviceModel_mojom_LoadModelResult>(
        'result', 0,
        0,
        onDeviceModel_mojom_LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetDeviceAndPerformanceInfo_ParamsMojoType {
}


export type PageHandler_GetDeviceAndPerformanceInfo_Params = PageHandler_GetDeviceAndPerformanceInfo_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetDeviceAndPerformanceInfo_ParamsMojoType>(
    PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec.$,
    'PageHandler_GetDeviceAndPerformanceInfo_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsMojoType {
  performanceInfo: onDeviceModel_mojom_DevicePerformanceInfo;
  deviceInfo: onDeviceModel_mojom_DeviceInfo;
}


export type PageHandler_GetDeviceAndPerformanceInfo_ResponseParams = PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsMojoType>(
    PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
    'PageHandler_GetDeviceAndPerformanceInfo_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsMojoType, onDeviceModel_mojom_DevicePerformanceInfo>(
        'performanceInfo', 0,
        0,
        onDeviceModel_mojom_DevicePerformanceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsMojoType, onDeviceModel_mojom_DeviceInfo>(
        'deviceInfo', 8,
        0,
        onDeviceModel_mojom_DeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetDefaultModelPath_ParamsMojoType {
}


export type PageHandler_GetDefaultModelPath_Params = PageHandler_GetDefaultModelPath_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetDefaultModelPath_ParamsMojoType>(
    PageHandler_GetDefaultModelPath_ParamsSpec.$,
    'PageHandler_GetDefaultModelPath_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetDefaultModelPath_ResponseParamsMojoType {
  modelPath: (mojoBase_mojom_FilePath | null);
}


export type PageHandler_GetDefaultModelPath_ResponseParams = PageHandler_GetDefaultModelPath_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetDefaultModelPath_ResponseParamsMojoType>(
    PageHandler_GetDefaultModelPath_ResponseParamsSpec.$,
    'PageHandler_GetDefaultModelPath_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetDefaultModelPath_ResponseParamsMojoType, mojoBase_mojom_FilePath>(
        'modelPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetPageData_ParamsMojoType {
}


export type PageHandler_GetPageData_Params = PageHandler_GetPageData_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetPageData_ParamsMojoType>(
    PageHandler_GetPageData_ParamsSpec.$,
    'PageHandler_GetPageData_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetPageData_ResponseParamsMojoType {
  pageData: PageData;
}


export type PageHandler_GetPageData_ResponseParams = PageHandler_GetPageData_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetPageData_ResponseParamsMojoType>(
    PageHandler_GetPageData_ResponseParamsSpec.$,
    'PageHandler_GetPageData_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetPageData_ResponseParamsMojoType, PageData>(
        'pageData', 0,
        0,
        PageDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetFeatureRecentlyUsedState_ParamsMojoType {
  featureKey: number;
  isRecentlyUsed: boolean;
}


export type PageHandler_SetFeatureRecentlyUsedState_Params = PageHandler_SetFeatureRecentlyUsedState_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetFeatureRecentlyUsedState_ParamsMojoType>(
    PageHandler_SetFeatureRecentlyUsedState_ParamsSpec.$,
    'PageHandler_SetFeatureRecentlyUsedState_Params',
    [
      mojo.internal.StructField<PageHandler_SetFeatureRecentlyUsedState_ParamsMojoType, number>(
        'featureKey', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetFeatureRecentlyUsedState_ParamsMojoType, boolean>(
        'isRecentlyUsed', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DecodeBitmap_ParamsMojoType {
  imageBuffer: mojoBase_mojom_BigBuffer;
}


export type PageHandler_DecodeBitmap_Params = PageHandler_DecodeBitmap_ParamsMojoType;
mojo.internal.Struct<PageHandler_DecodeBitmap_ParamsMojoType>(
    PageHandler_DecodeBitmap_ParamsSpec.$,
    'PageHandler_DecodeBitmap_Params',
    [
      mojo.internal.StructField<PageHandler_DecodeBitmap_ParamsMojoType, mojoBase_mojom_BigBuffer>(
        'imageBuffer', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_DecodeBitmap_ResponseParamsMojoType {
  bitmap: (skia_mojom_BitmapMappedFromTrustedProcess | null);
}


export type PageHandler_DecodeBitmap_ResponseParams = PageHandler_DecodeBitmap_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_DecodeBitmap_ResponseParamsMojoType>(
    PageHandler_DecodeBitmap_ResponseParamsSpec.$,
    'PageHandler_DecodeBitmap_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_DecodeBitmap_ResponseParamsMojoType, skia_mojom_BitmapMappedFromTrustedProcess>(
        'bitmap', 0,
        0,
        skia_mojom_BitmapMappedFromTrustedProcessSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ResetModelCrashCount_ParamsMojoType {
}


export type PageHandler_ResetModelCrashCount_Params = PageHandler_ResetModelCrashCount_ParamsMojoType;
mojo.internal.Struct<PageHandler_ResetModelCrashCount_ParamsMojoType>(
    PageHandler_ResetModelCrashCount_ParamsSpec.$,
    'PageHandler_ResetModelCrashCount_Params',
    [
    ],
    [[0, 8],]);





export interface Page_OnLogMessageAdded_ParamsMojoType {
  eventTime: mojoBase_mojom_Time;
  sourceFile: string;
  sourceLine: bigint;
  message: string;
}


export type Page_OnLogMessageAdded_Params = Page_OnLogMessageAdded_ParamsMojoType;
mojo.internal.Struct<Page_OnLogMessageAdded_ParamsMojoType>(
    Page_OnLogMessageAdded_ParamsSpec.$,
    'Page_OnLogMessageAdded_Params',
    [
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, mojoBase_mojom_Time>(
        'eventTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, string>(
        'sourceFile', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, bigint>(
        'sourceLine', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnLogMessageAdded_ParamsMojoType, string>(
        'message', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);



