// chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom.h"


namespace on_device_internals::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void LoadModel(const ::base::FilePath& model_path, ::ml::ModelPerformanceHint performance_hint, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadModelCallback callback) override;
  void LoadPlatformModel(const ::base::FilePath& model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadPlatformModelCallback callback) override;
  void GetDeviceAndPerformanceInfo(GetDeviceAndPerformanceInfoCallback callback) override;
  void GetDefaultModelPath(GetDefaultModelPathCallback callback) override;
  void GetPageData(GetPageDataCallback callback) override;
  void SetFeatureRecentlyUsedState(int32_t feature_key, bool is_recently_used) override;
  void DecodeBitmap(::mojo_base::BigBuffer image_buffer, DecodeBitmapCallback callback) override;
  void ResetModelCrashCount() override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void LoadModel(
      const ::base::FilePath& model_path, ::ml::ModelPerformanceHint performance_hint, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::on_device_model::mojom::LoadModelResult* out_result, ::on_device_model::Capabilities* out_capabilities);
  
  void LoadPlatformModel(
      const ::base::FilePath& model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::on_device_model::mojom::LoadModelResult* out_result);
  ::on_device_model::mojom::LoadModelResult LoadPlatformModel(const ::base::FilePath& model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model);
  void GetDeviceAndPerformanceInfo(
      ::on_device_model::mojom::DevicePerformanceInfoPtr* out_performance_info, ::on_device_model::mojom::DeviceInfoPtr* out_device_info);
  
  void GetDefaultModelPath(
      std::optional<::base::FilePath>* out_model_path);
  std::optional<::base::FilePath> GetDefaultModelPath();
  void GetPageData(
      PageDataPtr* out_page_data);
  PageDataPtr GetPageData();
  void DecodeBitmap(
      ::mojo_base::BigBuffer image_buffer, ::SkBitmap* out_bitmap);
  ::SkBitmap DecodeBitmap(::mojo_base::BigBuffer image_buffer);

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void OnLogMessageAdded(::base::Time event_time, const std::string& source_file, int64_t source_line, const std::string& message) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // on_device_internals::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_TEST_UTILS_H_