// chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_PARAMS_DATA_H_
#define CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace on_device_internals::mojom {
namespace internal {
class  PageHandlerFactory_CreatePageHandler_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data page;
  mojo::internal::Handle_Data handler;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandlerFactory_CreatePageHandler_Params_Data>;

  PageHandlerFactory_CreatePageHandler_Params_Data();
  ~PageHandlerFactory_CreatePageHandler_Params_Data() = delete;
};
static_assert(sizeof(PageHandlerFactory_CreatePageHandler_Params_Data) == 24,
              "Bad sizeof(PageHandlerFactory_CreatePageHandler_Params_Data)");
class  PageHandler_LoadModel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> model_path;
  int32_t performance_hint;
  mojo::internal::Handle_Data model;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_LoadModel_Params_Data>;

  PageHandler_LoadModel_Params_Data();
  ~PageHandler_LoadModel_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_LoadModel_Params_Data) == 24,
              "Bad sizeof(PageHandler_LoadModel_Params_Data)");
class  PageHandler_LoadModel_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::on_device_model::mojom::internal::Capabilities_Data> capabilities;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_LoadModel_ResponseParams_Data>;

  PageHandler_LoadModel_ResponseParams_Data();
  ~PageHandler_LoadModel_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_LoadModel_ResponseParams_Data) == 24,
              "Bad sizeof(PageHandler_LoadModel_ResponseParams_Data)");
class  PageHandler_LoadPlatformModel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> model_path;
  mojo::internal::Handle_Data model;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_LoadPlatformModel_Params_Data>;

  PageHandler_LoadPlatformModel_Params_Data();
  ~PageHandler_LoadPlatformModel_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_LoadPlatformModel_Params_Data) == 24,
              "Bad sizeof(PageHandler_LoadPlatformModel_Params_Data)");
class  PageHandler_LoadPlatformModel_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_LoadPlatformModel_ResponseParams_Data>;

  PageHandler_LoadPlatformModel_ResponseParams_Data();
  ~PageHandler_LoadPlatformModel_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_LoadPlatformModel_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_LoadPlatformModel_ResponseParams_Data)");
class  PageHandler_GetDeviceAndPerformanceInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetDeviceAndPerformanceInfo_Params_Data>;

  PageHandler_GetDeviceAndPerformanceInfo_Params_Data();
  ~PageHandler_GetDeviceAndPerformanceInfo_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetDeviceAndPerformanceInfo_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetDeviceAndPerformanceInfo_Params_Data)");
class  PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::on_device_model::mojom::internal::DevicePerformanceInfo_Data> performance_info;
  mojo::internal::Pointer<::on_device_model::mojom::internal::DeviceInfo_Data> device_info;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data>;

  PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data();
  ~PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data) == 24,
              "Bad sizeof(PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data)");
class  PageHandler_GetDefaultModelPath_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetDefaultModelPath_Params_Data>;

  PageHandler_GetDefaultModelPath_Params_Data();
  ~PageHandler_GetDefaultModelPath_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetDefaultModelPath_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetDefaultModelPath_Params_Data)");
class  PageHandler_GetDefaultModelPath_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> model_path;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetDefaultModelPath_ResponseParams_Data>;

  PageHandler_GetDefaultModelPath_ResponseParams_Data();
  ~PageHandler_GetDefaultModelPath_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetDefaultModelPath_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetDefaultModelPath_ResponseParams_Data)");
class  PageHandler_GetPageData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetPageData_Params_Data>;

  PageHandler_GetPageData_Params_Data();
  ~PageHandler_GetPageData_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetPageData_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetPageData_Params_Data)");
class  PageHandler_GetPageData_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PageData_Data> page_data;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetPageData_ResponseParams_Data>;

  PageHandler_GetPageData_ResponseParams_Data();
  ~PageHandler_GetPageData_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_GetPageData_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_GetPageData_ResponseParams_Data)");
class  PageHandler_SetFeatureRecentlyUsedState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t feature_key;
  uint8_t is_recently_used : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_SetFeatureRecentlyUsedState_Params_Data>;

  PageHandler_SetFeatureRecentlyUsedState_Params_Data();
  ~PageHandler_SetFeatureRecentlyUsedState_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_SetFeatureRecentlyUsedState_Params_Data) == 16,
              "Bad sizeof(PageHandler_SetFeatureRecentlyUsedState_Params_Data)");
class  PageHandler_DecodeBitmap_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::mojo_base::mojom::internal::BigBuffer_Data image_buffer;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_DecodeBitmap_Params_Data>;

  PageHandler_DecodeBitmap_Params_Data();
  ~PageHandler_DecodeBitmap_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_DecodeBitmap_Params_Data) == 24,
              "Bad sizeof(PageHandler_DecodeBitmap_Params_Data)");
class  PageHandler_DecodeBitmap_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::skia::mojom::internal::BitmapMappedFromTrustedProcess_Data> bitmap;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_DecodeBitmap_ResponseParams_Data>;

  PageHandler_DecodeBitmap_ResponseParams_Data();
  ~PageHandler_DecodeBitmap_ResponseParams_Data() = delete;
};
static_assert(sizeof(PageHandler_DecodeBitmap_ResponseParams_Data) == 16,
              "Bad sizeof(PageHandler_DecodeBitmap_ResponseParams_Data)");
class  PageHandler_ResetModelCrashCount_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ResetModelCrashCount_Params_Data>;

  PageHandler_ResetModelCrashCount_Params_Data();
  ~PageHandler_ResetModelCrashCount_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ResetModelCrashCount_Params_Data) == 8,
              "Bad sizeof(PageHandler_ResetModelCrashCount_Params_Data)");
class  Page_OnLogMessageAdded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> event_time;
  mojo::internal::Pointer<mojo::internal::String_Data> source_file;
  int64_t source_line;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<Page_OnLogMessageAdded_Params_Data>;

  Page_OnLogMessageAdded_Params_Data();
  ~Page_OnLogMessageAdded_Params_Data() = delete;
};
static_assert(sizeof(Page_OnLogMessageAdded_Params_Data) == 40,
              "Bad sizeof(Page_OnLogMessageAdded_Params_Data)");

}  // namespace internal


class PageHandlerFactory_CreatePageHandler_ParamsDataView {
 public:
  PageHandlerFactory_CreatePageHandler_ParamsDataView() = default;

  PageHandlerFactory_CreatePageHandler_ParamsDataView(
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePage() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::on_device_internals::mojom::PageInterfaceBase>>(
            &data_->page, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::on_device_internals::mojom::PageHandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandlerFactory_CreatePageHandler_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_LoadModel_ParamsDataView {
 public:
  PageHandler_LoadModel_ParamsDataView() = default;

  PageHandler_LoadModel_ParamsDataView(
      internal::PageHandler_LoadModel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetModelPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelPath(UserType* output) {
    
    auto* pointer = data_->model_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPerformanceHint(UserType* output) const {
    auto data_value = data_->performance_hint;
    return mojo::internal::Deserialize<::on_device_model::mojom::ModelPerformanceHint>(
        data_value, output);
  }
  ::on_device_model::mojom::ModelPerformanceHint performance_hint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::on_device_model::mojom::ModelPerformanceHint>(data_->performance_hint));
  }
  template <typename UserType>
  UserType TakeModel() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::OnDeviceModelInterfaceBase>>(
            &data_->model, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandler_LoadModel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_LoadModel_ResponseParamsDataView {
 public:
  PageHandler_LoadModel_ResponseParamsDataView() = default;

  PageHandler_LoadModel_ResponseParamsDataView(
      internal::PageHandler_LoadModel_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::on_device_model::mojom::LoadModelResult>(
        data_value, output);
  }
  ::on_device_model::mojom::LoadModelResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::on_device_model::mojom::LoadModelResult>(data_->result));
  }
  inline void GetCapabilitiesDataView(
      ::on_device_model::mojom::CapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCapabilities(UserType* output) {
    
    auto* pointer = data_->capabilities.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::CapabilitiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_LoadModel_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_LoadPlatformModel_ParamsDataView {
 public:
  PageHandler_LoadPlatformModel_ParamsDataView() = default;

  PageHandler_LoadPlatformModel_ParamsDataView(
      internal::PageHandler_LoadPlatformModel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetModelPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelPath(UserType* output) {
    
    auto* pointer = data_->model_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeModel() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::OnDeviceModelInterfaceBase>>(
            &data_->model, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandler_LoadPlatformModel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_LoadPlatformModel_ResponseParamsDataView {
 public:
  PageHandler_LoadPlatformModel_ResponseParamsDataView() = default;

  PageHandler_LoadPlatformModel_ResponseParamsDataView(
      internal::PageHandler_LoadPlatformModel_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::on_device_model::mojom::LoadModelResult>(
        data_value, output);
  }
  ::on_device_model::mojom::LoadModelResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::on_device_model::mojom::LoadModelResult>(data_->result));
  }
 private:
  internal::PageHandler_LoadPlatformModel_ResponseParams_Data* data_ = nullptr;
};


class PageHandler_GetDeviceAndPerformanceInfo_ParamsDataView {
 public:
  PageHandler_GetDeviceAndPerformanceInfo_ParamsDataView() = default;

  PageHandler_GetDeviceAndPerformanceInfo_ParamsDataView(
      internal::PageHandler_GetDeviceAndPerformanceInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetDeviceAndPerformanceInfo_Params_Data* data_ = nullptr;
};


class PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsDataView {
 public:
  PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsDataView() = default;

  PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsDataView(
      internal::PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPerformanceInfoDataView(
      ::on_device_model::mojom::DevicePerformanceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerformanceInfo(UserType* output) {
    
    auto* pointer = data_->performance_info.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::DevicePerformanceInfoDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceInfoDataView(
      ::on_device_model::mojom::DeviceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceInfo(UserType* output) {
    
    auto* pointer = data_->device_info.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::DeviceInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_GetDefaultModelPath_ParamsDataView {
 public:
  PageHandler_GetDefaultModelPath_ParamsDataView() = default;

  PageHandler_GetDefaultModelPath_ParamsDataView(
      internal::PageHandler_GetDefaultModelPath_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetDefaultModelPath_Params_Data* data_ = nullptr;
};


class PageHandler_GetDefaultModelPath_ResponseParamsDataView {
 public:
  PageHandler_GetDefaultModelPath_ResponseParamsDataView() = default;

  PageHandler_GetDefaultModelPath_ResponseParamsDataView(
      internal::PageHandler_GetDefaultModelPath_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetModelPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `model_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadModelPath` instead "
    "of `ReadModelPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->model_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetDefaultModelPath_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_GetPageData_ParamsDataView {
 public:
  PageHandler_GetPageData_ParamsDataView() = default;

  PageHandler_GetPageData_ParamsDataView(
      internal::PageHandler_GetPageData_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetPageData_Params_Data* data_ = nullptr;
};


class PageHandler_GetPageData_ResponseParamsDataView {
 public:
  PageHandler_GetPageData_ResponseParamsDataView() = default;

  PageHandler_GetPageData_ResponseParamsDataView(
      internal::PageHandler_GetPageData_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPageDataDataView(
      PageDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageData(UserType* output) {
    
    auto* pointer = data_->page_data.Get();
    return mojo::internal::Deserialize<::on_device_internals::mojom::PageDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_GetPageData_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_SetFeatureRecentlyUsedState_ParamsDataView {
 public:
  PageHandler_SetFeatureRecentlyUsedState_ParamsDataView() = default;

  PageHandler_SetFeatureRecentlyUsedState_ParamsDataView(
      internal::PageHandler_SetFeatureRecentlyUsedState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t feature_key() const {
    return data_->feature_key;
  }
  bool is_recently_used() const {
    return data_->is_recently_used;
  }
 private:
  internal::PageHandler_SetFeatureRecentlyUsedState_Params_Data* data_ = nullptr;
};


class PageHandler_DecodeBitmap_ParamsDataView {
 public:
  PageHandler_DecodeBitmap_ParamsDataView() = default;

  PageHandler_DecodeBitmap_ParamsDataView(
      internal::PageHandler_DecodeBitmap_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageBufferDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageBuffer(UserType* output) {
    
    auto* pointer = !data_->image_buffer.is_null() ? &data_->image_buffer : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_DecodeBitmap_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_DecodeBitmap_ResponseParamsDataView {
 public:
  PageHandler_DecodeBitmap_ResponseParamsDataView() = default;

  PageHandler_DecodeBitmap_ResponseParamsDataView(
      internal::PageHandler_DecodeBitmap_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitmapDataView(
      ::skia::mojom::BitmapMappedFromTrustedProcessDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapMappedFromTrustedProcessDataView, UserType>(),
    "Attempting to read the optional `bitmap` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBitmap` instead "
    "of `ReadBitmap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapMappedFromTrustedProcessDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageHandler_DecodeBitmap_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_ResetModelCrashCount_ParamsDataView {
 public:
  PageHandler_ResetModelCrashCount_ParamsDataView() = default;

  PageHandler_ResetModelCrashCount_ParamsDataView(
      internal::PageHandler_ResetModelCrashCount_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_ResetModelCrashCount_Params_Data* data_ = nullptr;
};


class Page_OnLogMessageAdded_ParamsDataView {
 public:
  Page_OnLogMessageAdded_ParamsDataView() = default;

  Page_OnLogMessageAdded_ParamsDataView(
      internal::Page_OnLogMessageAdded_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEventTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventTime(UserType* output) {
    
    auto* pointer = data_->event_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetSourceFileDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceFile(UserType* output) {
    
    auto* pointer = data_->source_file.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t source_line() const {
    return data_->source_line;
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Page_OnLogMessageAdded_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



inline void PageHandler_LoadModel_ParamsDataView::GetModelPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->model_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}


inline void PageHandler_LoadModel_ResponseParamsDataView::GetCapabilitiesDataView(
    ::on_device_model::mojom::CapabilitiesDataView* output) {
  auto pointer = data_->capabilities.Get();
  *output = ::on_device_model::mojom::CapabilitiesDataView(pointer, message_);
}


inline void PageHandler_LoadPlatformModel_ParamsDataView::GetModelPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->model_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}






inline void PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsDataView::GetPerformanceInfoDataView(
    ::on_device_model::mojom::DevicePerformanceInfoDataView* output) {
  auto pointer = data_->performance_info.Get();
  *output = ::on_device_model::mojom::DevicePerformanceInfoDataView(pointer, message_);
}
inline void PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsDataView::GetDeviceInfoDataView(
    ::on_device_model::mojom::DeviceInfoDataView* output) {
  auto pointer = data_->device_info.Get();
  *output = ::on_device_model::mojom::DeviceInfoDataView(pointer, message_);
}




inline void PageHandler_GetDefaultModelPath_ResponseParamsDataView::GetModelPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->model_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}




inline void PageHandler_GetPageData_ResponseParamsDataView::GetPageDataDataView(
    PageDataDataView* output) {
  auto pointer = data_->page_data.Get();
  *output = PageDataDataView(pointer, message_);
}




inline void PageHandler_DecodeBitmap_ParamsDataView::GetImageBufferDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->image_buffer;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void PageHandler_DecodeBitmap_ResponseParamsDataView::GetBitmapDataView(
    ::skia::mojom::BitmapMappedFromTrustedProcessDataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::skia::mojom::BitmapMappedFromTrustedProcessDataView(pointer, message_);
}




inline void Page_OnLogMessageAdded_ParamsDataView::GetEventTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->event_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void Page_OnLogMessageAdded_ParamsDataView::GetSourceFileDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source_file.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void Page_OnLogMessageAdded_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // on_device_internals::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_PARAMS_DATA_H_