// chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-shared.h"
#include "services/on_device_model/public/mojom/on_device_model_service.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"


namespace on_device_internals::mojom {
class PageDataDataView;

class BaseModelStateDataView;

class BaseModelInfoDataView;

class SupplementaryModelInfoDataView;

class FeatureAdaptationInfoDataView;



}  // on_device_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::on_device_internals::mojom::PageDataDataView> {
  using Data = ::on_device_internals::mojom::internal::PageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_internals::mojom::BaseModelStateDataView> {
  using Data = ::on_device_internals::mojom::internal::BaseModelState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_internals::mojom::BaseModelInfoDataView> {
  using Data = ::on_device_internals::mojom::internal::BaseModelInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_internals::mojom::SupplementaryModelInfoDataView> {
  using Data = ::on_device_internals::mojom::internal::SupplementaryModelInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_internals::mojom::FeatureAdaptationInfoDataView> {
  using Data = ::on_device_internals::mojom::internal::FeatureAdaptationInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace on_device_internals::mojom {
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class PageDataDataView {
 public:
  PageDataDataView() = default;

  PageDataDataView(
      internal::PageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBaseModelDataView(
      BaseModelStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseModel(UserType* output) {
    
    auto* pointer = data_->base_model.Get();
    return mojo::internal::Deserialize<::on_device_internals::mojom::BaseModelStateDataView>(
        pointer, output, message_);
  }
  inline void GetSuppModelsDataView(
      mojo::ArrayDataView<SupplementaryModelInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuppModels(UserType* output) {
    
    auto* pointer = data_->supp_models.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::on_device_internals::mojom::SupplementaryModelInfoDataView>>(
        pointer, output, message_);
  }
  int32_t model_crash_count() const {
    return data_->model_crash_count;
  }
  int32_t max_model_crash_count() const {
    return data_->max_model_crash_count;
  }
  inline void GetFeatureAdaptationsDataView(
      mojo::ArrayDataView<FeatureAdaptationInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatureAdaptations(UserType* output) {
    
    auto* pointer = data_->feature_adaptations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::on_device_internals::mojom::FeatureAdaptationInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetPerformanceInfoDataView(
      ::on_device_model::mojom::DevicePerformanceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerformanceInfo(UserType* output) {
    
    auto* pointer = data_->performance_info.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::DevicePerformanceInfoDataView>(
        pointer, output, message_);
  }
  uint64_t min_vram_mb() const {
    return data_->min_vram_mb;
  }
 private:
  internal::PageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BaseModelStateDataView {
 public:
  BaseModelStateDataView() = default;

  BaseModelStateDataView(
      internal::BaseModelState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) {
    
    auto* pointer = data_->state.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRegistrationCriteriaDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistrationCriteria(UserType* output) {
    
    auto* pointer = data_->registration_criteria.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetInfoDataView(
      BaseModelInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::on_device_internals::mojom::BaseModelInfoDataView, UserType>(),
    "Attempting to read the optional `info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInfo` instead "
    "of `ReadInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::on_device_internals::mojom::BaseModelInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::BaseModelState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BaseModelInfoDataView {
 public:
  BaseModelInfoDataView() = default;

  BaseModelInfoDataView(
      internal::BaseModelInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetComponentVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComponentVersion(UserType* output) {
    
    auto* pointer = data_->component_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFilePathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t file_size() const {
    return data_->file_size;
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersion(UserType* output) {
    
    auto* pointer = data_->version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBackendTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackendType(UserType* output) {
    
    auto* pointer = data_->backend_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BaseModelInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SupplementaryModelInfoDataView {
 public:
  SupplementaryModelInfoDataView() = default;

  SupplementaryModelInfoDataView(
      internal::SupplementaryModelInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSuppModelNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuppModelName(UserType* output) {
    
    auto* pointer = data_->supp_model_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_ready() const {
    return data_->is_ready;
  }
 private:
  internal::SupplementaryModelInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FeatureAdaptationInfoDataView {
 public:
  FeatureAdaptationInfoDataView() = default;

  FeatureAdaptationInfoDataView(
      internal::FeatureAdaptationInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFeatureNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatureName(UserType* output) {
    
    auto* pointer = data_->feature_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t feature_key() const {
    return data_->feature_key;
  }
  int64_t version() const {
    return data_->version;
  }
  bool is_recently_used() const {
    return data_->is_recently_used;
  }
 private:
  internal::FeatureAdaptationInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // on_device_internals::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_DATA_VIEW_H_