// chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_OMNIBOX_POPUP_MOJOM_OMNIBOX_POPUP_AIM_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_OMNIBOX_POPUP_MOJOM_OMNIBOX_POPUP_AIM_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom-forward.h"  // IWYU pragma: export
#include "components/omnibox/browser/searchbox.mojom-forward.h"
#include "mojo/public/mojom/base/work_in_progress.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace omnibox_popup_aim::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "omnibox_popup_aim.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "omnibox_popup_aim.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestCloseMinVersion = 0,
    kNavigateCurrentTabMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestClose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NavigateCurrentTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void RequestClose() = 0;

  virtual void NavigateCurrentTab(const ::GURL& url) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;
class PageResponseValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "omnibox_popup_aim.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = PageResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnPopupShownMinVersion = 0,
    kAddContextMinVersion = 0,
    kOnPopupHiddenMinVersion = 0,
    kSetPreserveContextOnCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPopupShown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPopupHidden_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPreserveContextOnClose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnPopupShown(::searchbox::mojom::SearchContextPtr context) = 0;

  virtual void AddContext(::searchbox::mojom::SearchContextPtr context) = 0;

  using OnPopupHiddenCallback = base::OnceCallback<void(const std::string&)>;
  using OnPopupHiddenMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void OnPopupHidden(OnPopupHiddenCallback callback) = 0;

  virtual void SetPreserveContextOnClose(bool preserve_context_on_close) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestClose() final;
  
  void NavigateCurrentTab(const ::GURL& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPopupShown(::searchbox::mojom::SearchContextPtr context) final;
  
  void AddContext(::searchbox::mojom::SearchContextPtr context) final;
  
  void OnPopupHidden(OnPopupHiddenCallback callback) final;
  
  void SetPreserveContextOnClose(bool preserve_context_on_close) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // omnibox_popup_aim::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_OMNIBOX_POPUP_MOJOM_OMNIBOX_POPUP_AIM_MOJOM_H_