// chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom-params-data.h"
#include "chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom-import-headers.h"
#include "chrome/browser/ui/webui/omnibox_popup/mojom/omnibox_popup_aim.mojom-test-utils.h"


namespace omnibox_popup_aim::mojom {
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive omnibox_popup_aim::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply omnibox_popup_aim::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13595e19;  // IPCStableHash for omnibox_popup_aim::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send omnibox_popup_aim::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::omnibox_popup_aim::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::omnibox_popup_aim::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::omnibox_popup_aim::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::omnibox_popup_aim::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kRequestClose: {
      return &PageHandler::RequestClose_Sym::IPCStableHash;
    }
    case messages::PageHandler::kNavigateCurrentTab: {
      return &PageHandler::NavigateCurrentTab_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kRequestClose:
            return "Receive omnibox_popup_aim::mojom::PageHandler::RequestClose";
      case messages::PageHandler::kNavigateCurrentTab:
            return "Receive omnibox_popup_aim::mojom::PageHandler::NavigateCurrentTab";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kRequestClose:
            return "Receive reply omnibox_popup_aim::mojom::PageHandler::RequestClose";
      case messages::PageHandler::kNavigateCurrentTab:
            return "Receive reply omnibox_popup_aim::mojom::PageHandler::NavigateCurrentTab";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::RequestClose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c4818c4;  // IPCStableHash for omnibox_popup_aim::mojom::PageHandler::RequestClose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::NavigateCurrentTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6fb9146b;  // IPCStableHash for omnibox_popup_aim::mojom::PageHandler::NavigateCurrentTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::RequestClose(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send omnibox_popup_aim::mojom::PageHandler::RequestClose");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRequestClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::omnibox_popup_aim::mojom::internal::PageHandler_RequestClose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RequestClose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::NavigateCurrentTab(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send omnibox_popup_aim::mojom::PageHandler::NavigateCurrentTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kNavigateCurrentTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::omnibox_popup_aim::mojom::internal::PageHandler_NavigateCurrentTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.NavigateCurrentTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("NavigateCurrentTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kRequestClose: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RequestClose_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RequestClose_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_RequestClose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestClose(        );
      return true;
    }
    case messages::PageHandler::kNavigateCurrentTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_NavigateCurrentTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_NavigateCurrentTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      ::GURL p_url{};
      PageHandler_NavigateCurrentTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NavigateCurrentTab(        
        std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kRequestClose: {
      break;
    }
    case messages::PageHandler::kNavigateCurrentTab: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_RequestClose_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_NavigateCurrentTab_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::omnibox_popup_aim::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnPopupShown: {
      return &Page::OnPopupShown_Sym::IPCStableHash;
    }
    case messages::Page::kAddContext: {
      return &Page::AddContext_Sym::IPCStableHash;
    }
    case messages::Page::kOnPopupHidden: {
      return &Page::OnPopupHidden_Sym::IPCStableHash;
    }
    case messages::Page::kSetPreserveContextOnClose: {
      return &Page::SetPreserveContextOnClose_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnPopupShown:
            return "Receive omnibox_popup_aim::mojom::Page::OnPopupShown";
      case messages::Page::kAddContext:
            return "Receive omnibox_popup_aim::mojom::Page::AddContext";
      case messages::Page::kOnPopupHidden:
            return "Receive omnibox_popup_aim::mojom::Page::OnPopupHidden";
      case messages::Page::kSetPreserveContextOnClose:
            return "Receive omnibox_popup_aim::mojom::Page::SetPreserveContextOnClose";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnPopupShown:
            return "Receive reply omnibox_popup_aim::mojom::Page::OnPopupShown";
      case messages::Page::kAddContext:
            return "Receive reply omnibox_popup_aim::mojom::Page::AddContext";
      case messages::Page::kOnPopupHidden:
            return "Receive reply omnibox_popup_aim::mojom::Page::OnPopupHidden";
      case messages::Page::kSetPreserveContextOnClose:
            return "Receive reply omnibox_popup_aim::mojom::Page::SetPreserveContextOnClose";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnPopupShown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e0c82a6;  // IPCStableHash for omnibox_popup_aim::mojom::Page::OnPopupShown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::AddContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d1af36a;  // IPCStableHash for omnibox_popup_aim::mojom::Page::AddContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnPopupHidden_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95bd3e0d;  // IPCStableHash for omnibox_popup_aim::mojom::Page::OnPopupHidden
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetPreserveContextOnClose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e77c432;  // IPCStableHash for omnibox_popup_aim::mojom::Page::SetPreserveContextOnClose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Page_OnPopupHidden_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Page_OnPopupHidden_ForwardToCallback(
      Page::OnPopupHiddenCallback callback
      ) : callback_(std::move(callback)) {
  }

  Page_OnPopupHidden_ForwardToCallback(const Page_OnPopupHidden_ForwardToCallback&) = delete;
  Page_OnPopupHidden_ForwardToCallback& operator=(const Page_OnPopupHidden_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Page::OnPopupHiddenCallback callback_;
};

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnPopupShown(
    ::searchbox::mojom::SearchContextPtr in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send omnibox_popup_aim::mojom::Page::OnPopupShown", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::searchbox::mojom::SearchContextPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnPopupShown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::omnibox_popup_aim::mojom::internal::Page_OnPopupShown_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context)::BaseType> context_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::SearchContextDataView>(
    in_context,
    context_fragment);

  params->context.Set(
      context_fragment.is_null() ? nullptr : context_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->context.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null context in Page.OnPopupShown request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnPopupShown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::AddContext(
    ::searchbox::mojom::SearchContextPtr in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send omnibox_popup_aim::mojom::Page::AddContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::searchbox::mojom::SearchContextPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kAddContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::omnibox_popup_aim::mojom::internal::Page_AddContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context)::BaseType> context_fragment(
          params.message());
  
  mojo::internal::Serialize<::searchbox::mojom::SearchContextDataView>(
    in_context,
    context_fragment);

  params->context.Set(
      context_fragment.is_null() ? nullptr : context_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->context.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null context in Page.AddContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("AddContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnPopupHidden(
    OnPopupHiddenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send omnibox_popup_aim::mojom::Page::OnPopupHidden");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnPopupHidden), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::omnibox_popup_aim::mojom::internal::Page_OnPopupHidden_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnPopupHidden");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Page_OnPopupHidden_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageProxy::SetPreserveContextOnClose(
    bool in_preserve_context_on_close) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send omnibox_popup_aim::mojom::Page::SetPreserveContextOnClose", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preserve_context_on_close"), in_preserve_context_on_close,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetPreserveContextOnClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::omnibox_popup_aim::mojom::internal::Page_SetPreserveContextOnClose_Params_Data> params(
          message);
  params.Allocate();

  params->preserve_context_on_close = in_preserve_context_on_close;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetPreserveContextOnClose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Page_OnPopupHidden_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Page::OnPopupHiddenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Page_OnPopupHidden_ProxyToResponder> proxy(
        new Page_OnPopupHidden_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Page_OnPopupHidden_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Page_OnPopupHidden_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Page_OnPopupHidden_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Page::OnPopupHiddenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_input);
};

bool Page_OnPopupHidden_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Page_OnPopupHidden_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Page_OnPopupHidden_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Page.2
  bool success = true;
  std::string p_input{};
  Page_OnPopupHidden_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInput(&p_input))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Page::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_input));
  }
  return true;
}

void Page_OnPopupHidden_ProxyToResponder::Run(
    const std::string& in_input) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply omnibox_popup_aim::mojom::Page::OnPopupHidden", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnPopupHidden), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::omnibox_popup_aim::mojom::internal::Page_OnPopupHidden_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnPopupHidden");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnPopupShown: {
      DCHECK(message->is_serialized());
      internal::Page_OnPopupShown_Params_Data* params =
          reinterpret_cast<internal::Page_OnPopupShown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ::searchbox::mojom::SearchContextPtr p_context{};
      Page_OnPopupShown_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContext(&p_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPopupShown(        
        std::move(p_context));
      return true;
    }
    case messages::Page::kAddContext: {
      DCHECK(message->is_serialized());
      internal::Page_AddContext_Params_Data* params =
          reinterpret_cast<internal::Page_AddContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      ::searchbox::mojom::SearchContextPtr p_context{};
      Page_AddContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContext(&p_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddContext(        
        std::move(p_context));
      return true;
    }
    case messages::Page::kOnPopupHidden: {
      break;
    }
    case messages::Page::kSetPreserveContextOnClose: {
      DCHECK(message->is_serialized());
      internal::Page_SetPreserveContextOnClose_Params_Data* params =
          reinterpret_cast<internal::Page_SetPreserveContextOnClose_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      bool p_preserve_context_on_close{};
      Page_SetPreserveContextOnClose_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_preserve_context_on_close = input_data_view.preserve_context_on_close();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPreserveContextOnClose(        
        std::move(p_preserve_context_on_close));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnPopupShown: {
      break;
    }
    case messages::Page::kAddContext: {
      break;
    }
    case messages::Page::kOnPopupHidden: {
      internal::Page_OnPopupHidden_Params_Data* params =
          reinterpret_cast<
              internal::Page_OnPopupHidden_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      Page_OnPopupHidden_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      auto callback =
          Page_OnPopupHidden_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPopupHidden(std::move(callback));
      return true;
    }
    case messages::Page::kSetPreserveContextOnClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnPopupShown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_AddContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnPopupHidden_Params_Data::Validate,
     &internal::Page_OnPopupHidden_ResponseParams_Data::Validate},
    { &internal::Page_SetPreserveContextOnClose_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::omnibox_popup_aim::mojom::Page::Name_,
    kPageValidationInfo);
}

bool PageResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::omnibox_popup_aim::mojom::Page::Name_,
    kPageValidationInfo);
}


}  // omnibox_popup_aim::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace omnibox_popup_aim::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::RequestClose() {
  GetForwardingInterface()->RequestClose();
}
void PageHandlerInterceptorForTesting::NavigateCurrentTab(const ::GURL& url) {
  GetForwardingInterface()->NavigateCurrentTab(
    std::move(url)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;





void PageInterceptorForTesting::OnPopupShown(::searchbox::mojom::SearchContextPtr context) {
  GetForwardingInterface()->OnPopupShown(
    std::move(context)
    );
}
void PageInterceptorForTesting::AddContext(::searchbox::mojom::SearchContextPtr context) {
  GetForwardingInterface()->AddContext(
    std::move(context)
    );
}
void PageInterceptorForTesting::OnPopupHidden(OnPopupHiddenCallback callback) {
  GetForwardingInterface()->OnPopupHidden(std::move(callback));
}
void PageInterceptorForTesting::SetPreserveContextOnClose(bool preserve_context_on_close) {
  GetForwardingInterface()->SetPreserveContextOnClose(
    std::move(preserve_context_on_close)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;


void PageAsyncWaiter::OnPopupHidden(
    std::string* out_input) {
  base::RunLoop loop;
  proxy_->OnPopupHidden(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_input
,
             const std::string& input) {*out_input = std::move(input);
            loop->Quit();
          },
          &loop,
          out_input));
  loop.Run();
}

std::string PageAsyncWaiter::OnPopupHidden(
    ) {
  std::string async_wait_result;
  OnPopupHidden(&async_wait_result);
  return async_wait_result;
}






}  // omnibox_popup_aim::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif