// chrome/browser/ui/webui/omnibox/omnibox_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/browser/ui/webui/omnibox/omnibox_mojom_traits.h"




namespace mojom {

class OmniboxPageHandlerProxy;

template <typename ImplRefTraits>
class OmniboxPageHandlerStub;

class OmniboxPageHandlerRequestValidator;
class OmniboxPageHandlerResponseValidator;


class OmniboxPageHandler
    : public OmniboxPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mojom.OmniboxPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OmniboxPageHandlerInterfaceBase;
  using Proxy_ = OmniboxPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = OmniboxPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = OmniboxPageHandlerRequestValidator;
  using ResponseValidator_ = OmniboxPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientPageMinVersion = 0,
    kStartOmniboxQueryMinVersion = 0,
    kGetMlModelVersionMinVersion = 0,
    kStartMlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClientPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartOmniboxQuery_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMlModelVersion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartMl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OmniboxPageHandler() = default;

  virtual void SetClientPage(::mojo::PendingRemote<OmniboxPage> page) = 0;

  virtual void StartOmniboxQuery(const std::string& input_string, bool reset_autocomplete_controller, int32_t cursor_position, bool zero_suggest, bool prevent_inline_autocomplete, bool prefer_keyword, const std::string& current_url, int32_t page_classification) = 0;

  using GetMlModelVersionCallback = base::OnceCallback<void(int32_t)>;
  using GetMlModelVersionMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void GetMlModelVersion(GetMlModelVersionCallback callback) = 0;

  using StartMlCallback = base::OnceCallback<void(float)>;
  using StartMlMojoCallback = base::OnceCallback<void(float)>;

  virtual void StartMl(const ::AutocompleteMatch::ScoringSignals& signals, StartMlCallback callback) = 0;
};

class OmniboxPageProxy;

template <typename ImplRefTraits>
class OmniboxPageStub;

class OmniboxPageRequestValidator;


class OmniboxPage
    : public OmniboxPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mojom.OmniboxPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OmniboxPageInterfaceBase;
  using Proxy_ = OmniboxPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = OmniboxPageStub<ImplRefTraits>;

  using RequestValidator_ = OmniboxPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kHandleNewAutocompleteQueryMinVersion = 0,
    kHandleNewAutocompleteResponseMinVersion = 0,
    kHandleNewMlResponseMinVersion = 0,
    kHandleAnswerIconImageDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct HandleNewAutocompleteQuery_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleNewAutocompleteResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleNewMlResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleAnswerIconImageData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OmniboxPage() = default;

  virtual void HandleNewAutocompleteQuery(AutocompleteControllerType autocomplete_controller_type, const std::string& input_text) = 0;

  virtual void HandleNewAutocompleteResponse(AutocompleteControllerType autocomplete_controller_type, OmniboxResponsePtr response) = 0;

  virtual void HandleNewMlResponse(AutocompleteControllerType autocomplete_controller_type, const std::string& input_text, const std::vector<::AutocompleteMatchWrapper>& matches) = 0;

  virtual void HandleAnswerIconImageData(AutocompleteControllerType autocomplete_controller_type, const ::GURL& image_url, const std::string& image_data) = 0;
};



class  OmniboxPageHandlerProxy
    : public OmniboxPageHandler {
 public:
  using InterfaceType = OmniboxPageHandler;

  explicit OmniboxPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClientPage(::mojo::PendingRemote<OmniboxPage> page) final;
  
  void StartOmniboxQuery(const std::string& input_string, bool reset_autocomplete_controller, int32_t cursor_position, bool zero_suggest, bool prevent_inline_autocomplete, bool prefer_keyword, const std::string& current_url, int32_t page_classification) final;
  
  void GetMlModelVersion(GetMlModelVersionCallback callback) final;
  
  void StartMl(const ::AutocompleteMatch::ScoringSignals& signals, StartMlCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  OmniboxPageProxy
    : public OmniboxPage {
 public:
  using InterfaceType = OmniboxPage;

  explicit OmniboxPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HandleNewAutocompleteQuery(AutocompleteControllerType autocomplete_controller_type, const std::string& input_text) final;
  
  void HandleNewAutocompleteResponse(AutocompleteControllerType autocomplete_controller_type, OmniboxResponsePtr response) final;
  
  void HandleNewMlResponse(AutocompleteControllerType autocomplete_controller_type, const std::string& input_text, const std::vector<::AutocompleteMatchWrapper>& matches) final;
  
  void HandleAnswerIconImageData(AutocompleteControllerType autocomplete_controller_type, const ::GURL& image_url, const std::string& image_data) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  OmniboxPageHandlerStubDispatch {
 public:
  static bool Accept(OmniboxPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OmniboxPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OmniboxPageHandler>>
class OmniboxPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OmniboxPageHandlerStub() = default;
  ~OmniboxPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OmniboxPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OmniboxPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OmniboxPageStubDispatch {
 public:
  static bool Accept(OmniboxPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OmniboxPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OmniboxPage>>
class OmniboxPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OmniboxPageStub() = default;
  ~OmniboxPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OmniboxPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OmniboxPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OmniboxPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OmniboxPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OmniboxPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ACMatchClassification {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ACMatchClassification, T>::value>;
  using DataView = ACMatchClassificationDataView;
  using Data_ = internal::ACMatchClassification_Data;

  template <typename... Args>
  static ACMatchClassificationPtr New(Args&&... args) {
    return ACMatchClassificationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ACMatchClassificationPtr From(const U& u) {
    return mojo::TypeConverter<ACMatchClassificationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ACMatchClassification>::Convert(*this);
  }


  ACMatchClassification();

  ACMatchClassification(
      int32_t offset,
      int32_t style);


  ~ACMatchClassification();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ACMatchClassificationPtr>
  ACMatchClassificationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ACMatchClassification::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ACMatchClassification::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ACMatchClassification::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ACMatchClassification_UnserializedMessageContext<
            UserType, ACMatchClassification::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ACMatchClassification::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ACMatchClassification::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ACMatchClassification_UnserializedMessageContext<
            UserType, ACMatchClassification::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ACMatchClassification::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t offset;
  
  int32_t style;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ACMatchClassification::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class  Signals {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Signals, T>::value>;
  using DataView = SignalsDataView;
  using Data_ = internal::Signals_Data;

  template <typename... Args>
  static SignalsPtr New(Args&&... args) {
    return SignalsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignalsPtr From(const U& u) {
    return mojo::TypeConverter<SignalsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Signals>::Convert(*this);
  }


  Signals();

  Signals(
      std::optional<int32_t> typed_count,
      std::optional<int32_t> visit_count,
      std::optional<int64_t> elapsed_time_last_visit_secs,
      std::optional<int32_t> shortcut_visit_count,
      std::optional<int32_t> shortest_shortcut_len,
      std::optional<int64_t> elapsed_time_last_shortcut_visit_sec,
      std::optional<bool> is_host_only,
      std::optional<int32_t> num_bookmarks_of_url,
      std::optional<int32_t> first_bookmark_title_match_position,
      std::optional<int32_t> total_bookmark_title_match_length,
      std::optional<int32_t> num_input_terms_matched_by_bookmark_title,
      std::optional<int32_t> first_url_match_position,
      std::optional<int32_t> total_url_match_length,
      std::optional<bool> host_match_at_word_boundary,
      std::optional<int32_t> total_host_match_length,
      std::optional<int32_t> total_path_match_length,
      std::optional<int32_t> total_query_or_ref_match_length,
      std::optional<int32_t> total_title_match_length,
      std::optional<bool> has_non_scheme_www_match,
      std::optional<int32_t> num_input_terms_matched_by_title,
      std::optional<int32_t> num_input_terms_matched_by_url,
      std::optional<int32_t> length_of_url,
      std::optional<float> site_engagement,
      std::optional<bool> allowed_to_be_default_match,
      std::optional<int32_t> search_suggest_relevance,
      std::optional<bool> is_search_suggest_entity,
      std::optional<bool> is_verbatim,
      std::optional<bool> is_navsuggest,
      std::optional<bool> is_search_suggest_tail,
      std::optional<bool> is_answer_suggest,
      std::optional<bool> is_calculator_suggest);


  ~Signals();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignalsPtr>
  SignalsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Signals::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Signals::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Signals::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Signals::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Signals::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Signals::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Signals_UnserializedMessageContext<
            UserType, Signals::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Signals::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Signals::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Signals_UnserializedMessageContext<
            UserType, Signals::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Signals::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<int32_t> typed_count;
  
  std::optional<int32_t> visit_count;
  
  std::optional<int64_t> elapsed_time_last_visit_secs;
  
  std::optional<int32_t> shortcut_visit_count;
  
  std::optional<int32_t> shortest_shortcut_len;
  
  std::optional<int64_t> elapsed_time_last_shortcut_visit_sec;
  
  std::optional<bool> is_host_only;
  
  std::optional<int32_t> num_bookmarks_of_url;
  
  std::optional<int32_t> first_bookmark_title_match_position;
  
  std::optional<int32_t> total_bookmark_title_match_length;
  
  std::optional<int32_t> num_input_terms_matched_by_bookmark_title;
  
  std::optional<int32_t> first_url_match_position;
  
  std::optional<int32_t> total_url_match_length;
  
  std::optional<bool> host_match_at_word_boundary;
  
  std::optional<int32_t> total_host_match_length;
  
  std::optional<int32_t> total_path_match_length;
  
  std::optional<int32_t> total_query_or_ref_match_length;
  
  std::optional<int32_t> total_title_match_length;
  
  std::optional<bool> has_non_scheme_www_match;
  
  std::optional<int32_t> num_input_terms_matched_by_title;
  
  std::optional<int32_t> num_input_terms_matched_by_url;
  
  std::optional<int32_t> length_of_url;
  
  std::optional<float> site_engagement;
  
  std::optional<bool> allowed_to_be_default_match;
  
  std::optional<int32_t> search_suggest_relevance;
  
  std::optional<bool> is_search_suggest_entity;
  
  std::optional<bool> is_verbatim;
  
  std::optional<bool> is_navsuggest;
  
  std::optional<bool> is_search_suggest_tail;
  
  std::optional<bool> is_answer_suggest;
  
  std::optional<bool> is_calculator_suggest;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Signals::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Signals::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Signals::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Signals::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutocompleteMatch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutocompleteMatch, T>::value>;
  using DataView = AutocompleteMatchDataView;
  using Data_ = internal::AutocompleteMatch_Data;

  template <typename... Args>
  static AutocompleteMatchPtr New(Args&&... args) {
    return AutocompleteMatchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutocompleteMatchPtr From(const U& u) {
    return mojo::TypeConverter<AutocompleteMatchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutocompleteMatch>::Convert(*this);
  }


  AutocompleteMatch();

  AutocompleteMatch(
      const std::string& provider_name,
      bool provider_done,
      int32_t relevance,
      bool deletable,
      const std::string& fill_into_edit,
      const std::string& inline_autocompletion,
      const ::GURL& destination_url,
      const ::GURL& stripped_destination_url,
      const ::GURL& icon,
      const ::GURL& image,
      const std::string& contents,
      std::vector<::AutocompleteMatch::ACMatchClassification> contents_class,
      const std::string& description,
      std::vector<::AutocompleteMatch::ACMatchClassification> description_class,
      bool swap_contents_and_description,
      const std::string& answer,
      const std::string& transition,
      bool allowed_to_be_default_match,
      const std::string& type,
      bool is_search_type,
      const std::string& aqs_type_subtypes,
      bool has_tab_match,
      const std::string& associated_keyword,
      const std::string& keyword,
      bool starred,
      int32_t duplicates,
      bool from_previous,
      int32_t pedal_id,
      const ::AutocompleteMatch::ScoringSignals& scoring_signals,
      const base::flat_map<std::string, std::string>& additional_info);


  ~AutocompleteMatch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutocompleteMatchPtr>
  AutocompleteMatchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteMatch::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteMatch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutocompleteMatch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutocompleteMatch_UnserializedMessageContext<
            UserType, AutocompleteMatch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutocompleteMatch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutocompleteMatch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutocompleteMatch_UnserializedMessageContext<
            UserType, AutocompleteMatch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutocompleteMatch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string provider_name;
  
  bool provider_done;
  
  int32_t relevance;
  
  bool deletable;
  
  std::string fill_into_edit;
  
  std::string inline_autocompletion;
  
  ::GURL destination_url;
  
  ::GURL stripped_destination_url;
  
  ::GURL icon;
  
  ::GURL image;
  
  std::string contents;
  
  std::vector<::AutocompleteMatch::ACMatchClassification> contents_class;
  
  std::string description;
  
  std::vector<::AutocompleteMatch::ACMatchClassification> description_class;
  
  bool swap_contents_and_description;
  
  std::string answer;
  
  std::string transition;
  
  bool allowed_to_be_default_match;
  
  std::string type;
  
  bool is_search_type;
  
  std::string aqs_type_subtypes;
  
  bool has_tab_match;
  
  std::string associated_keyword;
  
  std::string keyword;
  
  bool starred;
  
  int32_t duplicates;
  
  bool from_previous;
  
  int32_t pedal_id;
  
  ::AutocompleteMatch::ScoringSignals scoring_signals;
  
  base::flat_map<std::string, std::string> additional_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutocompleteMatch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutocompleteResultsForProvider {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutocompleteResultsForProvider, T>::value>;
  using DataView = AutocompleteResultsForProviderDataView;
  using Data_ = internal::AutocompleteResultsForProvider_Data;

  template <typename... Args>
  static AutocompleteResultsForProviderPtr New(Args&&... args) {
    return AutocompleteResultsForProviderPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutocompleteResultsForProviderPtr From(const U& u) {
    return mojo::TypeConverter<AutocompleteResultsForProviderPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutocompleteResultsForProvider>::Convert(*this);
  }


  AutocompleteResultsForProvider();

  AutocompleteResultsForProvider(
      const std::string& provider_name,
      std::vector<::AutocompleteMatchWrapper> results);


  ~AutocompleteResultsForProvider();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutocompleteResultsForProviderPtr>
  AutocompleteResultsForProviderPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteResultsForProvider::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteResultsForProvider::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutocompleteResultsForProvider::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutocompleteResultsForProvider_UnserializedMessageContext<
            UserType, AutocompleteResultsForProvider::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutocompleteResultsForProvider::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutocompleteResultsForProvider::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutocompleteResultsForProvider_UnserializedMessageContext<
            UserType, AutocompleteResultsForProvider::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutocompleteResultsForProvider::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string provider_name;
  
  std::vector<::AutocompleteMatchWrapper> results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  OmniboxResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OmniboxResponse, T>::value>;
  using DataView = OmniboxResponseDataView;
  using Data_ = internal::OmniboxResponse_Data;

  template <typename... Args>
  static OmniboxResponsePtr New(Args&&... args) {
    return OmniboxResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OmniboxResponsePtr From(const U& u) {
    return mojo::TypeConverter<OmniboxResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OmniboxResponse>::Convert(*this);
  }


  OmniboxResponse();

  OmniboxResponse(
      int32_t cursor_position,
      int32_t time_since_omnibox_started_ms,
      bool done,
      const std::string& type,
      const std::string& host,
      bool is_typed_host,
      const std::string& input_text,
      std::vector<::AutocompleteMatchWrapper> combined_results,
      std::vector<AutocompleteResultsForProviderPtr> results_by_provider);

OmniboxResponse(const OmniboxResponse&) = delete;
OmniboxResponse& operator=(const OmniboxResponse&) = delete;

  ~OmniboxResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OmniboxResponsePtr>
  OmniboxResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OmniboxResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OmniboxResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OmniboxResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OmniboxResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OmniboxResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OmniboxResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OmniboxResponse_UnserializedMessageContext<
            UserType, OmniboxResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OmniboxResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OmniboxResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OmniboxResponse_UnserializedMessageContext<
            UserType, OmniboxResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OmniboxResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t cursor_position;
  
  int32_t time_since_omnibox_started_ms;
  
  bool done;
  
  std::string type;
  
  std::string host;
  
  bool is_typed_host;
  
  std::string input_text;
  
  std::vector<::AutocompleteMatchWrapper> combined_results;
  
  std::vector<AutocompleteResultsForProviderPtr> results_by_provider;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OmniboxResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OmniboxResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OmniboxResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OmniboxResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ACMatchClassificationPtr ACMatchClassification::Clone() const {
  return New(
      mojo::Clone(offset),
      mojo::Clone(style)
  );
}

template <typename T, ACMatchClassification::EnableIfSame<T>*>
bool ACMatchClassification::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->style, other_struct.style))
    return false;
  return true;
}

template <typename T, ACMatchClassification::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.style < rhs.style)
    return true;
  if (rhs.style < lhs.style)
    return false;
  return false;
}
template <typename StructPtrType>
SignalsPtr Signals::Clone() const {
  return New(
      mojo::Clone(typed_count),
      mojo::Clone(visit_count),
      mojo::Clone(elapsed_time_last_visit_secs),
      mojo::Clone(shortcut_visit_count),
      mojo::Clone(shortest_shortcut_len),
      mojo::Clone(elapsed_time_last_shortcut_visit_sec),
      mojo::Clone(is_host_only),
      mojo::Clone(num_bookmarks_of_url),
      mojo::Clone(first_bookmark_title_match_position),
      mojo::Clone(total_bookmark_title_match_length),
      mojo::Clone(num_input_terms_matched_by_bookmark_title),
      mojo::Clone(first_url_match_position),
      mojo::Clone(total_url_match_length),
      mojo::Clone(host_match_at_word_boundary),
      mojo::Clone(total_host_match_length),
      mojo::Clone(total_path_match_length),
      mojo::Clone(total_query_or_ref_match_length),
      mojo::Clone(total_title_match_length),
      mojo::Clone(has_non_scheme_www_match),
      mojo::Clone(num_input_terms_matched_by_title),
      mojo::Clone(num_input_terms_matched_by_url),
      mojo::Clone(length_of_url),
      mojo::Clone(site_engagement),
      mojo::Clone(allowed_to_be_default_match),
      mojo::Clone(search_suggest_relevance),
      mojo::Clone(is_search_suggest_entity),
      mojo::Clone(is_verbatim),
      mojo::Clone(is_navsuggest),
      mojo::Clone(is_search_suggest_tail),
      mojo::Clone(is_answer_suggest),
      mojo::Clone(is_calculator_suggest)
  );
}

template <typename T, Signals::EnableIfSame<T>*>
bool Signals::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->typed_count, other_struct.typed_count))
    return false;
  if (!mojo::Equals(this->visit_count, other_struct.visit_count))
    return false;
  if (!mojo::Equals(this->elapsed_time_last_visit_secs, other_struct.elapsed_time_last_visit_secs))
    return false;
  if (!mojo::Equals(this->shortcut_visit_count, other_struct.shortcut_visit_count))
    return false;
  if (!mojo::Equals(this->shortest_shortcut_len, other_struct.shortest_shortcut_len))
    return false;
  if (!mojo::Equals(this->elapsed_time_last_shortcut_visit_sec, other_struct.elapsed_time_last_shortcut_visit_sec))
    return false;
  if (!mojo::Equals(this->is_host_only, other_struct.is_host_only))
    return false;
  if (!mojo::Equals(this->num_bookmarks_of_url, other_struct.num_bookmarks_of_url))
    return false;
  if (!mojo::Equals(this->first_bookmark_title_match_position, other_struct.first_bookmark_title_match_position))
    return false;
  if (!mojo::Equals(this->total_bookmark_title_match_length, other_struct.total_bookmark_title_match_length))
    return false;
  if (!mojo::Equals(this->num_input_terms_matched_by_bookmark_title, other_struct.num_input_terms_matched_by_bookmark_title))
    return false;
  if (!mojo::Equals(this->first_url_match_position, other_struct.first_url_match_position))
    return false;
  if (!mojo::Equals(this->total_url_match_length, other_struct.total_url_match_length))
    return false;
  if (!mojo::Equals(this->host_match_at_word_boundary, other_struct.host_match_at_word_boundary))
    return false;
  if (!mojo::Equals(this->total_host_match_length, other_struct.total_host_match_length))
    return false;
  if (!mojo::Equals(this->total_path_match_length, other_struct.total_path_match_length))
    return false;
  if (!mojo::Equals(this->total_query_or_ref_match_length, other_struct.total_query_or_ref_match_length))
    return false;
  if (!mojo::Equals(this->total_title_match_length, other_struct.total_title_match_length))
    return false;
  if (!mojo::Equals(this->has_non_scheme_www_match, other_struct.has_non_scheme_www_match))
    return false;
  if (!mojo::Equals(this->num_input_terms_matched_by_title, other_struct.num_input_terms_matched_by_title))
    return false;
  if (!mojo::Equals(this->num_input_terms_matched_by_url, other_struct.num_input_terms_matched_by_url))
    return false;
  if (!mojo::Equals(this->length_of_url, other_struct.length_of_url))
    return false;
  if (!mojo::Equals(this->site_engagement, other_struct.site_engagement))
    return false;
  if (!mojo::Equals(this->allowed_to_be_default_match, other_struct.allowed_to_be_default_match))
    return false;
  if (!mojo::Equals(this->search_suggest_relevance, other_struct.search_suggest_relevance))
    return false;
  if (!mojo::Equals(this->is_search_suggest_entity, other_struct.is_search_suggest_entity))
    return false;
  if (!mojo::Equals(this->is_verbatim, other_struct.is_verbatim))
    return false;
  if (!mojo::Equals(this->is_navsuggest, other_struct.is_navsuggest))
    return false;
  if (!mojo::Equals(this->is_search_suggest_tail, other_struct.is_search_suggest_tail))
    return false;
  if (!mojo::Equals(this->is_answer_suggest, other_struct.is_answer_suggest))
    return false;
  if (!mojo::Equals(this->is_calculator_suggest, other_struct.is_calculator_suggest))
    return false;
  return true;
}

template <typename T, Signals::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.typed_count < rhs.typed_count)
    return true;
  if (rhs.typed_count < lhs.typed_count)
    return false;
  if (lhs.visit_count < rhs.visit_count)
    return true;
  if (rhs.visit_count < lhs.visit_count)
    return false;
  if (lhs.elapsed_time_last_visit_secs < rhs.elapsed_time_last_visit_secs)
    return true;
  if (rhs.elapsed_time_last_visit_secs < lhs.elapsed_time_last_visit_secs)
    return false;
  if (lhs.shortcut_visit_count < rhs.shortcut_visit_count)
    return true;
  if (rhs.shortcut_visit_count < lhs.shortcut_visit_count)
    return false;
  if (lhs.shortest_shortcut_len < rhs.shortest_shortcut_len)
    return true;
  if (rhs.shortest_shortcut_len < lhs.shortest_shortcut_len)
    return false;
  if (lhs.elapsed_time_last_shortcut_visit_sec < rhs.elapsed_time_last_shortcut_visit_sec)
    return true;
  if (rhs.elapsed_time_last_shortcut_visit_sec < lhs.elapsed_time_last_shortcut_visit_sec)
    return false;
  if (lhs.is_host_only < rhs.is_host_only)
    return true;
  if (rhs.is_host_only < lhs.is_host_only)
    return false;
  if (lhs.num_bookmarks_of_url < rhs.num_bookmarks_of_url)
    return true;
  if (rhs.num_bookmarks_of_url < lhs.num_bookmarks_of_url)
    return false;
  if (lhs.first_bookmark_title_match_position < rhs.first_bookmark_title_match_position)
    return true;
  if (rhs.first_bookmark_title_match_position < lhs.first_bookmark_title_match_position)
    return false;
  if (lhs.total_bookmark_title_match_length < rhs.total_bookmark_title_match_length)
    return true;
  if (rhs.total_bookmark_title_match_length < lhs.total_bookmark_title_match_length)
    return false;
  if (lhs.num_input_terms_matched_by_bookmark_title < rhs.num_input_terms_matched_by_bookmark_title)
    return true;
  if (rhs.num_input_terms_matched_by_bookmark_title < lhs.num_input_terms_matched_by_bookmark_title)
    return false;
  if (lhs.first_url_match_position < rhs.first_url_match_position)
    return true;
  if (rhs.first_url_match_position < lhs.first_url_match_position)
    return false;
  if (lhs.total_url_match_length < rhs.total_url_match_length)
    return true;
  if (rhs.total_url_match_length < lhs.total_url_match_length)
    return false;
  if (lhs.host_match_at_word_boundary < rhs.host_match_at_word_boundary)
    return true;
  if (rhs.host_match_at_word_boundary < lhs.host_match_at_word_boundary)
    return false;
  if (lhs.total_host_match_length < rhs.total_host_match_length)
    return true;
  if (rhs.total_host_match_length < lhs.total_host_match_length)
    return false;
  if (lhs.total_path_match_length < rhs.total_path_match_length)
    return true;
  if (rhs.total_path_match_length < lhs.total_path_match_length)
    return false;
  if (lhs.total_query_or_ref_match_length < rhs.total_query_or_ref_match_length)
    return true;
  if (rhs.total_query_or_ref_match_length < lhs.total_query_or_ref_match_length)
    return false;
  if (lhs.total_title_match_length < rhs.total_title_match_length)
    return true;
  if (rhs.total_title_match_length < lhs.total_title_match_length)
    return false;
  if (lhs.has_non_scheme_www_match < rhs.has_non_scheme_www_match)
    return true;
  if (rhs.has_non_scheme_www_match < lhs.has_non_scheme_www_match)
    return false;
  if (lhs.num_input_terms_matched_by_title < rhs.num_input_terms_matched_by_title)
    return true;
  if (rhs.num_input_terms_matched_by_title < lhs.num_input_terms_matched_by_title)
    return false;
  if (lhs.num_input_terms_matched_by_url < rhs.num_input_terms_matched_by_url)
    return true;
  if (rhs.num_input_terms_matched_by_url < lhs.num_input_terms_matched_by_url)
    return false;
  if (lhs.length_of_url < rhs.length_of_url)
    return true;
  if (rhs.length_of_url < lhs.length_of_url)
    return false;
  if (lhs.site_engagement < rhs.site_engagement)
    return true;
  if (rhs.site_engagement < lhs.site_engagement)
    return false;
  if (lhs.allowed_to_be_default_match < rhs.allowed_to_be_default_match)
    return true;
  if (rhs.allowed_to_be_default_match < lhs.allowed_to_be_default_match)
    return false;
  if (lhs.search_suggest_relevance < rhs.search_suggest_relevance)
    return true;
  if (rhs.search_suggest_relevance < lhs.search_suggest_relevance)
    return false;
  if (lhs.is_search_suggest_entity < rhs.is_search_suggest_entity)
    return true;
  if (rhs.is_search_suggest_entity < lhs.is_search_suggest_entity)
    return false;
  if (lhs.is_verbatim < rhs.is_verbatim)
    return true;
  if (rhs.is_verbatim < lhs.is_verbatim)
    return false;
  if (lhs.is_navsuggest < rhs.is_navsuggest)
    return true;
  if (rhs.is_navsuggest < lhs.is_navsuggest)
    return false;
  if (lhs.is_search_suggest_tail < rhs.is_search_suggest_tail)
    return true;
  if (rhs.is_search_suggest_tail < lhs.is_search_suggest_tail)
    return false;
  if (lhs.is_answer_suggest < rhs.is_answer_suggest)
    return true;
  if (rhs.is_answer_suggest < lhs.is_answer_suggest)
    return false;
  if (lhs.is_calculator_suggest < rhs.is_calculator_suggest)
    return true;
  if (rhs.is_calculator_suggest < lhs.is_calculator_suggest)
    return false;
  return false;
}
template <typename StructPtrType>
AutocompleteMatchPtr AutocompleteMatch::Clone() const {
  return New(
      mojo::Clone(provider_name),
      mojo::Clone(provider_done),
      mojo::Clone(relevance),
      mojo::Clone(deletable),
      mojo::Clone(fill_into_edit),
      mojo::Clone(inline_autocompletion),
      mojo::Clone(destination_url),
      mojo::Clone(stripped_destination_url),
      mojo::Clone(icon),
      mojo::Clone(image),
      mojo::Clone(contents),
      mojo::Clone(contents_class),
      mojo::Clone(description),
      mojo::Clone(description_class),
      mojo::Clone(swap_contents_and_description),
      mojo::Clone(answer),
      mojo::Clone(transition),
      mojo::Clone(allowed_to_be_default_match),
      mojo::Clone(type),
      mojo::Clone(is_search_type),
      mojo::Clone(aqs_type_subtypes),
      mojo::Clone(has_tab_match),
      mojo::Clone(associated_keyword),
      mojo::Clone(keyword),
      mojo::Clone(starred),
      mojo::Clone(duplicates),
      mojo::Clone(from_previous),
      mojo::Clone(pedal_id),
      mojo::Clone(scoring_signals),
      mojo::Clone(additional_info)
  );
}

template <typename T, AutocompleteMatch::EnableIfSame<T>*>
bool AutocompleteMatch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provider_name, other_struct.provider_name))
    return false;
  if (!mojo::Equals(this->provider_done, other_struct.provider_done))
    return false;
  if (!mojo::Equals(this->relevance, other_struct.relevance))
    return false;
  if (!mojo::Equals(this->deletable, other_struct.deletable))
    return false;
  if (!mojo::Equals(this->fill_into_edit, other_struct.fill_into_edit))
    return false;
  if (!mojo::Equals(this->inline_autocompletion, other_struct.inline_autocompletion))
    return false;
  if (!mojo::Equals(this->destination_url, other_struct.destination_url))
    return false;
  if (!mojo::Equals(this->stripped_destination_url, other_struct.stripped_destination_url))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  if (!mojo::Equals(this->image, other_struct.image))
    return false;
  if (!mojo::Equals(this->contents, other_struct.contents))
    return false;
  if (!mojo::Equals(this->contents_class, other_struct.contents_class))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->description_class, other_struct.description_class))
    return false;
  if (!mojo::Equals(this->swap_contents_and_description, other_struct.swap_contents_and_description))
    return false;
  if (!mojo::Equals(this->answer, other_struct.answer))
    return false;
  if (!mojo::Equals(this->transition, other_struct.transition))
    return false;
  if (!mojo::Equals(this->allowed_to_be_default_match, other_struct.allowed_to_be_default_match))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->is_search_type, other_struct.is_search_type))
    return false;
  if (!mojo::Equals(this->aqs_type_subtypes, other_struct.aqs_type_subtypes))
    return false;
  if (!mojo::Equals(this->has_tab_match, other_struct.has_tab_match))
    return false;
  if (!mojo::Equals(this->associated_keyword, other_struct.associated_keyword))
    return false;
  if (!mojo::Equals(this->keyword, other_struct.keyword))
    return false;
  if (!mojo::Equals(this->starred, other_struct.starred))
    return false;
  if (!mojo::Equals(this->duplicates, other_struct.duplicates))
    return false;
  if (!mojo::Equals(this->from_previous, other_struct.from_previous))
    return false;
  if (!mojo::Equals(this->pedal_id, other_struct.pedal_id))
    return false;
  if (!mojo::Equals(this->scoring_signals, other_struct.scoring_signals))
    return false;
  if (!mojo::Equals(this->additional_info, other_struct.additional_info))
    return false;
  return true;
}

template <typename T, AutocompleteMatch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.provider_name < rhs.provider_name)
    return true;
  if (rhs.provider_name < lhs.provider_name)
    return false;
  if (lhs.provider_done < rhs.provider_done)
    return true;
  if (rhs.provider_done < lhs.provider_done)
    return false;
  if (lhs.relevance < rhs.relevance)
    return true;
  if (rhs.relevance < lhs.relevance)
    return false;
  if (lhs.deletable < rhs.deletable)
    return true;
  if (rhs.deletable < lhs.deletable)
    return false;
  if (lhs.fill_into_edit < rhs.fill_into_edit)
    return true;
  if (rhs.fill_into_edit < lhs.fill_into_edit)
    return false;
  if (lhs.inline_autocompletion < rhs.inline_autocompletion)
    return true;
  if (rhs.inline_autocompletion < lhs.inline_autocompletion)
    return false;
  if (lhs.destination_url < rhs.destination_url)
    return true;
  if (rhs.destination_url < lhs.destination_url)
    return false;
  if (lhs.stripped_destination_url < rhs.stripped_destination_url)
    return true;
  if (rhs.stripped_destination_url < lhs.stripped_destination_url)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  if (lhs.image < rhs.image)
    return true;
  if (rhs.image < lhs.image)
    return false;
  if (lhs.contents < rhs.contents)
    return true;
  if (rhs.contents < lhs.contents)
    return false;
  if (lhs.contents_class < rhs.contents_class)
    return true;
  if (rhs.contents_class < lhs.contents_class)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.description_class < rhs.description_class)
    return true;
  if (rhs.description_class < lhs.description_class)
    return false;
  if (lhs.swap_contents_and_description < rhs.swap_contents_and_description)
    return true;
  if (rhs.swap_contents_and_description < lhs.swap_contents_and_description)
    return false;
  if (lhs.answer < rhs.answer)
    return true;
  if (rhs.answer < lhs.answer)
    return false;
  if (lhs.transition < rhs.transition)
    return true;
  if (rhs.transition < lhs.transition)
    return false;
  if (lhs.allowed_to_be_default_match < rhs.allowed_to_be_default_match)
    return true;
  if (rhs.allowed_to_be_default_match < lhs.allowed_to_be_default_match)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.is_search_type < rhs.is_search_type)
    return true;
  if (rhs.is_search_type < lhs.is_search_type)
    return false;
  if (lhs.aqs_type_subtypes < rhs.aqs_type_subtypes)
    return true;
  if (rhs.aqs_type_subtypes < lhs.aqs_type_subtypes)
    return false;
  if (lhs.has_tab_match < rhs.has_tab_match)
    return true;
  if (rhs.has_tab_match < lhs.has_tab_match)
    return false;
  if (lhs.associated_keyword < rhs.associated_keyword)
    return true;
  if (rhs.associated_keyword < lhs.associated_keyword)
    return false;
  if (lhs.keyword < rhs.keyword)
    return true;
  if (rhs.keyword < lhs.keyword)
    return false;
  if (lhs.starred < rhs.starred)
    return true;
  if (rhs.starred < lhs.starred)
    return false;
  if (lhs.duplicates < rhs.duplicates)
    return true;
  if (rhs.duplicates < lhs.duplicates)
    return false;
  if (lhs.from_previous < rhs.from_previous)
    return true;
  if (rhs.from_previous < lhs.from_previous)
    return false;
  if (lhs.pedal_id < rhs.pedal_id)
    return true;
  if (rhs.pedal_id < lhs.pedal_id)
    return false;
  if (lhs.scoring_signals < rhs.scoring_signals)
    return true;
  if (rhs.scoring_signals < lhs.scoring_signals)
    return false;
  if (lhs.additional_info < rhs.additional_info)
    return true;
  if (rhs.additional_info < lhs.additional_info)
    return false;
  return false;
}
template <typename StructPtrType>
AutocompleteResultsForProviderPtr AutocompleteResultsForProvider::Clone() const {
  return New(
      mojo::Clone(provider_name),
      mojo::Clone(results)
  );
}

template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>*>
bool AutocompleteResultsForProvider::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provider_name, other_struct.provider_name))
    return false;
  if (!mojo::Equals(this->results, other_struct.results))
    return false;
  return true;
}

template <typename T, AutocompleteResultsForProvider::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.provider_name < rhs.provider_name)
    return true;
  if (rhs.provider_name < lhs.provider_name)
    return false;
  if (lhs.results < rhs.results)
    return true;
  if (rhs.results < lhs.results)
    return false;
  return false;
}
template <typename StructPtrType>
OmniboxResponsePtr OmniboxResponse::Clone() const {
  return New(
      mojo::Clone(cursor_position),
      mojo::Clone(time_since_omnibox_started_ms),
      mojo::Clone(done),
      mojo::Clone(type),
      mojo::Clone(host),
      mojo::Clone(is_typed_host),
      mojo::Clone(input_text),
      mojo::Clone(combined_results),
      mojo::Clone(results_by_provider)
  );
}

template <typename T, OmniboxResponse::EnableIfSame<T>*>
bool OmniboxResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cursor_position, other_struct.cursor_position))
    return false;
  if (!mojo::Equals(this->time_since_omnibox_started_ms, other_struct.time_since_omnibox_started_ms))
    return false;
  if (!mojo::Equals(this->done, other_struct.done))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->is_typed_host, other_struct.is_typed_host))
    return false;
  if (!mojo::Equals(this->input_text, other_struct.input_text))
    return false;
  if (!mojo::Equals(this->combined_results, other_struct.combined_results))
    return false;
  if (!mojo::Equals(this->results_by_provider, other_struct.results_by_provider))
    return false;
  return true;
}

template <typename T, OmniboxResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cursor_position < rhs.cursor_position)
    return true;
  if (rhs.cursor_position < lhs.cursor_position)
    return false;
  if (lhs.time_since_omnibox_started_ms < rhs.time_since_omnibox_started_ms)
    return true;
  if (rhs.time_since_omnibox_started_ms < lhs.time_since_omnibox_started_ms)
    return false;
  if (lhs.done < rhs.done)
    return true;
  if (rhs.done < lhs.done)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.is_typed_host < rhs.is_typed_host)
    return true;
  if (rhs.is_typed_host < lhs.is_typed_host)
    return false;
  if (lhs.input_text < rhs.input_text)
    return true;
  if (rhs.input_text < lhs.input_text)
    return false;
  if (lhs.combined_results < rhs.combined_results)
    return true;
  if (rhs.combined_results < lhs.combined_results)
    return false;
  if (lhs.results_by_provider < rhs.results_by_provider)
    return true;
  if (rhs.results_by_provider < lhs.results_by_provider)
    return false;
  return false;
}


}  // mojom

namespace mojo {


template <>
struct  StructTraits<::mojom::ACMatchClassification::DataView,
                                         ::mojom::ACMatchClassificationPtr> {
  static bool IsNull(const ::mojom::ACMatchClassificationPtr& input) { return !input; }
  static void SetToNull(::mojom::ACMatchClassificationPtr* output) { output->reset(); }

  static decltype(::mojom::ACMatchClassification::offset) offset(
      const ::mojom::ACMatchClassificationPtr& input) {
    return input->offset;
  }

  static decltype(::mojom::ACMatchClassification::style) style(
      const ::mojom::ACMatchClassificationPtr& input) {
    return input->style;
  }

  static bool Read(::mojom::ACMatchClassification::DataView input, ::mojom::ACMatchClassificationPtr* output);
};


template <>
struct  StructTraits<::mojom::Signals::DataView,
                                         ::mojom::SignalsPtr> {
  static bool IsNull(const ::mojom::SignalsPtr& input) { return !input; }
  static void SetToNull(::mojom::SignalsPtr* output) { output->reset(); }

  static decltype(::mojom::Signals::typed_count) typed_count(
      const ::mojom::SignalsPtr& input) {
    return input->typed_count;
  }

  static decltype(::mojom::Signals::visit_count) visit_count(
      const ::mojom::SignalsPtr& input) {
    return input->visit_count;
  }

  static decltype(::mojom::Signals::elapsed_time_last_visit_secs) elapsed_time_last_visit_secs(
      const ::mojom::SignalsPtr& input) {
    return input->elapsed_time_last_visit_secs;
  }

  static decltype(::mojom::Signals::shortcut_visit_count) shortcut_visit_count(
      const ::mojom::SignalsPtr& input) {
    return input->shortcut_visit_count;
  }

  static decltype(::mojom::Signals::shortest_shortcut_len) shortest_shortcut_len(
      const ::mojom::SignalsPtr& input) {
    return input->shortest_shortcut_len;
  }

  static decltype(::mojom::Signals::elapsed_time_last_shortcut_visit_sec) elapsed_time_last_shortcut_visit_sec(
      const ::mojom::SignalsPtr& input) {
    return input->elapsed_time_last_shortcut_visit_sec;
  }

  static decltype(::mojom::Signals::is_host_only) is_host_only(
      const ::mojom::SignalsPtr& input) {
    return input->is_host_only;
  }

  static decltype(::mojom::Signals::num_bookmarks_of_url) num_bookmarks_of_url(
      const ::mojom::SignalsPtr& input) {
    return input->num_bookmarks_of_url;
  }

  static decltype(::mojom::Signals::first_bookmark_title_match_position) first_bookmark_title_match_position(
      const ::mojom::SignalsPtr& input) {
    return input->first_bookmark_title_match_position;
  }

  static decltype(::mojom::Signals::total_bookmark_title_match_length) total_bookmark_title_match_length(
      const ::mojom::SignalsPtr& input) {
    return input->total_bookmark_title_match_length;
  }

  static decltype(::mojom::Signals::num_input_terms_matched_by_bookmark_title) num_input_terms_matched_by_bookmark_title(
      const ::mojom::SignalsPtr& input) {
    return input->num_input_terms_matched_by_bookmark_title;
  }

  static decltype(::mojom::Signals::first_url_match_position) first_url_match_position(
      const ::mojom::SignalsPtr& input) {
    return input->first_url_match_position;
  }

  static decltype(::mojom::Signals::total_url_match_length) total_url_match_length(
      const ::mojom::SignalsPtr& input) {
    return input->total_url_match_length;
  }

  static decltype(::mojom::Signals::host_match_at_word_boundary) host_match_at_word_boundary(
      const ::mojom::SignalsPtr& input) {
    return input->host_match_at_word_boundary;
  }

  static decltype(::mojom::Signals::total_host_match_length) total_host_match_length(
      const ::mojom::SignalsPtr& input) {
    return input->total_host_match_length;
  }

  static decltype(::mojom::Signals::total_path_match_length) total_path_match_length(
      const ::mojom::SignalsPtr& input) {
    return input->total_path_match_length;
  }

  static decltype(::mojom::Signals::total_query_or_ref_match_length) total_query_or_ref_match_length(
      const ::mojom::SignalsPtr& input) {
    return input->total_query_or_ref_match_length;
  }

  static decltype(::mojom::Signals::total_title_match_length) total_title_match_length(
      const ::mojom::SignalsPtr& input) {
    return input->total_title_match_length;
  }

  static decltype(::mojom::Signals::has_non_scheme_www_match) has_non_scheme_www_match(
      const ::mojom::SignalsPtr& input) {
    return input->has_non_scheme_www_match;
  }

  static decltype(::mojom::Signals::num_input_terms_matched_by_title) num_input_terms_matched_by_title(
      const ::mojom::SignalsPtr& input) {
    return input->num_input_terms_matched_by_title;
  }

  static decltype(::mojom::Signals::num_input_terms_matched_by_url) num_input_terms_matched_by_url(
      const ::mojom::SignalsPtr& input) {
    return input->num_input_terms_matched_by_url;
  }

  static decltype(::mojom::Signals::length_of_url) length_of_url(
      const ::mojom::SignalsPtr& input) {
    return input->length_of_url;
  }

  static decltype(::mojom::Signals::site_engagement) site_engagement(
      const ::mojom::SignalsPtr& input) {
    return input->site_engagement;
  }

  static decltype(::mojom::Signals::allowed_to_be_default_match) allowed_to_be_default_match(
      const ::mojom::SignalsPtr& input) {
    return input->allowed_to_be_default_match;
  }

  static decltype(::mojom::Signals::search_suggest_relevance) search_suggest_relevance(
      const ::mojom::SignalsPtr& input) {
    return input->search_suggest_relevance;
  }

  static decltype(::mojom::Signals::is_search_suggest_entity) is_search_suggest_entity(
      const ::mojom::SignalsPtr& input) {
    return input->is_search_suggest_entity;
  }

  static decltype(::mojom::Signals::is_verbatim) is_verbatim(
      const ::mojom::SignalsPtr& input) {
    return input->is_verbatim;
  }

  static decltype(::mojom::Signals::is_navsuggest) is_navsuggest(
      const ::mojom::SignalsPtr& input) {
    return input->is_navsuggest;
  }

  static decltype(::mojom::Signals::is_search_suggest_tail) is_search_suggest_tail(
      const ::mojom::SignalsPtr& input) {
    return input->is_search_suggest_tail;
  }

  static decltype(::mojom::Signals::is_answer_suggest) is_answer_suggest(
      const ::mojom::SignalsPtr& input) {
    return input->is_answer_suggest;
  }

  static decltype(::mojom::Signals::is_calculator_suggest) is_calculator_suggest(
      const ::mojom::SignalsPtr& input) {
    return input->is_calculator_suggest;
  }

  static bool Read(::mojom::Signals::DataView input, ::mojom::SignalsPtr* output);
};


template <>
struct  StructTraits<::mojom::AutocompleteMatch::DataView,
                                         ::mojom::AutocompleteMatchPtr> {
  static bool IsNull(const ::mojom::AutocompleteMatchPtr& input) { return !input; }
  static void SetToNull(::mojom::AutocompleteMatchPtr* output) { output->reset(); }

  static const decltype(::mojom::AutocompleteMatch::provider_name)& provider_name(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->provider_name;
  }

  static decltype(::mojom::AutocompleteMatch::provider_done) provider_done(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->provider_done;
  }

  static decltype(::mojom::AutocompleteMatch::relevance) relevance(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->relevance;
  }

  static decltype(::mojom::AutocompleteMatch::deletable) deletable(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->deletable;
  }

  static const decltype(::mojom::AutocompleteMatch::fill_into_edit)& fill_into_edit(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->fill_into_edit;
  }

  static const decltype(::mojom::AutocompleteMatch::inline_autocompletion)& inline_autocompletion(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->inline_autocompletion;
  }

  static const decltype(::mojom::AutocompleteMatch::destination_url)& destination_url(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->destination_url;
  }

  static const decltype(::mojom::AutocompleteMatch::stripped_destination_url)& stripped_destination_url(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->stripped_destination_url;
  }

  static const decltype(::mojom::AutocompleteMatch::icon)& icon(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->icon;
  }

  static const decltype(::mojom::AutocompleteMatch::image)& image(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->image;
  }

  static const decltype(::mojom::AutocompleteMatch::contents)& contents(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->contents;
  }

  static const decltype(::mojom::AutocompleteMatch::contents_class)& contents_class(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->contents_class;
  }

  static const decltype(::mojom::AutocompleteMatch::description)& description(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->description;
  }

  static const decltype(::mojom::AutocompleteMatch::description_class)& description_class(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->description_class;
  }

  static decltype(::mojom::AutocompleteMatch::swap_contents_and_description) swap_contents_and_description(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->swap_contents_and_description;
  }

  static const decltype(::mojom::AutocompleteMatch::answer)& answer(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->answer;
  }

  static const decltype(::mojom::AutocompleteMatch::transition)& transition(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->transition;
  }

  static decltype(::mojom::AutocompleteMatch::allowed_to_be_default_match) allowed_to_be_default_match(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->allowed_to_be_default_match;
  }

  static const decltype(::mojom::AutocompleteMatch::type)& type(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->type;
  }

  static decltype(::mojom::AutocompleteMatch::is_search_type) is_search_type(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->is_search_type;
  }

  static const decltype(::mojom::AutocompleteMatch::aqs_type_subtypes)& aqs_type_subtypes(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->aqs_type_subtypes;
  }

  static decltype(::mojom::AutocompleteMatch::has_tab_match) has_tab_match(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->has_tab_match;
  }

  static const decltype(::mojom::AutocompleteMatch::associated_keyword)& associated_keyword(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->associated_keyword;
  }

  static const decltype(::mojom::AutocompleteMatch::keyword)& keyword(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->keyword;
  }

  static decltype(::mojom::AutocompleteMatch::starred) starred(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->starred;
  }

  static decltype(::mojom::AutocompleteMatch::duplicates) duplicates(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->duplicates;
  }

  static decltype(::mojom::AutocompleteMatch::from_previous) from_previous(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->from_previous;
  }

  static decltype(::mojom::AutocompleteMatch::pedal_id) pedal_id(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->pedal_id;
  }

  static const decltype(::mojom::AutocompleteMatch::scoring_signals)& scoring_signals(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->scoring_signals;
  }

  static const decltype(::mojom::AutocompleteMatch::additional_info)& additional_info(
      const ::mojom::AutocompleteMatchPtr& input) {
    return input->additional_info;
  }

  static bool Read(::mojom::AutocompleteMatch::DataView input, ::mojom::AutocompleteMatchPtr* output);
};


template <>
struct  StructTraits<::mojom::AutocompleteResultsForProvider::DataView,
                                         ::mojom::AutocompleteResultsForProviderPtr> {
  static bool IsNull(const ::mojom::AutocompleteResultsForProviderPtr& input) { return !input; }
  static void SetToNull(::mojom::AutocompleteResultsForProviderPtr* output) { output->reset(); }

  static const decltype(::mojom::AutocompleteResultsForProvider::provider_name)& provider_name(
      const ::mojom::AutocompleteResultsForProviderPtr& input) {
    return input->provider_name;
  }

  static const decltype(::mojom::AutocompleteResultsForProvider::results)& results(
      const ::mojom::AutocompleteResultsForProviderPtr& input) {
    return input->results;
  }

  static bool Read(::mojom::AutocompleteResultsForProvider::DataView input, ::mojom::AutocompleteResultsForProviderPtr* output);
};


template <>
struct  StructTraits<::mojom::OmniboxResponse::DataView,
                                         ::mojom::OmniboxResponsePtr> {
  static bool IsNull(const ::mojom::OmniboxResponsePtr& input) { return !input; }
  static void SetToNull(::mojom::OmniboxResponsePtr* output) { output->reset(); }

  static decltype(::mojom::OmniboxResponse::cursor_position) cursor_position(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->cursor_position;
  }

  static decltype(::mojom::OmniboxResponse::time_since_omnibox_started_ms) time_since_omnibox_started_ms(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->time_since_omnibox_started_ms;
  }

  static decltype(::mojom::OmniboxResponse::done) done(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->done;
  }

  static const decltype(::mojom::OmniboxResponse::type)& type(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->type;
  }

  static const decltype(::mojom::OmniboxResponse::host)& host(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->host;
  }

  static decltype(::mojom::OmniboxResponse::is_typed_host) is_typed_host(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->is_typed_host;
  }

  static const decltype(::mojom::OmniboxResponse::input_text)& input_text(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->input_text;
  }

  static const decltype(::mojom::OmniboxResponse::combined_results)& combined_results(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->combined_results;
  }

  static const decltype(::mojom::OmniboxResponse::results_by_provider)& results_by_provider(
      const ::mojom::OmniboxResponsePtr& input) {
    return input->results_by_provider;
  }

  static bool Read(::mojom::OmniboxResponse::DataView input, ::mojom::OmniboxResponsePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_H_