// chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace aim_eligibility::mojom {

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "aim_eligibility.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnEligibilityStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnEligibilityStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnEligibilityStateChanged(EligibilityStatePtr state) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "aim_eligibility.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetEligibilityStateMinVersion = 0,
    kRequestServerEligibilityForDebuggingMinVersion = 0,
    kSetEligibilityResponseForDebuggingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetEligibilityState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestServerEligibilityForDebugging_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEligibilityResponseForDebugging_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetEligibilityStateCallback = base::OnceCallback<void(EligibilityStatePtr)>;
  using GetEligibilityStateMojoCallback = base::OnceCallback<void(EligibilityStatePtr)>;

  virtual void GetEligibilityState(GetEligibilityStateCallback callback) = 0;

  virtual void RequestServerEligibilityForDebugging() = 0;

  using SetEligibilityResponseForDebuggingCallback = base::OnceCallback<void(bool)>;
  using SetEligibilityResponseForDebuggingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetEligibilityResponseForDebugging(const std::string& base64_encoded_response, SetEligibilityResponseForDebuggingCallback callback) = 0;
};

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "aim_eligibility.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnEligibilityStateChanged(EligibilityStatePtr state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetEligibilityState(GetEligibilityStateCallback callback) final;
  
  void RequestServerEligibilityForDebugging() final;
  
  void SetEligibilityResponseForDebugging(const std::string& base64_encoded_response, SetEligibilityResponseForDebuggingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  EligibilityState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EligibilityState, T>::value>;
  using DataView = EligibilityStateDataView;
  using Data_ = internal::EligibilityState_Data;

  template <typename... Args>
  static EligibilityStatePtr New(Args&&... args) {
    return EligibilityStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EligibilityStatePtr From(const U& u) {
    return mojo::TypeConverter<EligibilityStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EligibilityState>::Convert(*this);
  }


  EligibilityState();

  EligibilityState(
      bool is_eligible,
      bool is_eligible_by_policy,
      bool is_eligible_by_dse,
      bool is_eligible_by_server,
      bool is_server_eligibility_enabled,
      const std::string& server_response_base64_encoded,
      const std::string& server_response_base64_url_encoded,
      const std::string& server_response_source,
      ::base::Time last_updated);


  ~EligibilityState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EligibilityStatePtr>
  EligibilityStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EligibilityState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EligibilityState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EligibilityState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EligibilityState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EligibilityState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EligibilityState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EligibilityState_UnserializedMessageContext<
            UserType, EligibilityState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EligibilityState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EligibilityState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EligibilityState_UnserializedMessageContext<
            UserType, EligibilityState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EligibilityState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_eligible;
  
  bool is_eligible_by_policy;
  
  bool is_eligible_by_dse;
  
  bool is_eligible_by_server;
  
  bool is_server_eligibility_enabled;
  
  std::string server_response_base64_encoded;
  
  std::string server_response_base64_url_encoded;
  
  std::string server_response_source;
  
  ::base::Time last_updated;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EligibilityState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EligibilityState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EligibilityState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EligibilityState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
EligibilityStatePtr EligibilityState::Clone() const {
  return New(
      mojo::Clone(is_eligible),
      mojo::Clone(is_eligible_by_policy),
      mojo::Clone(is_eligible_by_dse),
      mojo::Clone(is_eligible_by_server),
      mojo::Clone(is_server_eligibility_enabled),
      mojo::Clone(server_response_base64_encoded),
      mojo::Clone(server_response_base64_url_encoded),
      mojo::Clone(server_response_source),
      mojo::Clone(last_updated)
  );
}

template <typename T, EligibilityState::EnableIfSame<T>*>
bool EligibilityState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_eligible, other_struct.is_eligible))
    return false;
  if (!mojo::Equals(this->is_eligible_by_policy, other_struct.is_eligible_by_policy))
    return false;
  if (!mojo::Equals(this->is_eligible_by_dse, other_struct.is_eligible_by_dse))
    return false;
  if (!mojo::Equals(this->is_eligible_by_server, other_struct.is_eligible_by_server))
    return false;
  if (!mojo::Equals(this->is_server_eligibility_enabled, other_struct.is_server_eligibility_enabled))
    return false;
  if (!mojo::Equals(this->server_response_base64_encoded, other_struct.server_response_base64_encoded))
    return false;
  if (!mojo::Equals(this->server_response_base64_url_encoded, other_struct.server_response_base64_url_encoded))
    return false;
  if (!mojo::Equals(this->server_response_source, other_struct.server_response_source))
    return false;
  if (!mojo::Equals(this->last_updated, other_struct.last_updated))
    return false;
  return true;
}

template <typename T, EligibilityState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_eligible < rhs.is_eligible)
    return true;
  if (rhs.is_eligible < lhs.is_eligible)
    return false;
  if (lhs.is_eligible_by_policy < rhs.is_eligible_by_policy)
    return true;
  if (rhs.is_eligible_by_policy < lhs.is_eligible_by_policy)
    return false;
  if (lhs.is_eligible_by_dse < rhs.is_eligible_by_dse)
    return true;
  if (rhs.is_eligible_by_dse < lhs.is_eligible_by_dse)
    return false;
  if (lhs.is_eligible_by_server < rhs.is_eligible_by_server)
    return true;
  if (rhs.is_eligible_by_server < lhs.is_eligible_by_server)
    return false;
  if (lhs.is_server_eligibility_enabled < rhs.is_server_eligibility_enabled)
    return true;
  if (rhs.is_server_eligibility_enabled < lhs.is_server_eligibility_enabled)
    return false;
  if (lhs.server_response_base64_encoded < rhs.server_response_base64_encoded)
    return true;
  if (rhs.server_response_base64_encoded < lhs.server_response_base64_encoded)
    return false;
  if (lhs.server_response_base64_url_encoded < rhs.server_response_base64_url_encoded)
    return true;
  if (rhs.server_response_base64_url_encoded < lhs.server_response_base64_url_encoded)
    return false;
  if (lhs.server_response_source < rhs.server_response_source)
    return true;
  if (rhs.server_response_source < lhs.server_response_source)
    return false;
  if (lhs.last_updated < rhs.last_updated)
    return true;
  if (rhs.last_updated < lhs.last_updated)
    return false;
  return false;
}


}  // aim_eligibility::mojom

namespace mojo {


template <>
struct  StructTraits<::aim_eligibility::mojom::EligibilityState::DataView,
                                         ::aim_eligibility::mojom::EligibilityStatePtr> {
  static bool IsNull(const ::aim_eligibility::mojom::EligibilityStatePtr& input) { return !input; }
  static void SetToNull(::aim_eligibility::mojom::EligibilityStatePtr* output) { output->reset(); }

  static decltype(::aim_eligibility::mojom::EligibilityState::is_eligible) is_eligible(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->is_eligible;
  }

  static decltype(::aim_eligibility::mojom::EligibilityState::is_eligible_by_policy) is_eligible_by_policy(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->is_eligible_by_policy;
  }

  static decltype(::aim_eligibility::mojom::EligibilityState::is_eligible_by_dse) is_eligible_by_dse(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->is_eligible_by_dse;
  }

  static decltype(::aim_eligibility::mojom::EligibilityState::is_eligible_by_server) is_eligible_by_server(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->is_eligible_by_server;
  }

  static decltype(::aim_eligibility::mojom::EligibilityState::is_server_eligibility_enabled) is_server_eligibility_enabled(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->is_server_eligibility_enabled;
  }

  static const decltype(::aim_eligibility::mojom::EligibilityState::server_response_base64_encoded)& server_response_base64_encoded(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->server_response_base64_encoded;
  }

  static const decltype(::aim_eligibility::mojom::EligibilityState::server_response_base64_url_encoded)& server_response_base64_url_encoded(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->server_response_base64_url_encoded;
  }

  static const decltype(::aim_eligibility::mojom::EligibilityState::server_response_source)& server_response_source(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->server_response_source;
  }

  static const decltype(::aim_eligibility::mojom::EligibilityState::last_updated)& last_updated(
      const ::aim_eligibility::mojom::EligibilityStatePtr& input) {
    return input->last_updated;
  }

  static bool Read(::aim_eligibility::mojom::EligibilityState::DataView input, ::aim_eligibility::mojom::EligibilityStatePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_H_