// chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-params-data.h"
#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-import-headers.h"
#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-test-utils.h"


namespace aim_eligibility::mojom {
EligibilityState::EligibilityState()
    : is_eligible(),
      is_eligible_by_policy(),
      is_eligible_by_dse(),
      is_eligible_by_server(),
      is_server_eligibility_enabled(),
      server_response_base64_encoded(),
      server_response_base64_url_encoded(),
      server_response_source(),
      last_updated() {}

EligibilityState::EligibilityState(
    bool is_eligible_in,
    bool is_eligible_by_policy_in,
    bool is_eligible_by_dse_in,
    bool is_eligible_by_server_in,
    bool is_server_eligibility_enabled_in,
    const std::string& server_response_base64_encoded_in,
    const std::string& server_response_base64_url_encoded_in,
    const std::string& server_response_source_in,
    ::base::Time last_updated_in)
    : is_eligible(std::move(is_eligible_in)),
      is_eligible_by_policy(std::move(is_eligible_by_policy_in)),
      is_eligible_by_dse(std::move(is_eligible_by_dse_in)),
      is_eligible_by_server(std::move(is_eligible_by_server_in)),
      is_server_eligibility_enabled(std::move(is_server_eligibility_enabled_in)),
      server_response_base64_encoded(std::move(server_response_base64_encoded_in)),
      server_response_base64_url_encoded(std::move(server_response_base64_url_encoded_in)),
      server_response_source(std::move(server_response_source_in)),
      last_updated(std::move(last_updated_in)) {}

EligibilityState::~EligibilityState() = default;

void EligibilityState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_eligible"), this->is_eligible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_eligible_by_policy"), this->is_eligible_by_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_eligible_by_dse"), this->is_eligible_by_dse,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_eligible_by_server"), this->is_eligible_by_server,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_server_eligibility_enabled"), this->is_server_eligibility_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_response_base64_encoded"), this->server_response_base64_encoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_response_base64_url_encoded"), this->server_response_base64_url_encoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_response_source"), this->server_response_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_updated"), this->last_updated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EligibilityState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnEligibilityStateChanged: {
      return &Page::OnEligibilityStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnEligibilityStateChanged:
            return "Receive aim_eligibility::mojom::Page::OnEligibilityStateChanged";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnEligibilityStateChanged:
            return "Receive reply aim_eligibility::mojom::Page::OnEligibilityStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnEligibilityStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62d15376;  // IPCStableHash for aim_eligibility::mojom::Page::OnEligibilityStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnEligibilityStateChanged(
    EligibilityStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send aim_eligibility::mojom::Page::OnEligibilityStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type EligibilityStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnEligibilityStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::aim_eligibility::mojom::internal::Page_OnEligibilityStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::aim_eligibility::mojom::EligibilityStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in Page.OnEligibilityStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnEligibilityStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnEligibilityStateChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnEligibilityStateChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnEligibilityStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      EligibilityStatePtr p_state{};
      Page_OnEligibilityStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEligibilityStateChanged(        
        std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnEligibilityStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnEligibilityStateChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::aim_eligibility::mojom::Page::Name_,
    kPageValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetEligibilityState: {
      return &PageHandler::GetEligibilityState_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRequestServerEligibilityForDebugging: {
      return &PageHandler::RequestServerEligibilityForDebugging_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetEligibilityResponseForDebugging: {
      return &PageHandler::SetEligibilityResponseForDebugging_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetEligibilityState:
            return "Receive aim_eligibility::mojom::PageHandler::GetEligibilityState";
      case messages::PageHandler::kRequestServerEligibilityForDebugging:
            return "Receive aim_eligibility::mojom::PageHandler::RequestServerEligibilityForDebugging";
      case messages::PageHandler::kSetEligibilityResponseForDebugging:
            return "Receive aim_eligibility::mojom::PageHandler::SetEligibilityResponseForDebugging";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetEligibilityState:
            return "Receive reply aim_eligibility::mojom::PageHandler::GetEligibilityState";
      case messages::PageHandler::kRequestServerEligibilityForDebugging:
            return "Receive reply aim_eligibility::mojom::PageHandler::RequestServerEligibilityForDebugging";
      case messages::PageHandler::kSetEligibilityResponseForDebugging:
            return "Receive reply aim_eligibility::mojom::PageHandler::SetEligibilityResponseForDebugging";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetEligibilityState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93ada4bb;  // IPCStableHash for aim_eligibility::mojom::PageHandler::GetEligibilityState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RequestServerEligibilityForDebugging_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf2b65e1;  // IPCStableHash for aim_eligibility::mojom::PageHandler::RequestServerEligibilityForDebugging
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetEligibilityResponseForDebugging_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d109196;  // IPCStableHash for aim_eligibility::mojom::PageHandler::SetEligibilityResponseForDebugging
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetEligibilityState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetEligibilityState_ForwardToCallback(
      PageHandler::GetEligibilityStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetEligibilityState_ForwardToCallback(const PageHandler_GetEligibilityState_ForwardToCallback&) = delete;
  PageHandler_GetEligibilityState_ForwardToCallback& operator=(const PageHandler_GetEligibilityState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetEligibilityStateCallback callback_;
};

class PageHandler_SetEligibilityResponseForDebugging_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_SetEligibilityResponseForDebugging_ForwardToCallback(
      PageHandler::SetEligibilityResponseForDebuggingCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_SetEligibilityResponseForDebugging_ForwardToCallback(const PageHandler_SetEligibilityResponseForDebugging_ForwardToCallback&) = delete;
  PageHandler_SetEligibilityResponseForDebugging_ForwardToCallback& operator=(const PageHandler_SetEligibilityResponseForDebugging_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::SetEligibilityResponseForDebuggingCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetEligibilityState(
    GetEligibilityStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send aim_eligibility::mojom::PageHandler::GetEligibilityState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetEligibilityState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::aim_eligibility::mojom::internal::PageHandler_GetEligibilityState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetEligibilityState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetEligibilityState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::RequestServerEligibilityForDebugging(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send aim_eligibility::mojom::PageHandler::RequestServerEligibilityForDebugging");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRequestServerEligibilityForDebugging), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::aim_eligibility::mojom::internal::PageHandler_RequestServerEligibilityForDebugging_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RequestServerEligibilityForDebugging");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetEligibilityResponseForDebugging(
    const std::string& in_base64_encoded_response, SetEligibilityResponseForDebuggingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send aim_eligibility::mojom::PageHandler::SetEligibilityResponseForDebugging", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("base64_encoded_response"), in_base64_encoded_response,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetEligibilityResponseForDebugging), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::aim_eligibility::mojom::internal::PageHandler_SetEligibilityResponseForDebugging_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->base64_encoded_response)::BaseType> base64_encoded_response_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_base64_encoded_response,
    base64_encoded_response_fragment);

  params->base64_encoded_response.Set(
      base64_encoded_response_fragment.is_null() ? nullptr : base64_encoded_response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->base64_encoded_response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null base64_encoded_response in PageHandler.SetEligibilityResponseForDebugging request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetEligibilityResponseForDebugging");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_SetEligibilityResponseForDebugging_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_GetEligibilityState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetEligibilityStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetEligibilityState_ProxyToResponder> proxy(
        new PageHandler_GetEligibilityState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetEligibilityState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetEligibilityState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetEligibilityState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetEligibilityStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      EligibilityStatePtr in_state);
};

bool PageHandler_GetEligibilityState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetEligibilityState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetEligibilityState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  EligibilityStatePtr p_state{};
  PageHandler_GetEligibilityState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void PageHandler_GetEligibilityState_ProxyToResponder::Run(
    EligibilityStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply aim_eligibility::mojom::PageHandler::GetEligibilityState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type EligibilityStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetEligibilityState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::aim_eligibility::mojom::internal::PageHandler_GetEligibilityState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::aim_eligibility::mojom::EligibilityStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetEligibilityState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_SetEligibilityResponseForDebugging_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::SetEligibilityResponseForDebuggingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_SetEligibilityResponseForDebugging_ProxyToResponder> proxy(
        new PageHandler_SetEligibilityResponseForDebugging_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_SetEligibilityResponseForDebugging_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_SetEligibilityResponseForDebugging_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_SetEligibilityResponseForDebugging_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::SetEligibilityResponseForDebuggingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PageHandler_SetEligibilityResponseForDebugging_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_SetEligibilityResponseForDebugging_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_SetEligibilityResponseForDebugging_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  bool p_success{};
  PageHandler_SetEligibilityResponseForDebugging_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PageHandler_SetEligibilityResponseForDebugging_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply aim_eligibility::mojom::PageHandler::SetEligibilityResponseForDebugging", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetEligibilityResponseForDebugging), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::aim_eligibility::mojom::internal::PageHandler_SetEligibilityResponseForDebugging_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetEligibilityResponseForDebugging");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetEligibilityState: {
      break;
    }
    case messages::PageHandler::kRequestServerEligibilityForDebugging: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RequestServerEligibilityForDebugging_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RequestServerEligibilityForDebugging_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_RequestServerEligibilityForDebugging_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestServerEligibilityForDebugging(        );
      return true;
    }
    case messages::PageHandler::kSetEligibilityResponseForDebugging: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetEligibilityState: {
      internal::PageHandler_GetEligibilityState_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetEligibilityState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetEligibilityState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetEligibilityState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEligibilityState(std::move(callback));
      return true;
    }
    case messages::PageHandler::kRequestServerEligibilityForDebugging: {
      break;
    }
    case messages::PageHandler::kSetEligibilityResponseForDebugging: {
      internal::PageHandler_SetEligibilityResponseForDebugging_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_SetEligibilityResponseForDebugging_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      std::string p_base64_encoded_response{};
      PageHandler_SetEligibilityResponseForDebugging_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBase64EncodedResponse(&p_base64_encoded_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_SetEligibilityResponseForDebugging_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEligibilityResponseForDebugging(        
        std::move(p_base64_encoded_response), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetEligibilityState_Params_Data::Validate,
     &internal::PageHandler_GetEligibilityState_ResponseParams_Data::Validate},
    { &internal::PageHandler_RequestServerEligibilityForDebugging_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetEligibilityResponseForDebugging_Params_Data::Validate,
     &internal::PageHandler_SetEligibilityResponseForDebugging_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::aim_eligibility::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::aim_eligibility::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive aim_eligibility::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply aim_eligibility::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3429077;  // IPCStableHash for aim_eligibility::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send aim_eligibility::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::aim_eligibility::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::aim_eligibility::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::aim_eligibility::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::aim_eligibility::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}



}  // aim_eligibility::mojom


namespace mojo {


// static
bool StructTraits<::aim_eligibility::mojom::EligibilityState::DataView, ::aim_eligibility::mojom::EligibilityStatePtr>::Read(
    ::aim_eligibility::mojom::EligibilityState::DataView input,
    ::aim_eligibility::mojom::EligibilityStatePtr* output) {
  bool success = true;
  ::aim_eligibility::mojom::EligibilityStatePtr result(::aim_eligibility::mojom::EligibilityState::New());
  
      if (success)
        result->is_eligible = input.is_eligible();
      if (success)
        result->is_eligible_by_policy = input.is_eligible_by_policy();
      if (success)
        result->is_eligible_by_dse = input.is_eligible_by_dse();
      if (success)
        result->is_eligible_by_server = input.is_eligible_by_server();
      if (success)
        result->is_server_eligibility_enabled = input.is_server_eligibility_enabled();
      if (success && !input.ReadServerResponseBase64Encoded(&result->server_response_base64_encoded))
        success = false;
      if (success && !input.ReadServerResponseBase64UrlEncoded(&result->server_response_base64_url_encoded))
        success = false;
      if (success && !input.ReadServerResponseSource(&result->server_response_source))
        success = false;
      if (success && !input.ReadLastUpdated(&result->last_updated))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace aim_eligibility::mojom {


void PageInterceptorForTesting::OnEligibilityStateChanged(EligibilityStatePtr state) {
  GetForwardingInterface()->OnEligibilityStateChanged(
    std::move(state)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetEligibilityState(GetEligibilityStateCallback callback) {
  GetForwardingInterface()->GetEligibilityState(std::move(callback));
}
void PageHandlerInterceptorForTesting::RequestServerEligibilityForDebugging() {
  GetForwardingInterface()->RequestServerEligibilityForDebugging();
}
void PageHandlerInterceptorForTesting::SetEligibilityResponseForDebugging(const std::string& base64_encoded_response, SetEligibilityResponseForDebuggingCallback callback) {
  GetForwardingInterface()->SetEligibilityResponseForDebugging(
    std::move(base64_encoded_response)
    , std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetEligibilityState(
    EligibilityStatePtr* out_state) {
  base::RunLoop loop;
  proxy_->GetEligibilityState(
      base::BindOnce(
          [](base::RunLoop* loop,
             EligibilityStatePtr* out_state
,
             EligibilityStatePtr state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

EligibilityStatePtr PageHandlerAsyncWaiter::GetEligibilityState(
    ) {
  EligibilityStatePtr async_wait_result;
  GetEligibilityState(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::SetEligibilityResponseForDebugging(
    const std::string& base64_encoded_response, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetEligibilityResponseForDebugging(
      std::move(base64_encoded_response),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PageHandlerAsyncWaiter::SetEligibilityResponseForDebugging(
    const std::string& base64_encoded_response) {
  bool async_wait_result;
  SetEligibilityResponseForDebugging(std::move(base64_encoded_response),&async_wait_result);
  return async_wait_result;
}




void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;







}  // aim_eligibility::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif