// chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  JSTimeSpec as mojoBase_mojom_JSTimeSpec,
  JSTime as mojoBase_mojom_JSTime
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';







export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'aim_eligibility.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onEligibilityStateChanged(state: EligibilityState): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onEligibilityStateChanged(
      state: EligibilityState): void {
    this.proxy.sendMessage(
        0,
        Page_OnEligibilityStateChanged_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnEligibilityStateChanged_ParamsSpec.$,
        null,
        impl.onEligibilityStateChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "aim_eligibility.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onEligibilityStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onEligibilityStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnEligibilityStateChanged_ParamsSpec.$,
        null,
        this.onEligibilityStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'aim_eligibility.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getEligibilityState(): Promise<{
        state: EligibilityState, }>;
  requestServerEligibilityForDebugging(): void;
  setEligibilityResponseForDebugging(base64EncodedResponse: string): Promise<{
        success: boolean, }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getEligibilityState(): Promise<{
        state: EligibilityState, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetEligibilityState_ParamsSpec.$,
        PageHandler_GetEligibilityState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  requestServerEligibilityForDebugging(): void {
    this.proxy.sendMessage(
        1,
        PageHandler_RequestServerEligibilityForDebugging_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setEligibilityResponseForDebugging(
      base64EncodedResponse: string): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_SetEligibilityResponseForDebugging_ParamsSpec.$,
        PageHandler_SetEligibilityResponseForDebugging_ResponseParamsSpec.$,
        [
          base64EncodedResponse
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetEligibilityState_ParamsSpec.$,
        PageHandler_GetEligibilityState_ResponseParamsSpec.$,
        impl.getEligibilityState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_RequestServerEligibilityForDebugging_ParamsSpec.$,
        null,
        impl.requestServerEligibilityForDebugging.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_SetEligibilityResponseForDebugging_ParamsSpec.$,
        PageHandler_SetEligibilityResponseForDebugging_ResponseParamsSpec.$,
        impl.setEligibilityResponseForDebugging.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "aim_eligibility.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getEligibilityState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestServerEligibilityForDebugging: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setEligibilityResponseForDebugging: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getEligibilityState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetEligibilityState_ParamsSpec.$,
        PageHandler_GetEligibilityState_ResponseParamsSpec.$,
        this.getEligibilityState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestServerEligibilityForDebugging =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_RequestServerEligibilityForDebugging_ParamsSpec.$,
        null,
        this.requestServerEligibilityForDebugging.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setEligibilityResponseForDebugging =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_SetEligibilityResponseForDebugging_ParamsSpec.$,
        PageHandler_SetEligibilityResponseForDebugging_ResponseParamsSpec.$,
        this.setEligibilityResponseForDebugging.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'aim_eligibility.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "aim_eligibility.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const EligibilityStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnEligibilityStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetEligibilityState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetEligibilityState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RequestServerEligibilityForDebugging_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetEligibilityResponseForDebugging_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetEligibilityResponseForDebugging_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface EligibilityStateMojoType {
  isEligible: boolean;
  isEligibleByPolicy: boolean;
  isEligibleByDse: boolean;
  isEligibleByServer: boolean;
  isServerEligibilityEnabled: boolean;
  serverResponseBase64Encoded: string;
  serverResponseBase64UrlEncoded: string;
  serverResponseSource: string;
  lastUpdated: mojoBase_mojom_JSTime;
}


export type EligibilityState = EligibilityStateMojoType;
mojo.internal.Struct<EligibilityStateMojoType>(
    EligibilityStateSpec.$,
    'EligibilityState',
    [
      mojo.internal.StructField<EligibilityStateMojoType, boolean>(
        'isEligible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityStateMojoType, boolean>(
        'isEligibleByPolicy', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityStateMojoType, boolean>(
        'isEligibleByDse', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityStateMojoType, boolean>(
        'isEligibleByServer', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityStateMojoType, boolean>(
        'isServerEligibilityEnabled', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityStateMojoType, string>(
        'serverResponseBase64Encoded', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityStateMojoType, string>(
        'serverResponseBase64UrlEncoded', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityStateMojoType, string>(
        'serverResponseSource', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<EligibilityStateMojoType, mojoBase_mojom_JSTime>(
        'lastUpdated', 32,
        0,
        mojoBase_mojom_JSTimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface Page_OnEligibilityStateChanged_ParamsMojoType {
  state: EligibilityState;
}


export type Page_OnEligibilityStateChanged_Params = Page_OnEligibilityStateChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnEligibilityStateChanged_ParamsMojoType>(
    Page_OnEligibilityStateChanged_ParamsSpec.$,
    'Page_OnEligibilityStateChanged_Params',
    [
      mojo.internal.StructField<Page_OnEligibilityStateChanged_ParamsMojoType, EligibilityState>(
        'state', 0,
        0,
        EligibilityStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetEligibilityState_ParamsMojoType {
}


export type PageHandler_GetEligibilityState_Params = PageHandler_GetEligibilityState_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetEligibilityState_ParamsMojoType>(
    PageHandler_GetEligibilityState_ParamsSpec.$,
    'PageHandler_GetEligibilityState_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetEligibilityState_ResponseParamsMojoType {
  state: EligibilityState;
}


export type PageHandler_GetEligibilityState_ResponseParams = PageHandler_GetEligibilityState_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetEligibilityState_ResponseParamsMojoType>(
    PageHandler_GetEligibilityState_ResponseParamsSpec.$,
    'PageHandler_GetEligibilityState_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetEligibilityState_ResponseParamsMojoType, EligibilityState>(
        'state', 0,
        0,
        EligibilityStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RequestServerEligibilityForDebugging_ParamsMojoType {
}


export type PageHandler_RequestServerEligibilityForDebugging_Params = PageHandler_RequestServerEligibilityForDebugging_ParamsMojoType;
mojo.internal.Struct<PageHandler_RequestServerEligibilityForDebugging_ParamsMojoType>(
    PageHandler_RequestServerEligibilityForDebugging_ParamsSpec.$,
    'PageHandler_RequestServerEligibilityForDebugging_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_SetEligibilityResponseForDebugging_ParamsMojoType {
  base64EncodedResponse: string;
}


export type PageHandler_SetEligibilityResponseForDebugging_Params = PageHandler_SetEligibilityResponseForDebugging_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetEligibilityResponseForDebugging_ParamsMojoType>(
    PageHandler_SetEligibilityResponseForDebugging_ParamsSpec.$,
    'PageHandler_SetEligibilityResponseForDebugging_Params',
    [
      mojo.internal.StructField<PageHandler_SetEligibilityResponseForDebugging_ParamsMojoType, string>(
        'base64EncodedResponse', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetEligibilityResponseForDebugging_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_SetEligibilityResponseForDebugging_ResponseParams = PageHandler_SetEligibilityResponseForDebugging_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_SetEligibilityResponseForDebugging_ResponseParamsMojoType>(
    PageHandler_SetEligibilityResponseForDebugging_ResponseParamsSpec.$,
    'PageHandler_SetEligibilityResponseForDebugging_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_SetEligibilityResponseForDebugging_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



