// chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::aim_eligibility::mojom::EligibilityStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::aim_eligibility::mojom::EligibilityStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::aim_eligibility::mojom::internal::EligibilityState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_eligible = Traits::is_eligible(input);

    fragment->is_eligible_by_policy = Traits::is_eligible_by_policy(input);

    fragment->is_eligible_by_dse = Traits::is_eligible_by_dse(input);

    fragment->is_eligible_by_server = Traits::is_eligible_by_server(input);

    fragment->is_server_eligibility_enabled = Traits::is_server_eligibility_enabled(input);

    decltype(Traits::server_response_base64_encoded(input)) in_server_response_base64_encoded = Traits::server_response_base64_encoded(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_response_base64_encoded)::BaseType> server_response_base64_encoded_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_server_response_base64_encoded,
      server_response_base64_encoded_fragment);

    fragment->server_response_base64_encoded.Set(
        server_response_base64_encoded_fragment.is_null() ? nullptr : server_response_base64_encoded_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->server_response_base64_encoded.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null server_response_base64_encoded in EligibilityState struct");

    decltype(Traits::server_response_base64_url_encoded(input)) in_server_response_base64_url_encoded = Traits::server_response_base64_url_encoded(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_response_base64_url_encoded)::BaseType> server_response_base64_url_encoded_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_server_response_base64_url_encoded,
      server_response_base64_url_encoded_fragment);

    fragment->server_response_base64_url_encoded.Set(
        server_response_base64_url_encoded_fragment.is_null() ? nullptr : server_response_base64_url_encoded_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->server_response_base64_url_encoded.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null server_response_base64_url_encoded in EligibilityState struct");

    decltype(Traits::server_response_source(input)) in_server_response_source = Traits::server_response_source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_response_source)::BaseType> server_response_source_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_server_response_source,
      server_response_source_fragment);

    fragment->server_response_source.Set(
        server_response_source_fragment.is_null() ? nullptr : server_response_source_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->server_response_source.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null server_response_source in EligibilityState struct");

    decltype(Traits::last_updated(input)) in_last_updated = Traits::last_updated(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_updated)::BaseType> last_updated_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::JSTimeDataView>(
      in_last_updated,
      last_updated_fragment);

    fragment->last_updated.Set(
        last_updated_fragment.is_null() ? nullptr : last_updated_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_updated.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_updated in EligibilityState struct");
  }

  static bool Deserialize(::aim_eligibility::mojom::internal::EligibilityState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::aim_eligibility::mojom::EligibilityStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace aim_eligibility::mojom {

inline void EligibilityStateDataView::GetServerResponseBase64EncodedDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->server_response_base64_encoded.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void EligibilityStateDataView::GetServerResponseBase64UrlEncodedDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->server_response_base64_url_encoded.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void EligibilityStateDataView::GetServerResponseSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->server_response_source.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void EligibilityStateDataView::GetLastUpdatedDataView(
    ::mojo_base::mojom::JSTimeDataView* output) {
  auto pointer = data_->last_updated.Get();
  *output = ::mojo_base::mojom::JSTimeDataView(pointer, message_);
}



}  // aim_eligibility::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_SHARED_H_