// chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/omnibox/aim_eligibility/aim_eligibility.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace aim_eligibility::mojom {
class EligibilityStateDataView;



}  // aim_eligibility::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::aim_eligibility::mojom::EligibilityStateDataView> {
  using Data = ::aim_eligibility::mojom::internal::EligibilityState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace aim_eligibility::mojom {
// Interface base classes. They are used for type safety check.
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;


class EligibilityStateDataView {
 public:
  EligibilityStateDataView() = default;

  EligibilityStateDataView(
      internal::EligibilityState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_eligible() const {
    return data_->is_eligible;
  }
  bool is_eligible_by_policy() const {
    return data_->is_eligible_by_policy;
  }
  bool is_eligible_by_dse() const {
    return data_->is_eligible_by_dse;
  }
  bool is_eligible_by_server() const {
    return data_->is_eligible_by_server;
  }
  bool is_server_eligibility_enabled() const {
    return data_->is_server_eligibility_enabled;
  }
  inline void GetServerResponseBase64EncodedDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerResponseBase64Encoded(UserType* output) {
    
    auto* pointer = data_->server_response_base64_encoded.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServerResponseBase64UrlEncodedDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerResponseBase64UrlEncoded(UserType* output) {
    
    auto* pointer = data_->server_response_base64_url_encoded.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServerResponseSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerResponseSource(UserType* output) {
    
    auto* pointer = data_->server_response_source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLastUpdatedDataView(
      ::mojo_base::mojom::JSTimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUpdated(UserType* output) {
    
    auto* pointer = data_->last_updated.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::JSTimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::EligibilityState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // aim_eligibility::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_OMNIBOX_AIM_ELIGIBILITY_AIM_ELIGIBILITY_MOJOM_DATA_VIEW_H_