// chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-params-data.h"
namespace ntp_promo {
namespace mojom {

NOINLINE static const char* ShowNtpPromosResultToStringHelper(ShowNtpPromosResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ShowNtpPromosResult::kShown:
      return "kShown";
    case ShowNtpPromosResult::kNotShownNoPromos:
      return "kNotShownNoPromos";
    case ShowNtpPromosResult::kNotShownDueToPolicy:
      return "kNotShownDueToPolicy";
    default:
      return nullptr;
  }
}

std::string ShowNtpPromosResultToString(ShowNtpPromosResult value) {
  const char *str = ShowNtpPromosResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ShowNtpPromosResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ShowNtpPromosResult value) {
  return os << ShowNtpPromosResultToString(value);
}

namespace internal {


// static
bool PromosShown_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PromosShown_Data* object =
      static_cast<const PromosShown_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->eligible, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& eligible_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->eligible, validation_context,
                                         &eligible_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->completed, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& completed_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->completed, validation_context,
                                         &completed_validate_params)) {
    return false;
  }

  return true;
}

PromosShown_Data::PromosShown_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Promo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Promo_Data* object =
      static_cast<const Promo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icon_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icon_name, validation_context,
                                         &icon_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->body_text, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& body_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->body_text, validation_context,
                                         &body_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->button_text, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& button_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->button_text, validation_context,
                                         &button_text_validate_params)) {
    return false;
  }

  return true;
}

Promo_Data::Promo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoHandler_RequestPromos_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoHandler_RequestPromos_Params_Data* object =
      static_cast<const NtpPromoHandler_RequestPromos_Params_Data*>(data);

  return true;
}

NtpPromoHandler_RequestPromos_Params_Data::NtpPromoHandler_RequestPromos_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoHandler_OnPromosShown_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoHandler_OnPromosShown_Params_Data* object =
      static_cast<const NtpPromoHandler_OnPromosShown_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->eligible_shown, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& eligible_shown_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->eligible_shown, validation_context,
                                         &eligible_shown_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->completed_shown, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& completed_shown_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->completed_shown, validation_context,
                                         &completed_shown_validate_params)) {
    return false;
  }

  return true;
}

NtpPromoHandler_OnPromosShown_Params_Data::NtpPromoHandler_OnPromosShown_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoHandler_OnPromoClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoHandler_OnPromoClicked_Params_Data* object =
      static_cast<const NtpPromoHandler_OnPromoClicked_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->promo_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& promo_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->promo_id, validation_context,
                                         &promo_id_validate_params)) {
    return false;
  }

  return true;
}

NtpPromoHandler_OnPromoClicked_Params_Data::NtpPromoHandler_OnPromoClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoHandler_SnoozeSetupList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoHandler_SnoozeSetupList_Params_Data* object =
      static_cast<const NtpPromoHandler_SnoozeSetupList_Params_Data*>(data);

  return true;
}

NtpPromoHandler_SnoozeSetupList_Params_Data::NtpPromoHandler_SnoozeSetupList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoHandler_UnsnoozeSetupList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoHandler_UnsnoozeSetupList_Params_Data* object =
      static_cast<const NtpPromoHandler_UnsnoozeSetupList_Params_Data*>(data);

  return true;
}

NtpPromoHandler_UnsnoozeSetupList_Params_Data::NtpPromoHandler_UnsnoozeSetupList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoHandler_DisableSetupList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoHandler_DisableSetupList_Params_Data* object =
      static_cast<const NtpPromoHandler_DisableSetupList_Params_Data*>(data);

  return true;
}

NtpPromoHandler_DisableSetupList_Params_Data::NtpPromoHandler_DisableSetupList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoHandler_UndisableSetupList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoHandler_UndisableSetupList_Params_Data* object =
      static_cast<const NtpPromoHandler_UndisableSetupList_Params_Data*>(data);

  return true;
}

NtpPromoHandler_UndisableSetupList_Params_Data::NtpPromoHandler_UndisableSetupList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoClient_SetPromos_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoClient_SetPromos_Params_Data* object =
      static_cast<const NtpPromoClient_SetPromos_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->eligible, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& eligible_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->eligible, validation_context,
                                         &eligible_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->completed, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& completed_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->completed, validation_context,
                                         &completed_validate_params)) {
    return false;
  }

  return true;
}

NtpPromoClient_SetPromos_Params_Data::NtpPromoClient_SetPromos_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data* object =
      static_cast<const NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data::NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ntp_promo

namespace perfetto {

// static
void TraceFormatTraits<::ntp_promo::mojom::ShowNtpPromosResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::ntp_promo::mojom::ShowNtpPromosResult value) {
  return std::move(context).WriteString(::ntp_promo::mojom::ShowNtpPromosResultToString(value));
}

} // namespace perfetto