// chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-params-data.h"
#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-import-headers.h"
#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-test-utils.h"


namespace new_tab_page::mojom {
BackgroundImage::BackgroundImage()
    : url(),
      url_2x(),
      attribution_url(),
      size(),
      repeat_x(),
      repeat_y(),
      position_x(),
      position_y(),
      image_source() {}

BackgroundImage::BackgroundImage(
    const ::GURL& url_in,
    const std::optional<::GURL>& url_2x_in,
    const std::optional<::GURL>& attribution_url_in,
    const std::optional<std::string>& size_in,
    const std::optional<std::string>& repeat_x_in,
    const std::optional<std::string>& repeat_y_in,
    const std::optional<std::string>& position_x_in,
    const std::optional<std::string>& position_y_in,
    NtpBackgroundImageSource image_source_in)
    : url(std::move(url_in)),
      url_2x(std::move(url_2x_in)),
      attribution_url(std::move(attribution_url_in)),
      size(std::move(size_in)),
      repeat_x(std::move(repeat_x_in)),
      repeat_y(std::move(repeat_y_in)),
      position_x(std::move(position_x_in)),
      position_y(std::move(position_y_in)),
      image_source(std::move(image_source_in)) {}

BackgroundImage::~BackgroundImage() = default;

void BackgroundImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_2x"), this->url_2x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_url"), this->attribution_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "repeat_x"), this->repeat_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "repeat_y"), this->repeat_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position_x"), this->position_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position_y"), this->position_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_source"), this->image_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NtpBackgroundImageSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackgroundImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Theme::Theme()
    : text_color(),
      background_color(),
      is_baseline(),
      is_custom_background(),
      daily_refresh_enabled(),
      is_dark(),
      logo_color(),
      background_image_collection_id(),
      background_image(),
      background_image_attribution_1(),
      background_image_attribution_2(),
      background_image_attribution_url(),
      most_visited() {}

Theme::Theme(
    ::SkColor text_color_in,
    ::SkColor background_color_in,
    bool is_baseline_in,
    bool is_custom_background_in,
    bool daily_refresh_enabled_in,
    bool is_dark_in,
    std::optional<::SkColor> logo_color_in,
    const std::optional<std::string>& background_image_collection_id_in,
    BackgroundImagePtr background_image_in,
    const std::optional<std::string>& background_image_attribution_1_in,
    const std::optional<std::string>& background_image_attribution_2_in,
    const std::optional<::GURL>& background_image_attribution_url_in,
    ::most_visited::mojom::MostVisitedThemePtr most_visited_in)
    : text_color(std::move(text_color_in)),
      background_color(std::move(background_color_in)),
      is_baseline(std::move(is_baseline_in)),
      is_custom_background(std::move(is_custom_background_in)),
      daily_refresh_enabled(std::move(daily_refresh_enabled_in)),
      is_dark(std::move(is_dark_in)),
      logo_color(std::move(logo_color_in)),
      background_image_collection_id(std::move(background_image_collection_id_in)),
      background_image(std::move(background_image_in)),
      background_image_attribution_1(std::move(background_image_attribution_1_in)),
      background_image_attribution_2(std::move(background_image_attribution_2_in)),
      background_image_attribution_url(std::move(background_image_attribution_url_in)),
      most_visited(std::move(most_visited_in)) {}

Theme::~Theme() = default;

void Theme::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_color"), this->text_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_baseline"), this->is_baseline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_custom_background"), this->is_custom_background,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "daily_refresh_enabled"), this->daily_refresh_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_dark"), this->is_dark,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logo_color"), this->logo_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::SkColor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image_collection_id"), this->background_image_collection_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image"), this->background_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BackgroundImagePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image_attribution_1"), this->background_image_attribution_1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image_attribution_2"), this->background_image_attribution_2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image_attribution_url"), this->background_image_attribution_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "most_visited"), this->most_visited,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::most_visited::mojom::MostVisitedThemePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Theme::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ImageDoodle::ImageDoodle()
    : image_url(),
      animation_url(),
      width(),
      height(),
      background_color(),
      image_impression_log_url(),
      animation_impression_log_url() {}

ImageDoodle::ImageDoodle(
    const ::GURL& image_url_in,
    const std::optional<::GURL>& animation_url_in,
    uint32_t width_in,
    uint32_t height_in,
    ::SkColor background_color_in,
    const ::GURL& image_impression_log_url_in,
    const std::optional<::GURL>& animation_impression_log_url_in)
    : image_url(std::move(image_url_in)),
      animation_url(std::move(animation_url_in)),
      width(std::move(width_in)),
      height(std::move(height_in)),
      background_color(std::move(background_color_in)),
      image_impression_log_url(std::move(image_impression_log_url_in)),
      animation_impression_log_url(std::move(animation_impression_log_url_in)) {}

ImageDoodle::~ImageDoodle() = default;

void ImageDoodle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_url"), this->image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "animation_url"), this->animation_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_impression_log_url"), this->image_impression_log_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "animation_impression_log_url"), this->animation_impression_log_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ImageDoodle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AllModeImageDoodle::AllModeImageDoodle()
    : light(),
      dark(),
      on_click_url(),
      share_url() {}

AllModeImageDoodle::AllModeImageDoodle(
    ImageDoodlePtr light_in,
    ImageDoodlePtr dark_in,
    const std::optional<::GURL>& on_click_url_in,
    const ::GURL& share_url_in)
    : light(std::move(light_in)),
      dark(std::move(dark_in)),
      on_click_url(std::move(on_click_url_in)),
      share_url(std::move(share_url_in)) {}

AllModeImageDoodle::~AllModeImageDoodle() = default;

void AllModeImageDoodle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "light"), this->light,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ImageDoodlePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dark"), this->dark,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ImageDoodlePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "on_click_url"), this->on_click_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "share_url"), this->share_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AllModeImageDoodle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InteractiveDoodle::InteractiveDoodle()
    : url(),
      width(),
      height() {}

InteractiveDoodle::InteractiveDoodle(
    const ::GURL& url_in,
    uint32_t width_in,
    uint32_t height_in)
    : url(std::move(url_in)),
      width(std::move(width_in)),
      height(std::move(height_in)) {}

InteractiveDoodle::~InteractiveDoodle() = default;

void InteractiveDoodle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InteractiveDoodle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Doodle::Doodle()
    : image(),
      interactive(),
      description() {}

Doodle::Doodle(
    AllModeImageDoodlePtr image_in,
    InteractiveDoodlePtr interactive_in,
    const std::string& description_in)
    : image(std::move(image_in)),
      interactive(std::move(interactive_in)),
      description(std::move(description_in)) {}

Doodle::~Doodle() = default;

void Doodle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image"), this->image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AllModeImageDoodlePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interactive"), this->interactive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InteractiveDoodlePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Doodle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PromoImagePart::PromoImagePart()
    : image_url(),
      target() {}

PromoImagePart::PromoImagePart(
    const ::GURL& image_url_in,
    const ::GURL& target_in)
    : image_url(std::move(image_url_in)),
      target(std::move(target_in)) {}

PromoImagePart::~PromoImagePart() = default;

void PromoImagePart::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_url"), this->image_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target"), this->target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PromoImagePart::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PromoLinkPart::PromoLinkPart()
    : text(),
      url() {}

PromoLinkPart::PromoLinkPart(
    const std::string& text_in,
    const ::GURL& url_in)
    : text(std::move(text_in)),
      url(std::move(url_in)) {}

PromoLinkPart::~PromoLinkPart() = default;

void PromoLinkPart::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PromoLinkPart::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PromoTextPart::PromoTextPart()
    : text() {}

PromoTextPart::PromoTextPart(
    const std::string& text_in)
    : text(std::move(text_in)) {}

PromoTextPart::~PromoTextPart() = default;
size_t PromoTextPart::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->text);
  return seed;
}

void PromoTextPart::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PromoTextPart::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Promo::Promo()
    : id(),
      log_url(),
      middle_slot_parts() {}

Promo::Promo(
    const std::optional<std::string>& id_in,
    const std::optional<::GURL>& log_url_in,
    std::vector<PromoPartPtr> middle_slot_parts_in)
    : id(std::move(id_in)),
      log_url(std::move(log_url_in)),
      middle_slot_parts(std::move(middle_slot_parts_in)) {}

Promo::~Promo() = default;

void Promo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "log_url"), this->log_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "middle_slot_parts"), this->middle_slot_parts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PromoPartPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Promo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ModuleIdName::ModuleIdName()
    : id(),
      name() {}

ModuleIdName::ModuleIdName(
    const std::string& id_in,
    const std::string& name_in)
    : id(std::move(id_in)),
      name(std::move(name_in)) {}

ModuleIdName::~ModuleIdName() = default;
size_t ModuleIdName::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->name);
  return seed;
}

void ModuleIdName::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ModuleIdName::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PromoPartPtr
PromoPart::NewImage(
    PromoImagePartPtr value) {
  return PromoPartPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kImage)>,
      std::move(value));
}

PromoPartPtr
PromoPart::NewLink(
    PromoLinkPartPtr value) {
  return PromoPartPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLink)>,
      std::move(value));
}

PromoPartPtr
PromoPart::NewText(
    PromoTextPartPtr value) {
  return PromoPartPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kText)>,
      std::move(value));
}

PromoPart::PromoPart(
    std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
    PromoImagePartPtr value)
    : tag_(Tag::kImage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kImage)>,
            std::move(value)) {}

PromoPart::PromoPart(
    std::in_place_index_t<static_cast<size_t>(Tag::kLink)>,
    PromoLinkPartPtr value)
    : tag_(Tag::kLink),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLink)>,
            std::move(value)) {}

PromoPart::PromoPart(
    std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
    PromoTextPartPtr value)
    : tag_(Tag::kText),
      data_(std::in_place_index<static_cast<size_t>(Tag::kText)>,
            std::move(value)) {}
PromoPart::~PromoPart() {
  DestroyActive();
}

void PromoPart::set_image(PromoImagePartPtr image) {
  if (tag_ == Tag::kImage) {
    data_.image = std::move(image);
  } else {
    DestroyActive();
    tag_ = Tag::kImage;
    new (&data_.image) PromoImagePartPtr(
        std::move(image));
  }
}

void PromoPart::set_link(PromoLinkPartPtr link) {
  if (tag_ == Tag::kLink) {
    data_.link = std::move(link);
  } else {
    DestroyActive();
    tag_ = Tag::kLink;
    new (&data_.link) PromoLinkPartPtr(
        std::move(link));
  }
}

void PromoPart::set_text(PromoTextPartPtr text) {
  if (tag_ == Tag::kText) {
    data_.text = std::move(text);
  } else {
    DestroyActive();
    tag_ = Tag::kText;
    new (&data_.text) PromoTextPartPtr(
        std::move(text));
  }
}


PromoPart::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
    PromoImagePartPtr value)
    : image(std::move(value)) {}

PromoPart::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLink)>,
    PromoLinkPartPtr value)
    : link(std::move(value)) {}

PromoPart::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
    PromoTextPartPtr value)
    : text(std::move(value)) {}

void PromoPart::DestroyActive() {
  switch (tag_) {

    case Tag::kImage:
      std::destroy_at(&data_.image);
      break;
    case Tag::kLink:
      std::destroy_at(&data_.link);
      break;
    case Tag::kText:
      std::destroy_at(&data_.text);
      break;
  }
}

bool PromoPart::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive new_tab_page::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply new_tab_page::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0dcb97ab;  // IPCStableHash for new_tab_page::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::new_tab_page::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::new_tab_page::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::new_tab_page::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kSetMostVisitedSettings: {
      return &PageHandler::SetMostVisitedSettings_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetMostVisitedSettings: {
      return &PageHandler::GetMostVisitedSettings_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetDoodle: {
      return &PageHandler::GetDoodle_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdatePromoData: {
      return &PageHandler::UpdatePromoData_Sym::IPCStableHash;
    }
    case messages::PageHandler::kBlocklistPromo: {
      return &PageHandler::BlocklistPromo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUndoBlocklistPromo: {
      return &PageHandler::UndoBlocklistPromo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnDismissModule: {
      return &PageHandler::OnDismissModule_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnRestoreModule: {
      return &PageHandler::OnRestoreModule_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetModulesVisible: {
      return &PageHandler::SetModulesVisible_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetModuleDisabled: {
      return &PageHandler::SetModuleDisabled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdateDisabledModules: {
      return &PageHandler::UpdateDisabledModules_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnModulesLoadedWithData: {
      return &PageHandler::OnModulesLoadedWithData_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnModuleUsed: {
      return &PageHandler::OnModuleUsed_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetModulesIdNames: {
      return &PageHandler::GetModulesIdNames_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetModulesEligibleForRemoval: {
      return &PageHandler::GetModulesEligibleForRemoval_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetModulesOrder: {
      return &PageHandler::SetModulesOrder_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetModulesOrder: {
      return &PageHandler::GetModulesOrder_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdateModulesLoadable: {
      return &PageHandler::UpdateModulesLoadable_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetModulesDisabled: {
      return &PageHandler::SetModulesDisabled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdateActionChipsVisibility: {
      return &PageHandler::UpdateActionChipsVisibility_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdateFooterVisibility: {
      return &PageHandler::UpdateFooterVisibility_Sym::IPCStableHash;
    }
    case messages::PageHandler::kIncrementComposeButtonShownCount: {
      return &PageHandler::IncrementComposeButtonShownCount_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMaybeTriggerAutomaticCustomizeChromePromo: {
      return &PageHandler::MaybeTriggerAutomaticCustomizeChromePromo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordContextMenuClick: {
      return &PageHandler::RecordContextMenuClick_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnOneGoogleBarRendered: {
      return &PageHandler::OnOneGoogleBarRendered_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnPromoRendered: {
      return &PageHandler::OnPromoRendered_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnCustomizeDialogAction: {
      return &PageHandler::OnCustomizeDialogAction_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnDoodleImageClicked: {
      return &PageHandler::OnDoodleImageClicked_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnDoodleImageRendered: {
      return &PageHandler::OnDoodleImageRendered_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnDoodleShared: {
      return &PageHandler::OnDoodleShared_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnPromoLinkClicked: {
      return &PageHandler::OnPromoLinkClicked_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnAppRendered: {
      return &PageHandler::OnAppRendered_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kSetMostVisitedSettings:
            return "Receive new_tab_page::mojom::PageHandler::SetMostVisitedSettings";
      case messages::PageHandler::kGetMostVisitedSettings:
            return "Receive new_tab_page::mojom::PageHandler::GetMostVisitedSettings";
      case messages::PageHandler::kGetDoodle:
            return "Receive new_tab_page::mojom::PageHandler::GetDoodle";
      case messages::PageHandler::kUpdatePromoData:
            return "Receive new_tab_page::mojom::PageHandler::UpdatePromoData";
      case messages::PageHandler::kBlocklistPromo:
            return "Receive new_tab_page::mojom::PageHandler::BlocklistPromo";
      case messages::PageHandler::kUndoBlocklistPromo:
            return "Receive new_tab_page::mojom::PageHandler::UndoBlocklistPromo";
      case messages::PageHandler::kOnDismissModule:
            return "Receive new_tab_page::mojom::PageHandler::OnDismissModule";
      case messages::PageHandler::kOnRestoreModule:
            return "Receive new_tab_page::mojom::PageHandler::OnRestoreModule";
      case messages::PageHandler::kSetModulesVisible:
            return "Receive new_tab_page::mojom::PageHandler::SetModulesVisible";
      case messages::PageHandler::kSetModuleDisabled:
            return "Receive new_tab_page::mojom::PageHandler::SetModuleDisabled";
      case messages::PageHandler::kUpdateDisabledModules:
            return "Receive new_tab_page::mojom::PageHandler::UpdateDisabledModules";
      case messages::PageHandler::kOnModulesLoadedWithData:
            return "Receive new_tab_page::mojom::PageHandler::OnModulesLoadedWithData";
      case messages::PageHandler::kOnModuleUsed:
            return "Receive new_tab_page::mojom::PageHandler::OnModuleUsed";
      case messages::PageHandler::kGetModulesIdNames:
            return "Receive new_tab_page::mojom::PageHandler::GetModulesIdNames";
      case messages::PageHandler::kGetModulesEligibleForRemoval:
            return "Receive new_tab_page::mojom::PageHandler::GetModulesEligibleForRemoval";
      case messages::PageHandler::kSetModulesOrder:
            return "Receive new_tab_page::mojom::PageHandler::SetModulesOrder";
      case messages::PageHandler::kGetModulesOrder:
            return "Receive new_tab_page::mojom::PageHandler::GetModulesOrder";
      case messages::PageHandler::kUpdateModulesLoadable:
            return "Receive new_tab_page::mojom::PageHandler::UpdateModulesLoadable";
      case messages::PageHandler::kSetModulesDisabled:
            return "Receive new_tab_page::mojom::PageHandler::SetModulesDisabled";
      case messages::PageHandler::kUpdateActionChipsVisibility:
            return "Receive new_tab_page::mojom::PageHandler::UpdateActionChipsVisibility";
      case messages::PageHandler::kUpdateFooterVisibility:
            return "Receive new_tab_page::mojom::PageHandler::UpdateFooterVisibility";
      case messages::PageHandler::kIncrementComposeButtonShownCount:
            return "Receive new_tab_page::mojom::PageHandler::IncrementComposeButtonShownCount";
      case messages::PageHandler::kMaybeTriggerAutomaticCustomizeChromePromo:
            return "Receive new_tab_page::mojom::PageHandler::MaybeTriggerAutomaticCustomizeChromePromo";
      case messages::PageHandler::kRecordContextMenuClick:
            return "Receive new_tab_page::mojom::PageHandler::RecordContextMenuClick";
      case messages::PageHandler::kOnOneGoogleBarRendered:
            return "Receive new_tab_page::mojom::PageHandler::OnOneGoogleBarRendered";
      case messages::PageHandler::kOnPromoRendered:
            return "Receive new_tab_page::mojom::PageHandler::OnPromoRendered";
      case messages::PageHandler::kOnCustomizeDialogAction:
            return "Receive new_tab_page::mojom::PageHandler::OnCustomizeDialogAction";
      case messages::PageHandler::kOnDoodleImageClicked:
            return "Receive new_tab_page::mojom::PageHandler::OnDoodleImageClicked";
      case messages::PageHandler::kOnDoodleImageRendered:
            return "Receive new_tab_page::mojom::PageHandler::OnDoodleImageRendered";
      case messages::PageHandler::kOnDoodleShared:
            return "Receive new_tab_page::mojom::PageHandler::OnDoodleShared";
      case messages::PageHandler::kOnPromoLinkClicked:
            return "Receive new_tab_page::mojom::PageHandler::OnPromoLinkClicked";
      case messages::PageHandler::kOnAppRendered:
            return "Receive new_tab_page::mojom::PageHandler::OnAppRendered";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kSetMostVisitedSettings:
            return "Receive reply new_tab_page::mojom::PageHandler::SetMostVisitedSettings";
      case messages::PageHandler::kGetMostVisitedSettings:
            return "Receive reply new_tab_page::mojom::PageHandler::GetMostVisitedSettings";
      case messages::PageHandler::kGetDoodle:
            return "Receive reply new_tab_page::mojom::PageHandler::GetDoodle";
      case messages::PageHandler::kUpdatePromoData:
            return "Receive reply new_tab_page::mojom::PageHandler::UpdatePromoData";
      case messages::PageHandler::kBlocklistPromo:
            return "Receive reply new_tab_page::mojom::PageHandler::BlocklistPromo";
      case messages::PageHandler::kUndoBlocklistPromo:
            return "Receive reply new_tab_page::mojom::PageHandler::UndoBlocklistPromo";
      case messages::PageHandler::kOnDismissModule:
            return "Receive reply new_tab_page::mojom::PageHandler::OnDismissModule";
      case messages::PageHandler::kOnRestoreModule:
            return "Receive reply new_tab_page::mojom::PageHandler::OnRestoreModule";
      case messages::PageHandler::kSetModulesVisible:
            return "Receive reply new_tab_page::mojom::PageHandler::SetModulesVisible";
      case messages::PageHandler::kSetModuleDisabled:
            return "Receive reply new_tab_page::mojom::PageHandler::SetModuleDisabled";
      case messages::PageHandler::kUpdateDisabledModules:
            return "Receive reply new_tab_page::mojom::PageHandler::UpdateDisabledModules";
      case messages::PageHandler::kOnModulesLoadedWithData:
            return "Receive reply new_tab_page::mojom::PageHandler::OnModulesLoadedWithData";
      case messages::PageHandler::kOnModuleUsed:
            return "Receive reply new_tab_page::mojom::PageHandler::OnModuleUsed";
      case messages::PageHandler::kGetModulesIdNames:
            return "Receive reply new_tab_page::mojom::PageHandler::GetModulesIdNames";
      case messages::PageHandler::kGetModulesEligibleForRemoval:
            return "Receive reply new_tab_page::mojom::PageHandler::GetModulesEligibleForRemoval";
      case messages::PageHandler::kSetModulesOrder:
            return "Receive reply new_tab_page::mojom::PageHandler::SetModulesOrder";
      case messages::PageHandler::kGetModulesOrder:
            return "Receive reply new_tab_page::mojom::PageHandler::GetModulesOrder";
      case messages::PageHandler::kUpdateModulesLoadable:
            return "Receive reply new_tab_page::mojom::PageHandler::UpdateModulesLoadable";
      case messages::PageHandler::kSetModulesDisabled:
            return "Receive reply new_tab_page::mojom::PageHandler::SetModulesDisabled";
      case messages::PageHandler::kUpdateActionChipsVisibility:
            return "Receive reply new_tab_page::mojom::PageHandler::UpdateActionChipsVisibility";
      case messages::PageHandler::kUpdateFooterVisibility:
            return "Receive reply new_tab_page::mojom::PageHandler::UpdateFooterVisibility";
      case messages::PageHandler::kIncrementComposeButtonShownCount:
            return "Receive reply new_tab_page::mojom::PageHandler::IncrementComposeButtonShownCount";
      case messages::PageHandler::kMaybeTriggerAutomaticCustomizeChromePromo:
            return "Receive reply new_tab_page::mojom::PageHandler::MaybeTriggerAutomaticCustomizeChromePromo";
      case messages::PageHandler::kRecordContextMenuClick:
            return "Receive reply new_tab_page::mojom::PageHandler::RecordContextMenuClick";
      case messages::PageHandler::kOnOneGoogleBarRendered:
            return "Receive reply new_tab_page::mojom::PageHandler::OnOneGoogleBarRendered";
      case messages::PageHandler::kOnPromoRendered:
            return "Receive reply new_tab_page::mojom::PageHandler::OnPromoRendered";
      case messages::PageHandler::kOnCustomizeDialogAction:
            return "Receive reply new_tab_page::mojom::PageHandler::OnCustomizeDialogAction";
      case messages::PageHandler::kOnDoodleImageClicked:
            return "Receive reply new_tab_page::mojom::PageHandler::OnDoodleImageClicked";
      case messages::PageHandler::kOnDoodleImageRendered:
            return "Receive reply new_tab_page::mojom::PageHandler::OnDoodleImageRendered";
      case messages::PageHandler::kOnDoodleShared:
            return "Receive reply new_tab_page::mojom::PageHandler::OnDoodleShared";
      case messages::PageHandler::kOnPromoLinkClicked:
            return "Receive reply new_tab_page::mojom::PageHandler::OnPromoLinkClicked";
      case messages::PageHandler::kOnAppRendered:
            return "Receive reply new_tab_page::mojom::PageHandler::OnAppRendered";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::SetMostVisitedSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5578a407;  // IPCStableHash for new_tab_page::mojom::PageHandler::SetMostVisitedSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetMostVisitedSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3f3e534;  // IPCStableHash for new_tab_page::mojom::PageHandler::GetMostVisitedSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetDoodle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe829714;  // IPCStableHash for new_tab_page::mojom::PageHandler::GetDoodle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdatePromoData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c7fce9b;  // IPCStableHash for new_tab_page::mojom::PageHandler::UpdatePromoData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::BlocklistPromo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x798eb556;  // IPCStableHash for new_tab_page::mojom::PageHandler::BlocklistPromo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UndoBlocklistPromo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f0e8acc;  // IPCStableHash for new_tab_page::mojom::PageHandler::UndoBlocklistPromo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnDismissModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28e2ca60;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnDismissModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnRestoreModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3dcf9d03;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnRestoreModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetModulesVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43253ecd;  // IPCStableHash for new_tab_page::mojom::PageHandler::SetModulesVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetModuleDisabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba39d942;  // IPCStableHash for new_tab_page::mojom::PageHandler::SetModuleDisabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdateDisabledModules_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x68162ae7;  // IPCStableHash for new_tab_page::mojom::PageHandler::UpdateDisabledModules
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnModulesLoadedWithData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16bbb112;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnModulesLoadedWithData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnModuleUsed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf84053f3;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnModuleUsed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetModulesIdNames_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x317db428;  // IPCStableHash for new_tab_page::mojom::PageHandler::GetModulesIdNames
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetModulesEligibleForRemoval_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7da9ae4;  // IPCStableHash for new_tab_page::mojom::PageHandler::GetModulesEligibleForRemoval
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetModulesOrder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdde00d25;  // IPCStableHash for new_tab_page::mojom::PageHandler::SetModulesOrder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetModulesOrder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee3b90fb;  // IPCStableHash for new_tab_page::mojom::PageHandler::GetModulesOrder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdateModulesLoadable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x248c77a7;  // IPCStableHash for new_tab_page::mojom::PageHandler::UpdateModulesLoadable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetModulesDisabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d22b026;  // IPCStableHash for new_tab_page::mojom::PageHandler::SetModulesDisabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdateActionChipsVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ab2365f;  // IPCStableHash for new_tab_page::mojom::PageHandler::UpdateActionChipsVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdateFooterVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d94212c;  // IPCStableHash for new_tab_page::mojom::PageHandler::UpdateFooterVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::IncrementComposeButtonShownCount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85b29efa;  // IPCStableHash for new_tab_page::mojom::PageHandler::IncrementComposeButtonShownCount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::MaybeTriggerAutomaticCustomizeChromePromo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xebb2a148;  // IPCStableHash for new_tab_page::mojom::PageHandler::MaybeTriggerAutomaticCustomizeChromePromo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordContextMenuClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c38db81;  // IPCStableHash for new_tab_page::mojom::PageHandler::RecordContextMenuClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnOneGoogleBarRendered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x801d652d;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnOneGoogleBarRendered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnPromoRendered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb988292;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnPromoRendered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnCustomizeDialogAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11a617a4;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnCustomizeDialogAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnDoodleImageClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdd7f7fdc;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnDoodleImageClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnDoodleImageRendered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x688496a8;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnDoodleImageRendered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnDoodleShared_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2120657;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnDoodleShared
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnPromoLinkClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x427a87d8;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnPromoLinkClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnAppRendered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a7c4ba3;  // IPCStableHash for new_tab_page::mojom::PageHandler::OnAppRendered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetMostVisitedSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetMostVisitedSettings_ForwardToCallback(
      PageHandler::GetMostVisitedSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetMostVisitedSettings_ForwardToCallback(const PageHandler_GetMostVisitedSettings_ForwardToCallback&) = delete;
  PageHandler_GetMostVisitedSettings_ForwardToCallback& operator=(const PageHandler_GetMostVisitedSettings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetMostVisitedSettingsCallback callback_;
};

class PageHandler_GetDoodle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetDoodle_ForwardToCallback(
      PageHandler::GetDoodleCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetDoodle_ForwardToCallback(const PageHandler_GetDoodle_ForwardToCallback&) = delete;
  PageHandler_GetDoodle_ForwardToCallback& operator=(const PageHandler_GetDoodle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetDoodleCallback callback_;
};

class PageHandler_GetModulesIdNames_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetModulesIdNames_ForwardToCallback(
      PageHandler::GetModulesIdNamesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetModulesIdNames_ForwardToCallback(const PageHandler_GetModulesIdNames_ForwardToCallback&) = delete;
  PageHandler_GetModulesIdNames_ForwardToCallback& operator=(const PageHandler_GetModulesIdNames_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetModulesIdNamesCallback callback_;
};

class PageHandler_GetModulesEligibleForRemoval_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetModulesEligibleForRemoval_ForwardToCallback(
      PageHandler::GetModulesEligibleForRemovalCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetModulesEligibleForRemoval_ForwardToCallback(const PageHandler_GetModulesEligibleForRemoval_ForwardToCallback&) = delete;
  PageHandler_GetModulesEligibleForRemoval_ForwardToCallback& operator=(const PageHandler_GetModulesEligibleForRemoval_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetModulesEligibleForRemovalCallback callback_;
};

class PageHandler_GetModulesOrder_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetModulesOrder_ForwardToCallback(
      PageHandler::GetModulesOrderCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetModulesOrder_ForwardToCallback(const PageHandler_GetModulesOrder_ForwardToCallback&) = delete;
  PageHandler_GetModulesOrder_ForwardToCallback& operator=(const PageHandler_GetModulesOrder_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetModulesOrderCallback callback_;
};

class PageHandler_OnDoodleImageRendered_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_OnDoodleImageRendered_ForwardToCallback(
      PageHandler::OnDoodleImageRenderedCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_OnDoodleImageRendered_ForwardToCallback(const PageHandler_OnDoodleImageRendered_ForwardToCallback&) = delete;
  PageHandler_OnDoodleImageRendered_ForwardToCallback& operator=(const PageHandler_OnDoodleImageRendered_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::OnDoodleImageRenderedCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::SetMostVisitedSettings(
    ::ntp_tiles::mojom::TileType in_shortcuts_type, bool in_shortcuts_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::SetMostVisitedSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcuts_type"), in_shortcuts_type,
                        "<value of type ::ntp_tiles::mojom::TileType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcuts_visible"), in_shortcuts_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetMostVisitedSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_SetMostVisitedSettings_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ntp_tiles::mojom::TileType>(
    in_shortcuts_type,
    &params->shortcuts_type);

  params->shortcuts_visible = in_shortcuts_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetMostVisitedSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetMostVisitedSettings(
    GetMostVisitedSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::GetMostVisitedSettings");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetMostVisitedSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetMostVisitedSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetMostVisitedSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetMostVisitedSettings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetDoodle(
    GetDoodleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::GetDoodle");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDoodle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetDoodle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDoodle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetDoodle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::UpdatePromoData(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::UpdatePromoData");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdatePromoData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_UpdatePromoData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdatePromoData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::BlocklistPromo(
    const std::string& in_promo_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::BlocklistPromo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("promo_id"), in_promo_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kBlocklistPromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_BlocklistPromo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->promo_id)::BaseType> promo_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_promo_id,
    promo_id_fragment);

  params->promo_id.Set(
      promo_id_fragment.is_null() ? nullptr : promo_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->promo_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null promo_id in PageHandler.BlocklistPromo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("BlocklistPromo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UndoBlocklistPromo(
    const std::string& in_promo_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::UndoBlocklistPromo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("promo_id"), in_promo_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUndoBlocklistPromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_UndoBlocklistPromo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->promo_id)::BaseType> promo_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_promo_id,
    promo_id_fragment);

  params->promo_id.Set(
      promo_id_fragment.is_null() ? nullptr : promo_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->promo_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null promo_id in PageHandler.UndoBlocklistPromo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UndoBlocklistPromo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnDismissModule(
    const std::string& in_module_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnDismissModule", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_id"), in_module_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnDismissModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnDismissModule_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_id)::BaseType> module_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_id,
    module_id_fragment);

  params->module_id.Set(
      module_id_fragment.is_null() ? nullptr : module_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_id in PageHandler.OnDismissModule request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnDismissModule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnRestoreModule(
    const std::string& in_module_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnRestoreModule", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_id"), in_module_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnRestoreModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnRestoreModule_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_id)::BaseType> module_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_id,
    module_id_fragment);

  params->module_id.Set(
      module_id_fragment.is_null() ? nullptr : module_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_id in PageHandler.OnRestoreModule request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnRestoreModule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetModulesVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::SetModulesVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetModulesVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_SetModulesVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetModulesVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetModuleDisabled(
    const std::string& in_module_id, bool in_disabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::SetModuleDisabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_id"), in_module_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disabled"), in_disabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetModuleDisabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_SetModuleDisabled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_id)::BaseType> module_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_id,
    module_id_fragment);

  params->module_id.Set(
      module_id_fragment.is_null() ? nullptr : module_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_id in PageHandler.SetModuleDisabled request");

  params->disabled = in_disabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetModuleDisabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UpdateDisabledModules(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::UpdateDisabledModules");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateDisabledModules), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_UpdateDisabledModules_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateDisabledModules");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnModulesLoadedWithData(
    const std::vector<std::string>& in_module_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnModulesLoadedWithData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_ids"), in_module_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnModulesLoadedWithData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnModulesLoadedWithData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_ids)::BaseType>
      module_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& module_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_module_ids,
    module_ids_fragment,
    &module_ids_validate_params);

  params->module_ids.Set(
      module_ids_fragment.is_null() ? nullptr : module_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_ids in PageHandler.OnModulesLoadedWithData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnModulesLoadedWithData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnModuleUsed(
    const std::string& in_module_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnModuleUsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_id"), in_module_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnModuleUsed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnModuleUsed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_id)::BaseType> module_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_id,
    module_id_fragment);

  params->module_id.Set(
      module_id_fragment.is_null() ? nullptr : module_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_id in PageHandler.OnModuleUsed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnModuleUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetModulesIdNames(
    GetModulesIdNamesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::GetModulesIdNames");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetModulesIdNames), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetModulesIdNames_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetModulesIdNames");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetModulesIdNames_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetModulesEligibleForRemoval(
    GetModulesEligibleForRemovalCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::GetModulesEligibleForRemoval");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetModulesEligibleForRemoval), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetModulesEligibleForRemoval_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetModulesEligibleForRemoval");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetModulesEligibleForRemoval_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetModulesOrder(
    const std::vector<std::string>& in_module_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::SetModulesOrder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_ids"), in_module_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetModulesOrder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_SetModulesOrder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_ids)::BaseType>
      module_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& module_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_module_ids,
    module_ids_fragment,
    &module_ids_validate_params);

  params->module_ids.Set(
      module_ids_fragment.is_null() ? nullptr : module_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_ids in PageHandler.SetModulesOrder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetModulesOrder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetModulesOrder(
    GetModulesOrderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::GetModulesOrder");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetModulesOrder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetModulesOrder_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetModulesOrder");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetModulesOrder_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::UpdateModulesLoadable(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::UpdateModulesLoadable");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateModulesLoadable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_UpdateModulesLoadable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateModulesLoadable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetModulesDisabled(
    const std::vector<std::string>& in_module_ids, bool in_disabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::SetModulesDisabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_ids"), in_module_ids,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disabled"), in_disabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetModulesDisabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_SetModulesDisabled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_ids)::BaseType>
      module_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& module_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_module_ids,
    module_ids_fragment,
    &module_ids_validate_params);

  params->module_ids.Set(
      module_ids_fragment.is_null() ? nullptr : module_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_ids in PageHandler.SetModulesDisabled request");

  params->disabled = in_disabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetModulesDisabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UpdateActionChipsVisibility(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::UpdateActionChipsVisibility");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateActionChipsVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_UpdateActionChipsVisibility_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateActionChipsVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UpdateFooterVisibility(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::UpdateFooterVisibility");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateFooterVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_UpdateFooterVisibility_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateFooterVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::IncrementComposeButtonShownCount(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::IncrementComposeButtonShownCount");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIncrementComposeButtonShownCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_IncrementComposeButtonShownCount_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IncrementComposeButtonShownCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::MaybeTriggerAutomaticCustomizeChromePromo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::MaybeTriggerAutomaticCustomizeChromePromo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMaybeTriggerAutomaticCustomizeChromePromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("MaybeTriggerAutomaticCustomizeChromePromo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordContextMenuClick(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::RecordContextMenuClick");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordContextMenuClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_RecordContextMenuClick_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordContextMenuClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnOneGoogleBarRendered(
    double in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnOneGoogleBarRendered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnOneGoogleBarRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnOneGoogleBarRendered_Params_Data> params(
          message);
  params.Allocate();

  params->time = in_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnOneGoogleBarRendered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnPromoRendered(
    double in_time, const std::optional<::GURL>& in_log_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnPromoRendered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_url"), in_log_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnPromoRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnPromoRendered_Params_Data> params(
          message);
  params.Allocate();

  params->time = in_time;
  mojo::internal::MessageFragment<
      typename decltype(params->log_url)::BaseType> log_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_log_url,
    log_url_fragment);

  params->log_url.Set(
      log_url_fragment.is_null() ? nullptr : log_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnPromoRendered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnCustomizeDialogAction(
    CustomizeDialogAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnCustomizeDialogAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type CustomizeDialogAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnCustomizeDialogAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnCustomizeDialogAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::new_tab_page::mojom::CustomizeDialogAction>(
    in_action,
    &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnCustomizeDialogAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnDoodleImageClicked(
    DoodleImageType in_type, const std::optional<::GURL>& in_log_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnDoodleImageClicked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type DoodleImageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_url"), in_log_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnDoodleImageClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnDoodleImageClicked_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::new_tab_page::mojom::DoodleImageType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->log_url)::BaseType> log_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_log_url,
    log_url_fragment);

  params->log_url.Set(
      log_url_fragment.is_null() ? nullptr : log_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnDoodleImageClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnDoodleImageRendered(
    DoodleImageType in_type, double in_time, const ::GURL& in_log_url, OnDoodleImageRenderedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnDoodleImageRendered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type DoodleImageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_url"), in_log_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnDoodleImageRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnDoodleImageRendered_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::new_tab_page::mojom::DoodleImageType>(
    in_type,
    &params->type);

  params->time = in_time;
  mojo::internal::MessageFragment<
      typename decltype(params->log_url)::BaseType> log_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_log_url,
    log_url_fragment);

  params->log_url.Set(
      log_url_fragment.is_null() ? nullptr : log_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->log_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null log_url in PageHandler.OnDoodleImageRendered request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnDoodleImageRendered");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_OnDoodleImageRendered_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OnDoodleShared(
    DoodleShareChannel in_channel, const std::string& in_doodle_id, const std::optional<std::string>& in_share_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnDoodleShared", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel"), in_channel,
                        "<value of type DoodleShareChannel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("doodle_id"), in_doodle_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("share_id"), in_share_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnDoodleShared), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnDoodleShared_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::new_tab_page::mojom::DoodleShareChannel>(
    in_channel,
    &params->channel);
  mojo::internal::MessageFragment<
      typename decltype(params->doodle_id)::BaseType> doodle_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_doodle_id,
    doodle_id_fragment);

  params->doodle_id.Set(
      doodle_id_fragment.is_null() ? nullptr : doodle_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->doodle_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null doodle_id in PageHandler.OnDoodleShared request");
  mojo::internal::MessageFragment<
      typename decltype(params->share_id)::BaseType> share_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_share_id,
    share_id_fragment);

  params->share_id.Set(
      share_id_fragment.is_null() ? nullptr : share_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnDoodleShared");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnPromoLinkClicked(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::PageHandler::OnPromoLinkClicked");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnPromoLinkClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnPromoLinkClicked_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnPromoLinkClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnAppRendered(
    double in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::PageHandler::OnAppRendered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnAppRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnAppRendered_Params_Data> params(
          message);
  params.Allocate();

  params->time = in_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnAppRendered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetMostVisitedSettings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetMostVisitedSettingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetMostVisitedSettings_ProxyToResponder> proxy(
        new PageHandler_GetMostVisitedSettings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetMostVisitedSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetMostVisitedSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetMostVisitedSettings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetMostVisitedSettingsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::ntp_tiles::mojom::TileType in_shortcuts_type, bool in_shortcuts_visible);
};

bool PageHandler_GetMostVisitedSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetMostVisitedSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetMostVisitedSettings_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  ::ntp_tiles::mojom::TileType p_shortcuts_type{};
  bool p_shortcuts_visible{};
  PageHandler_GetMostVisitedSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadShortcutsType(&p_shortcuts_type))
    success = false;
  if (success)
    p_shortcuts_visible = input_data_view.shortcuts_visible();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_shortcuts_type), 
std::move(p_shortcuts_visible));
  }
  return true;
}

void PageHandler_GetMostVisitedSettings_ProxyToResponder::Run(
    ::ntp_tiles::mojom::TileType in_shortcuts_type, bool in_shortcuts_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply new_tab_page::mojom::PageHandler::GetMostVisitedSettings", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcuts_type"), in_shortcuts_type,
                        "<value of type ::ntp_tiles::mojom::TileType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shortcuts_visible"), in_shortcuts_visible,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetMostVisitedSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetMostVisitedSettings_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ntp_tiles::mojom::TileType>(
    in_shortcuts_type,
    &params->shortcuts_type);

  params->shortcuts_visible = in_shortcuts_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetMostVisitedSettings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetDoodle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetDoodleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetDoodle_ProxyToResponder> proxy(
        new PageHandler_GetDoodle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetDoodle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetDoodle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetDoodle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetDoodleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DoodlePtr in_doodle);
};

bool PageHandler_GetDoodle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetDoodle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetDoodle_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  DoodlePtr p_doodle{};
  PageHandler_GetDoodle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDoodle(&p_doodle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_doodle));
  }
  return true;
}

void PageHandler_GetDoodle_ProxyToResponder::Run(
    DoodlePtr in_doodle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply new_tab_page::mojom::PageHandler::GetDoodle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("doodle"), in_doodle,
                        "<value of type DoodlePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDoodle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetDoodle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->doodle)::BaseType> doodle_fragment(
          params.message());
  
  mojo::internal::Serialize<::new_tab_page::mojom::DoodleDataView>(
    in_doodle,
    doodle_fragment);

  params->doodle.Set(
      doodle_fragment.is_null() ? nullptr : doodle_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDoodle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetModulesIdNames_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetModulesIdNamesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetModulesIdNames_ProxyToResponder> proxy(
        new PageHandler_GetModulesIdNames_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetModulesIdNames_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetModulesIdNames_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetModulesIdNames_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetModulesIdNamesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ModuleIdNamePtr> in_data);
};

bool PageHandler_GetModulesIdNames_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetModulesIdNames_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetModulesIdNames_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.13
  bool success = true;
  std::vector<ModuleIdNamePtr> p_data{};
  PageHandler_GetModulesIdNames_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void PageHandler_GetModulesIdNames_ProxyToResponder::Run(
    std::vector<ModuleIdNamePtr> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply new_tab_page::mojom::PageHandler::GetModulesIdNames", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type std::vector<ModuleIdNamePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetModulesIdNames), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetModulesIdNames_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::new_tab_page::mojom::ModuleIdNameDataView>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetModulesIdNames");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetModulesEligibleForRemoval_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetModulesEligibleForRemovalCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetModulesEligibleForRemoval_ProxyToResponder> proxy(
        new PageHandler_GetModulesEligibleForRemoval_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetModulesEligibleForRemoval_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetModulesEligibleForRemoval_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetModulesEligibleForRemoval_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetModulesEligibleForRemovalCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_module_ids);
};

bool PageHandler_GetModulesEligibleForRemoval_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetModulesEligibleForRemoval_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetModulesEligibleForRemoval_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.14
  bool success = true;
  std::vector<std::string> p_module_ids{};
  PageHandler_GetModulesEligibleForRemoval_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadModuleIds(&p_module_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_module_ids));
  }
  return true;
}

void PageHandler_GetModulesEligibleForRemoval_ProxyToResponder::Run(
    const std::vector<std::string>& in_module_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply new_tab_page::mojom::PageHandler::GetModulesEligibleForRemoval", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_ids"), in_module_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetModulesEligibleForRemoval), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetModulesEligibleForRemoval_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_ids)::BaseType>
      module_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& module_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_module_ids,
    module_ids_fragment,
    &module_ids_validate_params);

  params->module_ids.Set(
      module_ids_fragment.is_null() ? nullptr : module_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetModulesEligibleForRemoval");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetModulesOrder_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetModulesOrderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetModulesOrder_ProxyToResponder> proxy(
        new PageHandler_GetModulesOrder_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetModulesOrder_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetModulesOrder_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetModulesOrder_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetModulesOrderCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_module_ids);
};

bool PageHandler_GetModulesOrder_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetModulesOrder_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetModulesOrder_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.16
  bool success = true;
  std::vector<std::string> p_module_ids{};
  PageHandler_GetModulesOrder_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadModuleIds(&p_module_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_module_ids));
  }
  return true;
}

void PageHandler_GetModulesOrder_ProxyToResponder::Run(
    const std::vector<std::string>& in_module_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply new_tab_page::mojom::PageHandler::GetModulesOrder", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_ids"), in_module_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetModulesOrder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_GetModulesOrder_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_ids)::BaseType>
      module_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& module_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_module_ids,
    module_ids_fragment,
    &module_ids_validate_params);

  params->module_ids.Set(
      module_ids_fragment.is_null() ? nullptr : module_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetModulesOrder");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_OnDoodleImageRendered_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::OnDoodleImageRenderedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_OnDoodleImageRendered_ProxyToResponder> proxy(
        new PageHandler_OnDoodleImageRendered_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_OnDoodleImageRendered_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_OnDoodleImageRendered_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_OnDoodleImageRendered_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::OnDoodleImageRenderedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_image_click_params, const std::optional<::GURL>& in_interaction_log_url, const std::optional<std::string>& in_share_id);
};

bool PageHandler_OnDoodleImageRendered_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_OnDoodleImageRendered_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_OnDoodleImageRendered_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.28
  bool success = true;
  std::optional<std::string> p_image_click_params{};
  std::optional<::GURL> p_interaction_log_url{};
  std::optional<std::string> p_share_id{};
  PageHandler_OnDoodleImageRendered_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImageClickParams(&p_image_click_params))
    success = false;
  if (success && !input_data_view.ReadInteractionLogUrl(&p_interaction_log_url))
    success = false;
  if (success && !input_data_view.ReadShareId(&p_share_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 28, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_image_click_params), 
std::move(p_interaction_log_url), 
std::move(p_share_id));
  }
  return true;
}

void PageHandler_OnDoodleImageRendered_ProxyToResponder::Run(
    const std::optional<std::string>& in_image_click_params, const std::optional<::GURL>& in_interaction_log_url, const std::optional<std::string>& in_share_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply new_tab_page::mojom::PageHandler::OnDoodleImageRendered", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_click_params"), in_image_click_params,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interaction_log_url"), in_interaction_log_url,
                        "<value of type const std::optional<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("share_id"), in_share_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnDoodleImageRendered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::PageHandler_OnDoodleImageRendered_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image_click_params)::BaseType> image_click_params_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_image_click_params,
    image_click_params_fragment);

  params->image_click_params.Set(
      image_click_params_fragment.is_null() ? nullptr : image_click_params_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->interaction_log_url)::BaseType> interaction_log_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_interaction_log_url,
    interaction_log_url_fragment);

  params->interaction_log_url.Set(
      interaction_log_url_fragment.is_null() ? nullptr : interaction_log_url_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->share_id)::BaseType> share_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_share_id,
    share_id_fragment);

  params->share_id.Set(
      share_id_fragment.is_null() ? nullptr : share_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnDoodleImageRendered");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kSetMostVisitedSettings: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetMostVisitedSettings_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetMostVisitedSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::ntp_tiles::mojom::TileType p_shortcuts_type{};
      bool p_shortcuts_visible{};
      PageHandler_SetMostVisitedSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadShortcutsType(&p_shortcuts_type))
        success = false;
      if (success)
        p_shortcuts_visible = input_data_view.shortcuts_visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMostVisitedSettings(        
        std::move(p_shortcuts_type), 
        std::move(p_shortcuts_visible));
      return true;
    }
    case messages::PageHandler::kGetMostVisitedSettings: {
      break;
    }
    case messages::PageHandler::kGetDoodle: {
      break;
    }
    case messages::PageHandler::kUpdatePromoData: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdatePromoData_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdatePromoData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_UpdatePromoData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePromoData(        );
      return true;
    }
    case messages::PageHandler::kBlocklistPromo: {
      DCHECK(message->is_serialized());
      internal::PageHandler_BlocklistPromo_Params_Data* params =
          reinterpret_cast<internal::PageHandler_BlocklistPromo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_promo_id{};
      PageHandler_BlocklistPromo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPromoId(&p_promo_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BlocklistPromo(        
        std::move(p_promo_id));
      return true;
    }
    case messages::PageHandler::kUndoBlocklistPromo: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UndoBlocklistPromo_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UndoBlocklistPromo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      std::string p_promo_id{};
      PageHandler_UndoBlocklistPromo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPromoId(&p_promo_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UndoBlocklistPromo(        
        std::move(p_promo_id));
      return true;
    }
    case messages::PageHandler::kOnDismissModule: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnDismissModule_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnDismissModule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      std::string p_module_id{};
      PageHandler_OnDismissModule_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleId(&p_module_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDismissModule(        
        std::move(p_module_id));
      return true;
    }
    case messages::PageHandler::kOnRestoreModule: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnRestoreModule_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnRestoreModule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      std::string p_module_id{};
      PageHandler_OnRestoreModule_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleId(&p_module_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRestoreModule(        
        std::move(p_module_id));
      return true;
    }
    case messages::PageHandler::kSetModulesVisible: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetModulesVisible_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetModulesVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      bool p_visible{};
      PageHandler_SetModulesVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModulesVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::PageHandler::kSetModuleDisabled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetModuleDisabled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetModuleDisabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      std::string p_module_id{};
      bool p_disabled{};
      PageHandler_SetModuleDisabled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleId(&p_module_id))
        success = false;
      if (success)
        p_disabled = input_data_view.disabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModuleDisabled(        
        std::move(p_module_id), 
        std::move(p_disabled));
      return true;
    }
    case messages::PageHandler::kUpdateDisabledModules: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateDisabledModules_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateDisabledModules_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      PageHandler_UpdateDisabledModules_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDisabledModules(        );
      return true;
    }
    case messages::PageHandler::kOnModulesLoadedWithData: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnModulesLoadedWithData_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnModulesLoadedWithData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      std::vector<std::string> p_module_ids{};
      PageHandler_OnModulesLoadedWithData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleIds(&p_module_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnModulesLoadedWithData(        
        std::move(p_module_ids));
      return true;
    }
    case messages::PageHandler::kOnModuleUsed: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnModuleUsed_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnModuleUsed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      std::string p_module_id{};
      PageHandler_OnModuleUsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleId(&p_module_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnModuleUsed(        
        std::move(p_module_id));
      return true;
    }
    case messages::PageHandler::kGetModulesIdNames: {
      break;
    }
    case messages::PageHandler::kGetModulesEligibleForRemoval: {
      break;
    }
    case messages::PageHandler::kSetModulesOrder: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetModulesOrder_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetModulesOrder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      std::vector<std::string> p_module_ids{};
      PageHandler_SetModulesOrder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleIds(&p_module_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModulesOrder(        
        std::move(p_module_ids));
      return true;
    }
    case messages::PageHandler::kGetModulesOrder: {
      break;
    }
    case messages::PageHandler::kUpdateModulesLoadable: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateModulesLoadable_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateModulesLoadable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.17
      bool success = true;
      PageHandler_UpdateModulesLoadable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateModulesLoadable(        );
      return true;
    }
    case messages::PageHandler::kSetModulesDisabled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetModulesDisabled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetModulesDisabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.18
      bool success = true;
      std::vector<std::string> p_module_ids{};
      bool p_disabled{};
      PageHandler_SetModulesDisabled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleIds(&p_module_ids))
        success = false;
      if (success)
        p_disabled = input_data_view.disabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModulesDisabled(        
        std::move(p_module_ids), 
        std::move(p_disabled));
      return true;
    }
    case messages::PageHandler::kUpdateActionChipsVisibility: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateActionChipsVisibility_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateActionChipsVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.19
      bool success = true;
      PageHandler_UpdateActionChipsVisibility_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateActionChipsVisibility(        );
      return true;
    }
    case messages::PageHandler::kUpdateFooterVisibility: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateFooterVisibility_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateFooterVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.20
      bool success = true;
      PageHandler_UpdateFooterVisibility_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateFooterVisibility(        );
      return true;
    }
    case messages::PageHandler::kIncrementComposeButtonShownCount: {
      DCHECK(message->is_serialized());
      internal::PageHandler_IncrementComposeButtonShownCount_Params_Data* params =
          reinterpret_cast<internal::PageHandler_IncrementComposeButtonShownCount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.21
      bool success = true;
      PageHandler_IncrementComposeButtonShownCount_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IncrementComposeButtonShownCount(        );
      return true;
    }
    case messages::PageHandler::kMaybeTriggerAutomaticCustomizeChromePromo: {
      DCHECK(message->is_serialized());
      internal::PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_Params_Data* params =
          reinterpret_cast<internal::PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.22
      bool success = true;
      PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeTriggerAutomaticCustomizeChromePromo(        );
      return true;
    }
    case messages::PageHandler::kRecordContextMenuClick: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordContextMenuClick_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordContextMenuClick_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.23
      bool success = true;
      PageHandler_RecordContextMenuClick_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordContextMenuClick(        );
      return true;
    }
    case messages::PageHandler::kOnOneGoogleBarRendered: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnOneGoogleBarRendered_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnOneGoogleBarRendered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.24
      bool success = true;
      double p_time{};
      PageHandler_OnOneGoogleBarRendered_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_time = input_data_view.time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOneGoogleBarRendered(        
        std::move(p_time));
      return true;
    }
    case messages::PageHandler::kOnPromoRendered: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnPromoRendered_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnPromoRendered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.25
      bool success = true;
      double p_time{};
      std::optional<::GURL> p_log_url{};
      PageHandler_OnPromoRendered_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_time = input_data_view.time();
      if (success && !input_data_view.ReadLogUrl(&p_log_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPromoRendered(        
        std::move(p_time), 
        std::move(p_log_url));
      return true;
    }
    case messages::PageHandler::kOnCustomizeDialogAction: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnCustomizeDialogAction_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnCustomizeDialogAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.26
      bool success = true;
      CustomizeDialogAction p_action{};
      PageHandler_OnCustomizeDialogAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCustomizeDialogAction(        
        std::move(p_action));
      return true;
    }
    case messages::PageHandler::kOnDoodleImageClicked: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnDoodleImageClicked_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnDoodleImageClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.27
      bool success = true;
      DoodleImageType p_type{};
      std::optional<::GURL> p_log_url{};
      PageHandler_OnDoodleImageClicked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadLogUrl(&p_log_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDoodleImageClicked(        
        std::move(p_type), 
        std::move(p_log_url));
      return true;
    }
    case messages::PageHandler::kOnDoodleImageRendered: {
      break;
    }
    case messages::PageHandler::kOnDoodleShared: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnDoodleShared_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnDoodleShared_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.29
      bool success = true;
      DoodleShareChannel p_channel{};
      std::string p_doodle_id{};
      std::optional<std::string> p_share_id{};
      PageHandler_OnDoodleShared_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChannel(&p_channel))
        success = false;
      if (success && !input_data_view.ReadDoodleId(&p_doodle_id))
        success = false;
      if (success && !input_data_view.ReadShareId(&p_share_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDoodleShared(        
        std::move(p_channel), 
        std::move(p_doodle_id), 
        std::move(p_share_id));
      return true;
    }
    case messages::PageHandler::kOnPromoLinkClicked: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnPromoLinkClicked_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnPromoLinkClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.30
      bool success = true;
      PageHandler_OnPromoLinkClicked_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPromoLinkClicked(        );
      return true;
    }
    case messages::PageHandler::kOnAppRendered: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnAppRendered_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnAppRendered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.31
      bool success = true;
      double p_time{};
      PageHandler_OnAppRendered_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_time = input_data_view.time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAppRendered(        
        std::move(p_time));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kSetMostVisitedSettings: {
      break;
    }
    case messages::PageHandler::kGetMostVisitedSettings: {
      internal::PageHandler_GetMostVisitedSettings_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetMostVisitedSettings_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_GetMostVisitedSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_GetMostVisitedSettings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMostVisitedSettings(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetDoodle: {
      internal::PageHandler_GetDoodle_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetDoodle_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_GetDoodle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_GetDoodle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDoodle(std::move(callback));
      return true;
    }
    case messages::PageHandler::kUpdatePromoData: {
      break;
    }
    case messages::PageHandler::kBlocklistPromo: {
      break;
    }
    case messages::PageHandler::kUndoBlocklistPromo: {
      break;
    }
    case messages::PageHandler::kOnDismissModule: {
      break;
    }
    case messages::PageHandler::kOnRestoreModule: {
      break;
    }
    case messages::PageHandler::kSetModulesVisible: {
      break;
    }
    case messages::PageHandler::kSetModuleDisabled: {
      break;
    }
    case messages::PageHandler::kUpdateDisabledModules: {
      break;
    }
    case messages::PageHandler::kOnModulesLoadedWithData: {
      break;
    }
    case messages::PageHandler::kOnModuleUsed: {
      break;
    }
    case messages::PageHandler::kGetModulesIdNames: {
      internal::PageHandler_GetModulesIdNames_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetModulesIdNames_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      PageHandler_GetModulesIdNames_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      auto callback =
          PageHandler_GetModulesIdNames_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetModulesIdNames(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetModulesEligibleForRemoval: {
      internal::PageHandler_GetModulesEligibleForRemoval_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetModulesEligibleForRemoval_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      PageHandler_GetModulesEligibleForRemoval_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      auto callback =
          PageHandler_GetModulesEligibleForRemoval_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetModulesEligibleForRemoval(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetModulesOrder: {
      break;
    }
    case messages::PageHandler::kGetModulesOrder: {
      internal::PageHandler_GetModulesOrder_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetModulesOrder_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.16
      bool success = true;
      PageHandler_GetModulesOrder_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 16, false);
        return false;
      }
      auto callback =
          PageHandler_GetModulesOrder_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetModulesOrder(std::move(callback));
      return true;
    }
    case messages::PageHandler::kUpdateModulesLoadable: {
      break;
    }
    case messages::PageHandler::kSetModulesDisabled: {
      break;
    }
    case messages::PageHandler::kUpdateActionChipsVisibility: {
      break;
    }
    case messages::PageHandler::kUpdateFooterVisibility: {
      break;
    }
    case messages::PageHandler::kIncrementComposeButtonShownCount: {
      break;
    }
    case messages::PageHandler::kMaybeTriggerAutomaticCustomizeChromePromo: {
      break;
    }
    case messages::PageHandler::kRecordContextMenuClick: {
      break;
    }
    case messages::PageHandler::kOnOneGoogleBarRendered: {
      break;
    }
    case messages::PageHandler::kOnPromoRendered: {
      break;
    }
    case messages::PageHandler::kOnCustomizeDialogAction: {
      break;
    }
    case messages::PageHandler::kOnDoodleImageClicked: {
      break;
    }
    case messages::PageHandler::kOnDoodleImageRendered: {
      internal::PageHandler_OnDoodleImageRendered_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_OnDoodleImageRendered_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.28
      bool success = true;
      DoodleImageType p_type{};
      double p_time{};
      ::GURL p_log_url{};
      PageHandler_OnDoodleImageRendered_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_time = input_data_view.time();
      if (success && !input_data_view.ReadLogUrl(&p_log_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 28, false);
        return false;
      }
      auto callback =
          PageHandler_OnDoodleImageRendered_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDoodleImageRendered(        
        std::move(p_type), 
        std::move(p_time), 
        std::move(p_log_url), std::move(callback));
      return true;
    }
    case messages::PageHandler::kOnDoodleShared: {
      break;
    }
    case messages::PageHandler::kOnPromoLinkClicked: {
      break;
    }
    case messages::PageHandler::kOnAppRendered: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_SetMostVisitedSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetMostVisitedSettings_Params_Data::Validate,
     &internal::PageHandler_GetMostVisitedSettings_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetDoodle_Params_Data::Validate,
     &internal::PageHandler_GetDoodle_ResponseParams_Data::Validate},
    { &internal::PageHandler_UpdatePromoData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_BlocklistPromo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_UndoBlocklistPromo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnDismissModule_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnRestoreModule_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetModulesVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetModuleDisabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_UpdateDisabledModules_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnModulesLoadedWithData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnModuleUsed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetModulesIdNames_Params_Data::Validate,
     &internal::PageHandler_GetModulesIdNames_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetModulesEligibleForRemoval_Params_Data::Validate,
     &internal::PageHandler_GetModulesEligibleForRemoval_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetModulesOrder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetModulesOrder_Params_Data::Validate,
     &internal::PageHandler_GetModulesOrder_ResponseParams_Data::Validate},
    { &internal::PageHandler_UpdateModulesLoadable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetModulesDisabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_UpdateActionChipsVisibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_UpdateFooterVisibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_IncrementComposeButtonShownCount_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_MaybeTriggerAutomaticCustomizeChromePromo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordContextMenuClick_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnOneGoogleBarRendered_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnPromoRendered_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnCustomizeDialogAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnDoodleImageClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnDoodleImageRendered_Params_Data::Validate,
     &internal::PageHandler_OnDoodleImageRendered_ResponseParams_Data::Validate},
    { &internal::PageHandler_OnDoodleShared_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnPromoLinkClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnAppRendered_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::new_tab_page::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::new_tab_page::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kSetTheme: {
      return &Page::SetTheme_Sym::IPCStableHash;
    }
    case messages::Page::kSetDisabledModules: {
      return &Page::SetDisabledModules_Sym::IPCStableHash;
    }
    case messages::Page::kSetModulesLoadable: {
      return &Page::SetModulesLoadable_Sym::IPCStableHash;
    }
    case messages::Page::kSetActionChipsVisibility: {
      return &Page::SetActionChipsVisibility_Sym::IPCStableHash;
    }
    case messages::Page::kSetPromo: {
      return &Page::SetPromo_Sym::IPCStableHash;
    }
    case messages::Page::kShowWebstoreToast: {
      return &Page::ShowWebstoreToast_Sym::IPCStableHash;
    }
    case messages::Page::kSetWallpaperSearchButtonVisibility: {
      return &Page::SetWallpaperSearchButtonVisibility_Sym::IPCStableHash;
    }
    case messages::Page::kFooterVisibilityUpdated: {
      return &Page::FooterVisibilityUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kConnectToParentDocument: {
      return &Page::ConnectToParentDocument_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSetTheme:
            return "Receive new_tab_page::mojom::Page::SetTheme";
      case messages::Page::kSetDisabledModules:
            return "Receive new_tab_page::mojom::Page::SetDisabledModules";
      case messages::Page::kSetModulesLoadable:
            return "Receive new_tab_page::mojom::Page::SetModulesLoadable";
      case messages::Page::kSetActionChipsVisibility:
            return "Receive new_tab_page::mojom::Page::SetActionChipsVisibility";
      case messages::Page::kSetPromo:
            return "Receive new_tab_page::mojom::Page::SetPromo";
      case messages::Page::kShowWebstoreToast:
            return "Receive new_tab_page::mojom::Page::ShowWebstoreToast";
      case messages::Page::kSetWallpaperSearchButtonVisibility:
            return "Receive new_tab_page::mojom::Page::SetWallpaperSearchButtonVisibility";
      case messages::Page::kFooterVisibilityUpdated:
            return "Receive new_tab_page::mojom::Page::FooterVisibilityUpdated";
      case messages::Page::kConnectToParentDocument:
            return "Receive new_tab_page::mojom::Page::ConnectToParentDocument";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSetTheme:
            return "Receive reply new_tab_page::mojom::Page::SetTheme";
      case messages::Page::kSetDisabledModules:
            return "Receive reply new_tab_page::mojom::Page::SetDisabledModules";
      case messages::Page::kSetModulesLoadable:
            return "Receive reply new_tab_page::mojom::Page::SetModulesLoadable";
      case messages::Page::kSetActionChipsVisibility:
            return "Receive reply new_tab_page::mojom::Page::SetActionChipsVisibility";
      case messages::Page::kSetPromo:
            return "Receive reply new_tab_page::mojom::Page::SetPromo";
      case messages::Page::kShowWebstoreToast:
            return "Receive reply new_tab_page::mojom::Page::ShowWebstoreToast";
      case messages::Page::kSetWallpaperSearchButtonVisibility:
            return "Receive reply new_tab_page::mojom::Page::SetWallpaperSearchButtonVisibility";
      case messages::Page::kFooterVisibilityUpdated:
            return "Receive reply new_tab_page::mojom::Page::FooterVisibilityUpdated";
      case messages::Page::kConnectToParentDocument:
            return "Receive reply new_tab_page::mojom::Page::ConnectToParentDocument";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::SetTheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74a96a0b;  // IPCStableHash for new_tab_page::mojom::Page::SetTheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetDisabledModules_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8123b145;  // IPCStableHash for new_tab_page::mojom::Page::SetDisabledModules
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetModulesLoadable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4aafa83b;  // IPCStableHash for new_tab_page::mojom::Page::SetModulesLoadable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetActionChipsVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a79df08;  // IPCStableHash for new_tab_page::mojom::Page::SetActionChipsVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetPromo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x785a09e7;  // IPCStableHash for new_tab_page::mojom::Page::SetPromo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ShowWebstoreToast_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0dde389c;  // IPCStableHash for new_tab_page::mojom::Page::ShowWebstoreToast
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetWallpaperSearchButtonVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3d9a624;  // IPCStableHash for new_tab_page::mojom::Page::SetWallpaperSearchButtonVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::FooterVisibilityUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2bf9596;  // IPCStableHash for new_tab_page::mojom::Page::FooterVisibilityUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ConnectToParentDocument_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xffa31a1c;  // IPCStableHash for new_tab_page::mojom::Page::ConnectToParentDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::SetTheme(
    ThemePtr in_theme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::Page::SetTheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme"), in_theme,
                        "<value of type ThemePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetTheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_SetTheme_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme)::BaseType> theme_fragment(
          params.message());
  
  mojo::internal::Serialize<::new_tab_page::mojom::ThemeDataView>(
    in_theme,
    theme_fragment);

  params->theme.Set(
      theme_fragment.is_null() ? nullptr : theme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->theme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null theme in Page.SetTheme request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetDisabledModules(
    bool in_all, const std::vector<std::string>& in_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::Page::SetDisabledModules", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("all"), in_all,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ids"), in_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetDisabledModules), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_SetDisabledModules_Params_Data> params(
          message);
  params.Allocate();

  params->all = in_all;
  mojo::internal::MessageFragment<
      typename decltype(params->ids)::BaseType>
      ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_ids,
    ids_fragment,
    &ids_validate_params);

  params->ids.Set(
      ids_fragment.is_null() ? nullptr : ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ids in Page.SetDisabledModules request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetDisabledModules");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetModulesLoadable(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::Page::SetModulesLoadable");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetModulesLoadable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_SetModulesLoadable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetModulesLoadable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetActionChipsVisibility(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::Page::SetActionChipsVisibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetActionChipsVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_SetActionChipsVisibility_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetActionChipsVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetPromo(
    PromoPtr in_promo) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::Page::SetPromo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("promo"), in_promo,
                        "<value of type PromoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetPromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_SetPromo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->promo)::BaseType> promo_fragment(
          params.message());
  
  mojo::internal::Serialize<::new_tab_page::mojom::PromoDataView>(
    in_promo,
    promo_fragment);

  params->promo.Set(
      promo_fragment.is_null() ? nullptr : promo_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetPromo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ShowWebstoreToast(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::Page::ShowWebstoreToast");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kShowWebstoreToast), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_ShowWebstoreToast_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ShowWebstoreToast");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetWallpaperSearchButtonVisibility(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::Page::SetWallpaperSearchButtonVisibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetWallpaperSearchButtonVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_SetWallpaperSearchButtonVisibility_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetWallpaperSearchButtonVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::FooterVisibilityUpdated(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::Page::FooterVisibilityUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kFooterVisibilityUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_FooterVisibilityUpdated_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("FooterVisibilityUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ConnectToParentDocument(
    ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> in_child_untrusted_document_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::Page::ConnectToParentDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_untrusted_document_remote"), in_child_untrusted_document_remote,
                        "<value of type ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kConnectToParentDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::Page_ConnectToParentDocument_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfaceBase>>(
    in_child_untrusted_document_remote,
    &params->child_untrusted_document_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->child_untrusted_document_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid child_untrusted_document_remote in Page.ConnectToParentDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ConnectToParentDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSetTheme: {
      DCHECK(message->is_serialized());
      internal::Page_SetTheme_Params_Data* params =
          reinterpret_cast<internal::Page_SetTheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ThemePtr p_theme{};
      Page_SetTheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTheme(&p_theme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTheme(        
        std::move(p_theme));
      return true;
    }
    case messages::Page::kSetDisabledModules: {
      DCHECK(message->is_serialized());
      internal::Page_SetDisabledModules_Params_Data* params =
          reinterpret_cast<internal::Page_SetDisabledModules_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      bool p_all{};
      std::vector<std::string> p_ids{};
      Page_SetDisabledModules_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_all = input_data_view.all();
      if (success && !input_data_view.ReadIds(&p_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisabledModules(        
        std::move(p_all), 
        std::move(p_ids));
      return true;
    }
    case messages::Page::kSetModulesLoadable: {
      DCHECK(message->is_serialized());
      internal::Page_SetModulesLoadable_Params_Data* params =
          reinterpret_cast<internal::Page_SetModulesLoadable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      Page_SetModulesLoadable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetModulesLoadable(        );
      return true;
    }
    case messages::Page::kSetActionChipsVisibility: {
      DCHECK(message->is_serialized());
      internal::Page_SetActionChipsVisibility_Params_Data* params =
          reinterpret_cast<internal::Page_SetActionChipsVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      bool p_visible{};
      Page_SetActionChipsVisibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActionChipsVisibility(        
        std::move(p_visible));
      return true;
    }
    case messages::Page::kSetPromo: {
      DCHECK(message->is_serialized());
      internal::Page_SetPromo_Params_Data* params =
          reinterpret_cast<internal::Page_SetPromo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.4
      bool success = true;
      PromoPtr p_promo{};
      Page_SetPromo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPromo(&p_promo))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPromo(        
        std::move(p_promo));
      return true;
    }
    case messages::Page::kShowWebstoreToast: {
      DCHECK(message->is_serialized());
      internal::Page_ShowWebstoreToast_Params_Data* params =
          reinterpret_cast<internal::Page_ShowWebstoreToast_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.5
      bool success = true;
      Page_ShowWebstoreToast_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowWebstoreToast(        );
      return true;
    }
    case messages::Page::kSetWallpaperSearchButtonVisibility: {
      DCHECK(message->is_serialized());
      internal::Page_SetWallpaperSearchButtonVisibility_Params_Data* params =
          reinterpret_cast<internal::Page_SetWallpaperSearchButtonVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.6
      bool success = true;
      bool p_visible{};
      Page_SetWallpaperSearchButtonVisibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWallpaperSearchButtonVisibility(        
        std::move(p_visible));
      return true;
    }
    case messages::Page::kFooterVisibilityUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_FooterVisibilityUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_FooterVisibilityUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.7
      bool success = true;
      bool p_visible{};
      Page_FooterVisibilityUpdated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FooterVisibilityUpdated(        
        std::move(p_visible));
      return true;
    }
    case messages::Page::kConnectToParentDocument: {
      DCHECK(message->is_serialized());
      internal::Page_ConnectToParentDocument_Params_Data* params =
          reinterpret_cast<internal::Page_ConnectToParentDocument_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.8
      bool success = true;
      ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> p_child_untrusted_document_remote{};
      Page_ConnectToParentDocument_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_child_untrusted_document_remote =
            input_data_view.TakeChildUntrustedDocumentRemote<decltype(p_child_untrusted_document_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToParentDocument(        
        std::move(p_child_untrusted_document_remote));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSetTheme: {
      break;
    }
    case messages::Page::kSetDisabledModules: {
      break;
    }
    case messages::Page::kSetModulesLoadable: {
      break;
    }
    case messages::Page::kSetActionChipsVisibility: {
      break;
    }
    case messages::Page::kSetPromo: {
      break;
    }
    case messages::Page::kShowWebstoreToast: {
      break;
    }
    case messages::Page::kSetWallpaperSearchButtonVisibility: {
      break;
    }
    case messages::Page::kFooterVisibilityUpdated: {
      break;
    }
    case messages::Page::kConnectToParentDocument: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_SetTheme_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetDisabledModules_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetModulesLoadable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetActionChipsVisibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetPromo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ShowWebstoreToast_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetWallpaperSearchButtonVisibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_FooterVisibilityUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ConnectToParentDocument_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::new_tab_page::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // new_tab_page::mojom


namespace mojo {


// static
bool StructTraits<::new_tab_page::mojom::BackgroundImage::DataView, ::new_tab_page::mojom::BackgroundImagePtr>::Read(
    ::new_tab_page::mojom::BackgroundImage::DataView input,
    ::new_tab_page::mojom::BackgroundImagePtr* output) {
  bool success = true;
  ::new_tab_page::mojom::BackgroundImagePtr result(::new_tab_page::mojom::BackgroundImage::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadUrl2x(&result->url_2x))
        success = false;
      if (success && !input.ReadAttributionUrl(&result->attribution_url))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadRepeatX(&result->repeat_x))
        success = false;
      if (success && !input.ReadRepeatY(&result->repeat_y))
        success = false;
      if (success && !input.ReadPositionX(&result->position_x))
        success = false;
      if (success && !input.ReadPositionY(&result->position_y))
        success = false;
      if (success && !input.ReadImageSource(&result->image_source))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::Theme::DataView, ::new_tab_page::mojom::ThemePtr>::Read(
    ::new_tab_page::mojom::Theme::DataView input,
    ::new_tab_page::mojom::ThemePtr* output) {
  bool success = true;
  ::new_tab_page::mojom::ThemePtr result(::new_tab_page::mojom::Theme::New());
  
      if (success && !input.ReadTextColor(&result->text_color))
        success = false;
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success)
        result->is_baseline = input.is_baseline();
      if (success)
        result->is_custom_background = input.is_custom_background();
      if (success)
        result->daily_refresh_enabled = input.daily_refresh_enabled();
      if (success)
        result->is_dark = input.is_dark();
      if (success && !input.ReadLogoColor(&result->logo_color))
        success = false;
      if (success && !input.ReadBackgroundImageCollectionId(&result->background_image_collection_id))
        success = false;
      if (success && !input.ReadBackgroundImage(&result->background_image))
        success = false;
      if (success && !input.ReadBackgroundImageAttribution1(&result->background_image_attribution_1))
        success = false;
      if (success && !input.ReadBackgroundImageAttribution2(&result->background_image_attribution_2))
        success = false;
      if (success && !input.ReadBackgroundImageAttributionUrl(&result->background_image_attribution_url))
        success = false;
      if (success && !input.ReadMostVisited(&result->most_visited))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::ImageDoodle::DataView, ::new_tab_page::mojom::ImageDoodlePtr>::Read(
    ::new_tab_page::mojom::ImageDoodle::DataView input,
    ::new_tab_page::mojom::ImageDoodlePtr* output) {
  bool success = true;
  ::new_tab_page::mojom::ImageDoodlePtr result(::new_tab_page::mojom::ImageDoodle::New());
  
      if (success && !input.ReadImageUrl(&result->image_url))
        success = false;
      if (success && !input.ReadAnimationUrl(&result->animation_url))
        success = false;
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success && !input.ReadImageImpressionLogUrl(&result->image_impression_log_url))
        success = false;
      if (success && !input.ReadAnimationImpressionLogUrl(&result->animation_impression_log_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::AllModeImageDoodle::DataView, ::new_tab_page::mojom::AllModeImageDoodlePtr>::Read(
    ::new_tab_page::mojom::AllModeImageDoodle::DataView input,
    ::new_tab_page::mojom::AllModeImageDoodlePtr* output) {
  bool success = true;
  ::new_tab_page::mojom::AllModeImageDoodlePtr result(::new_tab_page::mojom::AllModeImageDoodle::New());
  
      if (success && !input.ReadLight(&result->light))
        success = false;
      if (success && !input.ReadDark(&result->dark))
        success = false;
      if (success && !input.ReadOnClickUrl(&result->on_click_url))
        success = false;
      if (success && !input.ReadShareUrl(&result->share_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::InteractiveDoodle::DataView, ::new_tab_page::mojom::InteractiveDoodlePtr>::Read(
    ::new_tab_page::mojom::InteractiveDoodle::DataView input,
    ::new_tab_page::mojom::InteractiveDoodlePtr* output) {
  bool success = true;
  ::new_tab_page::mojom::InteractiveDoodlePtr result(::new_tab_page::mojom::InteractiveDoodle::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::Doodle::DataView, ::new_tab_page::mojom::DoodlePtr>::Read(
    ::new_tab_page::mojom::Doodle::DataView input,
    ::new_tab_page::mojom::DoodlePtr* output) {
  bool success = true;
  ::new_tab_page::mojom::DoodlePtr result(::new_tab_page::mojom::Doodle::New());
  
      if (success && !input.ReadImage(&result->image))
        success = false;
      if (success && !input.ReadInteractive(&result->interactive))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::PromoImagePart::DataView, ::new_tab_page::mojom::PromoImagePartPtr>::Read(
    ::new_tab_page::mojom::PromoImagePart::DataView input,
    ::new_tab_page::mojom::PromoImagePartPtr* output) {
  bool success = true;
  ::new_tab_page::mojom::PromoImagePartPtr result(::new_tab_page::mojom::PromoImagePart::New());
  
      if (success && !input.ReadImageUrl(&result->image_url))
        success = false;
      if (success && !input.ReadTarget(&result->target))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::PromoLinkPart::DataView, ::new_tab_page::mojom::PromoLinkPartPtr>::Read(
    ::new_tab_page::mojom::PromoLinkPart::DataView input,
    ::new_tab_page::mojom::PromoLinkPartPtr* output) {
  bool success = true;
  ::new_tab_page::mojom::PromoLinkPartPtr result(::new_tab_page::mojom::PromoLinkPart::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::PromoTextPart::DataView, ::new_tab_page::mojom::PromoTextPartPtr>::Read(
    ::new_tab_page::mojom::PromoTextPart::DataView input,
    ::new_tab_page::mojom::PromoTextPartPtr* output) {
  bool success = true;
  ::new_tab_page::mojom::PromoTextPartPtr result(::new_tab_page::mojom::PromoTextPart::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::Promo::DataView, ::new_tab_page::mojom::PromoPtr>::Read(
    ::new_tab_page::mojom::Promo::DataView input,
    ::new_tab_page::mojom::PromoPtr* output) {
  bool success = true;
  ::new_tab_page::mojom::PromoPtr result(::new_tab_page::mojom::Promo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadLogUrl(&result->log_url))
        success = false;
      if (success && !input.ReadMiddleSlotParts(&result->middle_slot_parts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_page::mojom::ModuleIdName::DataView, ::new_tab_page::mojom::ModuleIdNamePtr>::Read(
    ::new_tab_page::mojom::ModuleIdName::DataView input,
    ::new_tab_page::mojom::ModuleIdNamePtr* output) {
  bool success = true;
  ::new_tab_page::mojom::ModuleIdNamePtr result(::new_tab_page::mojom::ModuleIdName::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::new_tab_page::mojom::PromoPart::DataView, ::new_tab_page::mojom::PromoPartPtr>::Read(
    ::new_tab_page::mojom::PromoPart::DataView input,
    ::new_tab_page::mojom::PromoPartPtr* output) {
  using UnionType = ::new_tab_page::mojom::PromoPart;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kImage: {
      ::new_tab_page::mojom::PromoImagePartPtr result_image{};
      if (!input.ReadImage(&result_image))
        return false;

      *output = UnionType::NewImage(
          std::move(result_image));
      break;
    }
    case Tag::kLink: {
      ::new_tab_page::mojom::PromoLinkPartPtr result_link{};
      if (!input.ReadLink(&result_link))
        return false;

      *output = UnionType::NewLink(
          std::move(result_link));
      break;
    }
    case Tag::kText: {
      ::new_tab_page::mojom::PromoTextPartPtr result_text{};
      if (!input.ReadText(&result_text))
        return false;

      *output = UnionType::NewText(
          std::move(result_text));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace new_tab_page::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::SetMostVisitedSettings(::ntp_tiles::mojom::TileType shortcuts_type, bool shortcuts_visible) {
  GetForwardingInterface()->SetMostVisitedSettings(
    std::move(shortcuts_type)
    , 
    std::move(shortcuts_visible)
    );
}
void PageHandlerInterceptorForTesting::GetMostVisitedSettings(GetMostVisitedSettingsCallback callback) {
  GetForwardingInterface()->GetMostVisitedSettings(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetDoodle(GetDoodleCallback callback) {
  GetForwardingInterface()->GetDoodle(std::move(callback));
}
void PageHandlerInterceptorForTesting::UpdatePromoData() {
  GetForwardingInterface()->UpdatePromoData();
}
void PageHandlerInterceptorForTesting::BlocklistPromo(const std::string& promo_id) {
  GetForwardingInterface()->BlocklistPromo(
    std::move(promo_id)
    );
}
void PageHandlerInterceptorForTesting::UndoBlocklistPromo(const std::string& promo_id) {
  GetForwardingInterface()->UndoBlocklistPromo(
    std::move(promo_id)
    );
}
void PageHandlerInterceptorForTesting::OnDismissModule(const std::string& module_id) {
  GetForwardingInterface()->OnDismissModule(
    std::move(module_id)
    );
}
void PageHandlerInterceptorForTesting::OnRestoreModule(const std::string& module_id) {
  GetForwardingInterface()->OnRestoreModule(
    std::move(module_id)
    );
}
void PageHandlerInterceptorForTesting::SetModulesVisible(bool visible) {
  GetForwardingInterface()->SetModulesVisible(
    std::move(visible)
    );
}
void PageHandlerInterceptorForTesting::SetModuleDisabled(const std::string& module_id, bool disabled) {
  GetForwardingInterface()->SetModuleDisabled(
    std::move(module_id)
    , 
    std::move(disabled)
    );
}
void PageHandlerInterceptorForTesting::UpdateDisabledModules() {
  GetForwardingInterface()->UpdateDisabledModules();
}
void PageHandlerInterceptorForTesting::OnModulesLoadedWithData(const std::vector<std::string>& module_ids) {
  GetForwardingInterface()->OnModulesLoadedWithData(
    std::move(module_ids)
    );
}
void PageHandlerInterceptorForTesting::OnModuleUsed(const std::string& module_id) {
  GetForwardingInterface()->OnModuleUsed(
    std::move(module_id)
    );
}
void PageHandlerInterceptorForTesting::GetModulesIdNames(GetModulesIdNamesCallback callback) {
  GetForwardingInterface()->GetModulesIdNames(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetModulesEligibleForRemoval(GetModulesEligibleForRemovalCallback callback) {
  GetForwardingInterface()->GetModulesEligibleForRemoval(std::move(callback));
}
void PageHandlerInterceptorForTesting::SetModulesOrder(const std::vector<std::string>& module_ids) {
  GetForwardingInterface()->SetModulesOrder(
    std::move(module_ids)
    );
}
void PageHandlerInterceptorForTesting::GetModulesOrder(GetModulesOrderCallback callback) {
  GetForwardingInterface()->GetModulesOrder(std::move(callback));
}
void PageHandlerInterceptorForTesting::UpdateModulesLoadable() {
  GetForwardingInterface()->UpdateModulesLoadable();
}
void PageHandlerInterceptorForTesting::SetModulesDisabled(const std::vector<std::string>& module_ids, bool disabled) {
  GetForwardingInterface()->SetModulesDisabled(
    std::move(module_ids)
    , 
    std::move(disabled)
    );
}
void PageHandlerInterceptorForTesting::UpdateActionChipsVisibility() {
  GetForwardingInterface()->UpdateActionChipsVisibility();
}
void PageHandlerInterceptorForTesting::UpdateFooterVisibility() {
  GetForwardingInterface()->UpdateFooterVisibility();
}
void PageHandlerInterceptorForTesting::IncrementComposeButtonShownCount() {
  GetForwardingInterface()->IncrementComposeButtonShownCount();
}
void PageHandlerInterceptorForTesting::MaybeTriggerAutomaticCustomizeChromePromo() {
  GetForwardingInterface()->MaybeTriggerAutomaticCustomizeChromePromo();
}
void PageHandlerInterceptorForTesting::RecordContextMenuClick() {
  GetForwardingInterface()->RecordContextMenuClick();
}
void PageHandlerInterceptorForTesting::OnOneGoogleBarRendered(double time) {
  GetForwardingInterface()->OnOneGoogleBarRendered(
    std::move(time)
    );
}
void PageHandlerInterceptorForTesting::OnPromoRendered(double time, const std::optional<::GURL>& log_url) {
  GetForwardingInterface()->OnPromoRendered(
    std::move(time)
    , 
    std::move(log_url)
    );
}
void PageHandlerInterceptorForTesting::OnCustomizeDialogAction(CustomizeDialogAction action) {
  GetForwardingInterface()->OnCustomizeDialogAction(
    std::move(action)
    );
}
void PageHandlerInterceptorForTesting::OnDoodleImageClicked(DoodleImageType type, const std::optional<::GURL>& log_url) {
  GetForwardingInterface()->OnDoodleImageClicked(
    std::move(type)
    , 
    std::move(log_url)
    );
}
void PageHandlerInterceptorForTesting::OnDoodleImageRendered(DoodleImageType type, double time, const ::GURL& log_url, OnDoodleImageRenderedCallback callback) {
  GetForwardingInterface()->OnDoodleImageRendered(
    std::move(type)
    , 
    std::move(time)
    , 
    std::move(log_url)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::OnDoodleShared(DoodleShareChannel channel, const std::string& doodle_id, const std::optional<std::string>& share_id) {
  GetForwardingInterface()->OnDoodleShared(
    std::move(channel)
    , 
    std::move(doodle_id)
    , 
    std::move(share_id)
    );
}
void PageHandlerInterceptorForTesting::OnPromoLinkClicked() {
  GetForwardingInterface()->OnPromoLinkClicked();
}
void PageHandlerInterceptorForTesting::OnAppRendered(double time) {
  GetForwardingInterface()->OnAppRendered(
    std::move(time)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetMostVisitedSettings(
    ::ntp_tiles::mojom::TileType* out_shortcuts_type, bool* out_shortcuts_visible) {
  base::RunLoop loop;
  proxy_->GetMostVisitedSettings(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::ntp_tiles::mojom::TileType* out_shortcuts_type
,
             bool* out_shortcuts_visible
,
             ::ntp_tiles::mojom::TileType shortcuts_type,
             bool shortcuts_visible) {*out_shortcuts_type = std::move(shortcuts_type);*out_shortcuts_visible = std::move(shortcuts_visible);
            loop->Quit();
          },
          &loop,
          out_shortcuts_type,
          out_shortcuts_visible));
  loop.Run();
}



void PageHandlerAsyncWaiter::GetDoodle(
    DoodlePtr* out_doodle) {
  base::RunLoop loop;
  proxy_->GetDoodle(
      base::BindOnce(
          [](base::RunLoop* loop,
             DoodlePtr* out_doodle
,
             DoodlePtr doodle) {*out_doodle = std::move(doodle);
            loop->Quit();
          },
          &loop,
          out_doodle));
  loop.Run();
}

DoodlePtr PageHandlerAsyncWaiter::GetDoodle(
    ) {
  DoodlePtr async_wait_result;
  GetDoodle(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetModulesIdNames(
    std::vector<ModuleIdNamePtr>* out_data) {
  base::RunLoop loop;
  proxy_->GetModulesIdNames(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ModuleIdNamePtr>* out_data
,
             std::vector<ModuleIdNamePtr> data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

std::vector<ModuleIdNamePtr> PageHandlerAsyncWaiter::GetModulesIdNames(
    ) {
  std::vector<ModuleIdNamePtr> async_wait_result;
  GetModulesIdNames(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetModulesEligibleForRemoval(
    std::vector<std::string>* out_module_ids) {
  base::RunLoop loop;
  proxy_->GetModulesEligibleForRemoval(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_module_ids
,
             const std::vector<std::string>& module_ids) {*out_module_ids = std::move(module_ids);
            loop->Quit();
          },
          &loop,
          out_module_ids));
  loop.Run();
}

std::vector<std::string> PageHandlerAsyncWaiter::GetModulesEligibleForRemoval(
    ) {
  std::vector<std::string> async_wait_result;
  GetModulesEligibleForRemoval(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetModulesOrder(
    std::vector<std::string>* out_module_ids) {
  base::RunLoop loop;
  proxy_->GetModulesOrder(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_module_ids
,
             const std::vector<std::string>& module_ids) {*out_module_ids = std::move(module_ids);
            loop->Quit();
          },
          &loop,
          out_module_ids));
  loop.Run();
}

std::vector<std::string> PageHandlerAsyncWaiter::GetModulesOrder(
    ) {
  std::vector<std::string> async_wait_result;
  GetModulesOrder(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::OnDoodleImageRendered(
    DoodleImageType type, double time, const ::GURL& log_url, std::optional<std::string>* out_image_click_params, std::optional<::GURL>* out_interaction_log_url, std::optional<std::string>* out_share_id) {
  base::RunLoop loop;
  proxy_->OnDoodleImageRendered(
      std::move(type),
      std::move(time),
      std::move(log_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_image_click_params
,
             std::optional<::GURL>* out_interaction_log_url
,
             std::optional<std::string>* out_share_id
,
             const std::optional<std::string>& image_click_params,
             const std::optional<::GURL>& interaction_log_url,
             const std::optional<std::string>& share_id) {*out_image_click_params = std::move(image_click_params);*out_interaction_log_url = std::move(interaction_log_url);*out_share_id = std::move(share_id);
            loop->Quit();
          },
          &loop,
          out_image_click_params,
          out_interaction_log_url,
          out_share_id));
  loop.Run();
}






void PageInterceptorForTesting::SetTheme(ThemePtr theme) {
  GetForwardingInterface()->SetTheme(
    std::move(theme)
    );
}
void PageInterceptorForTesting::SetDisabledModules(bool all, const std::vector<std::string>& ids) {
  GetForwardingInterface()->SetDisabledModules(
    std::move(all)
    , 
    std::move(ids)
    );
}
void PageInterceptorForTesting::SetModulesLoadable() {
  GetForwardingInterface()->SetModulesLoadable();
}
void PageInterceptorForTesting::SetActionChipsVisibility(bool visible) {
  GetForwardingInterface()->SetActionChipsVisibility(
    std::move(visible)
    );
}
void PageInterceptorForTesting::SetPromo(PromoPtr promo) {
  GetForwardingInterface()->SetPromo(
    std::move(promo)
    );
}
void PageInterceptorForTesting::ShowWebstoreToast() {
  GetForwardingInterface()->ShowWebstoreToast();
}
void PageInterceptorForTesting::SetWallpaperSearchButtonVisibility(bool visible) {
  GetForwardingInterface()->SetWallpaperSearchButtonVisibility(
    std::move(visible)
    );
}
void PageInterceptorForTesting::FooterVisibilityUpdated(bool visible) {
  GetForwardingInterface()->FooterVisibilityUpdated(
    std::move(visible)
    );
}
void PageInterceptorForTesting::ConnectToParentDocument(::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> child_untrusted_document_remote) {
  GetForwardingInterface()->ConnectToParentDocument(
    std::move(child_untrusted_document_remote)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // new_tab_page::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif