// chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-shared-internal.h"
#include "components/ntp_tiles/tile_type.mojom-shared.h"
#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_shared_ui.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace new_tab_page::mojom {
class BackgroundImageDataView;

class ThemeDataView;

class ImageDoodleDataView;

class AllModeImageDoodleDataView;

class InteractiveDoodleDataView;

class DoodleDataView;

class PromoImagePartDataView;

class PromoLinkPartDataView;

class PromoTextPartDataView;

class PromoDataView;

class ModuleIdNameDataView;

class PromoPartDataView;


}  // new_tab_page::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::new_tab_page::mojom::BackgroundImageDataView> {
  using Data = ::new_tab_page::mojom::internal::BackgroundImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::ThemeDataView> {
  using Data = ::new_tab_page::mojom::internal::Theme_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::ImageDoodleDataView> {
  using Data = ::new_tab_page::mojom::internal::ImageDoodle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::AllModeImageDoodleDataView> {
  using Data = ::new_tab_page::mojom::internal::AllModeImageDoodle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::InteractiveDoodleDataView> {
  using Data = ::new_tab_page::mojom::internal::InteractiveDoodle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::DoodleDataView> {
  using Data = ::new_tab_page::mojom::internal::Doodle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::PromoImagePartDataView> {
  using Data = ::new_tab_page::mojom::internal::PromoImagePart_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::PromoLinkPartDataView> {
  using Data = ::new_tab_page::mojom::internal::PromoLinkPart_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::PromoTextPartDataView> {
  using Data = ::new_tab_page::mojom::internal::PromoTextPart_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::PromoDataView> {
  using Data = ::new_tab_page::mojom::internal::Promo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::ModuleIdNameDataView> {
  using Data = ::new_tab_page::mojom::internal::ModuleIdName_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::new_tab_page::mojom::PromoPartDataView> {
  using Data = ::new_tab_page::mojom::internal::PromoPart_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace new_tab_page::mojom {


enum class NtpBackgroundImageSource : int32_t {
  
  kNoImage = 0,
  
  kFirstPartyThemeWithoutDailyRefresh = 1,
  
  kFirstPartyThemeWithDailyRefresh = 2,
  
  kThirdPartyTheme = 3,
  
  kUploadedImage = 4,
  
  kWallpaperSearch = 5,
  
  kWallpaperSearchInspiration = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, NtpBackgroundImageSource value);
inline bool IsKnownEnumValue(NtpBackgroundImageSource value) {
  return internal::NtpBackgroundImageSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DoodleImageType : int32_t {
  
  kAnimation = 0,
  
  kCta = 1,
  
  kStatic = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DoodleImageType value);
inline bool IsKnownEnumValue(DoodleImageType value) {
  return internal::DoodleImageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DoodleShareChannel : int32_t {
  
  kFacebook = 0,
  
  kTwitter = 1,
  
  kEmail = 2,
  
  kLinkCopy = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DoodleShareChannel value);
inline bool IsKnownEnumValue(DoodleShareChannel value) {
  return internal::DoodleShareChannel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CustomizeDialogAction : int32_t {
  
  kCancelClicked = 0,
  
  kDoneClicked = 1,
  
  kOpenClicked = 2,
  
  kBackgroundsBackClicked = 3,
  
  kBackgroundsNoBackgroundSelected = 4,
  
  kBackgroundsCollectionOpened = 5,
  
  kBackgroundsRefreshToggleClicked = 6,
  
  kBackgroundsImageSelected = 7,
  
  kBackgroundsUploadFromDeviceClicked = 8,
  
  kShortcutsCustomLinksClicked = 9,
  
  kShortcutsMostVisitedClicked = 10,
  
  kShortcutsVisibilityToggleClicked = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

 std::ostream& operator<<(std::ostream& os, CustomizeDialogAction value);
inline bool IsKnownEnumValue(CustomizeDialogAction value) {
  return internal::CustomizeDialogAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OptInStatus : int32_t {
  
  kExplicitOptIn = 0,
  
  kImplicitOptIn = 1,
  
  kOptOut = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, OptInStatus value);
inline bool IsKnownEnumValue(OptInStatus value) {
  return internal::OptInStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class BackgroundImageDataView {
 public:
  BackgroundImageDataView() = default;

  BackgroundImageDataView(
      internal::BackgroundImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUrl2xDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl2x(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url_2x` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl2x` instead "
    "of `ReadUrl2x if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url_2x.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAttributionUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `attribution_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAttributionUrl` instead "
    "of `ReadAttributionUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->attribution_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSize` instead "
    "of `ReadSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRepeatXDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRepeatX(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `repeat_x` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRepeatX` instead "
    "of `ReadRepeatX if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->repeat_x.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRepeatYDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRepeatY(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `repeat_y` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRepeatY` instead "
    "of `ReadRepeatY if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->repeat_y.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPositionXDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositionX(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `position_x` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPositionX` instead "
    "of `ReadPositionX if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position_x.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPositionYDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositionY(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `position_y` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPositionY` instead "
    "of `ReadPositionY if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position_y.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadImageSource(UserType* output) const {
    auto data_value = data_->image_source;
    return mojo::internal::Deserialize<::new_tab_page::mojom::NtpBackgroundImageSource>(
        data_value, output);
  }
  NtpBackgroundImageSource image_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::new_tab_page::mojom::NtpBackgroundImageSource>(data_->image_source));
  }
 private:
  internal::BackgroundImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ThemeDataView {
 public:
  ThemeDataView() = default;

  ThemeDataView(
      internal::Theme_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextColor(UserType* output) {
    
    auto* pointer = data_->text_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  bool is_baseline() const {
    return data_->is_baseline;
  }
  bool is_custom_background() const {
    return data_->is_custom_background;
  }
  bool daily_refresh_enabled() const {
    return data_->daily_refresh_enabled;
  }
  bool is_dark() const {
    return data_->is_dark;
  }
  inline void GetLogoColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogoColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColorDataView, UserType>(),
    "Attempting to read the optional `logo_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLogoColor` instead "
    "of `ReadLogoColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->logo_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundImageCollectionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImageCollectionId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `background_image_collection_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackgroundImageCollectionId` instead "
    "of `ReadBackgroundImageCollectionId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->background_image_collection_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundImageDataView(
      BackgroundImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::new_tab_page::mojom::BackgroundImageDataView, UserType>(),
    "Attempting to read the optional `background_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackgroundImage` instead "
    "of `ReadBackgroundImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->background_image.Get();
    return mojo::internal::Deserialize<::new_tab_page::mojom::BackgroundImageDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundImageAttribution1DataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImageAttribution1(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `background_image_attribution_1` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackgroundImageAttribution1` instead "
    "of `ReadBackgroundImageAttribution1 if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->background_image_attribution_1.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundImageAttribution2DataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImageAttribution2(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `background_image_attribution_2` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackgroundImageAttribution2` instead "
    "of `ReadBackgroundImageAttribution2 if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->background_image_attribution_2.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundImageAttributionUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImageAttributionUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `background_image_attribution_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackgroundImageAttributionUrl` instead "
    "of `ReadBackgroundImageAttributionUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->background_image_attribution_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMostVisitedDataView(
      ::most_visited::mojom::MostVisitedThemeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMostVisited(UserType* output) {
    
    auto* pointer = data_->most_visited.Get();
    return mojo::internal::Deserialize<::most_visited::mojom::MostVisitedThemeDataView>(
        pointer, output, message_);
  }
 private:
  internal::Theme_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ImageDoodleDataView {
 public:
  ImageDoodleDataView() = default;

  ImageDoodleDataView(
      internal::ImageDoodle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageUrl(UserType* output) {
    
    auto* pointer = data_->image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAnimationUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnimationUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `animation_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnimationUrl` instead "
    "of `ReadAnimationUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->animation_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetImageImpressionLogUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageImpressionLogUrl(UserType* output) {
    
    auto* pointer = data_->image_impression_log_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetAnimationImpressionLogUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnimationImpressionLogUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `animation_impression_log_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnimationImpressionLogUrl` instead "
    "of `ReadAnimationImpressionLogUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->animation_impression_log_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ImageDoodle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AllModeImageDoodleDataView {
 public:
  AllModeImageDoodleDataView() = default;

  AllModeImageDoodleDataView(
      internal::AllModeImageDoodle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLightDataView(
      ImageDoodleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLight(UserType* output) {
    
    auto* pointer = data_->light.Get();
    return mojo::internal::Deserialize<::new_tab_page::mojom::ImageDoodleDataView>(
        pointer, output, message_);
  }
  inline void GetDarkDataView(
      ImageDoodleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDark(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::new_tab_page::mojom::ImageDoodleDataView, UserType>(),
    "Attempting to read the optional `dark` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDark` instead "
    "of `ReadDark if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->dark.Get();
    return mojo::internal::Deserialize<::new_tab_page::mojom::ImageDoodleDataView>(
        pointer, output, message_);
  }
  inline void GetOnClickUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOnClickUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `on_click_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOnClickUrl` instead "
    "of `ReadOnClickUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->on_click_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetShareUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShareUrl(UserType* output) {
    
    auto* pointer = data_->share_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::AllModeImageDoodle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InteractiveDoodleDataView {
 public:
  InteractiveDoodleDataView() = default;

  InteractiveDoodleDataView(
      internal::InteractiveDoodle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
 private:
  internal::InteractiveDoodle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DoodleDataView {
 public:
  DoodleDataView() = default;

  DoodleDataView(
      internal::Doodle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageDataView(
      AllModeImageDoodleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::new_tab_page::mojom::AllModeImageDoodleDataView, UserType>(),
    "Attempting to read the optional `image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImage` instead "
    "of `ReadImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<::new_tab_page::mojom::AllModeImageDoodleDataView>(
        pointer, output, message_);
  }
  inline void GetInteractiveDataView(
      InteractiveDoodleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInteractive(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::new_tab_page::mojom::InteractiveDoodleDataView, UserType>(),
    "Attempting to read the optional `interactive` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInteractive` instead "
    "of `ReadInteractive if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interactive.Get();
    return mojo::internal::Deserialize<::new_tab_page::mojom::InteractiveDoodleDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Doodle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PromoImagePartDataView {
 public:
  PromoImagePartDataView() = default;

  PromoImagePartDataView(
      internal::PromoImagePart_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageUrl(UserType* output) {
    
    auto* pointer = data_->image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTargetDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTarget(UserType* output) {
    
    auto* pointer = data_->target.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::PromoImagePart_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PromoLinkPartDataView {
 public:
  PromoLinkPartDataView() = default;

  PromoLinkPartDataView(
      internal::PromoLinkPart_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::PromoLinkPart_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PromoTextPartDataView {
 public:
  PromoTextPartDataView() = default;

  PromoTextPartDataView(
      internal::PromoTextPart_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PromoTextPart_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PromoDataView {
 public:
  PromoDataView() = default;

  PromoDataView(
      internal::Promo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLogUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `log_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLogUrl` instead "
    "of `ReadLogUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->log_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMiddleSlotPartsDataView(
      mojo::ArrayDataView<PromoPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMiddleSlotParts(UserType* output) {
    
    auto* pointer = data_->middle_slot_parts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::new_tab_page::mojom::PromoPartDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Promo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ModuleIdNameDataView {
 public:
  ModuleIdNameDataView() = default;

  ModuleIdNameDataView(
      internal::ModuleIdName_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ModuleIdName_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PromoPartDataView {
 public:
  using Tag = internal::PromoPart_Data::PromoPart_Tag;

  PromoPartDataView() = default;

  PromoPartDataView(
      internal::PromoPart_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_image() const { return data_->tag == Tag::kImage; }
  inline void GetImageDataView(
      PromoImagePartDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) const {
    
    CHECK(is_image());
    return mojo::internal::Deserialize<::new_tab_page::mojom::PromoImagePartDataView>(
        data_->data.f_image.Get(), output, message_);
  }
  bool is_link() const { return data_->tag == Tag::kLink; }
  inline void GetLinkDataView(
      PromoLinkPartDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLink(UserType* output) const {
    
    CHECK(is_link());
    return mojo::internal::Deserialize<::new_tab_page::mojom::PromoLinkPartDataView>(
        data_->data.f_link.Get(), output, message_);
  }
  bool is_text() const { return data_->tag == Tag::kText; }
  inline void GetTextDataView(
      PromoTextPartDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) const {
    
    CHECK(is_text());
    return mojo::internal::Deserialize<::new_tab_page::mojom::PromoTextPartDataView>(
        data_->data.f_text.Get(), output, message_);
  }

 private:
  internal::PromoPart_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // new_tab_page::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_DATA_VIEW_H_