// chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-params-data.h"
#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-import-headers.h"
#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-test-utils.h"


namespace action_chips::mojom {
TabInfo::TabInfo()
    : tab_id(),
      title(),
      url(),
      last_active_time() {}

TabInfo::TabInfo(
    int32_t tab_id_in,
    const std::string& title_in,
    const ::GURL& url_in,
    ::base::Time last_active_time_in)
    : tab_id(std::move(tab_id_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      last_active_time(std::move(last_active_time_in)) {}

TabInfo::~TabInfo() = default;

void TabInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active_time"), this->last_active_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ActionChip::ActionChip()
    : title(),
      suggestion(),
      type(),
      tab() {}

ActionChip::ActionChip(
    const std::string& title_in,
    const std::string& suggestion_in,
    ChipType type_in,
    TabInfoPtr tab_in)
    : title(std::move(title_in)),
      suggestion(std::move(suggestion_in)),
      type(std::move(type_in)),
      tab(std::move(tab_in)) {}

ActionChip::~ActionChip() = default;

void ActionChip::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion"), this->suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ChipType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab"), this->tab,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ActionChip::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ActionChipsHandler::IPCStableHashFunction ActionChipsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ActionChipsHandler>(message.name())) {
    case messages::ActionChipsHandler::kStartActionChipsRetrieval: {
      return &ActionChipsHandler::StartActionChipsRetrieval_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ActionChipsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ActionChipsHandler>(message.name())) {
      case messages::ActionChipsHandler::kStartActionChipsRetrieval:
            return "Receive action_chips::mojom::ActionChipsHandler::StartActionChipsRetrieval";
    }
  } else {
    switch (static_cast<messages::ActionChipsHandler>(message.name())) {
      case messages::ActionChipsHandler::kStartActionChipsRetrieval:
            return "Receive reply action_chips::mojom::ActionChipsHandler::StartActionChipsRetrieval";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ActionChipsHandler::StartActionChipsRetrieval_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x94e089a8;  // IPCStableHash for action_chips::mojom::ActionChipsHandler::StartActionChipsRetrieval
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ActionChipsHandlerProxy::ActionChipsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ActionChipsHandlerProxy::StartActionChipsRetrieval(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send action_chips::mojom::ActionChipsHandler::StartActionChipsRetrieval");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActionChipsHandler::kStartActionChipsRetrieval), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::action_chips::mojom::internal::ActionChipsHandler_StartActionChipsRetrieval_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActionChipsHandler::Name_);
  message.set_method_name("StartActionChipsRetrieval");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ActionChipsHandlerStubDispatch::Accept(
    ActionChipsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ActionChipsHandler>(message->header()->name)) {
    case messages::ActionChipsHandler::kStartActionChipsRetrieval: {
      DCHECK(message->is_serialized());
      internal::ActionChipsHandler_StartActionChipsRetrieval_Params_Data* params =
          reinterpret_cast<internal::ActionChipsHandler_StartActionChipsRetrieval_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActionChipsHandler.0
      bool success = true;
      ActionChipsHandler_StartActionChipsRetrieval_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActionChipsHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartActionChipsRetrieval(        );
      return true;
    }
  }
  return false;
}

// static
bool ActionChipsHandlerStubDispatch::AcceptWithResponder(
    ActionChipsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ActionChipsHandler>(message->header()->name)) {
    case messages::ActionChipsHandler::kStartActionChipsRetrieval: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kActionChipsHandlerValidationInfo[] = {
    { &internal::ActionChipsHandler_StartActionChipsRetrieval_Params_Data::Validate,
     nullptr /* no response */},
};

bool ActionChipsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::action_chips::mojom::ActionChipsHandler::Name_,
    kActionChipsHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnActionChipsChanged: {
      return &Page::OnActionChipsChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnActionChipsChanged:
            return "Receive action_chips::mojom::Page::OnActionChipsChanged";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnActionChipsChanged:
            return "Receive reply action_chips::mojom::Page::OnActionChipsChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnActionChipsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb6847a9;  // IPCStableHash for action_chips::mojom::Page::OnActionChipsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnActionChipsChanged(
    std::vector<ActionChipPtr> in_action_chips) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send action_chips::mojom::Page::OnActionChipsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_chips"), in_action_chips,
                        "<value of type std::vector<ActionChipPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnActionChipsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::action_chips::mojom::internal::Page_OnActionChipsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action_chips)::BaseType>
      action_chips_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& action_chips_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::action_chips::mojom::ActionChipDataView>>(
    in_action_chips,
    action_chips_fragment,
    &action_chips_validate_params);

  params->action_chips.Set(
      action_chips_fragment.is_null() ? nullptr : action_chips_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->action_chips.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null action_chips in Page.OnActionChipsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnActionChipsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnActionChipsChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnActionChipsChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnActionChipsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      std::vector<ActionChipPtr> p_action_chips{};
      Page_OnActionChipsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActionChips(&p_action_chips))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnActionChipsChanged(        
        std::move(p_action_chips));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnActionChipsChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnActionChipsChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::action_chips::mojom::Page::Name_,
    kPageValidationInfo);
}

// The declaration includes the definition on other builds.

ActionChipsHandlerFactory::IPCStableHashFunction ActionChipsHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ActionChipsHandlerFactory>(message.name())) {
    case messages::ActionChipsHandlerFactory::kCreateActionChipsHandler: {
      return &ActionChipsHandlerFactory::CreateActionChipsHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ActionChipsHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ActionChipsHandlerFactory>(message.name())) {
      case messages::ActionChipsHandlerFactory::kCreateActionChipsHandler:
            return "Receive action_chips::mojom::ActionChipsHandlerFactory::CreateActionChipsHandler";
    }
  } else {
    switch (static_cast<messages::ActionChipsHandlerFactory>(message.name())) {
      case messages::ActionChipsHandlerFactory::kCreateActionChipsHandler:
            return "Receive reply action_chips::mojom::ActionChipsHandlerFactory::CreateActionChipsHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ActionChipsHandlerFactory::CreateActionChipsHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1e97756;  // IPCStableHash for action_chips::mojom::ActionChipsHandlerFactory::CreateActionChipsHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ActionChipsHandlerFactoryProxy::ActionChipsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ActionChipsHandlerFactoryProxy::CreateActionChipsHandler(
    ::mojo::PendingReceiver<ActionChipsHandler> in_handler, ::mojo::PendingRemote<Page> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send action_chips::mojom::ActionChipsHandlerFactory::CreateActionChipsHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<ActionChipsHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActionChipsHandlerFactory::kCreateActionChipsHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::action_chips::mojom::internal::ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::action_chips::mojom::ActionChipsHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in ActionChipsHandlerFactory.CreateActionChipsHandler request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::action_chips::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in ActionChipsHandlerFactory.CreateActionChipsHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActionChipsHandlerFactory::Name_);
  message.set_method_name("CreateActionChipsHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ActionChipsHandlerFactoryStubDispatch::Accept(
    ActionChipsHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ActionChipsHandlerFactory>(message->header()->name)) {
    case messages::ActionChipsHandlerFactory::kCreateActionChipsHandler: {
      DCHECK(message->is_serialized());
      internal::ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data* params =
          reinterpret_cast<internal::ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActionChipsHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<ActionChipsHandler> p_handler{};
      ::mojo::PendingRemote<Page> p_page{};
      ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActionChipsHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateActionChipsHandler(        
        std::move(p_handler), 
        std::move(p_page));
      return true;
    }
  }
  return false;
}

// static
bool ActionChipsHandlerFactoryStubDispatch::AcceptWithResponder(
    ActionChipsHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ActionChipsHandlerFactory>(message->header()->name)) {
    case messages::ActionChipsHandlerFactory::kCreateActionChipsHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kActionChipsHandlerFactoryValidationInfo[] = {
    { &internal::ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ActionChipsHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::action_chips::mojom::ActionChipsHandlerFactory::Name_,
    kActionChipsHandlerFactoryValidationInfo);
}



}  // action_chips::mojom


namespace mojo {


// static
bool StructTraits<::action_chips::mojom::TabInfo::DataView, ::action_chips::mojom::TabInfoPtr>::Read(
    ::action_chips::mojom::TabInfo::DataView input,
    ::action_chips::mojom::TabInfoPtr* output) {
  bool success = true;
  ::action_chips::mojom::TabInfoPtr result(::action_chips::mojom::TabInfo::New());
  
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadLastActiveTime(&result->last_active_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::action_chips::mojom::ActionChip::DataView, ::action_chips::mojom::ActionChipPtr>::Read(
    ::action_chips::mojom::ActionChip::DataView input,
    ::action_chips::mojom::ActionChipPtr* output) {
  bool success = true;
  ::action_chips::mojom::ActionChipPtr result(::action_chips::mojom::ActionChip::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadSuggestion(&result->suggestion))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadTab(&result->tab))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace action_chips::mojom {


void ActionChipsHandlerInterceptorForTesting::StartActionChipsRetrieval() {
  GetForwardingInterface()->StartActionChipsRetrieval();
}
ActionChipsHandlerAsyncWaiter::ActionChipsHandlerAsyncWaiter(
    ActionChipsHandler* proxy) : proxy_(proxy) {}

ActionChipsHandlerAsyncWaiter::~ActionChipsHandlerAsyncWaiter() = default;





void PageInterceptorForTesting::OnActionChipsChanged(std::vector<ActionChipPtr> action_chips) {
  GetForwardingInterface()->OnActionChipsChanged(
    std::move(action_chips)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;





void ActionChipsHandlerFactoryInterceptorForTesting::CreateActionChipsHandler(::mojo::PendingReceiver<ActionChipsHandler> handler, ::mojo::PendingRemote<Page> page) {
  GetForwardingInterface()->CreateActionChipsHandler(
    std::move(handler)
    , 
    std::move(page)
    );
}
ActionChipsHandlerFactoryAsyncWaiter::ActionChipsHandlerFactoryAsyncWaiter(
    ActionChipsHandlerFactory* proxy) : proxy_(proxy) {}

ActionChipsHandlerFactoryAsyncWaiter::~ActionChipsHandlerFactoryAsyncWaiter() = default;







}  // action_chips::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif