// chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-data-view.h"




namespace std {

template <>
struct hash<::action_chips::mojom::ChipType>
    : public mojo::internal::EnumHashImpl<::action_chips::mojom::ChipType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::action_chips::mojom::ChipType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::action_chips::mojom::ChipType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::action_chips::mojom::ChipType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::action_chips::mojom::TabInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::action_chips::mojom::TabInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::action_chips::mojom::internal::TabInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->tab_id = Traits::tab_id(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabInfo struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in TabInfo struct");

    decltype(Traits::last_active_time(input)) in_last_active_time = Traits::last_active_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_active_time)::BaseType> last_active_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_active_time,
      last_active_time_fragment);

    fragment->last_active_time.Set(
        last_active_time_fragment.is_null() ? nullptr : last_active_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_active_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_active_time in TabInfo struct");
  }

  static bool Deserialize(::action_chips::mojom::internal::TabInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::action_chips::mojom::TabInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::action_chips::mojom::ActionChipDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::action_chips::mojom::ActionChipDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::action_chips::mojom::internal::ActionChip_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in ActionChip struct");

    decltype(Traits::suggestion(input)) in_suggestion = Traits::suggestion(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestion)::BaseType> suggestion_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_suggestion,
      suggestion_fragment);

    fragment->suggestion.Set(
        suggestion_fragment.is_null() ? nullptr : suggestion_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggestion.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestion in ActionChip struct");

    
    mojo::internal::Serialize<::action_chips::mojom::ChipType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::tab(input)) in_tab = Traits::tab(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab)::BaseType> tab_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::action_chips::mojom::TabInfoDataView>(
      in_tab,
      tab_fragment);

    fragment->tab.Set(
        tab_fragment.is_null() ? nullptr : tab_fragment.data());
  }

  static bool Deserialize(::action_chips::mojom::internal::ActionChip_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::action_chips::mojom::ActionChipDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace action_chips::mojom {

inline void TabInfoDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabInfoDataView::GetLastActiveTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_active_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void ActionChipDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ActionChipDataView::GetSuggestionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->suggestion.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ActionChipDataView::GetTabDataView(
    TabInfoDataView* output) {
  auto pointer = data_->tab.Get();
  *output = TabInfoDataView(pointer, message_);
}



}  // action_chips::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::action_chips::mojom::ChipType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::action_chips::mojom::ChipType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_SHARED_H_