// chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-params-data.h"
namespace action_chips {
namespace mojom {

NOINLINE static const char* ChipTypeToStringHelper(ChipType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ChipType::kImage:
      return "kImage";
    case ChipType::kDeepSearch:
      return "kDeepSearch";
    case ChipType::kRecentTab:
      return "kRecentTab";
    case ChipType::kDeepDive:
      return "kDeepDive";
    default:
      return nullptr;
  }
}

std::string ChipTypeToString(ChipType value) {
  const char *str = ChipTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ChipType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ChipType value) {
  return os << ChipTypeToString(value);
}

namespace internal {


// static
bool TabInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabInfo_Data* object =
      static_cast<const TabInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_active_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_active_time, validation_context))
    return false;

  return true;
}

TabInfo_Data::TabInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ActionChip_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ActionChip_Data* object =
      static_cast<const ActionChip_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestion, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestion_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suggestion, validation_context,
                                         &suggestion_validate_params)) {
    return false;
  }


  if (!::action_chips::mojom::internal::ChipType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tab, validation_context))
    return false;

  return true;
}

ActionChip_Data::ActionChip_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ActionChipsHandler_StartActionChipsRetrieval_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ActionChipsHandler_StartActionChipsRetrieval_Params_Data* object =
      static_cast<const ActionChipsHandler_StartActionChipsRetrieval_Params_Data*>(data);

  return true;
}

ActionChipsHandler_StartActionChipsRetrieval_Params_Data::ActionChipsHandler_StartActionChipsRetrieval_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnActionChipsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnActionChipsChanged_Params_Data* object =
      static_cast<const Page_OnActionChipsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action_chips, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& action_chips_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->action_chips, validation_context,
                                         &action_chips_validate_params)) {
    return false;
  }

  return true;
}

Page_OnActionChipsChanged_Params_Data::Page_OnActionChipsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data* object =
      static_cast<const ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data::ActionChipsHandlerFactory_CreateActionChipsHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace action_chips

namespace perfetto {

// static
void TraceFormatTraits<::action_chips::mojom::ChipType>::WriteIntoTrace(
   perfetto::TracedValue context, ::action_chips::mojom::ChipType value) {
  return std::move(context).WriteString(::action_chips::mojom::ChipTypeToString(value));
}

} // namespace perfetto