// chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace action_chips::mojom {
class TabInfoDataView;

class ActionChipDataView;



}  // action_chips::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::action_chips::mojom::TabInfoDataView> {
  using Data = ::action_chips::mojom::internal::TabInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::action_chips::mojom::ActionChipDataView> {
  using Data = ::action_chips::mojom::internal::ActionChip_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace action_chips::mojom {


enum class ChipType : int32_t {
  
  kImage = 0,
  
  kDeepSearch = 1,
  
  kRecentTab = 2,
  
  kDeepDive = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ChipType value);
inline bool IsKnownEnumValue(ChipType value) {
  return internal::ChipType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ActionChipsHandlerInterfaceBase {};

using ActionChipsHandlerPtrDataView =
    mojo::InterfacePtrDataView<ActionChipsHandlerInterfaceBase>;
using ActionChipsHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ActionChipsHandlerInterfaceBase>;
using ActionChipsHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ActionChipsHandlerInterfaceBase>;
using ActionChipsHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ActionChipsHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;
class ActionChipsHandlerFactoryInterfaceBase {};

using ActionChipsHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<ActionChipsHandlerFactoryInterfaceBase>;
using ActionChipsHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<ActionChipsHandlerFactoryInterfaceBase>;
using ActionChipsHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ActionChipsHandlerFactoryInterfaceBase>;
using ActionChipsHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ActionChipsHandlerFactoryInterfaceBase>;


class TabInfoDataView {
 public:
  TabInfoDataView() = default;

  TabInfoDataView(
      internal::TabInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLastActiveTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastActiveTime(UserType* output) {
    
    auto* pointer = data_->last_active_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ActionChipDataView {
 public:
  ActionChipDataView() = default;

  ActionChipDataView(
      internal::ActionChip_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSuggestionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestion(UserType* output) {
    
    auto* pointer = data_->suggestion.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::action_chips::mojom::ChipType>(
        data_value, output);
  }
  ChipType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::action_chips::mojom::ChipType>(data_->type));
  }
  inline void GetTabDataView(
      TabInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTab(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::action_chips::mojom::TabInfoDataView, UserType>(),
    "Attempting to read the optional `tab` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTab` instead "
    "of `ReadTab if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tab.Get();
    return mojo::internal::Deserialize<::action_chips::mojom::TabInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::ActionChip_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // action_chips::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_ACTION_CHIPS_ACTION_CHIPS_MOJOM_DATA_VIEW_H_