// chrome/browser/ui/webui/legion_internals/legion_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_LEGION_INTERNALS_LEGION_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_LEGION_INTERNALS_LEGION_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace legion_internals::mojom {

class LegionInternalsPageHandlerProxy;

template <typename ImplRefTraits>
class LegionInternalsPageHandlerStub;

class LegionInternalsPageHandlerRequestValidator;
class LegionInternalsPageHandlerResponseValidator;


class LegionInternalsPageHandler
    : public LegionInternalsPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "legion_internals.mojom.LegionInternalsPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LegionInternalsPageHandlerInterfaceBase;
  using Proxy_ = LegionInternalsPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = LegionInternalsPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = LegionInternalsPageHandlerRequestValidator;
  using ResponseValidator_ = LegionInternalsPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kConnectMinVersion = 0,
    kCloseMinVersion = 0,
    kSendRequestMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Connect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LegionInternalsPageHandler() = default;

  using ConnectCallback = base::OnceCallback<void()>;
  using ConnectMojoCallback = base::OnceCallback<void()>;

  virtual void Connect(const std::string& url, const std::string& api_key, ConnectCallback callback) = 0;

  using CloseCallback = base::OnceCallback<void()>;
  using CloseMojoCallback = base::OnceCallback<void()>;

  virtual void Close(CloseCallback callback) = 0;

  using SendRequestCallback = base::OnceCallback<void(LegionResponsePtr)>;
  using SendRequestMojoCallback = base::OnceCallback<void(LegionResponsePtr)>;

  virtual void SendRequest(const std::string& feature_name, const std::string& request, SendRequestCallback callback) = 0;
};



class  LegionInternalsPageHandlerProxy
    : public LegionInternalsPageHandler {
 public:
  using InterfaceType = LegionInternalsPageHandler;

  explicit LegionInternalsPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Connect(const std::string& url, const std::string& api_key, ConnectCallback callback) final;
  
  void Close(CloseCallback callback) final;
  
  void SendRequest(const std::string& feature_name, const std::string& request, SendRequestCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LegionInternalsPageHandlerStubDispatch {
 public:
  static bool Accept(LegionInternalsPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LegionInternalsPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LegionInternalsPageHandler>>
class LegionInternalsPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LegionInternalsPageHandlerStub() = default;
  ~LegionInternalsPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LegionInternalsPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LegionInternalsPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LegionInternalsPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LegionInternalsPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  LegionResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LegionResponse, T>::value>;
  using DataView = LegionResponseDataView;
  using Data_ = internal::LegionResponse_Data;

  template <typename... Args>
  static LegionResponsePtr New(Args&&... args) {
    return LegionResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LegionResponsePtr From(const U& u) {
    return mojo::TypeConverter<LegionResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LegionResponse>::Convert(*this);
  }


  LegionResponse();

  LegionResponse(
      const std::optional<std::string>& response,
      const std::optional<std::string>& error);


  ~LegionResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LegionResponsePtr>
  LegionResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LegionResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LegionResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LegionResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LegionResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LegionResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LegionResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LegionResponse_UnserializedMessageContext<
            UserType, LegionResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LegionResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LegionResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LegionResponse_UnserializedMessageContext<
            UserType, LegionResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LegionResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> response;
  
  std::optional<std::string> error;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LegionResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LegionResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LegionResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LegionResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
LegionResponsePtr LegionResponse::Clone() const {
  return New(
      mojo::Clone(response),
      mojo::Clone(error)
  );
}

template <typename T, LegionResponse::EnableIfSame<T>*>
bool LegionResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  return true;
}

template <typename T, LegionResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  return false;
}


}  // legion_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::legion_internals::mojom::LegionResponse::DataView,
                                         ::legion_internals::mojom::LegionResponsePtr> {
  static bool IsNull(const ::legion_internals::mojom::LegionResponsePtr& input) { return !input; }
  static void SetToNull(::legion_internals::mojom::LegionResponsePtr* output) { output->reset(); }

  static const decltype(::legion_internals::mojom::LegionResponse::response)& response(
      const ::legion_internals::mojom::LegionResponsePtr& input) {
    return input->response;
  }

  static const decltype(::legion_internals::mojom::LegionResponse::error)& error(
      const ::legion_internals::mojom::LegionResponsePtr& input) {
    return input->error;
  }

  static bool Read(::legion_internals::mojom::LegionResponse::DataView input, ::legion_internals::mojom::LegionResponsePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_LEGION_INTERNALS_LEGION_INTERNALS_MOJOM_H_