// chrome/browser/ui/webui/legion_internals/legion_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-test-utils.h"


namespace legion_internals::mojom {
LegionResponse::LegionResponse()
    : response(),
      error() {}

LegionResponse::LegionResponse(
    const std::optional<std::string>& response_in,
    const std::optional<std::string>& error_in)
    : response(std::move(response_in)),
      error(std::move(error_in)) {}

LegionResponse::~LegionResponse() = default;

void LegionResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response"), this->response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LegionResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

LegionInternalsPageHandler::IPCStableHashFunction LegionInternalsPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LegionInternalsPageHandler>(message.name())) {
    case messages::LegionInternalsPageHandler::kConnect: {
      return &LegionInternalsPageHandler::Connect_Sym::IPCStableHash;
    }
    case messages::LegionInternalsPageHandler::kClose: {
      return &LegionInternalsPageHandler::Close_Sym::IPCStableHash;
    }
    case messages::LegionInternalsPageHandler::kSendRequest: {
      return &LegionInternalsPageHandler::SendRequest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LegionInternalsPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LegionInternalsPageHandler>(message.name())) {
      case messages::LegionInternalsPageHandler::kConnect:
            return "Receive legion_internals::mojom::LegionInternalsPageHandler::Connect";
      case messages::LegionInternalsPageHandler::kClose:
            return "Receive legion_internals::mojom::LegionInternalsPageHandler::Close";
      case messages::LegionInternalsPageHandler::kSendRequest:
            return "Receive legion_internals::mojom::LegionInternalsPageHandler::SendRequest";
    }
  } else {
    switch (static_cast<messages::LegionInternalsPageHandler>(message.name())) {
      case messages::LegionInternalsPageHandler::kConnect:
            return "Receive reply legion_internals::mojom::LegionInternalsPageHandler::Connect";
      case messages::LegionInternalsPageHandler::kClose:
            return "Receive reply legion_internals::mojom::LegionInternalsPageHandler::Close";
      case messages::LegionInternalsPageHandler::kSendRequest:
            return "Receive reply legion_internals::mojom::LegionInternalsPageHandler::SendRequest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LegionInternalsPageHandler::Connect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x338c38b4;  // IPCStableHash for legion_internals::mojom::LegionInternalsPageHandler::Connect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LegionInternalsPageHandler::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x36ebc8fc;  // IPCStableHash for legion_internals::mojom::LegionInternalsPageHandler::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LegionInternalsPageHandler::SendRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6139e49f;  // IPCStableHash for legion_internals::mojom::LegionInternalsPageHandler::SendRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LegionInternalsPageHandler_Connect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LegionInternalsPageHandler_Connect_ForwardToCallback(
      LegionInternalsPageHandler::ConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  LegionInternalsPageHandler_Connect_ForwardToCallback(const LegionInternalsPageHandler_Connect_ForwardToCallback&) = delete;
  LegionInternalsPageHandler_Connect_ForwardToCallback& operator=(const LegionInternalsPageHandler_Connect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LegionInternalsPageHandler::ConnectCallback callback_;
};

class LegionInternalsPageHandler_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LegionInternalsPageHandler_Close_ForwardToCallback(
      LegionInternalsPageHandler::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  LegionInternalsPageHandler_Close_ForwardToCallback(const LegionInternalsPageHandler_Close_ForwardToCallback&) = delete;
  LegionInternalsPageHandler_Close_ForwardToCallback& operator=(const LegionInternalsPageHandler_Close_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LegionInternalsPageHandler::CloseCallback callback_;
};

class LegionInternalsPageHandler_SendRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LegionInternalsPageHandler_SendRequest_ForwardToCallback(
      LegionInternalsPageHandler::SendRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  LegionInternalsPageHandler_SendRequest_ForwardToCallback(const LegionInternalsPageHandler_SendRequest_ForwardToCallback&) = delete;
  LegionInternalsPageHandler_SendRequest_ForwardToCallback& operator=(const LegionInternalsPageHandler_SendRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LegionInternalsPageHandler::SendRequestCallback callback_;
};

LegionInternalsPageHandlerProxy::LegionInternalsPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LegionInternalsPageHandlerProxy::Connect(
    const std::string& in_url, const std::string& in_api_key, ConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send legion_internals::mojom::LegionInternalsPageHandler::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("api_key"), in_api_key,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LegionInternalsPageHandler::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::legion_internals::mojom::internal::LegionInternalsPageHandler_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LegionInternalsPageHandler.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->api_key)::BaseType> api_key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_api_key,
    api_key_fragment);

  params->api_key.Set(
      api_key_fragment.is_null() ? nullptr : api_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->api_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null api_key in LegionInternalsPageHandler.Connect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LegionInternalsPageHandler::Name_);
  message.set_method_name("Connect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LegionInternalsPageHandler_Connect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LegionInternalsPageHandlerProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send legion_internals::mojom::LegionInternalsPageHandler::Close");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LegionInternalsPageHandler::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::legion_internals::mojom::internal::LegionInternalsPageHandler_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LegionInternalsPageHandler::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LegionInternalsPageHandler_Close_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LegionInternalsPageHandlerProxy::SendRequest(
    const std::string& in_feature_name, const std::string& in_request, SendRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send legion_internals::mojom::LegionInternalsPageHandler::SendRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature_name"), in_feature_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LegionInternalsPageHandler::kSendRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::legion_internals::mojom::internal::LegionInternalsPageHandler_SendRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->feature_name)::BaseType> feature_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_feature_name,
    feature_name_fragment);

  params->feature_name.Set(
      feature_name_fragment.is_null() ? nullptr : feature_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->feature_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null feature_name in LegionInternalsPageHandler.SendRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in LegionInternalsPageHandler.SendRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LegionInternalsPageHandler::Name_);
  message.set_method_name("SendRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LegionInternalsPageHandler_SendRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LegionInternalsPageHandler_Connect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LegionInternalsPageHandler::ConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LegionInternalsPageHandler_Connect_ProxyToResponder> proxy(
        new LegionInternalsPageHandler_Connect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LegionInternalsPageHandler_Connect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LegionInternalsPageHandler_Connect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LegionInternalsPageHandler_Connect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LegionInternalsPageHandler::ConnectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LegionInternalsPageHandler_Connect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LegionInternalsPageHandler_Connect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LegionInternalsPageHandler_Connect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LegionInternalsPageHandler.0
  bool success = true;
  LegionInternalsPageHandler_Connect_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LegionInternalsPageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LegionInternalsPageHandler_Connect_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply legion_internals::mojom::LegionInternalsPageHandler::Connect");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LegionInternalsPageHandler::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::legion_internals::mojom::internal::LegionInternalsPageHandler_Connect_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LegionInternalsPageHandler::Name_);
  message.set_method_name("Connect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LegionInternalsPageHandler_Close_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LegionInternalsPageHandler::CloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LegionInternalsPageHandler_Close_ProxyToResponder> proxy(
        new LegionInternalsPageHandler_Close_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LegionInternalsPageHandler_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LegionInternalsPageHandler_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LegionInternalsPageHandler_Close_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LegionInternalsPageHandler::CloseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool LegionInternalsPageHandler_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LegionInternalsPageHandler_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LegionInternalsPageHandler_Close_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LegionInternalsPageHandler.1
  bool success = true;
  LegionInternalsPageHandler_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LegionInternalsPageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void LegionInternalsPageHandler_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply legion_internals::mojom::LegionInternalsPageHandler::Close");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LegionInternalsPageHandler::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::legion_internals::mojom::internal::LegionInternalsPageHandler_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LegionInternalsPageHandler::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LegionInternalsPageHandler_SendRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LegionInternalsPageHandler::SendRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LegionInternalsPageHandler_SendRequest_ProxyToResponder> proxy(
        new LegionInternalsPageHandler_SendRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LegionInternalsPageHandler_SendRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LegionInternalsPageHandler_SendRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LegionInternalsPageHandler_SendRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LegionInternalsPageHandler::SendRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      LegionResponsePtr in_response);
};

bool LegionInternalsPageHandler_SendRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LegionInternalsPageHandler_SendRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LegionInternalsPageHandler_SendRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LegionInternalsPageHandler.2
  bool success = true;
  LegionResponsePtr p_response{};
  LegionInternalsPageHandler_SendRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LegionInternalsPageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response));
  }
  return true;
}

void LegionInternalsPageHandler_SendRequest_ProxyToResponder::Run(
    LegionResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply legion_internals::mojom::LegionInternalsPageHandler::SendRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type LegionResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LegionInternalsPageHandler::kSendRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::legion_internals::mojom::internal::LegionInternalsPageHandler_SendRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::legion_internals::mojom::LegionResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LegionInternalsPageHandler::Name_);
  message.set_method_name("SendRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LegionInternalsPageHandlerStubDispatch::Accept(
    LegionInternalsPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LegionInternalsPageHandler>(message->header()->name)) {
    case messages::LegionInternalsPageHandler::kConnect: {
      break;
    }
    case messages::LegionInternalsPageHandler::kClose: {
      break;
    }
    case messages::LegionInternalsPageHandler::kSendRequest: {
      break;
    }
  }
  return false;
}

// static
bool LegionInternalsPageHandlerStubDispatch::AcceptWithResponder(
    LegionInternalsPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LegionInternalsPageHandler>(message->header()->name)) {
    case messages::LegionInternalsPageHandler::kConnect: {
      internal::LegionInternalsPageHandler_Connect_Params_Data* params =
          reinterpret_cast<
              internal::LegionInternalsPageHandler_Connect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LegionInternalsPageHandler.0
      bool success = true;
      std::string p_url{};
      std::string p_api_key{};
      LegionInternalsPageHandler_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadApiKey(&p_api_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LegionInternalsPageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          LegionInternalsPageHandler_Connect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_url), 
        std::move(p_api_key), std::move(callback));
      return true;
    }
    case messages::LegionInternalsPageHandler::kClose: {
      internal::LegionInternalsPageHandler_Close_Params_Data* params =
          reinterpret_cast<
              internal::LegionInternalsPageHandler_Close_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LegionInternalsPageHandler.1
      bool success = true;
      LegionInternalsPageHandler_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LegionInternalsPageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          LegionInternalsPageHandler_Close_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
    case messages::LegionInternalsPageHandler::kSendRequest: {
      internal::LegionInternalsPageHandler_SendRequest_Params_Data* params =
          reinterpret_cast<
              internal::LegionInternalsPageHandler_SendRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LegionInternalsPageHandler.2
      bool success = true;
      std::string p_feature_name{};
      std::string p_request{};
      LegionInternalsPageHandler_SendRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatureName(&p_feature_name))
        success = false;
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LegionInternalsPageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          LegionInternalsPageHandler_SendRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendRequest(        
        std::move(p_feature_name), 
        std::move(p_request), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLegionInternalsPageHandlerValidationInfo[] = {
    { &internal::LegionInternalsPageHandler_Connect_Params_Data::Validate,
     &internal::LegionInternalsPageHandler_Connect_ResponseParams_Data::Validate},
    { &internal::LegionInternalsPageHandler_Close_Params_Data::Validate,
     &internal::LegionInternalsPageHandler_Close_ResponseParams_Data::Validate},
    { &internal::LegionInternalsPageHandler_SendRequest_Params_Data::Validate,
     &internal::LegionInternalsPageHandler_SendRequest_ResponseParams_Data::Validate},
};

bool LegionInternalsPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::legion_internals::mojom::LegionInternalsPageHandler::Name_,
    kLegionInternalsPageHandlerValidationInfo);
}

bool LegionInternalsPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::legion_internals::mojom::LegionInternalsPageHandler::Name_,
    kLegionInternalsPageHandlerValidationInfo);
}


}  // legion_internals::mojom


namespace mojo {


// static
bool StructTraits<::legion_internals::mojom::LegionResponse::DataView, ::legion_internals::mojom::LegionResponsePtr>::Read(
    ::legion_internals::mojom::LegionResponse::DataView input,
    ::legion_internals::mojom::LegionResponsePtr* output) {
  bool success = true;
  ::legion_internals::mojom::LegionResponsePtr result(::legion_internals::mojom::LegionResponse::New());
  
      if (success && !input.ReadResponse(&result->response))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace legion_internals::mojom {


void LegionInternalsPageHandlerInterceptorForTesting::Connect(const std::string& url, const std::string& api_key, ConnectCallback callback) {
  GetForwardingInterface()->Connect(
    std::move(url)
    , 
    std::move(api_key)
    , std::move(callback));
}
void LegionInternalsPageHandlerInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
void LegionInternalsPageHandlerInterceptorForTesting::SendRequest(const std::string& feature_name, const std::string& request, SendRequestCallback callback) {
  GetForwardingInterface()->SendRequest(
    std::move(feature_name)
    , 
    std::move(request)
    , std::move(callback));
}
LegionInternalsPageHandlerAsyncWaiter::LegionInternalsPageHandlerAsyncWaiter(
    LegionInternalsPageHandler* proxy) : proxy_(proxy) {}

LegionInternalsPageHandlerAsyncWaiter::~LegionInternalsPageHandlerAsyncWaiter() = default;


void LegionInternalsPageHandlerAsyncWaiter::Connect(
    const std::string& url, const std::string& api_key) {
  base::RunLoop loop;
  proxy_->Connect(
      std::move(url),
      std::move(api_key),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void LegionInternalsPageHandlerAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void LegionInternalsPageHandlerAsyncWaiter::SendRequest(
    const std::string& feature_name, const std::string& request, LegionResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->SendRequest(
      std::move(feature_name),
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             LegionResponsePtr* out_response
,
             LegionResponsePtr response) {*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_response));
  loop.Run();
}

LegionResponsePtr LegionInternalsPageHandlerAsyncWaiter::SendRequest(
    const std::string& feature_name, const std::string& request) {
  LegionResponsePtr async_wait_result;
  SendRequest(std::move(feature_name),std::move(request),&async_wait_result);
  return async_wait_result;
}






}  // legion_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif