// chrome/browser/ui/webui/legion_internals/legion_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_LEGION_INTERNALS_LEGION_INTERNALS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_LEGION_INTERNALS_LEGION_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/legion_internals/legion_internals.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::legion_internals::mojom::LegionResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::legion_internals::mojom::LegionResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::legion_internals::mojom::internal::LegionResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::response(input)) in_response = Traits::response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response)::BaseType> response_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_response,
      response_fragment);

    fragment->response.Set(
        response_fragment.is_null() ? nullptr : response_fragment.data());

    decltype(Traits::error(input)) in_error = Traits::error(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error)::BaseType> error_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_error,
      error_fragment);

    fragment->error.Set(
        error_fragment.is_null() ? nullptr : error_fragment.data());
  }

  static bool Deserialize(::legion_internals::mojom::internal::LegionResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::legion_internals::mojom::LegionResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace legion_internals::mojom {

inline void LegionResponseDataView::GetResponseDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->response.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LegionResponseDataView::GetErrorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // legion_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_LEGION_INTERNALS_LEGION_INTERNALS_MOJOM_SHARED_H_