// chrome/browser/ui/webui/infobar_internals/infobar_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/infobar_internals/infobar_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/infobar_internals/infobar_internals.mojom-params-data.h"
namespace infobar_internals {
namespace mojom {

NOINLINE static const char* InfoBarTypeToStringHelper(InfoBarType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InfoBarType::kDefaultBrowser:
      return "kDefaultBrowser";
    case InfoBarType::kSessionRestore:
      return "kSessionRestore";
    default:
      return nullptr;
  }
}

std::string InfoBarTypeToString(InfoBarType value) {
  const char *str = InfoBarTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InfoBarType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InfoBarType value) {
  return os << InfoBarTypeToString(value);
}

namespace internal {


// static
bool InfoBarEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InfoBarEntry_Data* object =
      static_cast<const InfoBarEntry_Data*>(data);


  if (!::infobar_internals::mojom::internal::InfoBarType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

InfoBarEntry_Data::InfoBarEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetInfoBars_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetInfoBars_Params_Data* object =
      static_cast<const PageHandler_GetInfoBars_Params_Data*>(data);

  return true;
}

PageHandler_GetInfoBars_Params_Data::PageHandler_GetInfoBars_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetInfoBars_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetInfoBars_ResponseParams_Data* object =
      static_cast<const PageHandler_GetInfoBars_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->infobars, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& infobars_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->infobars, validation_context,
                                         &infobars_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetInfoBars_ResponseParams_Data::PageHandler_GetInfoBars_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_TriggerInfoBar_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_TriggerInfoBar_Params_Data* object =
      static_cast<const PageHandler_TriggerInfoBar_Params_Data*>(data);


  if (!::infobar_internals::mojom::internal::InfoBarType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

PageHandler_TriggerInfoBar_Params_Data::PageHandler_TriggerInfoBar_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_TriggerInfoBar_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_TriggerInfoBar_ResponseParams_Data* object =
      static_cast<const PageHandler_TriggerInfoBar_ResponseParams_Data*>(data);

  return true;
}

PageHandler_TriggerInfoBar_ResponseParams_Data::PageHandler_TriggerInfoBar_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace infobar_internals

namespace perfetto {

// static
void TraceFormatTraits<::infobar_internals::mojom::InfoBarType>::WriteIntoTrace(
   perfetto::TracedValue context, ::infobar_internals::mojom::InfoBarType value) {
  return std::move(context).WriteString(::infobar_internals::mojom::InfoBarTypeToString(value));
}

} // namespace perfetto