// chrome/browser/ui/webui/downloads/downloads.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/downloads/downloads.mojom.h"


namespace downloads::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void GetDownloads(const std::vector<std::string>& search_terms) override;
  void OpenFileRequiringGesture(const std::string& id) override;
  void Drag(const std::string& id) override;
  void SaveSuspiciousRequiringGesture(const std::string& id) override;
  void RecordOpenBypassWarningDialog(const std::string& id) override;
  void SaveDangerousFromDialogRequiringGesture(const std::string& id) override;
  void RecordCancelBypassWarningDialog(const std::string& id) override;
  void DiscardDangerous(const std::string& id) override;
  void RetryDownload(const std::string& id) override;
  void Show(const std::string& id) override;
  void Pause(const std::string& id) override;
  void Resume(const std::string& id) override;
  void Remove(const std::string& id) override;
  void Undo() override;
  void Cancel(const std::string& id) override;
  void ClearAll() override;
  void OpenDownloadsFolderRequiringGesture() override;
  void OpenEsbSettings() override;
  void LogEsbPromotionRowViewed() override;
  void OpenDuringScanningRequiringGesture(const std::string& id) override;
  void ReviewDangerousRequiringGesture(const std::string& id) override;
  void DeepScan(const std::string& id) override;
  void BypassDeepScanRequiringGesture(const std::string& id) override;
  void IsEligibleForEsbPromo(IsEligibleForEsbPromoCallback callback) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void IsEligibleForEsbPromo(
      bool* out_result);
  bool IsEligibleForEsbPromo();

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void RemoveItem(int32_t index) override;
  void UpdateItem(int32_t index, DataPtr data) override;
  void InsertItems(int32_t index, std::vector<DataPtr> items) override;
  void ClearAll() override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // downloads::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_TEST_UTILS_H_