// chrome/browser/ui/webui/downloads/downloads.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/downloads/downloads.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace downloads::mojom {
class DataDataView;



}  // downloads::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::downloads::mojom::DataDataView> {
  using Data = ::downloads::mojom::internal::Data_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace downloads::mojom {


enum class DangerType : int32_t {
  
  kNoApplicableDangerType = 0,
  
  kDangerousFile = 1,
  
  kDangerousUrl = 2,
  
  kDangerousContent = 3,
  
  kCookieTheft = 4,
  
  kUncommonContent = 5,
  
  kDangerousHost = 6,
  
  kPotentiallyUnwanted = 7,
  
  kAsyncScanning = 8,
  
  kAsyncLocalPasswordScanning = 9,
  
  kBlockedPasswordProtected = 10,
  
  kBlockedTooLarge = 11,
  
  kSensitiveContentWarning = 12,
  
  kSensitiveContentBlock = 13,
  
  kDeepScannedFailed = 14,
  
  kDeepScannedSafe = 15,
  
  kDeepScannedOpenedDangerous = 16,
  
  kBlockedScanFailed = 17,
  
  kForcedSaveToGdrive = 18,
  kMinValue = 0,
  kMaxValue = 18,
};

 std::ostream& operator<<(std::ostream& os, DangerType value);
inline bool IsKnownEnumValue(DangerType value) {
  return internal::DangerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TailoredWarningType : int32_t {
  
  kNoApplicableTailoredWarningType = 0,
  
  kCookieTheft = 1,
  
  kSuspiciousArchive = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TailoredWarningType value);
inline bool IsKnownEnumValue(TailoredWarningType value) {
  return internal::TailoredWarningType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class State : int32_t {
  
  kInProgress = 0,
  
  kCancelled = 1,
  
  kComplete = 2,
  
  kPaused = 3,
  
  kDangerous = 4,
  
  kInterrupted = 5,
  
  kInsecure = 6,
  
  kAsyncScanning = 7,
  
  kPromptForScanning = 8,
  
  kPromptForLocalPasswordScanning = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

 std::ostream& operator<<(std::ostream& os, State value);
inline bool IsKnownEnumValue(State value) {
  return internal::State_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SafeBrowsingState : int32_t {
  
  kNoSafeBrowsing = 0,
  
  kStandardProtection = 1,
  
  kEnhancedProtection = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SafeBrowsingState value);
inline bool IsKnownEnumValue(SafeBrowsingState value) {
  return internal::SafeBrowsingState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class DataDataView {
 public:
  DataDataView() = default;

  DataDataView(
      internal::Data_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool file_externally_removed() const {
    return data_->file_externally_removed;
  }
  bool is_dangerous() const {
    return data_->is_dangerous;
  }
  bool is_insecure() const {
    return data_->is_insecure;
  }
  bool is_reviewable() const {
    return data_->is_reviewable;
  }
  bool otr() const {
    return data_->otr;
  }
  bool resume() const {
    return data_->resume;
  }
  bool retry() const {
    return data_->retry;
  }
  int32_t percent() const {
    return data_->percent;
  }
  int32_t started() const {
    return data_->started;
  }
  int64_t total() const {
    return data_->total;
  }
  inline void GetByExtIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadByExtId(UserType* output) {
    
    auto* pointer = data_->by_ext_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetByExtNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadByExtName(UserType* output) {
    
    auto* pointer = data_->by_ext_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDangerType(UserType* output) const {
    auto data_value = data_->danger_type;
    return mojo::internal::Deserialize<::downloads::mojom::DangerType>(
        data_value, output);
  }
  DangerType danger_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::downloads::mojom::DangerType>(data_->danger_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTailoredWarningType(UserType* output) const {
    auto data_value = data_->tailored_warning_type;
    return mojo::internal::Deserialize<::downloads::mojom::TailoredWarningType>(
        data_value, output);
  }
  TailoredWarningType tailored_warning_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::downloads::mojom::TailoredWarningType>(data_->tailored_warning_type));
  }
  inline void GetDateStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDateString(UserType* output) {
    
    auto* pointer = data_->date_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFileNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileName(UserType* output) {
    
    auto* pointer = data_->file_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFilePathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFileUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileUrl(UserType* output) {
    
    auto* pointer = data_->file_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLastReasonTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastReasonText(UserType* output) {
    
    auto* pointer = data_->last_reason_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetProgressStatusTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProgressStatusText(UserType* output) {
    
    auto* pointer = data_->progress_status_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetShowInFolderTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShowInFolderText(UserType* output) {
    
    auto* pointer = data_->show_in_folder_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSinceStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSinceString(UserType* output) {
    
    auto* pointer = data_->since_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::downloads::mojom::State>(
        data_value, output);
  }
  State state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::downloads::mojom::State>(data_->state));
  }
  inline void GetDisplayInitiatorOriginDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayInitiatorOrigin(UserType* output) {
    
    auto* pointer = data_->display_initiator_origin.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayUrlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayUrl(UserType* output) {
    
    auto* pointer = data_->display_url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSafeBrowsingState(UserType* output) const {
    auto data_value = data_->safe_browsing_state;
    return mojo::internal::Deserialize<::downloads::mojom::SafeBrowsingState>(
        data_value, output);
  }
  SafeBrowsingState safe_browsing_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::downloads::mojom::SafeBrowsingState>(data_->safe_browsing_state));
  }
  bool has_safe_browsing_verdict() const {
    return data_->has_safe_browsing_verdict;
  }
 private:
  internal::Data_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // downloads::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_DATA_VIEW_H_