// chrome/browser/ui/webui/discards/site_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/discards/site_data.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/discards/site_data.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/discards/site_data.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace discards::mojom {

class SiteDataProviderProxy;

template <typename ImplRefTraits>
class SiteDataProviderStub;

class SiteDataProviderRequestValidator;
class SiteDataProviderResponseValidator;


class SiteDataProvider
    : public SiteDataProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "discards.mojom.SiteDataProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SiteDataProviderInterfaceBase;
  using Proxy_ = SiteDataProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = SiteDataProviderStub<ImplRefTraits>;

  using RequestValidator_ = SiteDataProviderRequestValidator;
  using ResponseValidator_ = SiteDataProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSiteDataArrayMinVersion = 0,
    kGetSiteDataDatabaseSizeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSiteDataArray_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSiteDataDatabaseSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SiteDataProvider() = default;

  using GetSiteDataArrayCallback = base::OnceCallback<void(SiteDataArrayPtr)>;
  using GetSiteDataArrayMojoCallback = base::OnceCallback<void(SiteDataArrayPtr)>;

  virtual void GetSiteDataArray(const std::vector<std::string>& explicitly_requested_origins, GetSiteDataArrayCallback callback) = 0;

  using GetSiteDataDatabaseSizeCallback = base::OnceCallback<void(SiteDataDatabaseSizePtr)>;
  using GetSiteDataDatabaseSizeMojoCallback = base::OnceCallback<void(SiteDataDatabaseSizePtr)>;

  virtual void GetSiteDataDatabaseSize(GetSiteDataDatabaseSizeCallback callback) = 0;
};



class  SiteDataProviderProxy
    : public SiteDataProvider {
 public:
  using InterfaceType = SiteDataProvider;

  explicit SiteDataProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetSiteDataArray(const std::vector<std::string>& explicitly_requested_origins, GetSiteDataArrayCallback callback) final;
  
  void GetSiteDataDatabaseSize(GetSiteDataDatabaseSizeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SiteDataProviderStubDispatch {
 public:
  static bool Accept(SiteDataProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SiteDataProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SiteDataProvider>>
class SiteDataProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SiteDataProviderStub() = default;
  ~SiteDataProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SiteDataProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SiteDataProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SiteDataProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SiteDataProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  SiteDataFeature {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteDataFeature, T>::value>;
  using DataView = SiteDataFeatureDataView;
  using Data_ = internal::SiteDataFeature_Data;

  template <typename... Args>
  static SiteDataFeaturePtr New(Args&&... args) {
    return SiteDataFeaturePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteDataFeaturePtr From(const U& u) {
    return mojo::TypeConverter<SiteDataFeaturePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteDataFeature>::Convert(*this);
  }


  SiteDataFeature();

  SiteDataFeature(
      int64_t observation_duration,
      int64_t use_timestamp);


  ~SiteDataFeature();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteDataFeaturePtr>
  SiteDataFeaturePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteDataFeature::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteDataFeature::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteDataFeature::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataFeature::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataFeature::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteDataFeature::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteDataFeature_UnserializedMessageContext<
            UserType, SiteDataFeature::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteDataFeature::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteDataFeature::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteDataFeature_UnserializedMessageContext<
            UserType, SiteDataFeature::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteDataFeature::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t observation_duration;
  
  int64_t use_timestamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteDataFeature::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteDataFeature::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteDataFeature::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteDataFeature::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SiteDataPerformanceMeasurement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteDataPerformanceMeasurement, T>::value>;
  using DataView = SiteDataPerformanceMeasurementDataView;
  using Data_ = internal::SiteDataPerformanceMeasurement_Data;

  template <typename... Args>
  static SiteDataPerformanceMeasurementPtr New(Args&&... args) {
    return SiteDataPerformanceMeasurementPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteDataPerformanceMeasurementPtr From(const U& u) {
    return mojo::TypeConverter<SiteDataPerformanceMeasurementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteDataPerformanceMeasurement>::Convert(*this);
  }


  SiteDataPerformanceMeasurement();

  SiteDataPerformanceMeasurement(
      float avg_cpu_usage_us,
      float avg_footprint_kb,
      float avg_load_duration_us);


  ~SiteDataPerformanceMeasurement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteDataPerformanceMeasurementPtr>
  SiteDataPerformanceMeasurementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataPerformanceMeasurement::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataPerformanceMeasurement::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteDataPerformanceMeasurement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteDataPerformanceMeasurement_UnserializedMessageContext<
            UserType, SiteDataPerformanceMeasurement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteDataPerformanceMeasurement::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteDataPerformanceMeasurement::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteDataPerformanceMeasurement_UnserializedMessageContext<
            UserType, SiteDataPerformanceMeasurement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteDataPerformanceMeasurement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float avg_cpu_usage_us;
  
  float avg_footprint_kb;
  
  float avg_load_duration_us;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SiteDataDatabaseSize {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteDataDatabaseSize, T>::value>;
  using DataView = SiteDataDatabaseSizeDataView;
  using Data_ = internal::SiteDataDatabaseSize_Data;

  template <typename... Args>
  static SiteDataDatabaseSizePtr New(Args&&... args) {
    return SiteDataDatabaseSizePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteDataDatabaseSizePtr From(const U& u) {
    return mojo::TypeConverter<SiteDataDatabaseSizePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteDataDatabaseSize>::Convert(*this);
  }


  SiteDataDatabaseSize();

  SiteDataDatabaseSize(
      int64_t num_rows,
      int64_t on_disk_size_kb);


  ~SiteDataDatabaseSize();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteDataDatabaseSizePtr>
  SiteDataDatabaseSizePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteDataDatabaseSize::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteDataDatabaseSize::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteDataDatabaseSize::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataDatabaseSize::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataDatabaseSize::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteDataDatabaseSize::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteDataDatabaseSize_UnserializedMessageContext<
            UserType, SiteDataDatabaseSize::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteDataDatabaseSize::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteDataDatabaseSize::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteDataDatabaseSize_UnserializedMessageContext<
            UserType, SiteDataDatabaseSize::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteDataDatabaseSize::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t num_rows;
  
  int64_t on_disk_size_kb;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteDataDatabaseSize::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteDataDatabaseSize::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteDataDatabaseSize::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteDataDatabaseSize::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}













class  SiteDataValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteDataValue, T>::value>;
  using DataView = SiteDataValueDataView;
  using Data_ = internal::SiteDataValue_Data;

  template <typename... Args>
  static SiteDataValuePtr New(Args&&... args) {
    return SiteDataValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteDataValuePtr From(const U& u) {
    return mojo::TypeConverter<SiteDataValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteDataValue>::Convert(*this);
  }


  SiteDataValue();

  SiteDataValue(
      uint32_t last_loaded,
      SiteDataFeaturePtr updates_favicon_in_background,
      SiteDataFeaturePtr updates_title_in_background,
      SiteDataFeaturePtr uses_audio_in_background,
      SiteDataPerformanceMeasurementPtr load_time_estimates);

SiteDataValue(const SiteDataValue&) = delete;
SiteDataValue& operator=(const SiteDataValue&) = delete;

  ~SiteDataValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteDataValuePtr>
  SiteDataValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteDataValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteDataValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteDataValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteDataValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteDataValue_UnserializedMessageContext<
            UserType, SiteDataValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteDataValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteDataValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteDataValue_UnserializedMessageContext<
            UserType, SiteDataValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteDataValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t last_loaded;
  
  SiteDataFeaturePtr updates_favicon_in_background;
  
  SiteDataFeaturePtr updates_title_in_background;
  
  SiteDataFeaturePtr uses_audio_in_background;
  
  SiteDataPerformanceMeasurementPtr load_time_estimates;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteDataValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteDataValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteDataValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteDataValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SiteDataEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteDataEntry, T>::value>;
  using DataView = SiteDataEntryDataView;
  using Data_ = internal::SiteDataEntry_Data;

  template <typename... Args>
  static SiteDataEntryPtr New(Args&&... args) {
    return SiteDataEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteDataEntryPtr From(const U& u) {
    return mojo::TypeConverter<SiteDataEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteDataEntry>::Convert(*this);
  }


  SiteDataEntry();

  SiteDataEntry(
      const std::string& origin,
      bool is_dirty,
      SiteDataValuePtr value);

SiteDataEntry(const SiteDataEntry&) = delete;
SiteDataEntry& operator=(const SiteDataEntry&) = delete;

  ~SiteDataEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteDataEntryPtr>
  SiteDataEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteDataEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteDataEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteDataEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteDataEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteDataEntry_UnserializedMessageContext<
            UserType, SiteDataEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteDataEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteDataEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteDataEntry_UnserializedMessageContext<
            UserType, SiteDataEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteDataEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string origin;
  
  bool is_dirty;
  
  SiteDataValuePtr value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteDataEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteDataEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteDataEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteDataEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SiteDataArray {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteDataArray, T>::value>;
  using DataView = SiteDataArrayDataView;
  using Data_ = internal::SiteDataArray_Data;

  template <typename... Args>
  static SiteDataArrayPtr New(Args&&... args) {
    return SiteDataArrayPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteDataArrayPtr From(const U& u) {
    return mojo::TypeConverter<SiteDataArrayPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteDataArray>::Convert(*this);
  }


  SiteDataArray();

  explicit SiteDataArray(
      std::vector<SiteDataEntryPtr> db_rows);

SiteDataArray(const SiteDataArray&) = delete;
SiteDataArray& operator=(const SiteDataArray&) = delete;

  ~SiteDataArray();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteDataArrayPtr>
  SiteDataArrayPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteDataArray::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteDataArray::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteDataArray::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataArray::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteDataArray::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteDataArray::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteDataArray_UnserializedMessageContext<
            UserType, SiteDataArray::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteDataArray::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteDataArray::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteDataArray_UnserializedMessageContext<
            UserType, SiteDataArray::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteDataArray::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<SiteDataEntryPtr> db_rows;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteDataArray::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteDataArray::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteDataArray::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteDataArray::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SiteDataFeaturePtr SiteDataFeature::Clone() const {
  return New(
      mojo::Clone(observation_duration),
      mojo::Clone(use_timestamp)
  );
}

template <typename T, SiteDataFeature::EnableIfSame<T>*>
bool SiteDataFeature::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->observation_duration, other_struct.observation_duration))
    return false;
  if (!mojo::Equals(this->use_timestamp, other_struct.use_timestamp))
    return false;
  return true;
}

template <typename T, SiteDataFeature::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.observation_duration < rhs.observation_duration)
    return true;
  if (rhs.observation_duration < lhs.observation_duration)
    return false;
  if (lhs.use_timestamp < rhs.use_timestamp)
    return true;
  if (rhs.use_timestamp < lhs.use_timestamp)
    return false;
  return false;
}
template <typename StructPtrType>
SiteDataPerformanceMeasurementPtr SiteDataPerformanceMeasurement::Clone() const {
  return New(
      mojo::Clone(avg_cpu_usage_us),
      mojo::Clone(avg_footprint_kb),
      mojo::Clone(avg_load_duration_us)
  );
}

template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>*>
bool SiteDataPerformanceMeasurement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->avg_cpu_usage_us, other_struct.avg_cpu_usage_us))
    return false;
  if (!mojo::Equals(this->avg_footprint_kb, other_struct.avg_footprint_kb))
    return false;
  if (!mojo::Equals(this->avg_load_duration_us, other_struct.avg_load_duration_us))
    return false;
  return true;
}

template <typename T, SiteDataPerformanceMeasurement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.avg_cpu_usage_us < rhs.avg_cpu_usage_us)
    return true;
  if (rhs.avg_cpu_usage_us < lhs.avg_cpu_usage_us)
    return false;
  if (lhs.avg_footprint_kb < rhs.avg_footprint_kb)
    return true;
  if (rhs.avg_footprint_kb < lhs.avg_footprint_kb)
    return false;
  if (lhs.avg_load_duration_us < rhs.avg_load_duration_us)
    return true;
  if (rhs.avg_load_duration_us < lhs.avg_load_duration_us)
    return false;
  return false;
}
template <typename StructPtrType>
SiteDataDatabaseSizePtr SiteDataDatabaseSize::Clone() const {
  return New(
      mojo::Clone(num_rows),
      mojo::Clone(on_disk_size_kb)
  );
}

template <typename T, SiteDataDatabaseSize::EnableIfSame<T>*>
bool SiteDataDatabaseSize::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->num_rows, other_struct.num_rows))
    return false;
  if (!mojo::Equals(this->on_disk_size_kb, other_struct.on_disk_size_kb))
    return false;
  return true;
}

template <typename T, SiteDataDatabaseSize::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.num_rows < rhs.num_rows)
    return true;
  if (rhs.num_rows < lhs.num_rows)
    return false;
  if (lhs.on_disk_size_kb < rhs.on_disk_size_kb)
    return true;
  if (rhs.on_disk_size_kb < lhs.on_disk_size_kb)
    return false;
  return false;
}
template <typename StructPtrType>
SiteDataValuePtr SiteDataValue::Clone() const {
  return New(
      mojo::Clone(last_loaded),
      mojo::Clone(updates_favicon_in_background),
      mojo::Clone(updates_title_in_background),
      mojo::Clone(uses_audio_in_background),
      mojo::Clone(load_time_estimates)
  );
}

template <typename T, SiteDataValue::EnableIfSame<T>*>
bool SiteDataValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->last_loaded, other_struct.last_loaded))
    return false;
  if (!mojo::Equals(this->updates_favicon_in_background, other_struct.updates_favicon_in_background))
    return false;
  if (!mojo::Equals(this->updates_title_in_background, other_struct.updates_title_in_background))
    return false;
  if (!mojo::Equals(this->uses_audio_in_background, other_struct.uses_audio_in_background))
    return false;
  if (!mojo::Equals(this->load_time_estimates, other_struct.load_time_estimates))
    return false;
  return true;
}

template <typename T, SiteDataValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.last_loaded < rhs.last_loaded)
    return true;
  if (rhs.last_loaded < lhs.last_loaded)
    return false;
  if (lhs.updates_favicon_in_background < rhs.updates_favicon_in_background)
    return true;
  if (rhs.updates_favicon_in_background < lhs.updates_favicon_in_background)
    return false;
  if (lhs.updates_title_in_background < rhs.updates_title_in_background)
    return true;
  if (rhs.updates_title_in_background < lhs.updates_title_in_background)
    return false;
  if (lhs.uses_audio_in_background < rhs.uses_audio_in_background)
    return true;
  if (rhs.uses_audio_in_background < lhs.uses_audio_in_background)
    return false;
  if (lhs.load_time_estimates < rhs.load_time_estimates)
    return true;
  if (rhs.load_time_estimates < lhs.load_time_estimates)
    return false;
  return false;
}
template <typename StructPtrType>
SiteDataEntryPtr SiteDataEntry::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(is_dirty),
      mojo::Clone(value)
  );
}

template <typename T, SiteDataEntry::EnableIfSame<T>*>
bool SiteDataEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->is_dirty, other_struct.is_dirty))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SiteDataEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.is_dirty < rhs.is_dirty)
    return true;
  if (rhs.is_dirty < lhs.is_dirty)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
SiteDataArrayPtr SiteDataArray::Clone() const {
  return New(
      mojo::Clone(db_rows)
  );
}

template <typename T, SiteDataArray::EnableIfSame<T>*>
bool SiteDataArray::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->db_rows, other_struct.db_rows))
    return false;
  return true;
}

template <typename T, SiteDataArray::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.db_rows < rhs.db_rows)
    return true;
  if (rhs.db_rows < lhs.db_rows)
    return false;
  return false;
}


}  // discards::mojom

namespace mojo {


template <>
struct  StructTraits<::discards::mojom::SiteDataFeature::DataView,
                                         ::discards::mojom::SiteDataFeaturePtr> {
  static bool IsNull(const ::discards::mojom::SiteDataFeaturePtr& input) { return !input; }
  static void SetToNull(::discards::mojom::SiteDataFeaturePtr* output) { output->reset(); }

  static decltype(::discards::mojom::SiteDataFeature::observation_duration) observation_duration(
      const ::discards::mojom::SiteDataFeaturePtr& input) {
    return input->observation_duration;
  }

  static decltype(::discards::mojom::SiteDataFeature::use_timestamp) use_timestamp(
      const ::discards::mojom::SiteDataFeaturePtr& input) {
    return input->use_timestamp;
  }

  static bool Read(::discards::mojom::SiteDataFeature::DataView input, ::discards::mojom::SiteDataFeaturePtr* output);
};


template <>
struct  StructTraits<::discards::mojom::SiteDataPerformanceMeasurement::DataView,
                                         ::discards::mojom::SiteDataPerformanceMeasurementPtr> {
  static bool IsNull(const ::discards::mojom::SiteDataPerformanceMeasurementPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::SiteDataPerformanceMeasurementPtr* output) { output->reset(); }

  static decltype(::discards::mojom::SiteDataPerformanceMeasurement::avg_cpu_usage_us) avg_cpu_usage_us(
      const ::discards::mojom::SiteDataPerformanceMeasurementPtr& input) {
    return input->avg_cpu_usage_us;
  }

  static decltype(::discards::mojom::SiteDataPerformanceMeasurement::avg_footprint_kb) avg_footprint_kb(
      const ::discards::mojom::SiteDataPerformanceMeasurementPtr& input) {
    return input->avg_footprint_kb;
  }

  static decltype(::discards::mojom::SiteDataPerformanceMeasurement::avg_load_duration_us) avg_load_duration_us(
      const ::discards::mojom::SiteDataPerformanceMeasurementPtr& input) {
    return input->avg_load_duration_us;
  }

  static bool Read(::discards::mojom::SiteDataPerformanceMeasurement::DataView input, ::discards::mojom::SiteDataPerformanceMeasurementPtr* output);
};


template <>
struct  StructTraits<::discards::mojom::SiteDataDatabaseSize::DataView,
                                         ::discards::mojom::SiteDataDatabaseSizePtr> {
  static bool IsNull(const ::discards::mojom::SiteDataDatabaseSizePtr& input) { return !input; }
  static void SetToNull(::discards::mojom::SiteDataDatabaseSizePtr* output) { output->reset(); }

  static decltype(::discards::mojom::SiteDataDatabaseSize::num_rows) num_rows(
      const ::discards::mojom::SiteDataDatabaseSizePtr& input) {
    return input->num_rows;
  }

  static decltype(::discards::mojom::SiteDataDatabaseSize::on_disk_size_kb) on_disk_size_kb(
      const ::discards::mojom::SiteDataDatabaseSizePtr& input) {
    return input->on_disk_size_kb;
  }

  static bool Read(::discards::mojom::SiteDataDatabaseSize::DataView input, ::discards::mojom::SiteDataDatabaseSizePtr* output);
};


template <>
struct  StructTraits<::discards::mojom::SiteDataValue::DataView,
                                         ::discards::mojom::SiteDataValuePtr> {
  static bool IsNull(const ::discards::mojom::SiteDataValuePtr& input) { return !input; }
  static void SetToNull(::discards::mojom::SiteDataValuePtr* output) { output->reset(); }

  static decltype(::discards::mojom::SiteDataValue::last_loaded) last_loaded(
      const ::discards::mojom::SiteDataValuePtr& input) {
    return input->last_loaded;
  }

  static const decltype(::discards::mojom::SiteDataValue::updates_favicon_in_background)& updates_favicon_in_background(
      const ::discards::mojom::SiteDataValuePtr& input) {
    return input->updates_favicon_in_background;
  }

  static const decltype(::discards::mojom::SiteDataValue::updates_title_in_background)& updates_title_in_background(
      const ::discards::mojom::SiteDataValuePtr& input) {
    return input->updates_title_in_background;
  }

  static const decltype(::discards::mojom::SiteDataValue::uses_audio_in_background)& uses_audio_in_background(
      const ::discards::mojom::SiteDataValuePtr& input) {
    return input->uses_audio_in_background;
  }

  static const decltype(::discards::mojom::SiteDataValue::load_time_estimates)& load_time_estimates(
      const ::discards::mojom::SiteDataValuePtr& input) {
    return input->load_time_estimates;
  }

  static bool Read(::discards::mojom::SiteDataValue::DataView input, ::discards::mojom::SiteDataValuePtr* output);
};


template <>
struct  StructTraits<::discards::mojom::SiteDataEntry::DataView,
                                         ::discards::mojom::SiteDataEntryPtr> {
  static bool IsNull(const ::discards::mojom::SiteDataEntryPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::SiteDataEntryPtr* output) { output->reset(); }

  static const decltype(::discards::mojom::SiteDataEntry::origin)& origin(
      const ::discards::mojom::SiteDataEntryPtr& input) {
    return input->origin;
  }

  static decltype(::discards::mojom::SiteDataEntry::is_dirty) is_dirty(
      const ::discards::mojom::SiteDataEntryPtr& input) {
    return input->is_dirty;
  }

  static const decltype(::discards::mojom::SiteDataEntry::value)& value(
      const ::discards::mojom::SiteDataEntryPtr& input) {
    return input->value;
  }

  static bool Read(::discards::mojom::SiteDataEntry::DataView input, ::discards::mojom::SiteDataEntryPtr* output);
};


template <>
struct  StructTraits<::discards::mojom::SiteDataArray::DataView,
                                         ::discards::mojom::SiteDataArrayPtr> {
  static bool IsNull(const ::discards::mojom::SiteDataArrayPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::SiteDataArrayPtr* output) { output->reset(); }

  static const decltype(::discards::mojom::SiteDataArray::db_rows)& db_rows(
      const ::discards::mojom::SiteDataArrayPtr& input) {
    return input->db_rows;
  }

  static bool Read(::discards::mojom::SiteDataArray::DataView input, ::discards::mojom::SiteDataArrayPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_H_