// chrome/browser/ui/webui/discards/discards.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/discards/discards.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/discards/discards.mojom-params-data.h"
#include "chrome/browser/ui/webui/discards/discards.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/discards/discards.mojom-import-headers.h"
#include "chrome/browser/ui/webui/discards/discards.mojom-test-utils.h"


namespace discards::mojom {
TabDiscardsInfo::TabDiscardsInfo()
    : tab_url(),
      title(),
      visibility(),
      loading_state(),
      state(),
      can_discard(),
      cannot_discard_reasons(),
      can_freeze(),
      cannot_freeze_reasons(),
      discard_count(),
      discard_reason(),
      utility_rank(),
      last_active_seconds(),
      id(),
      is_auto_discardable(),
      site_engagement_score(),
      has_focus(),
      state_change_time() {}

TabDiscardsInfo::TabDiscardsInfo(
    const std::string& tab_url_in,
    const std::string& title_in,
    LifecycleUnitVisibility visibility_in,
    ::mojom::LifecycleUnitLoadingState loading_state_in,
    ::mojom::LifecycleUnitState state_in,
    bool can_discard_in,
    std::vector<std::string> cannot_discard_reasons_in,
    CanFreeze can_freeze_in,
    std::vector<std::string> cannot_freeze_reasons_in,
    int32_t discard_count_in,
    ::mojom::LifecycleUnitDiscardReason discard_reason_in,
    int32_t utility_rank_in,
    int32_t last_active_seconds_in,
    int32_t id_in,
    bool is_auto_discardable_in,
    double site_engagement_score_in,
    bool has_focus_in,
    ::base::TimeDelta state_change_time_in)
    : tab_url(std::move(tab_url_in)),
      title(std::move(title_in)),
      visibility(std::move(visibility_in)),
      loading_state(std::move(loading_state_in)),
      state(std::move(state_in)),
      can_discard(std::move(can_discard_in)),
      cannot_discard_reasons(std::move(cannot_discard_reasons_in)),
      can_freeze(std::move(can_freeze_in)),
      cannot_freeze_reasons(std::move(cannot_freeze_reasons_in)),
      discard_count(std::move(discard_count_in)),
      discard_reason(std::move(discard_reason_in)),
      utility_rank(std::move(utility_rank_in)),
      last_active_seconds(std::move(last_active_seconds_in)),
      id(std::move(id_in)),
      is_auto_discardable(std::move(is_auto_discardable_in)),
      site_engagement_score(std::move(site_engagement_score_in)),
      has_focus(std::move(has_focus_in)),
      state_change_time(std::move(state_change_time_in)) {}

TabDiscardsInfo::~TabDiscardsInfo() = default;

void TabDiscardsInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_url"), this->tab_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visibility"), this->visibility,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LifecycleUnitVisibility>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "loading_state"), this->loading_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojom::LifecycleUnitLoadingState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojom::LifecycleUnitState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_discard"), this->can_discard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cannot_discard_reasons"), this->cannot_discard_reasons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_freeze"), this->can_freeze,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CanFreeze>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cannot_freeze_reasons"), this->cannot_freeze_reasons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discard_count"), this->discard_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discard_reason"), this->discard_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojom::LifecycleUnitDiscardReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "utility_rank"), this->utility_rank,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active_seconds"), this->last_active_seconds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_auto_discardable"), this->is_auto_discardable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_engagement_score"), this->site_engagement_score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_focus"), this->has_focus,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state_change_time"), this->state_change_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabDiscardsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PageInfo::PageInfo()
    : id(),
      main_frame_url(),
      opener_frame_id(),
      embedder_frame_id(),
      description_json() {}

PageInfo::PageInfo(
    int64_t id_in,
    const ::GURL& main_frame_url_in,
    int64_t opener_frame_id_in,
    int64_t embedder_frame_id_in,
    const std::string& description_json_in)
    : id(std::move(id_in)),
      main_frame_url(std::move(main_frame_url_in)),
      opener_frame_id(std::move(opener_frame_id_in)),
      embedder_frame_id(std::move(embedder_frame_id_in)),
      description_json(std::move(description_json_in)) {}

PageInfo::~PageInfo() = default;

void PageInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_url"), this->main_frame_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_frame_id"), this->opener_frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedder_frame_id"), this->embedder_frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description_json"), this->description_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameInfo::FrameInfo()
    : id(),
      url(),
      page_id(),
      parent_frame_id(),
      process_id(),
      description_json() {}

FrameInfo::FrameInfo(
    int64_t id_in,
    const ::GURL& url_in,
    int64_t page_id_in,
    int64_t parent_frame_id_in,
    int64_t process_id_in,
    const std::string& description_json_in)
    : id(std::move(id_in)),
      url(std::move(url_in)),
      page_id(std::move(page_id_in)),
      parent_frame_id(std::move(parent_frame_id_in)),
      process_id(std::move(process_id_in)),
      description_json(std::move(description_json_in)) {}

FrameInfo::~FrameInfo() = default;

void FrameInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_id"), this->page_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_frame_id"), this->parent_frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_id"), this->process_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description_json"), this->description_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProcessInfo::ProcessInfo()
    : id(),
      pid(),
      private_footprint_kb(),
      description_json() {}

ProcessInfo::ProcessInfo(
    int64_t id_in,
    ::base::ProcessId pid_in,
    uint64_t private_footprint_kb_in,
    const std::string& description_json_in)
    : id(std::move(id_in)),
      pid(std::move(pid_in)),
      private_footprint_kb(std::move(private_footprint_kb_in)),
      description_json(std::move(description_json_in)) {}

ProcessInfo::~ProcessInfo() = default;

void ProcessInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pid"), this->pid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ProcessId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_footprint_kb"), this->private_footprint_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description_json"), this->description_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProcessInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WorkerInfo::WorkerInfo()
    : id(),
      url(),
      process_id(),
      client_frame_ids(),
      client_worker_ids(),
      child_worker_ids(),
      description_json() {}

WorkerInfo::WorkerInfo(
    int64_t id_in,
    const ::GURL& url_in,
    int64_t process_id_in,
    std::vector<int64_t> client_frame_ids_in,
    std::vector<int64_t> client_worker_ids_in,
    std::vector<int64_t> child_worker_ids_in,
    const std::string& description_json_in)
    : id(std::move(id_in)),
      url(std::move(url_in)),
      process_id(std::move(process_id_in)),
      client_frame_ids(std::move(client_frame_ids_in)),
      client_worker_ids(std::move(client_worker_ids_in)),
      child_worker_ids(std::move(child_worker_ids_in)),
      description_json(std::move(description_json_in)) {}

WorkerInfo::~WorkerInfo() = default;

void WorkerInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_id"), this->process_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_frame_ids"), this->client_frame_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_worker_ids"), this->client_worker_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "child_worker_ids"), this->child_worker_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description_json"), this->description_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WorkerInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FavIconInfo::FavIconInfo()
    : node_id(),
      icon_data() {}

FavIconInfo::FavIconInfo(
    int64_t node_id_in,
    const std::string& icon_data_in)
    : node_id(std::move(node_id_in)),
      icon_data(std::move(icon_data_in)) {}

FavIconInfo::~FavIconInfo() = default;
size_t FavIconInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->node_id);
  seed = mojo::internal::Hash(seed, this->icon_data);
  return seed;
}

void FavIconInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_id"), this->node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_data"), this->icon_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FavIconInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DetailsProvider::IPCStableHashFunction DetailsProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DetailsProvider>(message.name())) {
    case messages::DetailsProvider::kGetTabDiscardsInfo: {
      return &DetailsProvider::GetTabDiscardsInfo_Sym::IPCStableHash;
    }
    case messages::DetailsProvider::kSetAutoDiscardable: {
      return &DetailsProvider::SetAutoDiscardable_Sym::IPCStableHash;
    }
    case messages::DetailsProvider::kDiscardById: {
      return &DetailsProvider::DiscardById_Sym::IPCStableHash;
    }
    case messages::DetailsProvider::kFreezeById: {
      return &DetailsProvider::FreezeById_Sym::IPCStableHash;
    }
    case messages::DetailsProvider::kLoadById: {
      return &DetailsProvider::LoadById_Sym::IPCStableHash;
    }
    case messages::DetailsProvider::kDiscard: {
      return &DetailsProvider::Discard_Sym::IPCStableHash;
    }
    case messages::DetailsProvider::kToggleBatterySaverMode: {
      return &DetailsProvider::ToggleBatterySaverMode_Sym::IPCStableHash;
    }
    case messages::DetailsProvider::kRefreshPerformanceTabCpuMeasurements: {
      return &DetailsProvider::RefreshPerformanceTabCpuMeasurements_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DetailsProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DetailsProvider>(message.name())) {
      case messages::DetailsProvider::kGetTabDiscardsInfo:
            return "Receive discards::mojom::DetailsProvider::GetTabDiscardsInfo";
      case messages::DetailsProvider::kSetAutoDiscardable:
            return "Receive discards::mojom::DetailsProvider::SetAutoDiscardable";
      case messages::DetailsProvider::kDiscardById:
            return "Receive discards::mojom::DetailsProvider::DiscardById";
      case messages::DetailsProvider::kFreezeById:
            return "Receive discards::mojom::DetailsProvider::FreezeById";
      case messages::DetailsProvider::kLoadById:
            return "Receive discards::mojom::DetailsProvider::LoadById";
      case messages::DetailsProvider::kDiscard:
            return "Receive discards::mojom::DetailsProvider::Discard";
      case messages::DetailsProvider::kToggleBatterySaverMode:
            return "Receive discards::mojom::DetailsProvider::ToggleBatterySaverMode";
      case messages::DetailsProvider::kRefreshPerformanceTabCpuMeasurements:
            return "Receive discards::mojom::DetailsProvider::RefreshPerformanceTabCpuMeasurements";
    }
  } else {
    switch (static_cast<messages::DetailsProvider>(message.name())) {
      case messages::DetailsProvider::kGetTabDiscardsInfo:
            return "Receive reply discards::mojom::DetailsProvider::GetTabDiscardsInfo";
      case messages::DetailsProvider::kSetAutoDiscardable:
            return "Receive reply discards::mojom::DetailsProvider::SetAutoDiscardable";
      case messages::DetailsProvider::kDiscardById:
            return "Receive reply discards::mojom::DetailsProvider::DiscardById";
      case messages::DetailsProvider::kFreezeById:
            return "Receive reply discards::mojom::DetailsProvider::FreezeById";
      case messages::DetailsProvider::kLoadById:
            return "Receive reply discards::mojom::DetailsProvider::LoadById";
      case messages::DetailsProvider::kDiscard:
            return "Receive reply discards::mojom::DetailsProvider::Discard";
      case messages::DetailsProvider::kToggleBatterySaverMode:
            return "Receive reply discards::mojom::DetailsProvider::ToggleBatterySaverMode";
      case messages::DetailsProvider::kRefreshPerformanceTabCpuMeasurements:
            return "Receive reply discards::mojom::DetailsProvider::RefreshPerformanceTabCpuMeasurements";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DetailsProvider::GetTabDiscardsInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9891a0f5;  // IPCStableHash for discards::mojom::DetailsProvider::GetTabDiscardsInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DetailsProvider::SetAutoDiscardable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf64d2cba;  // IPCStableHash for discards::mojom::DetailsProvider::SetAutoDiscardable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DetailsProvider::DiscardById_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x956b7128;  // IPCStableHash for discards::mojom::DetailsProvider::DiscardById
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DetailsProvider::FreezeById_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31219697;  // IPCStableHash for discards::mojom::DetailsProvider::FreezeById
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DetailsProvider::LoadById_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e707232;  // IPCStableHash for discards::mojom::DetailsProvider::LoadById
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DetailsProvider::Discard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x839d67e8;  // IPCStableHash for discards::mojom::DetailsProvider::Discard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DetailsProvider::ToggleBatterySaverMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf504d71e;  // IPCStableHash for discards::mojom::DetailsProvider::ToggleBatterySaverMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DetailsProvider::RefreshPerformanceTabCpuMeasurements_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x439463e9;  // IPCStableHash for discards::mojom::DetailsProvider::RefreshPerformanceTabCpuMeasurements
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DetailsProvider_GetTabDiscardsInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DetailsProvider_GetTabDiscardsInfo_ForwardToCallback(
      DetailsProvider::GetTabDiscardsInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  DetailsProvider_GetTabDiscardsInfo_ForwardToCallback(const DetailsProvider_GetTabDiscardsInfo_ForwardToCallback&) = delete;
  DetailsProvider_GetTabDiscardsInfo_ForwardToCallback& operator=(const DetailsProvider_GetTabDiscardsInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DetailsProvider::GetTabDiscardsInfoCallback callback_;
};

class DetailsProvider_SetAutoDiscardable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DetailsProvider_SetAutoDiscardable_ForwardToCallback(
      DetailsProvider::SetAutoDiscardableCallback callback
      ) : callback_(std::move(callback)) {
  }

  DetailsProvider_SetAutoDiscardable_ForwardToCallback(const DetailsProvider_SetAutoDiscardable_ForwardToCallback&) = delete;
  DetailsProvider_SetAutoDiscardable_ForwardToCallback& operator=(const DetailsProvider_SetAutoDiscardable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DetailsProvider::SetAutoDiscardableCallback callback_;
};

class DetailsProvider_DiscardById_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DetailsProvider_DiscardById_ForwardToCallback(
      DetailsProvider::DiscardByIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  DetailsProvider_DiscardById_ForwardToCallback(const DetailsProvider_DiscardById_ForwardToCallback&) = delete;
  DetailsProvider_DiscardById_ForwardToCallback& operator=(const DetailsProvider_DiscardById_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DetailsProvider::DiscardByIdCallback callback_;
};

class DetailsProvider_Discard_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DetailsProvider_Discard_ForwardToCallback(
      DetailsProvider::DiscardCallback callback
      ) : callback_(std::move(callback)) {
  }

  DetailsProvider_Discard_ForwardToCallback(const DetailsProvider_Discard_ForwardToCallback&) = delete;
  DetailsProvider_Discard_ForwardToCallback& operator=(const DetailsProvider_Discard_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DetailsProvider::DiscardCallback callback_;
};

DetailsProviderProxy::DetailsProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DetailsProviderProxy::GetTabDiscardsInfo(
    GetTabDiscardsInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send discards::mojom::DetailsProvider::GetTabDiscardsInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kGetTabDiscardsInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_GetTabDiscardsInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("GetTabDiscardsInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DetailsProvider_GetTabDiscardsInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DetailsProviderProxy::SetAutoDiscardable(
    int32_t in_tab_id, bool in_is_auto_discardable, SetAutoDiscardableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::DetailsProvider::SetAutoDiscardable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_auto_discardable"), in_is_auto_discardable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kSetAutoDiscardable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_SetAutoDiscardable_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->is_auto_discardable = in_is_auto_discardable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("SetAutoDiscardable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DetailsProvider_SetAutoDiscardable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DetailsProviderProxy::DiscardById(
    int32_t in_tab_id, ::mojom::LifecycleUnitDiscardReason in_reason, DiscardByIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::DetailsProvider::DiscardById", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::mojom::LifecycleUnitDiscardReason>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kDiscardById), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_DiscardById_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  
  mojo::internal::Serialize<::mojom::LifecycleUnitDiscardReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("DiscardById");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DetailsProvider_DiscardById_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DetailsProviderProxy::FreezeById(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::DetailsProvider::FreezeById", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kFreezeById), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_FreezeById_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("FreezeById");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DetailsProviderProxy::LoadById(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::DetailsProvider::LoadById", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kLoadById), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_LoadById_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("LoadById");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DetailsProviderProxy::Discard(
    DiscardCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send discards::mojom::DetailsProvider::Discard");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kDiscard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_Discard_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("Discard");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DetailsProvider_Discard_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DetailsProviderProxy::ToggleBatterySaverMode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send discards::mojom::DetailsProvider::ToggleBatterySaverMode");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kToggleBatterySaverMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_ToggleBatterySaverMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("ToggleBatterySaverMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DetailsProviderProxy::RefreshPerformanceTabCpuMeasurements(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send discards::mojom::DetailsProvider::RefreshPerformanceTabCpuMeasurements");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kRefreshPerformanceTabCpuMeasurements), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("RefreshPerformanceTabCpuMeasurements");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DetailsProvider_GetTabDiscardsInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DetailsProvider::GetTabDiscardsInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DetailsProvider_GetTabDiscardsInfo_ProxyToResponder> proxy(
        new DetailsProvider_GetTabDiscardsInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DetailsProvider_GetTabDiscardsInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DetailsProvider_GetTabDiscardsInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DetailsProvider_GetTabDiscardsInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DetailsProvider::GetTabDiscardsInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<TabDiscardsInfoPtr> in_infos);
};

bool DetailsProvider_GetTabDiscardsInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DetailsProvider.0
  bool success = true;
  std::vector<TabDiscardsInfoPtr> p_infos{};
  DetailsProvider_GetTabDiscardsInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfos(&p_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DetailsProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_infos));
  }
  return true;
}

void DetailsProvider_GetTabDiscardsInfo_ProxyToResponder::Run(
    std::vector<TabDiscardsInfoPtr> in_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply discards::mojom::DetailsProvider::GetTabDiscardsInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("infos"), in_infos,
                        "<value of type std::vector<TabDiscardsInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kGetTabDiscardsInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->infos)::BaseType>
      infos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::discards::mojom::TabDiscardsInfoDataView>>(
    in_infos,
    infos_fragment,
    &infos_validate_params);

  params->infos.Set(
      infos_fragment.is_null() ? nullptr : infos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->infos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null infos in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("GetTabDiscardsInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DetailsProvider_SetAutoDiscardable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DetailsProvider::SetAutoDiscardableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DetailsProvider_SetAutoDiscardable_ProxyToResponder> proxy(
        new DetailsProvider_SetAutoDiscardable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DetailsProvider_SetAutoDiscardable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DetailsProvider_SetAutoDiscardable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DetailsProvider_SetAutoDiscardable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DetailsProvider::SetAutoDiscardableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool DetailsProvider_SetAutoDiscardable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DetailsProvider_SetAutoDiscardable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DetailsProvider_SetAutoDiscardable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DetailsProvider.1
  bool success = true;
  DetailsProvider_SetAutoDiscardable_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DetailsProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void DetailsProvider_SetAutoDiscardable_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply discards::mojom::DetailsProvider::SetAutoDiscardable");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kSetAutoDiscardable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_SetAutoDiscardable_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("SetAutoDiscardable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DetailsProvider_DiscardById_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DetailsProvider::DiscardByIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DetailsProvider_DiscardById_ProxyToResponder> proxy(
        new DetailsProvider_DiscardById_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DetailsProvider_DiscardById_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DetailsProvider_DiscardById_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DetailsProvider_DiscardById_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DetailsProvider::DiscardByIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool DetailsProvider_DiscardById_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DetailsProvider_DiscardById_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DetailsProvider_DiscardById_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DetailsProvider.2
  bool success = true;
  DetailsProvider_DiscardById_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DetailsProvider::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void DetailsProvider_DiscardById_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply discards::mojom::DetailsProvider::DiscardById");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kDiscardById), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_DiscardById_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("DiscardById");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DetailsProvider_Discard_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DetailsProvider::DiscardCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DetailsProvider_Discard_ProxyToResponder> proxy(
        new DetailsProvider_Discard_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DetailsProvider_Discard_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DetailsProvider_Discard_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DetailsProvider_Discard_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DetailsProvider::DiscardCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool DetailsProvider_Discard_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DetailsProvider_Discard_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DetailsProvider_Discard_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DetailsProvider.5
  bool success = true;
  DetailsProvider_Discard_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DetailsProvider::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void DetailsProvider_Discard_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply discards::mojom::DetailsProvider::Discard");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DetailsProvider::kDiscard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::DetailsProvider_Discard_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DetailsProvider::Name_);
  message.set_method_name("Discard");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DetailsProviderStubDispatch::Accept(
    DetailsProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DetailsProvider>(message->header()->name)) {
    case messages::DetailsProvider::kGetTabDiscardsInfo: {
      break;
    }
    case messages::DetailsProvider::kSetAutoDiscardable: {
      break;
    }
    case messages::DetailsProvider::kDiscardById: {
      break;
    }
    case messages::DetailsProvider::kFreezeById: {
      DCHECK(message->is_serialized());
      internal::DetailsProvider_FreezeById_Params_Data* params =
          reinterpret_cast<internal::DetailsProvider_FreezeById_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DetailsProvider.3
      bool success = true;
      int32_t p_tab_id{};
      DetailsProvider_FreezeById_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DetailsProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FreezeById(        
        std::move(p_tab_id));
      return true;
    }
    case messages::DetailsProvider::kLoadById: {
      DCHECK(message->is_serialized());
      internal::DetailsProvider_LoadById_Params_Data* params =
          reinterpret_cast<internal::DetailsProvider_LoadById_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DetailsProvider.4
      bool success = true;
      int32_t p_tab_id{};
      DetailsProvider_LoadById_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DetailsProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadById(        
        std::move(p_tab_id));
      return true;
    }
    case messages::DetailsProvider::kDiscard: {
      break;
    }
    case messages::DetailsProvider::kToggleBatterySaverMode: {
      DCHECK(message->is_serialized());
      internal::DetailsProvider_ToggleBatterySaverMode_Params_Data* params =
          reinterpret_cast<internal::DetailsProvider_ToggleBatterySaverMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DetailsProvider.6
      bool success = true;
      DetailsProvider_ToggleBatterySaverMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DetailsProvider::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleBatterySaverMode(        );
      return true;
    }
    case messages::DetailsProvider::kRefreshPerformanceTabCpuMeasurements: {
      DCHECK(message->is_serialized());
      internal::DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data* params =
          reinterpret_cast<internal::DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DetailsProvider.7
      bool success = true;
      DetailsProvider_RefreshPerformanceTabCpuMeasurements_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DetailsProvider::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RefreshPerformanceTabCpuMeasurements(        );
      return true;
    }
  }
  return false;
}

// static
bool DetailsProviderStubDispatch::AcceptWithResponder(
    DetailsProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DetailsProvider>(message->header()->name)) {
    case messages::DetailsProvider::kGetTabDiscardsInfo: {
      internal::DetailsProvider_GetTabDiscardsInfo_Params_Data* params =
          reinterpret_cast<
              internal::DetailsProvider_GetTabDiscardsInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DetailsProvider.0
      bool success = true;
      DetailsProvider_GetTabDiscardsInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DetailsProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          DetailsProvider_GetTabDiscardsInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabDiscardsInfo(std::move(callback));
      return true;
    }
    case messages::DetailsProvider::kSetAutoDiscardable: {
      internal::DetailsProvider_SetAutoDiscardable_Params_Data* params =
          reinterpret_cast<
              internal::DetailsProvider_SetAutoDiscardable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DetailsProvider.1
      bool success = true;
      int32_t p_tab_id{};
      bool p_is_auto_discardable{};
      DetailsProvider_SetAutoDiscardable_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_is_auto_discardable = input_data_view.is_auto_discardable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DetailsProvider::Name_, 1, false);
        return false;
      }
      auto callback =
          DetailsProvider_SetAutoDiscardable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAutoDiscardable(        
        std::move(p_tab_id), 
        std::move(p_is_auto_discardable), std::move(callback));
      return true;
    }
    case messages::DetailsProvider::kDiscardById: {
      internal::DetailsProvider_DiscardById_Params_Data* params =
          reinterpret_cast<
              internal::DetailsProvider_DiscardById_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DetailsProvider.2
      bool success = true;
      int32_t p_tab_id{};
      ::mojom::LifecycleUnitDiscardReason p_reason{};
      DetailsProvider_DiscardById_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DetailsProvider::Name_, 2, false);
        return false;
      }
      auto callback =
          DetailsProvider_DiscardById_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DiscardById(        
        std::move(p_tab_id), 
        std::move(p_reason), std::move(callback));
      return true;
    }
    case messages::DetailsProvider::kFreezeById: {
      break;
    }
    case messages::DetailsProvider::kLoadById: {
      break;
    }
    case messages::DetailsProvider::kDiscard: {
      internal::DetailsProvider_Discard_Params_Data* params =
          reinterpret_cast<
              internal::DetailsProvider_Discard_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DetailsProvider.5
      bool success = true;
      DetailsProvider_Discard_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DetailsProvider::Name_, 5, false);
        return false;
      }
      auto callback =
          DetailsProvider_Discard_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Discard(std::move(callback));
      return true;
    }
    case messages::DetailsProvider::kToggleBatterySaverMode: {
      break;
    }
    case messages::DetailsProvider::kRefreshPerformanceTabCpuMeasurements: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDetailsProviderValidationInfo[] = {
    { &internal::DetailsProvider_GetTabDiscardsInfo_Params_Data::Validate,
     &internal::DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data::Validate},
    { &internal::DetailsProvider_SetAutoDiscardable_Params_Data::Validate,
     &internal::DetailsProvider_SetAutoDiscardable_ResponseParams_Data::Validate},
    { &internal::DetailsProvider_DiscardById_Params_Data::Validate,
     &internal::DetailsProvider_DiscardById_ResponseParams_Data::Validate},
    { &internal::DetailsProvider_FreezeById_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DetailsProvider_LoadById_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DetailsProvider_Discard_Params_Data::Validate,
     &internal::DetailsProvider_Discard_ResponseParams_Data::Validate},
    { &internal::DetailsProvider_ToggleBatterySaverMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data::Validate,
     nullptr /* no response */},
};

bool DetailsProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::discards::mojom::DetailsProvider::Name_,
    kDetailsProviderValidationInfo);
}

bool DetailsProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::discards::mojom::DetailsProvider::Name_,
    kDetailsProviderValidationInfo);
}
// The declaration includes the definition on other builds.

GraphChangeStream::IPCStableHashFunction GraphChangeStream::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GraphChangeStream>(message.name())) {
    case messages::GraphChangeStream::kFrameCreated: {
      return &GraphChangeStream::FrameCreated_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kPageCreated: {
      return &GraphChangeStream::PageCreated_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kProcessCreated: {
      return &GraphChangeStream::ProcessCreated_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kWorkerCreated: {
      return &GraphChangeStream::WorkerCreated_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kFrameChanged: {
      return &GraphChangeStream::FrameChanged_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kPageChanged: {
      return &GraphChangeStream::PageChanged_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kProcessChanged: {
      return &GraphChangeStream::ProcessChanged_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kWorkerChanged: {
      return &GraphChangeStream::WorkerChanged_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kFavIconDataAvailable: {
      return &GraphChangeStream::FavIconDataAvailable_Sym::IPCStableHash;
    }
    case messages::GraphChangeStream::kNodeDeleted: {
      return &GraphChangeStream::NodeDeleted_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GraphChangeStream::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GraphChangeStream>(message.name())) {
      case messages::GraphChangeStream::kFrameCreated:
            return "Receive discards::mojom::GraphChangeStream::FrameCreated";
      case messages::GraphChangeStream::kPageCreated:
            return "Receive discards::mojom::GraphChangeStream::PageCreated";
      case messages::GraphChangeStream::kProcessCreated:
            return "Receive discards::mojom::GraphChangeStream::ProcessCreated";
      case messages::GraphChangeStream::kWorkerCreated:
            return "Receive discards::mojom::GraphChangeStream::WorkerCreated";
      case messages::GraphChangeStream::kFrameChanged:
            return "Receive discards::mojom::GraphChangeStream::FrameChanged";
      case messages::GraphChangeStream::kPageChanged:
            return "Receive discards::mojom::GraphChangeStream::PageChanged";
      case messages::GraphChangeStream::kProcessChanged:
            return "Receive discards::mojom::GraphChangeStream::ProcessChanged";
      case messages::GraphChangeStream::kWorkerChanged:
            return "Receive discards::mojom::GraphChangeStream::WorkerChanged";
      case messages::GraphChangeStream::kFavIconDataAvailable:
            return "Receive discards::mojom::GraphChangeStream::FavIconDataAvailable";
      case messages::GraphChangeStream::kNodeDeleted:
            return "Receive discards::mojom::GraphChangeStream::NodeDeleted";
    }
  } else {
    switch (static_cast<messages::GraphChangeStream>(message.name())) {
      case messages::GraphChangeStream::kFrameCreated:
            return "Receive reply discards::mojom::GraphChangeStream::FrameCreated";
      case messages::GraphChangeStream::kPageCreated:
            return "Receive reply discards::mojom::GraphChangeStream::PageCreated";
      case messages::GraphChangeStream::kProcessCreated:
            return "Receive reply discards::mojom::GraphChangeStream::ProcessCreated";
      case messages::GraphChangeStream::kWorkerCreated:
            return "Receive reply discards::mojom::GraphChangeStream::WorkerCreated";
      case messages::GraphChangeStream::kFrameChanged:
            return "Receive reply discards::mojom::GraphChangeStream::FrameChanged";
      case messages::GraphChangeStream::kPageChanged:
            return "Receive reply discards::mojom::GraphChangeStream::PageChanged";
      case messages::GraphChangeStream::kProcessChanged:
            return "Receive reply discards::mojom::GraphChangeStream::ProcessChanged";
      case messages::GraphChangeStream::kWorkerChanged:
            return "Receive reply discards::mojom::GraphChangeStream::WorkerChanged";
      case messages::GraphChangeStream::kFavIconDataAvailable:
            return "Receive reply discards::mojom::GraphChangeStream::FavIconDataAvailable";
      case messages::GraphChangeStream::kNodeDeleted:
            return "Receive reply discards::mojom::GraphChangeStream::NodeDeleted";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GraphChangeStream::FrameCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16af7517;  // IPCStableHash for discards::mojom::GraphChangeStream::FrameCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::PageCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedb566a7;  // IPCStableHash for discards::mojom::GraphChangeStream::PageCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::ProcessCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea3fc3e6;  // IPCStableHash for discards::mojom::GraphChangeStream::ProcessCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::WorkerCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x069b5573;  // IPCStableHash for discards::mojom::GraphChangeStream::WorkerCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::FrameChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x06a36aef;  // IPCStableHash for discards::mojom::GraphChangeStream::FrameChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::PageChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98eb646d;  // IPCStableHash for discards::mojom::GraphChangeStream::PageChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::ProcessChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61d276d4;  // IPCStableHash for discards::mojom::GraphChangeStream::ProcessChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::WorkerChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c2b3a3a;  // IPCStableHash for discards::mojom::GraphChangeStream::WorkerChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::FavIconDataAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x40e74d4d;  // IPCStableHash for discards::mojom::GraphChangeStream::FavIconDataAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphChangeStream::NodeDeleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d5011b3;  // IPCStableHash for discards::mojom::GraphChangeStream::NodeDeleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

GraphChangeStreamProxy::GraphChangeStreamProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GraphChangeStreamProxy::FrameCreated(
    FrameInfoPtr in_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::FrameCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type FrameInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kFrameCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_FrameCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::FrameInfoDataView>(
    in_frame,
    frame_fragment);

  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame in GraphChangeStream.FrameCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("FrameCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::PageCreated(
    PageInfoPtr in_pages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::PageCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pages"), in_pages,
                        "<value of type PageInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kPageCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_PageCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pages)::BaseType> pages_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::PageInfoDataView>(
    in_pages,
    pages_fragment);

  params->pages.Set(
      pages_fragment.is_null() ? nullptr : pages_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pages.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pages in GraphChangeStream.PageCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("PageCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::ProcessCreated(
    ProcessInfoPtr in_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::ProcessCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process"), in_process,
                        "<value of type ProcessInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kProcessCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_ProcessCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->process)::BaseType> process_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::ProcessInfoDataView>(
    in_process,
    process_fragment);

  params->process.Set(
      process_fragment.is_null() ? nullptr : process_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->process.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null process in GraphChangeStream.ProcessCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("ProcessCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::WorkerCreated(
    WorkerInfoPtr in_worker) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::WorkerCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker"), in_worker,
                        "<value of type WorkerInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kWorkerCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_WorkerCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->worker)::BaseType> worker_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::WorkerInfoDataView>(
    in_worker,
    worker_fragment);

  params->worker.Set(
      worker_fragment.is_null() ? nullptr : worker_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->worker.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null worker in GraphChangeStream.WorkerCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("WorkerCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::FrameChanged(
    FrameInfoPtr in_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::FrameChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type FrameInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kFrameChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_FrameChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::FrameInfoDataView>(
    in_frame,
    frame_fragment);

  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame in GraphChangeStream.FrameChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("FrameChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::PageChanged(
    PageInfoPtr in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::PageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type PageInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kPageChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_PageChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page)::BaseType> page_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::PageInfoDataView>(
    in_page,
    page_fragment);

  params->page.Set(
      page_fragment.is_null() ? nullptr : page_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page in GraphChangeStream.PageChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("PageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::ProcessChanged(
    ProcessInfoPtr in_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::ProcessChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process"), in_process,
                        "<value of type ProcessInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kProcessChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_ProcessChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->process)::BaseType> process_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::ProcessInfoDataView>(
    in_process,
    process_fragment);

  params->process.Set(
      process_fragment.is_null() ? nullptr : process_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->process.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null process in GraphChangeStream.ProcessChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("ProcessChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::WorkerChanged(
    WorkerInfoPtr in_worker) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::WorkerChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker"), in_worker,
                        "<value of type WorkerInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kWorkerChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_WorkerChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->worker)::BaseType> worker_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::WorkerInfoDataView>(
    in_worker,
    worker_fragment);

  params->worker.Set(
      worker_fragment.is_null() ? nullptr : worker_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->worker.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null worker in GraphChangeStream.WorkerChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("WorkerChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::FavIconDataAvailable(
    FavIconInfoPtr in_favicon) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::FavIconDataAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("favicon"), in_favicon,
                        "<value of type FavIconInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kFavIconDataAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_FavIconDataAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->favicon)::BaseType> favicon_fragment(
          params.message());
  
  mojo::internal::Serialize<::discards::mojom::FavIconInfoDataView>(
    in_favicon,
    favicon_fragment);

  params->favicon.Set(
      favicon_fragment.is_null() ? nullptr : favicon_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->favicon.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null favicon in GraphChangeStream.FavIconDataAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("FavIconDataAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphChangeStreamProxy::NodeDeleted(
    int64_t in_node_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphChangeStream::NodeDeleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphChangeStream::kNodeDeleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphChangeStream_NodeDeleted_Params_Data> params(
          message);
  params.Allocate();

  params->node_id = in_node_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphChangeStream::Name_);
  message.set_method_name("NodeDeleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool GraphChangeStreamStubDispatch::Accept(
    GraphChangeStream* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GraphChangeStream>(message->header()->name)) {
    case messages::GraphChangeStream::kFrameCreated: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_FrameCreated_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_FrameCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.0
      bool success = true;
      FrameInfoPtr p_frame{};
      GraphChangeStream_FrameCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameCreated(        
        std::move(p_frame));
      return true;
    }
    case messages::GraphChangeStream::kPageCreated: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_PageCreated_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_PageCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.1
      bool success = true;
      PageInfoPtr p_pages{};
      GraphChangeStream_PageCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPages(&p_pages))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PageCreated(        
        std::move(p_pages));
      return true;
    }
    case messages::GraphChangeStream::kProcessCreated: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_ProcessCreated_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_ProcessCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.2
      bool success = true;
      ProcessInfoPtr p_process{};
      GraphChangeStream_ProcessCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProcess(&p_process))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProcessCreated(        
        std::move(p_process));
      return true;
    }
    case messages::GraphChangeStream::kWorkerCreated: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_WorkerCreated_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_WorkerCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.3
      bool success = true;
      WorkerInfoPtr p_worker{};
      GraphChangeStream_WorkerCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWorker(&p_worker))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WorkerCreated(        
        std::move(p_worker));
      return true;
    }
    case messages::GraphChangeStream::kFrameChanged: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_FrameChanged_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_FrameChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.4
      bool success = true;
      FrameInfoPtr p_frame{};
      GraphChangeStream_FrameChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FrameChanged(        
        std::move(p_frame));
      return true;
    }
    case messages::GraphChangeStream::kPageChanged: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_PageChanged_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_PageChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.5
      bool success = true;
      PageInfoPtr p_page{};
      GraphChangeStream_PageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPage(&p_page))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PageChanged(        
        std::move(p_page));
      return true;
    }
    case messages::GraphChangeStream::kProcessChanged: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_ProcessChanged_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_ProcessChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.6
      bool success = true;
      ProcessInfoPtr p_process{};
      GraphChangeStream_ProcessChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProcess(&p_process))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProcessChanged(        
        std::move(p_process));
      return true;
    }
    case messages::GraphChangeStream::kWorkerChanged: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_WorkerChanged_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_WorkerChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.7
      bool success = true;
      WorkerInfoPtr p_worker{};
      GraphChangeStream_WorkerChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWorker(&p_worker))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WorkerChanged(        
        std::move(p_worker));
      return true;
    }
    case messages::GraphChangeStream::kFavIconDataAvailable: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_FavIconDataAvailable_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_FavIconDataAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.8
      bool success = true;
      FavIconInfoPtr p_favicon{};
      GraphChangeStream_FavIconDataAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFavicon(&p_favicon))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FavIconDataAvailable(        
        std::move(p_favicon));
      return true;
    }
    case messages::GraphChangeStream::kNodeDeleted: {
      DCHECK(message->is_serialized());
      internal::GraphChangeStream_NodeDeleted_Params_Data* params =
          reinterpret_cast<internal::GraphChangeStream_NodeDeleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphChangeStream.9
      bool success = true;
      int64_t p_node_id{};
      GraphChangeStream_NodeDeleted_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_node_id = input_data_view.node_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphChangeStream::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NodeDeleted(        
        std::move(p_node_id));
      return true;
    }
  }
  return false;
}

// static
bool GraphChangeStreamStubDispatch::AcceptWithResponder(
    GraphChangeStream* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GraphChangeStream>(message->header()->name)) {
    case messages::GraphChangeStream::kFrameCreated: {
      break;
    }
    case messages::GraphChangeStream::kPageCreated: {
      break;
    }
    case messages::GraphChangeStream::kProcessCreated: {
      break;
    }
    case messages::GraphChangeStream::kWorkerCreated: {
      break;
    }
    case messages::GraphChangeStream::kFrameChanged: {
      break;
    }
    case messages::GraphChangeStream::kPageChanged: {
      break;
    }
    case messages::GraphChangeStream::kProcessChanged: {
      break;
    }
    case messages::GraphChangeStream::kWorkerChanged: {
      break;
    }
    case messages::GraphChangeStream::kFavIconDataAvailable: {
      break;
    }
    case messages::GraphChangeStream::kNodeDeleted: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGraphChangeStreamValidationInfo[] = {
    { &internal::GraphChangeStream_FrameCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_PageCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_ProcessCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_WorkerCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_FrameChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_PageChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_ProcessChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_WorkerChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_FavIconDataAvailable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphChangeStream_NodeDeleted_Params_Data::Validate,
     nullptr /* no response */},
};

bool GraphChangeStreamRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::discards::mojom::GraphChangeStream::Name_,
    kGraphChangeStreamValidationInfo);
}

// The declaration includes the definition on other builds.

GraphDump::IPCStableHashFunction GraphDump::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GraphDump>(message.name())) {
    case messages::GraphDump::kSubscribeToChanges: {
      return &GraphDump::SubscribeToChanges_Sym::IPCStableHash;
    }
    case messages::GraphDump::kRequestNodeDescriptions: {
      return &GraphDump::RequestNodeDescriptions_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GraphDump::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GraphDump>(message.name())) {
      case messages::GraphDump::kSubscribeToChanges:
            return "Receive discards::mojom::GraphDump::SubscribeToChanges";
      case messages::GraphDump::kRequestNodeDescriptions:
            return "Receive discards::mojom::GraphDump::RequestNodeDescriptions";
    }
  } else {
    switch (static_cast<messages::GraphDump>(message.name())) {
      case messages::GraphDump::kSubscribeToChanges:
            return "Receive reply discards::mojom::GraphDump::SubscribeToChanges";
      case messages::GraphDump::kRequestNodeDescriptions:
            return "Receive reply discards::mojom::GraphDump::RequestNodeDescriptions";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GraphDump::SubscribeToChanges_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcea3fae8;  // IPCStableHash for discards::mojom::GraphDump::SubscribeToChanges
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GraphDump::RequestNodeDescriptions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x58b46fc8;  // IPCStableHash for discards::mojom::GraphDump::RequestNodeDescriptions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GraphDump_RequestNodeDescriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GraphDump_RequestNodeDescriptions_ForwardToCallback(
      GraphDump::RequestNodeDescriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  GraphDump_RequestNodeDescriptions_ForwardToCallback(const GraphDump_RequestNodeDescriptions_ForwardToCallback&) = delete;
  GraphDump_RequestNodeDescriptions_ForwardToCallback& operator=(const GraphDump_RequestNodeDescriptions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GraphDump::RequestNodeDescriptionsCallback callback_;
};

GraphDumpProxy::GraphDumpProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GraphDumpProxy::SubscribeToChanges(
    ::mojo::PendingRemote<GraphChangeStream> in_change_subscriber) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphDump::SubscribeToChanges", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("change_subscriber"), in_change_subscriber,
                        "<value of type ::mojo::PendingRemote<GraphChangeStream>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphDump::kSubscribeToChanges), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphDump_SubscribeToChanges_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::discards::mojom::GraphChangeStreamInterfaceBase>>(
    in_change_subscriber,
    &params->change_subscriber,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->change_subscriber)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid change_subscriber in GraphDump.SubscribeToChanges request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphDump::Name_);
  message.set_method_name("SubscribeToChanges");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GraphDumpProxy::RequestNodeDescriptions(
    const std::vector<int64_t>& in_node_ids, RequestNodeDescriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send discards::mojom::GraphDump::RequestNodeDescriptions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_ids"), in_node_ids,
                        "<value of type const std::vector<int64_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphDump::kRequestNodeDescriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphDump_RequestNodeDescriptions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node_ids)::BaseType>
      node_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_node_ids,
    node_ids_fragment,
    &node_ids_validate_params);

  params->node_ids.Set(
      node_ids_fragment.is_null() ? nullptr : node_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_ids in GraphDump.RequestNodeDescriptions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphDump::Name_);
  message.set_method_name("RequestNodeDescriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GraphDump_RequestNodeDescriptions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GraphDump_RequestNodeDescriptions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GraphDump::RequestNodeDescriptionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GraphDump_RequestNodeDescriptions_ProxyToResponder> proxy(
        new GraphDump_RequestNodeDescriptions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GraphDump_RequestNodeDescriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GraphDump_RequestNodeDescriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GraphDump_RequestNodeDescriptions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GraphDump::RequestNodeDescriptionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<int64_t, std::string>& in_node_descriptions_json);
};

bool GraphDump_RequestNodeDescriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GraphDump_RequestNodeDescriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GraphDump_RequestNodeDescriptions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GraphDump.1
  bool success = true;
  base::flat_map<int64_t, std::string> p_node_descriptions_json{};
  GraphDump_RequestNodeDescriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNodeDescriptionsJson(&p_node_descriptions_json))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GraphDump::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_node_descriptions_json));
  }
  return true;
}

void GraphDump_RequestNodeDescriptions_ProxyToResponder::Run(
    const base::flat_map<int64_t, std::string>& in_node_descriptions_json) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply discards::mojom::GraphDump::RequestNodeDescriptions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_descriptions_json"), in_node_descriptions_json,
                        "<value of type const base::flat_map<int64_t, std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GraphDump::kRequestNodeDescriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::discards::mojom::internal::GraphDump_RequestNodeDescriptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node_descriptions_json)::BaseType>
      node_descriptions_json_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& node_descriptions_json_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<int64_t, mojo::StringDataView>>(
    in_node_descriptions_json,
    node_descriptions_json_fragment,
    &node_descriptions_json_validate_params);

  params->node_descriptions_json.Set(
      node_descriptions_json_fragment.is_null() ? nullptr : node_descriptions_json_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_descriptions_json.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_descriptions_json in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GraphDump::Name_);
  message.set_method_name("RequestNodeDescriptions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GraphDumpStubDispatch::Accept(
    GraphDump* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GraphDump>(message->header()->name)) {
    case messages::GraphDump::kSubscribeToChanges: {
      DCHECK(message->is_serialized());
      internal::GraphDump_SubscribeToChanges_Params_Data* params =
          reinterpret_cast<internal::GraphDump_SubscribeToChanges_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GraphDump.0
      bool success = true;
      ::mojo::PendingRemote<GraphChangeStream> p_change_subscriber{};
      GraphDump_SubscribeToChanges_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_change_subscriber =
            input_data_view.TakeChangeSubscriber<decltype(p_change_subscriber)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphDump::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToChanges(        
        std::move(p_change_subscriber));
      return true;
    }
    case messages::GraphDump::kRequestNodeDescriptions: {
      break;
    }
  }
  return false;
}

// static
bool GraphDumpStubDispatch::AcceptWithResponder(
    GraphDump* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GraphDump>(message->header()->name)) {
    case messages::GraphDump::kSubscribeToChanges: {
      break;
    }
    case messages::GraphDump::kRequestNodeDescriptions: {
      internal::GraphDump_RequestNodeDescriptions_Params_Data* params =
          reinterpret_cast<
              internal::GraphDump_RequestNodeDescriptions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GraphDump.1
      bool success = true;
      std::vector<int64_t> p_node_ids{};
      GraphDump_RequestNodeDescriptions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNodeIds(&p_node_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GraphDump::Name_, 1, false);
        return false;
      }
      auto callback =
          GraphDump_RequestNodeDescriptions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNodeDescriptions(        
        std::move(p_node_ids), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGraphDumpValidationInfo[] = {
    { &internal::GraphDump_SubscribeToChanges_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GraphDump_RequestNodeDescriptions_Params_Data::Validate,
     &internal::GraphDump_RequestNodeDescriptions_ResponseParams_Data::Validate},
};

bool GraphDumpRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::discards::mojom::GraphDump::Name_,
    kGraphDumpValidationInfo);
}

bool GraphDumpResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::discards::mojom::GraphDump::Name_,
    kGraphDumpValidationInfo);
}


}  // discards::mojom


namespace mojo {


// static
bool StructTraits<::discards::mojom::TabDiscardsInfo::DataView, ::discards::mojom::TabDiscardsInfoPtr>::Read(
    ::discards::mojom::TabDiscardsInfo::DataView input,
    ::discards::mojom::TabDiscardsInfoPtr* output) {
  bool success = true;
  ::discards::mojom::TabDiscardsInfoPtr result(::discards::mojom::TabDiscardsInfo::New());
  
      if (success && !input.ReadTabUrl(&result->tab_url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadVisibility(&result->visibility))
        success = false;
      if (success && !input.ReadLoadingState(&result->loading_state))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->can_discard = input.can_discard();
      if (success && !input.ReadCannotDiscardReasons(&result->cannot_discard_reasons))
        success = false;
      if (success && !input.ReadCanFreeze(&result->can_freeze))
        success = false;
      if (success && !input.ReadCannotFreezeReasons(&result->cannot_freeze_reasons))
        success = false;
      if (success)
        result->discard_count = input.discard_count();
      if (success && !input.ReadDiscardReason(&result->discard_reason))
        success = false;
      if (success)
        result->utility_rank = input.utility_rank();
      if (success)
        result->last_active_seconds = input.last_active_seconds();
      if (success)
        result->id = input.id();
      if (success)
        result->is_auto_discardable = input.is_auto_discardable();
      if (success)
        result->site_engagement_score = input.site_engagement_score();
      if (success)
        result->has_focus = input.has_focus();
      if (success && !input.ReadStateChangeTime(&result->state_change_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::PageInfo::DataView, ::discards::mojom::PageInfoPtr>::Read(
    ::discards::mojom::PageInfo::DataView input,
    ::discards::mojom::PageInfoPtr* output) {
  bool success = true;
  ::discards::mojom::PageInfoPtr result(::discards::mojom::PageInfo::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadMainFrameUrl(&result->main_frame_url))
        success = false;
      if (success)
        result->opener_frame_id = input.opener_frame_id();
      if (success)
        result->embedder_frame_id = input.embedder_frame_id();
      if (success && !input.ReadDescriptionJson(&result->description_json))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::FrameInfo::DataView, ::discards::mojom::FrameInfoPtr>::Read(
    ::discards::mojom::FrameInfo::DataView input,
    ::discards::mojom::FrameInfoPtr* output) {
  bool success = true;
  ::discards::mojom::FrameInfoPtr result(::discards::mojom::FrameInfo::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->page_id = input.page_id();
      if (success)
        result->parent_frame_id = input.parent_frame_id();
      if (success)
        result->process_id = input.process_id();
      if (success && !input.ReadDescriptionJson(&result->description_json))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::ProcessInfo::DataView, ::discards::mojom::ProcessInfoPtr>::Read(
    ::discards::mojom::ProcessInfo::DataView input,
    ::discards::mojom::ProcessInfoPtr* output) {
  bool success = true;
  ::discards::mojom::ProcessInfoPtr result(::discards::mojom::ProcessInfo::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadPid(&result->pid))
        success = false;
      if (success)
        result->private_footprint_kb = input.private_footprint_kb();
      if (success && !input.ReadDescriptionJson(&result->description_json))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::WorkerInfo::DataView, ::discards::mojom::WorkerInfoPtr>::Read(
    ::discards::mojom::WorkerInfo::DataView input,
    ::discards::mojom::WorkerInfoPtr* output) {
  bool success = true;
  ::discards::mojom::WorkerInfoPtr result(::discards::mojom::WorkerInfo::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->process_id = input.process_id();
      if (success && !input.ReadClientFrameIds(&result->client_frame_ids))
        success = false;
      if (success && !input.ReadClientWorkerIds(&result->client_worker_ids))
        success = false;
      if (success && !input.ReadChildWorkerIds(&result->child_worker_ids))
        success = false;
      if (success && !input.ReadDescriptionJson(&result->description_json))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::discards::mojom::FavIconInfo::DataView, ::discards::mojom::FavIconInfoPtr>::Read(
    ::discards::mojom::FavIconInfo::DataView input,
    ::discards::mojom::FavIconInfoPtr* output) {
  bool success = true;
  ::discards::mojom::FavIconInfoPtr result(::discards::mojom::FavIconInfo::New());
  
      if (success)
        result->node_id = input.node_id();
      if (success && !input.ReadIconData(&result->icon_data))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace discards::mojom {


void DetailsProviderInterceptorForTesting::GetTabDiscardsInfo(GetTabDiscardsInfoCallback callback) {
  GetForwardingInterface()->GetTabDiscardsInfo(std::move(callback));
}
void DetailsProviderInterceptorForTesting::SetAutoDiscardable(int32_t tab_id, bool is_auto_discardable, SetAutoDiscardableCallback callback) {
  GetForwardingInterface()->SetAutoDiscardable(
    std::move(tab_id)
    , 
    std::move(is_auto_discardable)
    , std::move(callback));
}
void DetailsProviderInterceptorForTesting::DiscardById(int32_t tab_id, ::mojom::LifecycleUnitDiscardReason reason, DiscardByIdCallback callback) {
  GetForwardingInterface()->DiscardById(
    std::move(tab_id)
    , 
    std::move(reason)
    , std::move(callback));
}
void DetailsProviderInterceptorForTesting::FreezeById(int32_t tab_id) {
  GetForwardingInterface()->FreezeById(
    std::move(tab_id)
    );
}
void DetailsProviderInterceptorForTesting::LoadById(int32_t tab_id) {
  GetForwardingInterface()->LoadById(
    std::move(tab_id)
    );
}
void DetailsProviderInterceptorForTesting::Discard(DiscardCallback callback) {
  GetForwardingInterface()->Discard(std::move(callback));
}
void DetailsProviderInterceptorForTesting::ToggleBatterySaverMode() {
  GetForwardingInterface()->ToggleBatterySaverMode();
}
void DetailsProviderInterceptorForTesting::RefreshPerformanceTabCpuMeasurements() {
  GetForwardingInterface()->RefreshPerformanceTabCpuMeasurements();
}
DetailsProviderAsyncWaiter::DetailsProviderAsyncWaiter(
    DetailsProvider* proxy) : proxy_(proxy) {}

DetailsProviderAsyncWaiter::~DetailsProviderAsyncWaiter() = default;


void DetailsProviderAsyncWaiter::GetTabDiscardsInfo(
    std::vector<TabDiscardsInfoPtr>* out_infos) {
  base::RunLoop loop;
  proxy_->GetTabDiscardsInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<TabDiscardsInfoPtr>* out_infos
,
             std::vector<TabDiscardsInfoPtr> infos) {*out_infos = std::move(infos);
            loop->Quit();
          },
          &loop,
          out_infos));
  loop.Run();
}

std::vector<TabDiscardsInfoPtr> DetailsProviderAsyncWaiter::GetTabDiscardsInfo(
    ) {
  std::vector<TabDiscardsInfoPtr> async_wait_result;
  GetTabDiscardsInfo(&async_wait_result);
  return async_wait_result;
}

void DetailsProviderAsyncWaiter::SetAutoDiscardable(
    int32_t tab_id, bool is_auto_discardable) {
  base::RunLoop loop;
  proxy_->SetAutoDiscardable(
      std::move(tab_id),
      std::move(is_auto_discardable),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void DetailsProviderAsyncWaiter::DiscardById(
    int32_t tab_id, ::mojom::LifecycleUnitDiscardReason reason) {
  base::RunLoop loop;
  proxy_->DiscardById(
      std::move(tab_id),
      std::move(reason),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void DetailsProviderAsyncWaiter::Discard(
    ) {
  base::RunLoop loop;
  proxy_->Discard(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void GraphChangeStreamInterceptorForTesting::FrameCreated(FrameInfoPtr frame) {
  GetForwardingInterface()->FrameCreated(
    std::move(frame)
    );
}
void GraphChangeStreamInterceptorForTesting::PageCreated(PageInfoPtr pages) {
  GetForwardingInterface()->PageCreated(
    std::move(pages)
    );
}
void GraphChangeStreamInterceptorForTesting::ProcessCreated(ProcessInfoPtr process) {
  GetForwardingInterface()->ProcessCreated(
    std::move(process)
    );
}
void GraphChangeStreamInterceptorForTesting::WorkerCreated(WorkerInfoPtr worker) {
  GetForwardingInterface()->WorkerCreated(
    std::move(worker)
    );
}
void GraphChangeStreamInterceptorForTesting::FrameChanged(FrameInfoPtr frame) {
  GetForwardingInterface()->FrameChanged(
    std::move(frame)
    );
}
void GraphChangeStreamInterceptorForTesting::PageChanged(PageInfoPtr page) {
  GetForwardingInterface()->PageChanged(
    std::move(page)
    );
}
void GraphChangeStreamInterceptorForTesting::ProcessChanged(ProcessInfoPtr process) {
  GetForwardingInterface()->ProcessChanged(
    std::move(process)
    );
}
void GraphChangeStreamInterceptorForTesting::WorkerChanged(WorkerInfoPtr worker) {
  GetForwardingInterface()->WorkerChanged(
    std::move(worker)
    );
}
void GraphChangeStreamInterceptorForTesting::FavIconDataAvailable(FavIconInfoPtr favicon) {
  GetForwardingInterface()->FavIconDataAvailable(
    std::move(favicon)
    );
}
void GraphChangeStreamInterceptorForTesting::NodeDeleted(int64_t node_id) {
  GetForwardingInterface()->NodeDeleted(
    std::move(node_id)
    );
}
GraphChangeStreamAsyncWaiter::GraphChangeStreamAsyncWaiter(
    GraphChangeStream* proxy) : proxy_(proxy) {}

GraphChangeStreamAsyncWaiter::~GraphChangeStreamAsyncWaiter() = default;





void GraphDumpInterceptorForTesting::SubscribeToChanges(::mojo::PendingRemote<GraphChangeStream> change_subscriber) {
  GetForwardingInterface()->SubscribeToChanges(
    std::move(change_subscriber)
    );
}
void GraphDumpInterceptorForTesting::RequestNodeDescriptions(const std::vector<int64_t>& node_ids, RequestNodeDescriptionsCallback callback) {
  GetForwardingInterface()->RequestNodeDescriptions(
    std::move(node_ids)
    , std::move(callback));
}
GraphDumpAsyncWaiter::GraphDumpAsyncWaiter(
    GraphDump* proxy) : proxy_(proxy) {}

GraphDumpAsyncWaiter::~GraphDumpAsyncWaiter() = default;


void GraphDumpAsyncWaiter::RequestNodeDescriptions(
    const std::vector<int64_t>& node_ids, base::flat_map<int64_t, std::string>* out_node_descriptions_json) {
  base::RunLoop loop;
  proxy_->RequestNodeDescriptions(
      std::move(node_ids),
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<int64_t, std::string>* out_node_descriptions_json
,
             const base::flat_map<int64_t, std::string>& node_descriptions_json) {*out_node_descriptions_json = std::move(node_descriptions_json);
            loop->Quit();
          },
          &loop,
          out_node_descriptions_json));
  loop.Run();
}

base::flat_map<int64_t, std::string> GraphDumpAsyncWaiter::RequestNodeDescriptions(
    const std::vector<int64_t>& node_ids) {
  base::flat_map<int64_t, std::string> async_wait_result;
  RequestNodeDescriptions(std::move(node_ids),&async_wait_result);
  return async_wait_result;
}






}  // discards::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif