// chrome/browser/ui/webui/discards/discards.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/discards/discards.mojom-shared-internal.h"
#include "chrome/browser/resource_coordinator/lifecycle_unit_state.mojom-shared.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/discards/discards.mojom-data-view.h"




namespace std {

template <>
struct hash<::discards::mojom::LifecycleUnitVisibility>
    : public mojo::internal::EnumHashImpl<::discards::mojom::LifecycleUnitVisibility> {};

template <>
struct hash<::discards::mojom::CanFreeze>
    : public mojo::internal::EnumHashImpl<::discards::mojom::CanFreeze> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::LifecycleUnitVisibility, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::discards::mojom::LifecycleUnitVisibility, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::discards::mojom::LifecycleUnitVisibility>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::CanFreeze, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::discards::mojom::CanFreeze, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::discards::mojom::CanFreeze>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::TabDiscardsInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::TabDiscardsInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::TabDiscardsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tab_url(input)) in_tab_url = Traits::tab_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_url)::BaseType> tab_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_tab_url,
      tab_url_fragment);

    fragment->tab_url.Set(
        tab_url_fragment.is_null() ? nullptr : tab_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_url in TabDiscardsInfo struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabDiscardsInfo struct");

    
    mojo::internal::Serialize<::discards::mojom::LifecycleUnitVisibility>(
      Traits::visibility(input),
      &fragment->visibility);

    
    mojo::internal::Serialize<::mojom::LifecycleUnitLoadingState>(
      Traits::loading_state(input),
      &fragment->loading_state);

    
    mojo::internal::Serialize<::mojom::LifecycleUnitState>(
      Traits::state(input),
      &fragment->state);

    fragment->can_discard = Traits::can_discard(input);

    decltype(Traits::cannot_discard_reasons(input)) in_cannot_discard_reasons = Traits::cannot_discard_reasons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cannot_discard_reasons)::BaseType>
        cannot_discard_reasons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cannot_discard_reasons_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_cannot_discard_reasons,
      cannot_discard_reasons_fragment,
      &cannot_discard_reasons_validate_params);

    fragment->cannot_discard_reasons.Set(
        cannot_discard_reasons_fragment.is_null() ? nullptr : cannot_discard_reasons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cannot_discard_reasons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cannot_discard_reasons in TabDiscardsInfo struct");

    
    mojo::internal::Serialize<::discards::mojom::CanFreeze>(
      Traits::can_freeze(input),
      &fragment->can_freeze);

    decltype(Traits::cannot_freeze_reasons(input)) in_cannot_freeze_reasons = Traits::cannot_freeze_reasons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cannot_freeze_reasons)::BaseType>
        cannot_freeze_reasons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cannot_freeze_reasons_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_cannot_freeze_reasons,
      cannot_freeze_reasons_fragment,
      &cannot_freeze_reasons_validate_params);

    fragment->cannot_freeze_reasons.Set(
        cannot_freeze_reasons_fragment.is_null() ? nullptr : cannot_freeze_reasons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cannot_freeze_reasons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cannot_freeze_reasons in TabDiscardsInfo struct");

    fragment->discard_count = Traits::discard_count(input);

    
    mojo::internal::Serialize<::mojom::LifecycleUnitDiscardReason>(
      Traits::discard_reason(input),
      &fragment->discard_reason);

    fragment->utility_rank = Traits::utility_rank(input);

    fragment->last_active_seconds = Traits::last_active_seconds(input);

    fragment->id = Traits::id(input);

    fragment->is_auto_discardable = Traits::is_auto_discardable(input);

    fragment->site_engagement_score = Traits::site_engagement_score(input);

    fragment->has_focus = Traits::has_focus(input);

    decltype(Traits::state_change_time(input)) in_state_change_time = Traits::state_change_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->state_change_time)::BaseType> state_change_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_state_change_time,
      state_change_time_fragment);

    fragment->state_change_time.Set(
        state_change_time_fragment.is_null() ? nullptr : state_change_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->state_change_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state_change_time in TabDiscardsInfo struct");
  }

  static bool Deserialize(::discards::mojom::internal::TabDiscardsInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::TabDiscardsInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::PageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::PageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::PageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::main_frame_url(input)) in_main_frame_url = Traits::main_frame_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_frame_url)::BaseType> main_frame_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_main_frame_url,
      main_frame_url_fragment);

    fragment->main_frame_url.Set(
        main_frame_url_fragment.is_null() ? nullptr : main_frame_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->main_frame_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_frame_url in PageInfo struct");

    fragment->opener_frame_id = Traits::opener_frame_id(input);

    fragment->embedder_frame_id = Traits::embedder_frame_id(input);

    decltype(Traits::description_json(input)) in_description_json = Traits::description_json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description_json)::BaseType> description_json_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description_json,
      description_json_fragment);

    fragment->description_json.Set(
        description_json_fragment.is_null() ? nullptr : description_json_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description_json.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description_json in PageInfo struct");
  }

  static bool Deserialize(::discards::mojom::internal::PageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::PageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::FrameInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::FrameInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::FrameInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in FrameInfo struct");

    fragment->page_id = Traits::page_id(input);

    fragment->parent_frame_id = Traits::parent_frame_id(input);

    fragment->process_id = Traits::process_id(input);

    decltype(Traits::description_json(input)) in_description_json = Traits::description_json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description_json)::BaseType> description_json_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description_json,
      description_json_fragment);

    fragment->description_json.Set(
        description_json_fragment.is_null() ? nullptr : description_json_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description_json.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description_json in FrameInfo struct");
  }

  static bool Deserialize(::discards::mojom::internal::FrameInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::FrameInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::ProcessInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::ProcessInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::ProcessInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::pid(input)) in_pid = Traits::pid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pid)::BaseType> pid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
      in_pid,
      pid_fragment);

    fragment->pid.Set(
        pid_fragment.is_null() ? nullptr : pid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pid in ProcessInfo struct");

    fragment->private_footprint_kb = Traits::private_footprint_kb(input);

    decltype(Traits::description_json(input)) in_description_json = Traits::description_json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description_json)::BaseType> description_json_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description_json,
      description_json_fragment);

    fragment->description_json.Set(
        description_json_fragment.is_null() ? nullptr : description_json_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description_json.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description_json in ProcessInfo struct");
  }

  static bool Deserialize(::discards::mojom::internal::ProcessInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::ProcessInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::WorkerInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::WorkerInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::WorkerInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in WorkerInfo struct");

    fragment->process_id = Traits::process_id(input);

    decltype(Traits::client_frame_ids(input)) in_client_frame_ids = Traits::client_frame_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_frame_ids)::BaseType>
        client_frame_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& client_frame_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_client_frame_ids,
      client_frame_ids_fragment,
      &client_frame_ids_validate_params);

    fragment->client_frame_ids.Set(
        client_frame_ids_fragment.is_null() ? nullptr : client_frame_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_frame_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_frame_ids in WorkerInfo struct");

    decltype(Traits::client_worker_ids(input)) in_client_worker_ids = Traits::client_worker_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_worker_ids)::BaseType>
        client_worker_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& client_worker_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_client_worker_ids,
      client_worker_ids_fragment,
      &client_worker_ids_validate_params);

    fragment->client_worker_ids.Set(
        client_worker_ids_fragment.is_null() ? nullptr : client_worker_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_worker_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_worker_ids in WorkerInfo struct");

    decltype(Traits::child_worker_ids(input)) in_child_worker_ids = Traits::child_worker_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->child_worker_ids)::BaseType>
        child_worker_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& child_worker_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
      in_child_worker_ids,
      child_worker_ids_fragment,
      &child_worker_ids_validate_params);

    fragment->child_worker_ids.Set(
        child_worker_ids_fragment.is_null() ? nullptr : child_worker_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->child_worker_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_worker_ids in WorkerInfo struct");

    decltype(Traits::description_json(input)) in_description_json = Traits::description_json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description_json)::BaseType> description_json_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description_json,
      description_json_fragment);

    fragment->description_json.Set(
        description_json_fragment.is_null() ? nullptr : description_json_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description_json.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description_json in WorkerInfo struct");
  }

  static bool Deserialize(::discards::mojom::internal::WorkerInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::WorkerInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::FavIconInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::FavIconInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::FavIconInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->node_id = Traits::node_id(input);

    decltype(Traits::icon_data(input)) in_icon_data = Traits::icon_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon_data)::BaseType> icon_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_icon_data,
      icon_data_fragment);

    fragment->icon_data.Set(
        icon_data_fragment.is_null() ? nullptr : icon_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icon_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_data in FavIconInfo struct");
  }

  static bool Deserialize(::discards::mojom::internal::FavIconInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::FavIconInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace discards::mojom {

inline void TabDiscardsInfoDataView::GetTabUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tab_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDiscardsInfoDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDiscardsInfoDataView::GetCannotDiscardReasonsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cannot_discard_reasons.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void TabDiscardsInfoDataView::GetCannotFreezeReasonsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cannot_freeze_reasons.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void TabDiscardsInfoDataView::GetStateChangeTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->state_change_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void PageInfoDataView::GetMainFrameUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->main_frame_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PageInfoDataView::GetDescriptionJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void FrameInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FrameInfoDataView::GetDescriptionJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ProcessInfoDataView::GetPidDataView(
    ::mojo_base::mojom::ProcessIdDataView* output) {
  auto pointer = data_->pid.Get();
  *output = ::mojo_base::mojom::ProcessIdDataView(pointer, message_);
}
inline void ProcessInfoDataView::GetDescriptionJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WorkerInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WorkerInfoDataView::GetClientFrameIdsDataView(
    mojo::ArrayDataView<int64_t>* output) {
  auto pointer = data_->client_frame_ids.Get();
  *output = mojo::ArrayDataView<int64_t>(pointer, message_);
}
inline void WorkerInfoDataView::GetClientWorkerIdsDataView(
    mojo::ArrayDataView<int64_t>* output) {
  auto pointer = data_->client_worker_ids.Get();
  *output = mojo::ArrayDataView<int64_t>(pointer, message_);
}
inline void WorkerInfoDataView::GetChildWorkerIdsDataView(
    mojo::ArrayDataView<int64_t>* output) {
  auto pointer = data_->child_worker_ids.Get();
  *output = mojo::ArrayDataView<int64_t>(pointer, message_);
}
inline void WorkerInfoDataView::GetDescriptionJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description_json.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void FavIconInfoDataView::GetIconDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->icon_data.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // discards::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::discards::mojom::LifecycleUnitVisibility> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::discards::mojom::LifecycleUnitVisibility value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::discards::mojom::CanFreeze> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::discards::mojom::CanFreeze value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_SHARED_H_