// chrome/browser/ui/webui/discards/discards.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/discards/discards.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/discards/discards.mojom-params-data.h"
namespace discards {
namespace mojom {

NOINLINE static const char* LifecycleUnitVisibilityToStringHelper(LifecycleUnitVisibility value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LifecycleUnitVisibility::HIDDEN:
      return "HIDDEN";
    case LifecycleUnitVisibility::OCCLUDED:
      return "OCCLUDED";
    case LifecycleUnitVisibility::VISIBLE:
      return "VISIBLE";
    default:
      return nullptr;
  }
}

std::string LifecycleUnitVisibilityToString(LifecycleUnitVisibility value) {
  const char *str = LifecycleUnitVisibilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LifecycleUnitVisibility value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LifecycleUnitVisibility value) {
  return os << LifecycleUnitVisibilityToString(value);
}

NOINLINE static const char* CanFreezeToStringHelper(CanFreeze value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CanFreeze::YES:
      return "YES";
    case CanFreeze::VARIES:
      return "VARIES";
    case CanFreeze::NO:
      return "NO";
    default:
      return nullptr;
  }
}

std::string CanFreezeToString(CanFreeze value) {
  const char *str = CanFreezeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CanFreeze value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CanFreeze value) {
  return os << CanFreezeToString(value);
}

namespace internal {


// static
bool TabDiscardsInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabDiscardsInfo_Data* object =
      static_cast<const TabDiscardsInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_url, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_url, validation_context,
                                         &tab_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }


  if (!::discards::mojom::internal::LifecycleUnitVisibility_Data
        ::Validate(object->visibility, validation_context))
    return false;


  if (!::mojom::internal::LifecycleUnitLoadingState_Data
        ::Validate(object->loading_state, validation_context))
    return false;


  if (!::mojom::internal::LifecycleUnitState_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cannot_discard_reasons, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cannot_discard_reasons_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cannot_discard_reasons, validation_context,
                                         &cannot_discard_reasons_validate_params)) {
    return false;
  }


  if (!::discards::mojom::internal::CanFreeze_Data
        ::Validate(object->can_freeze, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cannot_freeze_reasons, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cannot_freeze_reasons_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cannot_freeze_reasons, validation_context,
                                         &cannot_freeze_reasons_validate_params)) {
    return false;
  }


  if (!::mojom::internal::LifecycleUnitDiscardReason_Data
        ::Validate(object->discard_reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state_change_time, 18, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state_change_time, validation_context))
    return false;

  return true;
}

TabDiscardsInfo_Data::TabDiscardsInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageInfo_Data* object =
      static_cast<const PageInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_frame_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_frame_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_json, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description_json, validation_context,
                                         &description_json_validate_params)) {
    return false;
  }

  return true;
}

PageInfo_Data::PageInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameInfo_Data* object =
      static_cast<const FrameInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_json, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description_json, validation_context,
                                         &description_json_validate_params)) {
    return false;
  }

  return true;
}

FrameInfo_Data::FrameInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProcessInfo_Data* object =
      static_cast<const ProcessInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_json, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description_json, validation_context,
                                         &description_json_validate_params)) {
    return false;
  }

  return true;
}

ProcessInfo_Data::ProcessInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WorkerInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WorkerInfo_Data* object =
      static_cast<const WorkerInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_frame_ids, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_frame_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_frame_ids, validation_context,
                                         &client_frame_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_worker_ids, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_worker_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_worker_ids, validation_context,
                                         &client_worker_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_worker_ids, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& child_worker_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->child_worker_ids, validation_context,
                                         &child_worker_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_json, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description_json, validation_context,
                                         &description_json_validate_params)) {
    return false;
  }

  return true;
}

WorkerInfo_Data::WorkerInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FavIconInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FavIconInfo_Data* object =
      static_cast<const FavIconInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icon_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icon_data, validation_context,
                                         &icon_data_validate_params)) {
    return false;
  }

  return true;
}

FavIconInfo_Data::FavIconInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_GetTabDiscardsInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_GetTabDiscardsInfo_Params_Data* object =
      static_cast<const DetailsProvider_GetTabDiscardsInfo_Params_Data*>(data);

  return true;
}

DetailsProvider_GetTabDiscardsInfo_Params_Data::DetailsProvider_GetTabDiscardsInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data* object =
      static_cast<const DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->infos, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->infos, validation_context,
                                         &infos_validate_params)) {
    return false;
  }

  return true;
}

DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data::DetailsProvider_GetTabDiscardsInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_SetAutoDiscardable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_SetAutoDiscardable_Params_Data* object =
      static_cast<const DetailsProvider_SetAutoDiscardable_Params_Data*>(data);

  return true;
}

DetailsProvider_SetAutoDiscardable_Params_Data::DetailsProvider_SetAutoDiscardable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_SetAutoDiscardable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_SetAutoDiscardable_ResponseParams_Data* object =
      static_cast<const DetailsProvider_SetAutoDiscardable_ResponseParams_Data*>(data);

  return true;
}

DetailsProvider_SetAutoDiscardable_ResponseParams_Data::DetailsProvider_SetAutoDiscardable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_DiscardById_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_DiscardById_Params_Data* object =
      static_cast<const DetailsProvider_DiscardById_Params_Data*>(data);


  if (!::mojom::internal::LifecycleUnitDiscardReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

DetailsProvider_DiscardById_Params_Data::DetailsProvider_DiscardById_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_DiscardById_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_DiscardById_ResponseParams_Data* object =
      static_cast<const DetailsProvider_DiscardById_ResponseParams_Data*>(data);

  return true;
}

DetailsProvider_DiscardById_ResponseParams_Data::DetailsProvider_DiscardById_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_FreezeById_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_FreezeById_Params_Data* object =
      static_cast<const DetailsProvider_FreezeById_Params_Data*>(data);

  return true;
}

DetailsProvider_FreezeById_Params_Data::DetailsProvider_FreezeById_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_LoadById_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_LoadById_Params_Data* object =
      static_cast<const DetailsProvider_LoadById_Params_Data*>(data);

  return true;
}

DetailsProvider_LoadById_Params_Data::DetailsProvider_LoadById_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_Discard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_Discard_Params_Data* object =
      static_cast<const DetailsProvider_Discard_Params_Data*>(data);

  return true;
}

DetailsProvider_Discard_Params_Data::DetailsProvider_Discard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_Discard_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_Discard_ResponseParams_Data* object =
      static_cast<const DetailsProvider_Discard_ResponseParams_Data*>(data);

  return true;
}

DetailsProvider_Discard_ResponseParams_Data::DetailsProvider_Discard_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_ToggleBatterySaverMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_ToggleBatterySaverMode_Params_Data* object =
      static_cast<const DetailsProvider_ToggleBatterySaverMode_Params_Data*>(data);

  return true;
}

DetailsProvider_ToggleBatterySaverMode_Params_Data::DetailsProvider_ToggleBatterySaverMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data* object =
      static_cast<const DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data*>(data);

  return true;
}

DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data::DetailsProvider_RefreshPerformanceTabCpuMeasurements_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_FrameCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_FrameCreated_Params_Data* object =
      static_cast<const GraphChangeStream_FrameCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

GraphChangeStream_FrameCreated_Params_Data::GraphChangeStream_FrameCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_PageCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_PageCreated_Params_Data* object =
      static_cast<const GraphChangeStream_PageCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pages, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pages, validation_context))
    return false;

  return true;
}

GraphChangeStream_PageCreated_Params_Data::GraphChangeStream_PageCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_ProcessCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_ProcessCreated_Params_Data* object =
      static_cast<const GraphChangeStream_ProcessCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->process, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->process, validation_context))
    return false;

  return true;
}

GraphChangeStream_ProcessCreated_Params_Data::GraphChangeStream_ProcessCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_WorkerCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_WorkerCreated_Params_Data* object =
      static_cast<const GraphChangeStream_WorkerCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->worker, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->worker, validation_context))
    return false;

  return true;
}

GraphChangeStream_WorkerCreated_Params_Data::GraphChangeStream_WorkerCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_FrameChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_FrameChanged_Params_Data* object =
      static_cast<const GraphChangeStream_FrameChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

GraphChangeStream_FrameChanged_Params_Data::GraphChangeStream_FrameChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_PageChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_PageChanged_Params_Data* object =
      static_cast<const GraphChangeStream_PageChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page, validation_context))
    return false;

  return true;
}

GraphChangeStream_PageChanged_Params_Data::GraphChangeStream_PageChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_ProcessChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_ProcessChanged_Params_Data* object =
      static_cast<const GraphChangeStream_ProcessChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->process, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->process, validation_context))
    return false;

  return true;
}

GraphChangeStream_ProcessChanged_Params_Data::GraphChangeStream_ProcessChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_WorkerChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_WorkerChanged_Params_Data* object =
      static_cast<const GraphChangeStream_WorkerChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->worker, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->worker, validation_context))
    return false;

  return true;
}

GraphChangeStream_WorkerChanged_Params_Data::GraphChangeStream_WorkerChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_FavIconDataAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_FavIconDataAvailable_Params_Data* object =
      static_cast<const GraphChangeStream_FavIconDataAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicon, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->favicon, validation_context))
    return false;

  return true;
}

GraphChangeStream_FavIconDataAvailable_Params_Data::GraphChangeStream_FavIconDataAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphChangeStream_NodeDeleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphChangeStream_NodeDeleted_Params_Data* object =
      static_cast<const GraphChangeStream_NodeDeleted_Params_Data*>(data);

  return true;
}

GraphChangeStream_NodeDeleted_Params_Data::GraphChangeStream_NodeDeleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphDump_SubscribeToChanges_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphDump_SubscribeToChanges_Params_Data* object =
      static_cast<const GraphDump_SubscribeToChanges_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->change_subscriber, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->change_subscriber,
                                                 validation_context)) {
    return false;
  }

  return true;
}

GraphDump_SubscribeToChanges_Params_Data::GraphDump_SubscribeToChanges_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphDump_RequestNodeDescriptions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphDump_RequestNodeDescriptions_Params_Data* object =
      static_cast<const GraphDump_RequestNodeDescriptions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->node_ids, validation_context,
                                         &node_ids_validate_params)) {
    return false;
  }

  return true;
}

GraphDump_RequestNodeDescriptions_Params_Data::GraphDump_RequestNodeDescriptions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GraphDump_RequestNodeDescriptions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GraphDump_RequestNodeDescriptions_ResponseParams_Data* object =
      static_cast<const GraphDump_RequestNodeDescriptions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_descriptions_json, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_descriptions_json_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->node_descriptions_json, validation_context,
                                         &node_descriptions_json_validate_params)) {
    return false;
  }

  return true;
}

GraphDump_RequestNodeDescriptions_ResponseParams_Data::GraphDump_RequestNodeDescriptions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace discards

namespace perfetto {

// static
void TraceFormatTraits<::discards::mojom::LifecycleUnitVisibility>::WriteIntoTrace(
   perfetto::TracedValue context, ::discards::mojom::LifecycleUnitVisibility value) {
  return std::move(context).WriteString(::discards::mojom::LifecycleUnitVisibilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::discards::mojom::CanFreeze>::WriteIntoTrace(
   perfetto::TracedValue context, ::discards::mojom::CanFreeze value) {
  return std::move(context).WriteString(::discards::mojom::CanFreezeToString(value));
}

} // namespace perfetto