// chrome/browser/ui/webui/discards/discards.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/discards/discards.mojom-shared-internal.h"
#include "chrome/browser/resource_coordinator/lifecycle_unit_state.mojom-shared.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace discards::mojom {
class TabDiscardsInfoDataView;

class PageInfoDataView;

class FrameInfoDataView;

class ProcessInfoDataView;

class WorkerInfoDataView;

class FavIconInfoDataView;



}  // discards::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::discards::mojom::TabDiscardsInfoDataView> {
  using Data = ::discards::mojom::internal::TabDiscardsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::PageInfoDataView> {
  using Data = ::discards::mojom::internal::PageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::FrameInfoDataView> {
  using Data = ::discards::mojom::internal::FrameInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::ProcessInfoDataView> {
  using Data = ::discards::mojom::internal::ProcessInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::WorkerInfoDataView> {
  using Data = ::discards::mojom::internal::WorkerInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::discards::mojom::FavIconInfoDataView> {
  using Data = ::discards::mojom::internal::FavIconInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace discards::mojom {


enum class LifecycleUnitVisibility : int32_t {
  
  HIDDEN = 0,
  
  OCCLUDED = 1,
  
  VISIBLE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, LifecycleUnitVisibility value);
inline bool IsKnownEnumValue(LifecycleUnitVisibility value) {
  return internal::LifecycleUnitVisibility_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CanFreeze : int32_t {
  
  YES = 0,
  
  VARIES = 1,
  
  NO = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CanFreeze value);
inline bool IsKnownEnumValue(CanFreeze value) {
  return internal::CanFreeze_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DetailsProviderInterfaceBase {};

using DetailsProviderPtrDataView =
    mojo::InterfacePtrDataView<DetailsProviderInterfaceBase>;
using DetailsProviderRequestDataView =
    mojo::InterfaceRequestDataView<DetailsProviderInterfaceBase>;
using DetailsProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DetailsProviderInterfaceBase>;
using DetailsProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DetailsProviderInterfaceBase>;
class GraphChangeStreamInterfaceBase {};

using GraphChangeStreamPtrDataView =
    mojo::InterfacePtrDataView<GraphChangeStreamInterfaceBase>;
using GraphChangeStreamRequestDataView =
    mojo::InterfaceRequestDataView<GraphChangeStreamInterfaceBase>;
using GraphChangeStreamAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GraphChangeStreamInterfaceBase>;
using GraphChangeStreamAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GraphChangeStreamInterfaceBase>;
class GraphDumpInterfaceBase {};

using GraphDumpPtrDataView =
    mojo::InterfacePtrDataView<GraphDumpInterfaceBase>;
using GraphDumpRequestDataView =
    mojo::InterfaceRequestDataView<GraphDumpInterfaceBase>;
using GraphDumpAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GraphDumpInterfaceBase>;
using GraphDumpAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GraphDumpInterfaceBase>;


class TabDiscardsInfoDataView {
 public:
  TabDiscardsInfoDataView() = default;

  TabDiscardsInfoDataView(
      internal::TabDiscardsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabUrl(UserType* output) {
    
    auto* pointer = data_->tab_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVisibility(UserType* output) const {
    auto data_value = data_->visibility;
    return mojo::internal::Deserialize<::discards::mojom::LifecycleUnitVisibility>(
        data_value, output);
  }
  LifecycleUnitVisibility visibility() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::discards::mojom::LifecycleUnitVisibility>(data_->visibility));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLoadingState(UserType* output) const {
    auto data_value = data_->loading_state;
    return mojo::internal::Deserialize<::mojom::LifecycleUnitLoadingState>(
        data_value, output);
  }
  ::mojom::LifecycleUnitLoadingState loading_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojom::LifecycleUnitLoadingState>(data_->loading_state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::mojom::LifecycleUnitState>(
        data_value, output);
  }
  ::mojom::LifecycleUnitState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojom::LifecycleUnitState>(data_->state));
  }
  bool can_discard() const {
    return data_->can_discard;
  }
  inline void GetCannotDiscardReasonsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCannotDiscardReasons(UserType* output) {
    
    auto* pointer = data_->cannot_discard_reasons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCanFreeze(UserType* output) const {
    auto data_value = data_->can_freeze;
    return mojo::internal::Deserialize<::discards::mojom::CanFreeze>(
        data_value, output);
  }
  CanFreeze can_freeze() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::discards::mojom::CanFreeze>(data_->can_freeze));
  }
  inline void GetCannotFreezeReasonsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCannotFreezeReasons(UserType* output) {
    
    auto* pointer = data_->cannot_freeze_reasons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  int32_t discard_count() const {
    return data_->discard_count;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDiscardReason(UserType* output) const {
    auto data_value = data_->discard_reason;
    return mojo::internal::Deserialize<::mojom::LifecycleUnitDiscardReason>(
        data_value, output);
  }
  ::mojom::LifecycleUnitDiscardReason discard_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojom::LifecycleUnitDiscardReason>(data_->discard_reason));
  }
  int32_t utility_rank() const {
    return data_->utility_rank;
  }
  int32_t last_active_seconds() const {
    return data_->last_active_seconds;
  }
  int32_t id() const {
    return data_->id;
  }
  bool is_auto_discardable() const {
    return data_->is_auto_discardable;
  }
  double site_engagement_score() const {
    return data_->site_engagement_score;
  }
  bool has_focus() const {
    return data_->has_focus;
  }
  inline void GetStateChangeTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStateChangeTime(UserType* output) {
    
    auto* pointer = data_->state_change_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabDiscardsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageInfoDataView {
 public:
  PageInfoDataView() = default;

  PageInfoDataView(
      internal::PageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetMainFrameUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameUrl(UserType* output) {
    
    auto* pointer = data_->main_frame_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t opener_frame_id() const {
    return data_->opener_frame_id;
  }
  int64_t embedder_frame_id() const {
    return data_->embedder_frame_id;
  }
  inline void GetDescriptionJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptionJson(UserType* output) {
    
    auto* pointer = data_->description_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameInfoDataView {
 public:
  FrameInfoDataView() = default;

  FrameInfoDataView(
      internal::FrameInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t page_id() const {
    return data_->page_id;
  }
  int64_t parent_frame_id() const {
    return data_->parent_frame_id;
  }
  int64_t process_id() const {
    return data_->process_id;
  }
  inline void GetDescriptionJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptionJson(UserType* output) {
    
    auto* pointer = data_->description_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FrameInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProcessInfoDataView {
 public:
  ProcessInfoDataView() = default;

  ProcessInfoDataView(
      internal::ProcessInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetPidDataView(
      ::mojo_base::mojom::ProcessIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPid(UserType* output) {
    
    auto* pointer = data_->pid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProcessIdDataView>(
        pointer, output, message_);
  }
  uint64_t private_footprint_kb() const {
    return data_->private_footprint_kb;
  }
  inline void GetDescriptionJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptionJson(UserType* output) {
    
    auto* pointer = data_->description_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProcessInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WorkerInfoDataView {
 public:
  WorkerInfoDataView() = default;

  WorkerInfoDataView(
      internal::WorkerInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t process_id() const {
    return data_->process_id;
  }
  inline void GetClientFrameIdsDataView(
      mojo::ArrayDataView<int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientFrameIds(UserType* output) {
    
    auto* pointer = data_->client_frame_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int64_t>>(
        pointer, output, message_);
  }
  inline void GetClientWorkerIdsDataView(
      mojo::ArrayDataView<int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientWorkerIds(UserType* output) {
    
    auto* pointer = data_->client_worker_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int64_t>>(
        pointer, output, message_);
  }
  inline void GetChildWorkerIdsDataView(
      mojo::ArrayDataView<int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildWorkerIds(UserType* output) {
    
    auto* pointer = data_->child_worker_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int64_t>>(
        pointer, output, message_);
  }
  inline void GetDescriptionJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptionJson(UserType* output) {
    
    auto* pointer = data_->description_json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WorkerInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FavIconInfoDataView {
 public:
  FavIconInfoDataView() = default;

  FavIconInfoDataView(
      internal::FavIconInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t node_id() const {
    return data_->node_id;
  }
  inline void GetIconDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconData(UserType* output) {
    
    auto* pointer = data_->icon_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FavIconInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // discards::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_DATA_VIEW_H_