// chrome/browser/ui/webui/data_sharing/data_sharing.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom.h"


namespace data_sharing::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void ShowUI() override;
  void CloseUI(int32_t status_code) override;
  void ApiInitComplete() override;
  void MakeTabGroupShared(const std::string& tab_group_id, const std::string& group_id, const std::string& access_token, MakeTabGroupSharedCallback callback) override;
  void GetShareLink(const std::string& group_id, const std::string& access_token, GetShareLinkCallback callback) override;
  void GetTabGroupPreview(const std::string& group_id, const std::string& access_token, GetTabGroupPreviewCallback callback) override;
  void OpenTabGroup(const std::string& group_id) override;
  void AboutToUnShareTabGroup(const std::string& tab_group_id) override;
  void OnTabGroupUnShareComplete(const std::string& tab_group_id) override;
  void OnGroupAction(GroupAction action, GroupActionProgress progress) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void MakeTabGroupShared(
      const std::string& tab_group_id, const std::string& group_id, const std::string& access_token, std::optional<::GURL>* out_url);
  std::optional<::GURL> MakeTabGroupShared(const std::string& tab_group_id, const std::string& group_id, const std::string& access_token);
  void GetShareLink(
      const std::string& group_id, const std::string& access_token, ::GURL* out_url);
  ::GURL GetShareLink(const std::string& group_id, const std::string& access_token);
  void GetTabGroupPreview(
      const std::string& group_id, const std::string& access_token, GroupPreviewPtr* out_group_preview);
  GroupPreviewPtr GetTabGroupPreview(const std::string& group_id, const std::string& access_token);

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void OnAccessTokenFetched(const std::string& access_token) override;
  void ReadGroups(ReadGroupsParamsPtr read_groups_params, ReadGroupsCallback callback) override;
  void ReadGroupWithToken(ReadGroupWithTokenParamPtr param, ReadGroupWithTokenCallback callback) override;
  void DeleteGroup(const std::string& group_id, DeleteGroupCallback callback) override;
  void LeaveGroup(const std::string& group_id, LeaveGroupCallback callback) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();
  void ReadGroups(
      ReadGroupsParamsPtr read_groups_params, ReadGroupsResultPtr* out_result);
  ReadGroupsResultPtr ReadGroups(ReadGroupsParamsPtr read_groups_params);
  void ReadGroupWithToken(
      ReadGroupWithTokenParamPtr param, ReadGroupWithTokenResultPtr* out_result);
  ReadGroupWithTokenResultPtr ReadGroupWithToken(ReadGroupWithTokenParamPtr param);
  void DeleteGroup(
      const std::string& group_id, int32_t* out_status_code);
  int32_t DeleteGroup(const std::string& group_id);
  void LeaveGroup(
      const std::string& group_id, int32_t* out_status_code);
  int32_t LeaveGroup(const std::string& group_id);

 private:
  Page* const proxy_;
};




}  // data_sharing::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_TEST_UTILS_H_