// chrome/browser/ui/webui/data_sharing/data_sharing.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-params-data.h"
namespace data_sharing {
namespace mojom {

NOINLINE static const char* GroupActionToStringHelper(GroupAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GroupAction::kUnknown:
      return "kUnknown";
    case GroupAction::kJoinGroup:
      return "kJoinGroup";
    case GroupAction::kDeleteGroup:
      return "kDeleteGroup";
    case GroupAction::kLeaveGroup:
      return "kLeaveGroup";
    case GroupAction::kKeepGroup:
      return "kKeepGroup";
    case GroupAction::kStopSharing:
      return "kStopSharing";
    default:
      return nullptr;
  }
}

std::string GroupActionToString(GroupAction value) {
  const char *str = GroupActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GroupAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GroupAction value) {
  return os << GroupActionToString(value);
}

NOINLINE static const char* GroupActionProgressToStringHelper(GroupActionProgress value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GroupActionProgress::kUnknown:
      return "kUnknown";
    case GroupActionProgress::kStarted:
      return "kStarted";
    case GroupActionProgress::kFailed:
      return "kFailed";
    case GroupActionProgress::kSuccess:
      return "kSuccess";
    default:
      return nullptr;
  }
}

std::string GroupActionProgressToString(GroupActionProgress value) {
  const char *str = GroupActionProgressToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GroupActionProgress value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GroupActionProgress value) {
  return os << GroupActionProgressToString(value);
}

namespace internal {


// static
bool ReadGroupsParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadGroupsParams_Data* object =
      static_cast<const ReadGroupsParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->params, validation_context,
                                         &params_validate_params)) {
    return false;
  }

  return true;
}

ReadGroupsParams_Data::ReadGroupsParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadGroupParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadGroupParams_Data* object =
      static_cast<const ReadGroupParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->consistency_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& consistency_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->consistency_token, validation_context,
                                         &consistency_token_validate_params)) {
    return false;
  }

  return true;
}

ReadGroupParams_Data::ReadGroupParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadGroupsResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadGroupsResult_Data* object =
      static_cast<const ReadGroupsResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->groups, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->groups, validation_context,
                                         &groups_validate_params)) {
    return false;
  }

  return true;
}

ReadGroupsResult_Data::ReadGroupsResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadGroupWithTokenParam_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadGroupWithTokenParam_Data* object =
      static_cast<const ReadGroupWithTokenParam_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_token, validation_context,
                                         &access_token_validate_params)) {
    return false;
  }

  return true;
}

ReadGroupWithTokenParam_Data::ReadGroupWithTokenParam_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadGroupWithTokenResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadGroupWithTokenResult_Data* object =
      static_cast<const ReadGroupWithTokenResult_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->group, validation_context))
    return false;

  return true;
}

ReadGroupWithTokenResult_Data::ReadGroupWithTokenResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedTab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedTab_Data* object =
      static_cast<const SharedTab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_url, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_url, validation_context,
                                         &display_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->favicon_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;

  return true;
}

SharedTab_Data::SharedTab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GroupPreview_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GroupPreview_Data* object =
      static_cast<const GroupPreview_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_tabs, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& shared_tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shared_tabs, validation_context,
                                         &shared_tabs_validate_params)) {
    return false;
  }


  if (!::mojo_base::mojom::internal::AbslStatusCode_Data
        ::Validate(object->status_code, validation_context))
    return false;

  return true;
}

GroupPreview_Data::GroupPreview_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowUI_Params_Data* object =
      static_cast<const PageHandler_ShowUI_Params_Data*>(data);

  return true;
}

PageHandler_ShowUI_Params_Data::PageHandler_ShowUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloseUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloseUI_Params_Data* object =
      static_cast<const PageHandler_CloseUI_Params_Data*>(data);

  return true;
}

PageHandler_CloseUI_Params_Data::PageHandler_CloseUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ApiInitComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ApiInitComplete_Params_Data* object =
      static_cast<const PageHandler_ApiInitComplete_Params_Data*>(data);

  return true;
}

PageHandler_ApiInitComplete_Params_Data::PageHandler_ApiInitComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_MakeTabGroupShared_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_MakeTabGroupShared_Params_Data* object =
      static_cast<const PageHandler_MakeTabGroupShared_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_group_id, validation_context,
                                         &tab_group_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_token, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_token, validation_context,
                                         &access_token_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_MakeTabGroupShared_Params_Data::PageHandler_MakeTabGroupShared_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_MakeTabGroupShared_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_MakeTabGroupShared_ResponseParams_Data* object =
      static_cast<const PageHandler_MakeTabGroupShared_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_MakeTabGroupShared_ResponseParams_Data::PageHandler_MakeTabGroupShared_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetShareLink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetShareLink_Params_Data* object =
      static_cast<const PageHandler_GetShareLink_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_token, validation_context,
                                         &access_token_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetShareLink_Params_Data::PageHandler_GetShareLink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetShareLink_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetShareLink_ResponseParams_Data* object =
      static_cast<const PageHandler_GetShareLink_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_GetShareLink_ResponseParams_Data::PageHandler_GetShareLink_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabGroupPreview_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabGroupPreview_Params_Data* object =
      static_cast<const PageHandler_GetTabGroupPreview_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_token, validation_context,
                                         &access_token_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetTabGroupPreview_Params_Data::PageHandler_GetTabGroupPreview_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetTabGroupPreview_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetTabGroupPreview_ResponseParams_Data* object =
      static_cast<const PageHandler_GetTabGroupPreview_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_preview, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_preview, validation_context))
    return false;

  return true;
}

PageHandler_GetTabGroupPreview_ResponseParams_Data::PageHandler_GetTabGroupPreview_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenTabGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenTabGroup_Params_Data* object =
      static_cast<const PageHandler_OpenTabGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OpenTabGroup_Params_Data::PageHandler_OpenTabGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_AboutToUnShareTabGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_AboutToUnShareTabGroup_Params_Data* object =
      static_cast<const PageHandler_AboutToUnShareTabGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_group_id, validation_context,
                                         &tab_group_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_AboutToUnShareTabGroup_Params_Data::PageHandler_AboutToUnShareTabGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnTabGroupUnShareComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnTabGroupUnShareComplete_Params_Data* object =
      static_cast<const PageHandler_OnTabGroupUnShareComplete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_group_id, validation_context,
                                         &tab_group_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OnTabGroupUnShareComplete_Params_Data::PageHandler_OnTabGroupUnShareComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnGroupAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnGroupAction_Params_Data* object =
      static_cast<const PageHandler_OnGroupAction_Params_Data*>(data);


  if (!::data_sharing::mojom::internal::GroupAction_Data
        ::Validate(object->action, validation_context))
    return false;


  if (!::data_sharing::mojom::internal::GroupActionProgress_Data
        ::Validate(object->progress, validation_context))
    return false;

  return true;
}

PageHandler_OnGroupAction_Params_Data::PageHandler_OnGroupAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnAccessTokenFetched_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnAccessTokenFetched_Params_Data* object =
      static_cast<const Page_OnAccessTokenFetched_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_token, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_token, validation_context,
                                         &access_token_validate_params)) {
    return false;
  }

  return true;
}

Page_OnAccessTokenFetched_Params_Data::Page_OnAccessTokenFetched_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ReadGroups_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ReadGroups_Params_Data* object =
      static_cast<const Page_ReadGroups_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->read_groups_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->read_groups_params, validation_context))
    return false;

  return true;
}

Page_ReadGroups_Params_Data::Page_ReadGroups_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ReadGroups_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ReadGroups_ResponseParams_Data* object =
      static_cast<const Page_ReadGroups_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

Page_ReadGroups_ResponseParams_Data::Page_ReadGroups_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ReadGroupWithToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ReadGroupWithToken_Params_Data* object =
      static_cast<const Page_ReadGroupWithToken_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->param, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->param, validation_context))
    return false;

  return true;
}

Page_ReadGroupWithToken_Params_Data::Page_ReadGroupWithToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ReadGroupWithToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ReadGroupWithToken_ResponseParams_Data* object =
      static_cast<const Page_ReadGroupWithToken_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

Page_ReadGroupWithToken_ResponseParams_Data::Page_ReadGroupWithToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_DeleteGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_DeleteGroup_Params_Data* object =
      static_cast<const Page_DeleteGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

Page_DeleteGroup_Params_Data::Page_DeleteGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_DeleteGroup_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_DeleteGroup_ResponseParams_Data* object =
      static_cast<const Page_DeleteGroup_ResponseParams_Data*>(data);

  return true;
}

Page_DeleteGroup_ResponseParams_Data::Page_DeleteGroup_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_LeaveGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_LeaveGroup_Params_Data* object =
      static_cast<const Page_LeaveGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

Page_LeaveGroup_Params_Data::Page_LeaveGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_LeaveGroup_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_LeaveGroup_ResponseParams_Data* object =
      static_cast<const Page_LeaveGroup_ResponseParams_Data*>(data);

  return true;
}

Page_LeaveGroup_ResponseParams_Data::Page_LeaveGroup_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace data_sharing

namespace perfetto {

// static
void TraceFormatTraits<::data_sharing::mojom::GroupAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::data_sharing::mojom::GroupAction value) {
  return std::move(context).WriteString(::data_sharing::mojom::GroupActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::data_sharing::mojom::GroupActionProgress>::WriteIntoTrace(
   perfetto::TracedValue context, ::data_sharing::mojom::GroupActionProgress value) {
  return std::move(context).WriteString(::data_sharing::mojom::GroupActionProgressToString(value));
}

} // namespace perfetto