// chrome/browser/ui/webui/data_sharing/data_sharing.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-shared-internal.h"
#include "components/data_sharing/public/protocol/group_data.mojom-shared.h"
#include "mojo/public/mojom/base/absl_status.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::data_sharing::mojom::GroupAction, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::data_sharing::mojom::GroupActionProgress, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::data_sharing::mojom::ReadGroupsParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupsParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupsParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params)::BaseType>
          params_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::ReadGroupParamsDataView>, send_validation>(
        in_params,
        params_fragment,
        &params_validate_params);

      fragment->params.Set(
          params_fragment.is_null() ? nullptr : params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in ReadGroupsParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::data_sharing::mojom::ReadGroupParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_id)::BaseType> group_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group_id,
        group_id_fragment);

      fragment->group_id.Set(
          group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_id in ReadGroupParams struct");

      decltype(Traits::consistency_token(input)) in_consistency_token = Traits::consistency_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->consistency_token)::BaseType> consistency_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_consistency_token,
        consistency_token_fragment);

      fragment->consistency_token.Set(
          consistency_token_fragment.is_null() ? nullptr : consistency_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->consistency_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null consistency_token in ReadGroupParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::data_sharing::mojom::ReadGroupsResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupsResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupsResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::groups(input)) in_groups = Traits::groups(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->groups)::BaseType>
          groups_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::GroupDataDataView>, send_validation>(
        in_groups,
        groups_fragment,
        &groups_validate_params);

      fragment->groups.Set(
          groups_fragment.is_null() ? nullptr : groups_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->groups.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null groups in ReadGroupsResult struct");

      fragment->status_code = Traits::status_code(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::data_sharing::mojom::ReadGroupWithTokenParamDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupWithTokenParamDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupWithTokenParam_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_id)::BaseType> group_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group_id,
        group_id_fragment);

      fragment->group_id.Set(
          group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_id in ReadGroupWithTokenParam struct");

      decltype(Traits::access_token(input)) in_access_token = Traits::access_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->access_token)::BaseType> access_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_access_token,
        access_token_fragment);

      fragment->access_token.Set(
          access_token_fragment.is_null() ? nullptr : access_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->access_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_token in ReadGroupWithTokenParam struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::data_sharing::mojom::ReadGroupWithTokenResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupWithTokenResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupWithTokenResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::group(input)) in_group = Traits::group(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group)::BaseType> group_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::data_sharing::mojom::GroupDataDataView, send_validation>(
        in_group,
        group_fragment);

      fragment->group.Set(
          group_fragment.is_null() ? nullptr : group_fragment.data());

      fragment->status_code = Traits::status_code(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::data_sharing::mojom::SharedTabDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::SharedTabDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::SharedTab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::display_url(input)) in_display_url = Traits::display_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_url)::BaseType> display_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_url,
        display_url_fragment);

      fragment->display_url.Set(
          display_url_fragment.is_null() ? nullptr : display_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_url in SharedTab struct");

      decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_favicon_url,
        favicon_url_fragment);

      fragment->favicon_url.Set(
          favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->favicon_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null favicon_url in SharedTab struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::data_sharing::mojom::GroupPreviewDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::GroupPreviewDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::GroupPreview_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in GroupPreview struct");

      decltype(Traits::shared_tabs(input)) in_shared_tabs = Traits::shared_tabs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shared_tabs)::BaseType>
          shared_tabs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& shared_tabs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::SharedTabDataView>, send_validation>(
        in_shared_tabs,
        shared_tabs_fragment,
        &shared_tabs_validate_params);

      fragment->shared_tabs.Set(
          shared_tabs_fragment.is_null() ? nullptr : shared_tabs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->shared_tabs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_tabs in GroupPreview struct");

      
      mojo::internal::Serialize<::mojo_base::mojom::AbslStatusCode>(
        Traits::status_code(input),
        &fragment->status_code);
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_SEND_VALIDATION_H_