// chrome/browser/ui/webui/data_sharing/data_sharing.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-shared-internal.h"
#include "components/data_sharing/public/protocol/group_data.mojom-shared.h"
#include "mojo/public/mojom/base/absl_status.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace data_sharing::mojom {
class ReadGroupsParamsDataView;

class ReadGroupParamsDataView;

class ReadGroupsResultDataView;

class ReadGroupWithTokenParamDataView;

class ReadGroupWithTokenResultDataView;

class SharedTabDataView;

class GroupPreviewDataView;



}  // data_sharing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::data_sharing::mojom::ReadGroupsParamsDataView> {
  using Data = ::data_sharing::mojom::internal::ReadGroupsParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::data_sharing::mojom::ReadGroupParamsDataView> {
  using Data = ::data_sharing::mojom::internal::ReadGroupParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::data_sharing::mojom::ReadGroupsResultDataView> {
  using Data = ::data_sharing::mojom::internal::ReadGroupsResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::data_sharing::mojom::ReadGroupWithTokenParamDataView> {
  using Data = ::data_sharing::mojom::internal::ReadGroupWithTokenParam_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::data_sharing::mojom::ReadGroupWithTokenResultDataView> {
  using Data = ::data_sharing::mojom::internal::ReadGroupWithTokenResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::data_sharing::mojom::SharedTabDataView> {
  using Data = ::data_sharing::mojom::internal::SharedTab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::data_sharing::mojom::GroupPreviewDataView> {
  using Data = ::data_sharing::mojom::internal::GroupPreview_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace data_sharing::mojom {


enum class GroupAction : int32_t {
  
  kUnknown = 0,
  
  kJoinGroup = 1,
  
  kDeleteGroup = 2,
  
  kLeaveGroup = 3,
  
  kKeepGroup = 4,
  
  kStopSharing = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, GroupAction value);
inline bool IsKnownEnumValue(GroupAction value) {
  return internal::GroupAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GroupActionProgress : int32_t {
  
  kUnknown = 0,
  
  kStarted = 1,
  
  kFailed = 2,
  
  kSuccess = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, GroupActionProgress value);
inline bool IsKnownEnumValue(GroupActionProgress value) {
  return internal::GroupActionProgress_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ReadGroupsParamsDataView {
 public:
  ReadGroupsParamsDataView() = default;

  ReadGroupsParamsDataView(
      internal::ReadGroupsParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      mojo::ArrayDataView<ReadGroupParamsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::data_sharing::mojom::ReadGroupParamsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ReadGroupsParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadGroupParamsDataView {
 public:
  ReadGroupParamsDataView() = default;

  ReadGroupParamsDataView(
      internal::ReadGroupParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetConsistencyTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConsistencyToken(UserType* output) {
    
    auto* pointer = data_->consistency_token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ReadGroupParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadGroupsResultDataView {
 public:
  ReadGroupsResultDataView() = default;

  ReadGroupsResultDataView(
      internal::ReadGroupsResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupsDataView(
      mojo::ArrayDataView<::data_sharing::mojom::GroupDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroups(UserType* output) {
    
    auto* pointer = data_->groups.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::data_sharing::mojom::GroupDataDataView>>(
        pointer, output, message_);
  }
  int32_t status_code() const {
    return data_->status_code;
  }
 private:
  internal::ReadGroupsResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadGroupWithTokenParamDataView {
 public:
  ReadGroupWithTokenParamDataView() = default;

  ReadGroupWithTokenParamDataView(
      internal::ReadGroupWithTokenParam_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAccessTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessToken(UserType* output) {
    
    auto* pointer = data_->access_token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ReadGroupWithTokenParam_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadGroupWithTokenResultDataView {
 public:
  ReadGroupWithTokenResultDataView() = default;

  ReadGroupWithTokenResultDataView(
      internal::ReadGroupWithTokenResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupDataView(
      ::data_sharing::mojom::GroupDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroup(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::data_sharing::mojom::GroupDataDataView, UserType>(),
    "Attempting to read the optional `group` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGroup` instead "
    "of `ReadGroup if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->group.Get();
    return mojo::internal::Deserialize<::data_sharing::mojom::GroupDataDataView>(
        pointer, output, message_);
  }
  int32_t status_code() const {
    return data_->status_code;
  }
 private:
  internal::ReadGroupWithTokenResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedTabDataView {
 public:
  SharedTabDataView() = default;

  SharedTabDataView(
      internal::SharedTab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDisplayUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayUrl(UserType* output) {
    
    auto* pointer = data_->display_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFaviconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFaviconUrl(UserType* output) {
    
    auto* pointer = data_->favicon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedTab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GroupPreviewDataView {
 public:
  GroupPreviewDataView() = default;

  GroupPreviewDataView(
      internal::GroupPreview_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSharedTabsDataView(
      mojo::ArrayDataView<SharedTabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedTabs(UserType* output) {
    
    auto* pointer = data_->shared_tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::data_sharing::mojom::SharedTabDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatusCode(UserType* output) const {
    auto data_value = data_->status_code;
    return mojo::internal::Deserialize<::mojo_base::mojom::AbslStatusCode>(
        data_value, output);
  }
  ::mojo_base::mojom::AbslStatusCode status_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::AbslStatusCode>(data_->status_code));
  }
 private:
  internal::GroupPreview_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // data_sharing::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_DATA_VIEW_H_